/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSPlotAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class DOOCSDataContainerRefHISTOGRAM
extends DOOCSDataContainer {
    public float[] srcData;
    private int resultLength = 0;
    private DOOCSDataContainer refContainer;
    protected Point2D pt;
    double[] counts;
    int bins;
    double deltaX;
    double area;
    double minX;
    double resSigma;
    double resMean;
    double srcXmin;
    double srcXmax;
    double srcYmin;
    double srcYmax;

    public DOOCSDataContainerRefHISTOGRAM(DOOCSChannel ch, DOOCSDataContainer ref) {
        super(ch);
        this.refContainer = ref;
        this.pt = new Point();
        this.bins = 100;
        this.resultLength = 0;
        this.counts = new double[this.bins];
        if (this.refContainer != null) {
            this.refContainer.hasNewData = true;
        }
    }

    @Override
    public int getDataLength() {
        return this.bins;
    }

    @Override
    public double getDataInc() {
        return this.deltaX;
    }

    @Override
    public double getYData(int idx) {
        return this.counts[idx];
    }

    @Override
    public double getXData(int idx) {
        return this.minX + this.deltaX * (double)idx;
    }

    @Override
    public boolean hasValidData() {
        return this.resultLength > 0;
    }

    @Override
    public boolean update() {
        boolean flag = false;
        int count = 0;
        double res = 0.0;
        double sxx = 0.0;
        this.minX = this.channel.plot.doocsPlotAxisX.actMin;
        double xMax = this.channel.plot.doocsPlotAxisX.actMax;
        this.deltaX = (xMax - this.minX) / (double)this.bins;
        if (this.deltaX <= 0.0) {
            this.deltaX = 1.0;
        }
        this.srcXmin = this.refContainer.channel.plot.selectionXMin();
        this.srcXmax = this.refContainer.channel.plot.selectionXMax();
        this.srcYmin = this.refContainer.channel.plot.selectionYMin();
        this.srcYmax = this.refContainer.channel.plot.selectionYMax();
        if (this.refContainer == null) {
            System.out.println("Ref Undefined!! in " + this.channel.toString());
        }
        try {
            int len = this.refContainer.getDataLength();
            if (len >= 10 && (this.refContainer.hasNewData || this.channel.plot.recalcFlag)) {
                int i;
                this.refContainer.hasNewData = false;
                this.descriptionMsg = "Histogram of " + this.refContainer.descriptionMsg;
                for (i = 0; i < this.bins; ++i) {
                    this.counts[i] = 0.0;
                }
                for (i = 0; i < len; ++i) {
                    double y;
                    double x = this.refContainer.getXData(i);
                    if (!this.refContainer.channel.plot.doocsPlotSelection.isIn(x, y = this.refContainer.getYData(i))) continue;
                    if (y < this.minX) {
                        this.counts[0] = this.counts[0] + 1.0;
                        continue;
                    }
                    if (y > xMax) {
                        int n = this.bins - 1;
                        this.counts[n] = this.counts[n] + 1.0;
                        continue;
                    }
                    int j = Math.round((float)((y - this.minX) / this.deltaX));
                    if (j < this.bins) {
                        int n = j;
                        this.counts[n] = this.counts[n] + 1.0;
                    }
                    res += y;
                    sxx += y * y;
                    ++count;
                }
                if (count > 2) {
                    double rms = Math.sqrt(sxx / (double)count);
                    double s = ((double)count * sxx - res * res) / (double)((count - 1) * count);
                    this.resSigma = Math.sqrt(s);
                    this.resMean = res / (double)count;
                    this.area = this.deltaX * (double)count;
                    this.mathResult = String.format("Mean=%.4g, SD=%.4g, RMS=%.4g, N=%d", this.resMean, this.resSigma, rms, count);
                } else {
                    this.mathResult = "";
                }
                this.resultLength = this.bins;
                flag = true;
                this.errorMsg = "";
                this.hasNewData = true;
                this.hasData = true;
            }
        }
        catch (Exception e) {
            this.resultLength = 0;
            this.hasData = false;
            this.errorMsg = String.format("Read ERROR!", new Object[0]);
        }
        return this.hasData;
    }

    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xMin = xaxis.actMin;
        double xMax = xaxis.actMax;
        int len = this.refContainer.getDataLength();
        if (len >= 10) {
            for (int i = 0; i < len; ++i) {
                double y;
                double x = this.refContainer.getXData(i);
                if (!this.refContainer.channel.plot.doocsPlotSelection.isIn(x, y = this.refContainer.getYData(i))) continue;
                if (y < xMin) {
                    xMin = y;
                    continue;
                }
                if (!(y > xMax)) continue;
                xMax = y;
            }
            if (xaxis.actMin > xMin) {
                xaxis.actMin = xMin;
            }
            if (xaxis.actMax < xMax) {
                xaxis.actMax = xMax;
            }
        }
    }

    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xMin = xaxis.actMin;
        double xMax = xaxis.actMax;
        double yMin = yaxis.actMin;
        double yMax = yaxis.actMax;
        if (this.resultLength > 0) {
            for (int i = 0; i < this.resultLength; ++i) {
                double x = this.minX + this.deltaX * (double)i;
                if (x < xMin || x > xMax || yaxis.isLog && (double)((float)this.counts[i]) <= 0.0) continue;
                if ((double)((float)this.counts[i]) > yaxis.actMax) {
                    yaxis.actMax = (float)this.counts[i];
                }
                if (!((double)((float)this.counts[i]) < yaxis.actMin)) continue;
                yaxis.actMin = (float)this.counts[i];
            }
        }
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        int iyg0 = 0;
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        if (this.refContainer == null) {
            return;
        }
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeSize);
        BasicStroke thin = new BasicStroke();
        Rectangle clip = g2d.getClipBounds();
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        Color col = this.channel.lineColor;
        int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
        int len = this.resultLength;
        if (len >= 10) {
            int y0;
            double y = 0.0;
            double x = this.minX;
            if (xaxis.isLog) {
                x = x <= 0.0 ? -20.0 : Math.log10(x);
            }
            if (yaxis.isLog) {
                y = y <= 0.0 ? -20.0 : Math.log10(y);
            }
            ((Point2D)po).setLocation(x, y);
            tr.transform(po, this.pt);
            int x0 = (int)this.pt.getX();
            iyg0 = y0 = (int)this.pt.getY();
            for (int i = 1; i < len; ++i) {
                y = this.counts[i];
                x = this.minX + this.deltaX * (double)i;
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                ((Point2D)po).setLocation(x, y);
                tr.transform(po, this.pt);
                int x1 = (int)this.pt.getX();
                int y1 = (int)this.pt.getY();
                this.drawDataPoint(g2d, x0, y1, x1, y0, y0, intColorFg, false);
                if (this.channel.plot.getShowLegend() && this.resSigma != 0.0) {
                    double z = (x - this.resMean) / this.resSigma;
                    double yg = 0.3989 / this.resSigma * Math.exp(-0.5 * z * z) * this.area;
                    if (yaxis.isLog) {
                        yg = yg <= 0.0 ? -20.0 : Math.log10(yg);
                    }
                    ((Point2D)po).setLocation(x, yg);
                    tr.transform(po, this.pt);
                    x1 = (int)this.pt.getX();
                    int iyg = (int)this.pt.getY();
                    g2d.setStroke(thin);
                    g2d.drawLine(x0, iyg0, x1, iyg);
                    iyg0 = iyg;
                    g2d.setStroke(this.channel.strokeSize);
                }
                x0 = x1;
            }
        }
    }
}

