/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotRefDFT;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class DOOCSDataContainerRefDFT
extends DOOCSDataContainer {
    public float[] srcData;
    private int resultLength = 0;
    private DOOCSDataContainer refContainer;
    protected Point2D pt;
    double[] angleOut;
    double[] magnitude;
    double lowF;
    double highF;
    double delta;
    int zero;

    public DOOCSDataContainerRefDFT(DOOCSChannel ch, DOOCSDataContainer ref) {
        super(ch);
        this.refContainer = ref;
        this.pt = new Point();
        this.resultLength = 0;
        if (this.refContainer != null) {
            this.refContainer.hasNewData = true;
        }
    }

    @Override
    public int getDataLength() {
        return this.resultLength;
    }

    @Override
    public double getDataInc() {
        return 1.0;
    }

    @Override
    public double getYData(int idx) {
        return this.magnitude[idx];
    }

    @Override
    public double getXData(int idx) {
        return this.lowF + this.delta * (double)idx;
    }

    @Override
    public boolean hasValidData() {
        return this.resultLength > 0;
    }

    public void FFTtransform(float[] data, int dataLen, int offset, double[] angleOut, double[] magnitude) {
        double pi = Math.PI;
        double[] realOut = new double[dataLen];
        double[] imagOut = new double[dataLen];
        for (int i = 0; i < dataLen; ++i) {
            realOut[i] = data[i + offset];
        }
        DOOCSDataContainerRefDFT.complexToComplex(1, dataLen, realOut, imagOut);
        for (int cnt = 0; cnt < dataLen; ++cnt) {
            magnitude[cnt] = Math.sqrt(realOut[cnt] * realOut[cnt] + imagOut[cnt] * imagOut[cnt]) / (double)dataLen;
            angleOut[cnt] = imagOut[cnt] == 0.0 && realOut[cnt] == 0.0 ? 0.0 : Math.atan(imagOut[cnt] / realOut[cnt]) * 180.0 / pi;
            if (realOut[cnt] < 0.0 && imagOut[cnt] == 0.0) {
                angleOut[cnt] = 180.0;
                continue;
            }
            if (realOut[cnt] < 0.0 && imagOut[cnt] == -0.0) {
                angleOut[cnt] = -180.0;
                continue;
            }
            if (realOut[cnt] < 0.0 && imagOut[cnt] > 0.0) {
                int n = cnt;
                angleOut[n] = angleOut[n] + 180.0;
                continue;
            }
            if (!(realOut[cnt] < 0.0) || !(imagOut[cnt] < 0.0)) continue;
            int n = cnt;
            angleOut[n] = angleOut[n] + -180.0;
        }
    }

    public static void complexToComplex(int sign, int len, double[] real, double[] imag) {
        double scale = 1.0;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int m;
            if (j >= i) {
                double tempr = real[j] * scale;
                double tempi = imag[j] * scale;
                real[j] = real[i] * scale;
                imag[j] = imag[i] * scale;
                real[i] = tempr;
                imag[i] = tempi;
            }
            for (m = len / 2; m >= 1 && j >= m; j -= m, m /= 2) {
            }
            j += m;
        }
        boolean stage = false;
        int maxSpectraForStage = 1;
        int stepSize = 2 * maxSpectraForStage;
        while (maxSpectraForStage < len) {
            double deltaAngle = (double)sign * Math.PI / (double)maxSpectraForStage;
            for (int spectraCnt = 0; spectraCnt < maxSpectraForStage; ++spectraCnt) {
                double angle = (double)spectraCnt * deltaAngle;
                double realCorrection = Math.cos(angle);
                double imagCorrection = Math.sin(angle);
                int right = 0;
                for (int left = spectraCnt; left < len; left += stepSize) {
                    right = left + maxSpectraForStage;
                    double tempReal = realCorrection * real[right] - imagCorrection * imag[right];
                    double tempImag = realCorrection * imag[right] + imagCorrection * real[right];
                    real[right] = real[left] - tempReal;
                    imag[right] = imag[left] - tempImag;
                    int n = left;
                    real[n] = real[n] + tempReal;
                    int n2 = left;
                    imag[n2] = imag[n2] + tempImag;
                }
            }
            maxSpectraForStage = stepSize;
            maxSpectraForStage = stepSize;
            stepSize = 2 * maxSpectraForStage;
        }
    }

    public void transform(float[] data, int dataLen, int offset, double[] angleOut, double[] magnitude, int zero, double lowF, double highF) {
        double pi = Math.PI;
        double delF = (highF - lowF) / (double)dataLen;
        for (int i = 0; i < dataLen; ++i) {
            double freq = lowF + (double)i * delF;
            double real = 0.0;
            double imag = 0.0;
            double ang = 0.0;
            for (int j = 0; j < dataLen; ++j) {
                real += (double)data[j + offset] * Math.cos(2.0 * pi * freq * (double)(j - zero));
                imag += (double)data[j + offset] * Math.sin(2.0 * pi * freq * (double)(j - zero));
            }
            magnitude[i] = Math.sqrt(real * real + imag * imag) / (double)dataLen;
            ang = imag == 0.0 && real == 0.0 ? 0.0 : Math.atan(imag / real) * 180.0 / pi;
            if (real < 0.0 && imag == 0.0) {
                ang = 180.0;
            } else if (real < 0.0 && imag == -0.0) {
                ang = -180.0;
            } else if (real < 0.0 && imag > 0.0) {
                ang += 180.0;
            } else if (real < 0.0 && imag < 0.0) {
                ang += -180.0;
            }
            angleOut[i] = ang;
        }
    }

    @Override
    public boolean update() {
        boolean flag = false;
        double inc = 1.0;
        int dataStart = 0;
        if (this.refContainer == null) {
            System.out.println("Ref Undefined!! in " + this.channel.toString());
            return false;
        }
        try {
            this.srcData = this.refContainer.getSelectedData();
            int len = this.refContainer.getDataLength();
            inc = this.refContainer.getDataInc();
            if (this.refContainer.channel.plot.doocsPlotSelection.isActive()) {
                double m;
                double dStart = this.refContainer.channel.plot.doocsPlotSelection.getXMin() / inc;
                if (dStart < this.refContainer.getDataOffset()) {
                    dStart = this.refContainer.getDataOffset();
                }
                dataStart = (int)(dStart - this.refContainer.getDataOffset());
                double stop = (int)this.refContainer.channel.plot.doocsPlotSelection.getXMax();
                if (stop > (m = this.refContainer.getDataOffset() + (double)len * this.refContainer.getDataInc() - 1.0)) {
                    stop = m;
                }
                len = (int)((stop - this.refContainer.getDataOffset() - (double)dataStart + 1.0) / this.refContainer.getDataInc());
            }
            if (this.srcData != null && len >= 10 && (this.refContainer.hasNewData || this.channel.plot.recalcFlag)) {
                this.refContainer.hasNewData = false;
                this.angleOut = new double[len];
                this.magnitude = new double[len];
                this.descriptionMsg = "Spectrum of " + this.refContainer.descriptionMsg;
                this.lowF = 0.0;
                this.highF = inc != 0.0 ? 0.5 / inc : 488.0;
                this.delta = 2.0 * (this.highF - this.lowF) / (double)len;
                this.zero = 0;
                double f = Math.log(len) / Math.log(2.0);
                double p = Math.pow(2.0, Math.rint(f));
                if (this.channel.plot instanceof DOOCSPlotRefDFT && ((DOOCSPlotRefDFT)this.channel.plot).checkBoxHanningWindow.isSelected()) {
                    float[] dataFilt = new float[len + dataStart];
                    for (int i = 0; i < len; ++i) {
                        double arg = Math.PI * 2 * (double)i / (double)(len - 1);
                        float scale = (float)(0.5 - 0.5 * Math.cos(arg));
                        dataFilt[i + dataStart] = this.srcData[i + dataStart] * scale;
                    }
                    if (p == (double)len) {
                        this.FFTtransform(dataFilt, len, dataStart, this.angleOut, this.magnitude);
                    } else {
                        this.transform(dataFilt, len, dataStart, this.angleOut, this.magnitude, this.zero, this.lowF, this.highF);
                        this.delta /= 2.0;
                    }
                } else if (p == (double)len) {
                    this.FFTtransform(this.srcData, len, dataStart, this.angleOut, this.magnitude);
                } else {
                    this.transform(this.srcData, len, dataStart, this.angleOut, this.magnitude, this.zero, this.lowF, this.highF);
                    this.delta /= 2.0;
                }
                this.resultLength = len;
                flag = true;
                this.errorMsg = "";
                this.hasData = true;
            }
        }
        catch (Exception e) {
            this.resultLength = 0;
            this.errorMsg = String.format("Read ERROR! " + e.toString(), new Object[0]);
            this.hasData = false;
        }
        return flag;
    }

    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xMin = xaxis.actMin;
        double xMax = xaxis.actMax;
        if (xaxis.actMin > this.lowF) {
            xaxis.actMin = this.lowF;
        }
        if (xaxis.actMax < this.highF) {
            xaxis.actMax = this.highF;
        }
    }

    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xMin = xaxis.actMin;
        double xMax = xaxis.actMax;
        double yMin = yaxis.actMin;
        double yMax = yaxis.actMax;
        double x = this.lowF;
        if (this.resultLength > 0) {
            for (int i = 0; i < this.resultLength; ++i) {
                if (x < xMin || x > xMax || yaxis.isLog && (double)((float)this.magnitude[i]) <= 0.0) continue;
                if ((double)((float)this.magnitude[i]) > yaxis.actMax) {
                    yaxis.actMax = (float)this.magnitude[i];
                }
                if ((double)((float)this.magnitude[i]) < yaxis.actMin) {
                    yaxis.actMin = (float)this.magnitude[i];
                }
                x += this.delta;
            }
        }
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeSize);
        Rectangle clip = g2d.getClipBounds();
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        if (this.refContainer == null) {
            return;
        }
        int len = this.resultLength;
        if (len >= 10) {
            double y = this.magnitude[0];
            double x = this.lowF;
            if (xaxis.isLog) {
                x = x <= 0.0 ? -20.0 : Math.log10(x);
            }
            if (yaxis.isLog) {
                y = y <= 0.0 ? -20.0 : Math.log10(y);
            }
            ((Point2D)po).setLocation(x, y);
            tr.transform(po, this.pt);
            int x1 = (int)this.pt.getX();
            int y1 = (int)this.pt.getY();
            for (int i = 1; i < len; ++i) {
                y = this.magnitude[i];
                x += this.delta;
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                ((Point2D)po).setLocation(x, y);
                tr.transform(po, this.pt);
                int x2 = (int)this.pt.getX();
                int y2 = (int)this.pt.getY();
                if (xaxis.isLog) {
                    if (clip.intersectsLine(x1, y1, x2, y2)) {
                        g2d.drawLine(x1, y1, x2, y2);
                    }
                } else if (clip.intersectsLine(x1, y1, x2, y2)) {
                    g2d.drawLine(x1, y1, x2, y2);
                }
                x1 = x2;
                y1 = y2;
            }
        }
    }
}

