/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.ShowException;
import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSPlotAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;

public class DOOCSDataContainerLocationFile
extends DOOCSDataContainer {
    protected EqAdr ea;
    protected EqAdr refAdr;
    protected EqData ed;
    protected EqData dataLocStrings;
    protected boolean hasLocStrings;
    protected File file;
    protected long lastModified;
    int dataLength;
    protected Color bgColor;

    public DOOCSDataContainerLocationFile(DOOCSChannel ch, File f) {
        block18: {
            super(ch);
            this.hasLocStrings = false;
            this.file = f;
            this.lastModified = 0L;
            Object line = null;
            Object inputStream = null;
            boolean idx = false;
            this.channel = ch;
            this.color = new Color(0, 0, 0);
            this.bgColor = new Color(128, 128, 128, 60);
            this.pt = new Point();
            this.ea = new EqAdr(ch.doocsAdr);
            this.ed = new EqData();
            this.data = new EqData();
            this.dataLocStrings = new EqData();
            this.eq = new EqCall();
            this.descriptionMsg = ch.doocsAdr;
            if (ch.plot.doocsRefAdr.length() > 6) {
                if (ch.plot.doocsRefAdr.startsWith("file:")) {
                    try {
                        this.dataLocStrings.init();
                        this.dataLocStrings.set_type(103);
                        this.dataLocStrings.set_from_file(ch.plot.doocsRefAdr.substring(5));
                        this.errorMsg = "";
                        this.hasLocStrings = true;
                    }
                    catch (Exception e) {
                        this.errorMsg = String.format("Read ERROR : %s", e.getMessage());
                    }
                } else {
                    this.refAdr = new EqAdr(ch.plot.doocsRefAdr);
                    this.descriptionMsg = ch.plot.doocsRefAdr.substring(ch.plot.doocsRefAdr.indexOf("/", 1));
                    try {
                        this.dataLocStrings.init();
                        int sysMask = this.channel.plot.sysMask;
                        if (sysMask != 0) {
                            this.ed.set(sysMask);
                        }
                        this.eq.get(this.refAdr, this.ed, this.dataLocStrings);
                        if (this.dataLocStrings.error() == 0) {
                            this.hasLocStrings = true;
                            if (!ch.doocsReadEGU) break block18;
                            EqAdr eaa = new EqAdr(ch.doocsAdr);
                            eaa.set_location(this.dataLocStrings.get_string_arg(0));
                            eaa.merge("///.EGU");
                            try {
                                this.data.init();
                                this.data.set_type(16);
                                this.eq.get(eaa, this.ed, this.data);
                                if (this.data.error() == 0) {
                                    this.eguText = "[" + this.data.get_string_arg().trim() + "]";
                                    break block18;
                                }
                                this.eguText = this.data.get_string();
                            }
                            catch (Exception e) {
                                this.errorMsg = "EGU read error";
                            }
                            break block18;
                        }
                        this.hasLocStrings = false;
                    }
                    catch (Exception e) {
                        this.hasLocStrings = false;
                    }
                }
            }
        }
        try {
            this.data.init();
            int sysMask = this.channel.plot.sysMask;
            if (sysMask != 0) {
                this.ed.set(sysMask);
            }
            if (this.channel.plot.doocsRefAdr.length() > 6) {
                this.data.set_type(100);
            } else {
                this.data.set_type(103);
            }
            this.eq.get(this.ea, this.ed, this.data);
            int i = this.data.error();
            if (i == 0 && this.data.array_length() == 0) {
                this.channel.lineStyle = DOOCSChannel.LineStyle.Line;
            }
            this.errorMsg = "";
            this.hasData = true;
        }
        catch (Exception e) {
            this.errorMsg = "read data error";
            this.hasData = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        int i = 0;
        Object line = null;
        BufferedReader inputStream = null;
        try {
            long lm = this.file.lastModified() / 1000L;
            if (lm > this.lastModified) {
                if (this.channel.plot.doocsRefAdr.length() > 6) {
                    this.data.set_type(100);
                } else {
                    this.data.set_type(103);
                }
                this.data.set_from_file(this.file.getAbsolutePath());
                if (this.data.error() == 0) {
                    this.dataLength = this.data.array_length();
                    if (this.dataLength == 0) {
                        this.dataLength = 1;
                    }
                    this.errorMsg = "";
                } else {
                    this.errorMsg = this.data.get_string_arg();
                }
                this.hasData = true;
                this.lastModified = System.currentTimeMillis() / 1000L;
            }
        }
        catch (Exception e) {
            this.errorMsg = String.format("File Read ERROR! Line=%d : %s", i, line);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                new ShowException(null, "IOException", e);
            }
        }
        this.hasNewData = this.hasData;
        return this.hasData;
    }

    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        int i = 1;
        if (this.hasData) {
            i = this.dataLength;
        }
        if ((double)i > xaxis.actMax) {
            xaxis.actMax = i;
        }
        xaxis.actMin = 0.0;
    }

    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xMin = xaxis.actMin;
        double xMax = xaxis.actMax;
        if (this.hasData && this.data.error() == 0 && this.dataLength > 0) {
            for (int i = 0; i < this.dataLength; ++i) {
                double x = i;
                if (x < xMin || x > xMax) continue;
                float y = this.dataLength == 1 ? this.data.get_float() : this.data.get_float(i);
                if (yaxis.isLog && (double)y <= 0.0) continue;
                if ((double)y > yaxis.actMax) {
                    yaxis.actMax = y;
                }
                if (!((double)y < yaxis.actMin)) continue;
                yaxis.actMin = y;
            }
        }
    }

    @Override
    public float[] getSelectedData() {
        return this.data.get_float_array();
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public double getDataInc() {
        return 1.0;
    }

    @Override
    public double getYData(int idx) {
        return this.data.get_float(idx);
    }

    @Override
    public double getXData(int idx) {
        return idx;
    }

    @Override
    public String getXString(int idx) {
        if (idx >= 0 && idx < this.dataLength) {
            if (this.hasLocStrings) {
                return this.dataLocStrings.get_string_arg(idx);
            }
            if (this.data.type() == 103) {
                return this.data.get_string_arg(idx);
            }
            return String.format("%d", idx);
        }
        if (this.dataLength == 0) {
            return String.format("%d", idx);
        }
        return "";
    }

    @Override
    public String getStatusMsg(int idx) {
        if (this.errorMsg.length() > 0) {
            return this.errorMsg;
        }
        return this.getXString(idx) + " " + this.eguText;
    }

    @Override
    public String getToolTipText(double dataX, double dataY, String adrString) {
        double y = this.channel.plot.doocsPlotAxisY.isLog ? Math.pow(10.0, dataY) : dataY;
        return String.format("X=%s, Y=%g : %s", adrString, y, this.descriptionMsg);
    }

    @Override
    public boolean hasValidData() {
        return this.hasData && this.data.error() == 0;
    }

    private void drawResult(Graphics2D g2d, String tmp, int x, int y) {
        g2d.setColor(this.color);
        g2d.drawString(tmp, x, y);
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        int idMax;
        int iDelta;
        int x2 = 0;
        int y2 = 0;
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        int idMin = (int)Math.round(xmin);
        if (idMin < 0) {
            idMin = 0;
        }
        if ((iDelta = (idMax = (int)Math.round(xmax)) - idMin) + idMin > this.dataLength) {
            iDelta = this.dataLength - idMin;
        }
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        Rectangle clip = g.getClipBounds();
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeSize);
        Color col = this.channel.lineColor;
        int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
        if (this.hasData && this.data.error() == 0 && this.dataLength > 0) {
            double x = idMin;
            double y = yaxis.isLog ? Math.log10(yaxis.actMin) : 0.0;
            ((Point2D)po).setLocation(x, y);
            tr.transform(po, this.pt);
            int y0 = (int)this.pt.getY();
            if (xaxis.isLog) {
                x = x <= 0.0 ? -20.0 : Math.log10(x);
            }
            y = this.dataLength == 0 ? (double)this.data.get_float() : (double)this.data.get_float(0);
            if (yaxis.isLog) {
                y = y <= 0.0 ? -20.0 : Math.log10(y);
            }
            this.pt_s = new Point2D.Double();
            this.pt_s.setLocation(x, y);
            tr.transform(this.pt_s, this.pt);
            int x1 = (int)this.pt.getX();
            int y1 = (int)this.pt.getY();
            if (this.dataLength == 1) {
                x = xaxis.actMax;
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                ((Point2D)po).setLocation(x, y);
                tr.transform(po, this.pt);
                y2 = (int)this.pt.getY();
                x2 = (int)this.pt.getX();
                this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false);
            } else {
                for (int i = idMin; i < idMin + iDelta; ++i) {
                    x = i;
                    if (xaxis.isLog) {
                        x = x <= 0.0 ? -20.0 : Math.log10(x);
                    }
                    y = this.dataLength == 0 ? (double)this.data.get_float() : (double)this.data.get_float(i);
                    if (yaxis.isLog) {
                        y = y <= 0.0 ? -20.0 : Math.log10(y);
                    }
                    this.pt_s.setLocation(x, y);
                    tr.transform(this.pt_s, this.pt);
                    x2 = (int)this.pt.getX();
                    y2 = (int)this.pt.getY();
                    if (!(x1 < clip.x && x2 < clip.x || x1 > clip.x + clip.width && x2 > clip.x + clip.width)) {
                        this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false);
                    }
                    x1 = x2;
                    y1 = y2;
                }
                this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false);
            }
        }
    }
}

