/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSChannelList;
import DOOCSPlot.DOOCSDataContainerHist;
import DOOCSPlot.DOOCSFindDataPoint;
import DOOCSPlot.DOOCSHistBlock;
import DOOCSPlot.DOOCSPlotAxis;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.TDS;

public class DOOCSDataContainerHistXY
extends DOOCSDataContainerHist {
    private double xMinSelection;
    private double xMaxSelection;
    private DOOCSChannelList refContainers;
    private DOOCSDataContainerHist refContainer;

    public DOOCSDataContainerHistXY(DOOCSChannel ch) {
        super(ch);
        this.refContainers = ch.plot.doocsRefChannels;
    }

    @Override
    public boolean update() {
        boolean flag = false;
        if (this.channel == null) {
            this.errorMsg = "Internal ERROR! No channel defined";
            return false;
        }
        if (this.refContainers != null) {
            this.refContainer = this.refContainers.channels.get(0) != null ? (DOOCSDataContainerHist)this.refContainers.channels.get((int)0).dataContainer : null;
        }
        if (this.channel.plot.doocsPlotSelection.isTimeRangeDefined()) {
            this.xMaxSelection = this.channel.plot.doocsPlotSelection.getTimeRangeMax();
            this.xMinSelection = this.channel.plot.doocsPlotSelection.getTimeRangeMin();
        } else {
            this.xMaxSelection = System.currentTimeMillis() / 1000L;
            this.xMinSelection = this.xMaxSelection - 28800.0;
        }
        if (this.firstRead || ((DOOCSHistBlock)this.dataBlock.get((int)1)).tTo + (long)this.tReread < System.currentTimeMillis() / 1000L) {
            if (this.firstRead) {
                EqAdr eaa = new EqAdr(this.channel.doocsAdr + ".EGU");
                super.readEGU(eaa);
            }
            if (this.channel.isRefChannel) {
                this.channel.plot.doocsPlotAxisX.eguText = this.channel.doocsAdr + "  " + this.eguText;
            }
            this.firstRead = false;
            flag = true;
        }
        if (this.xMin != this.channel.plot.doocsPlotAxisX.actMin || this.xMax != this.channel.plot.doocsPlotAxisX.actMax) {
            this.channel.plot.repaint();
            flag = true;
        }
        try {
            if (!this.adrActual.protocol().startsWith("file")) {
                ((DOOCSHistBlock)this.dataBlock.get((int)0)).data.set_type(2);
                this.eq.get(this.adrActual, this.ed, ((DOOCSHistBlock)this.dataBlock.get((int)0)).data);
                this.errorMsg = ((DOOCSHistBlock)this.dataBlock.get((int)0)).data.error() == 0 ? null : "ERROR!" + ((DOOCSHistBlock)this.dataBlock.get((int)0)).data.get_string();
                if (((DOOCSHistBlock)this.dataBlock.get((int)0)).data.get_time() == 0L) {
                    ((DOOCSHistBlock)this.dataBlock.get((int)0)).data.set_time((int)(System.currentTimeMillis() / 1000L));
                }
                flag = true;
            }
        }
        catch (Exception e) {
            this.errorMsg = "Read ERROR!" + e.toString();
            this.hasData = false;
            this.dataLength = 0;
        }
        this.hasNewData = flag;
        return flag;
    }

    @Override
    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.channel.isRefChannel) {
            double xLast = 0.0;
            for (int j = 0; j < this.dataBlock.size(); ++j) {
                if (!this.hasData || ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.error() != 0) continue;
                int l = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.length();
                if (((DOOCSHistBlock)this.dataBlock.get((int)j)).data.type() == 0) continue;
                if (((DOOCSHistBlock)this.dataBlock.get((int)j)).data.type() != 101) {
                    l = 1;
                }
                for (int i = 0; i < l; ++i) {
                    double x;
                    float y;
                    if (((DOOCSHistBlock)this.dataBlock.get((int)j)).data.type() == 101) {
                        TDS tds = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_tds(i);
                        if (tds == null) continue;
                        y = tds.data;
                        x = tds.tm.value;
                    } else {
                        y = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_float();
                        x = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_time() / 1000L;
                    }
                    if (!this.channel.plot.doocsPlotSelection.isInTimeRange(xLast, x) || xaxis.isLog && (double)y <= 0.0) continue;
                    if ((double)y > xaxis.actMax) {
                        xaxis.actMax = y;
                    }
                    if ((double)y < xaxis.actMin) {
                        xaxis.actMin = y;
                    }
                    xLast = x;
                }
            }
        }
    }

    @Override
    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (!this.channel.isRefChannel) {
            double xLast = 0.0;
            for (int j = 0; j < this.dataBlock.size(); ++j) {
                if (!this.hasData || ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.error() != 0) continue;
                int l = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.length();
                if (((DOOCSHistBlock)this.dataBlock.get((int)j)).data.type() == 0) continue;
                for (int i = 0; i < l; ++i) {
                    double x;
                    float y;
                    if (((DOOCSHistBlock)this.dataBlock.get((int)j)).data.type() == 101) {
                        TDS tds = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_tds(i);
                        if (tds == null) continue;
                        y = tds.data;
                        x = tds.tm.value;
                    } else {
                        y = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_float();
                        x = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_time() / 1000L;
                    }
                    if (!this.channel.plot.doocsPlotSelection.isInTimeRange(xLast, x) || yaxis.isLog && (double)y <= 0.0) continue;
                    if ((double)y > yaxis.actMax) {
                        yaxis.actMax = y;
                    }
                    if ((double)y < yaxis.actMin) {
                        yaxis.actMin = y;
                    }
                    xLast = x;
                }
            }
        }
    }

    @Override
    public double getYData(int idx) {
        int block;
        if (idx > this.dataLength) {
            return 0.0;
        }
        int blocks = this.dataBlock.size();
        int l = 0;
        for (block = 0; block < blocks && idx > (l = ((DOOCSHistBlock)this.dataBlock.get((int)block)).data.length()); ++block, idx -= l) {
        }
        if (block < blocks && idx < (l = ((DOOCSHistBlock)this.dataBlock.get((int)block)).data.length())) {
            return ((DOOCSHistBlock)this.dataBlock.get((int)block)).data.get_float(idx);
        }
        return 0.0;
    }

    @Override
    public double getYofX(double x) {
        double tmpY = 0.0;
        double tmpY2 = 0.0;
        double xFirst = 0.0;
        if (this.refContainer == null) {
            return 0.0;
        }
        int blocks = this.refContainer.dataBlock.size();
        boolean l = false;
        for (int block = 0; block < blocks; ++block) {
            EqData dat = this.refContainer.dataBlock.get((int)block).data;
            for (int i = 0; i < dat.length(); ++i) {
                double xd;
                if (block == 0) {
                    xd = (double)dat.get_time() / 1000.0;
                    tmpY = dat.get_float();
                    if (xd == 0.0 || !(x >= xd)) continue;
                    return tmpY;
                }
                xd = (double)dat.get_time(i) / 1000.0;
                tmpY2 = dat.get_float(i);
                if (xFirst != 0.0 && x >= xFirst && x <= xd) {
                    if (this.channel.plot.debug == 1) {
                        System.out.format("Tin=%9.9g,T=%9.9g, Ypre=%.4g,Y=%.4g", x, xd, tmpY, tmpY2);
                    }
                    if (x == xd) {
                        return tmpY2;
                    }
                    return tmpY;
                }
                tmpY = tmpY2;
                xFirst = xd;
            }
        }
        return tmpY;
    }

    @Override
    public double getXData(int idx) {
        int block;
        if (idx > this.dataLength) {
            return 0.0;
        }
        int blocks = this.dataBlock.size();
        int l = 0;
        for (block = 0; block < blocks && idx > (l = ((DOOCSHistBlock)this.dataBlock.get((int)block)).data.length()); ++block, idx -= l) {
        }
        l = ((DOOCSHistBlock)this.dataBlock.get((int)block)).data.length();
        if (block < blocks && idx < l) {
            double t = (double)((DOOCSHistBlock)this.dataBlock.get((int)block)).data.get_time(idx) / 1000.0;
            return this.getYofX(t);
        }
        return 0.0;
    }

    @Override
    public String getToolTipText(double dataX, double dataY, String adrString) {
        double x = this.channel.plot.doocsPlotAxisX.isLog ? Math.pow(10.0, dataX) : dataX;
        double y = this.channel.plot.doocsPlotAxisY.isLog ? Math.pow(10.0, dataY) : dataY;
        return String.format("X=%g, Y=%g : %s", x, y, adrString);
    }

    @Override
    public void findClosestDataPoint(DOOCSFindDataPoint dp, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        double ymin = yaxis.actMin;
        double ymax = yaxis.actMax;
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        if (this.hasData) {
            if (xaxis.isLog) {
                xmin = Math.log10(xmin);
                xmax = Math.log10(xmax);
            }
            if (yaxis.isLog) {
                ymin = Math.log10(ymin);
                ymax = Math.log10(ymax);
            }
            for (int j = 0; j < this.dataBlock.size(); ++j) {
                int len = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.length();
                for (int i = 0; i < len; ++i) {
                    double x;
                    double y;
                    if (((DOOCSHistBlock)this.dataBlock.get((int)j)).data.type() == 101) {
                        TDS tds = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_tds(i);
                        if (tds != null) {
                            y = tds.data;
                            double t = tds.tm.value;
                            x = this.getYofX(t);
                        } else {
                            y = 0.0;
                            x = 0.0;
                        }
                    } else {
                        y = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_float();
                        x = this.refContainer != null ? this.refContainer.getYData(0) : 0.0;
                    }
                    if (xaxis.isLog) {
                        x = x <= 0.0 ? -20.0 : Math.log10(x);
                    }
                    if (yaxis.isLog) {
                        y = y <= 0.0 ? -20.0 : Math.log10(y);
                    }
                    this.pt_s.setLocation(x, y);
                    tr.transform(this.pt_s, this.pt);
                    int x2 = (int)this.pt.getX();
                    int y2 = (int)this.pt.getY();
                    if (!(x >= xmin) || !(x <= xmax) || !(y >= ymin) || !(y <= ymax)) continue;
                    dp.find(x2, y2, x, y, this.getLocationAdr(0), this.getStatusMsg(i), this.channel);
                }
            }
        }
    }

    @Override
    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (!this.channel.isRefChannel) {
            boolean doAll;
            int x2 = 0;
            int y2 = 0;
            double xmin = xaxis.actMin;
            double xmax = xaxis.actMax;
            boolean isTDS = false;
            double xi = 1000.0;
            double xx = 0.0;
            Point2D.Double po = new Point2D.Double();
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
            g2d.setColor(this.channel.lineColor);
            g2d.setStroke(this.channel.strokeSize);
            Color col = this.channel.lineColor;
            Rectangle clip = g2d.getClipBounds();
            boolean bl = doAll = !this.singleUpdate;
            if (clip.x == this.channel.plot.dataAreaX0 && clip.width == this.channel.plot.dataAreaX1 - this.channel.plot.dataAreaX0) {
                doAll = true;
            }
            if (this.channel.plot.doAll) {
                doAll = true;
            }
            this.singleUpdate = false;
            int intColorFg = this.prepareDraw(g, col, tr, xaxis, yaxis);
            for (int j = 0; j < this.dataBlock.size(); ++j) {
                double t;
                TDS tds;
                double x;
                if (!this.hasData || ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.error() != 0 || !doAll && ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.length() > 1) continue;
                double t0 = x = xaxis.actMin;
                double y = yaxis.actMin;
                if (yaxis.isLog) {
                    y = Math.log10(y);
                }
                ((Point2D)po).setLocation(x, y);
                tr.transform(po, this.pt);
                int y0 = (int)this.pt.getY();
                if (((DOOCSHistBlock)this.dataBlock.get((int)j)).data.type() == 0) continue;
                boolean bl2 = isTDS = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.type() == 101;
                if (isTDS) {
                    tds = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_tds(0);
                    if (tds != null) {
                        y = tds.data;
                        t = tds.tm.value;
                        x = this.getYofX(t);
                    } else {
                        y = 0.0;
                        x = 0.0;
                    }
                } else {
                    y = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_float();
                    x = this.refContainer != null ? this.refContainer.getYData(0) : 0.0;
                }
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                this.pt_s = new Point2D.Double();
                this.pt_s.setLocation(x, y);
                tr.transform(this.pt_s, this.pt);
                int x1 = (int)this.pt.getX();
                int y1 = (int)this.pt.getY();
                for (int i = 1; i < ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.length(); ++i) {
                    boolean fl2;
                    tds = ((DOOCSHistBlock)this.dataBlock.get((int)j)).data.get_tds(i);
                    if (tds == null || tds.tm == null) continue;
                    y = tds.data;
                    t = tds.tm.value;
                    if (t == 0.0) continue;
                    x = this.getYofX(t);
                    if (this.channel.plot.debug == 1) {
                        System.out.format("  Y=%.4g, X=%.4g, T=%.9g \n", y, x, t);
                    }
                    if (xaxis.isLog) {
                        x = x <= 0.0 ? -20.0 : Math.log10(x);
                    }
                    if (yaxis.isLog) {
                        y = y <= 0.0 ? -20.0 : Math.log10(y);
                    }
                    this.pt_s.setLocation(x, y);
                    tr.transform(this.pt_s, this.pt);
                    x2 = (int)this.pt.getX();
                    y2 = (int)this.pt.getY();
                    boolean fl1 = x1 < clip.x && x2 < clip.x;
                    boolean bl3 = fl2 = x1 > clip.x + clip.width && x2 > clip.x + clip.width;
                    if (isTDS && !fl1 && !fl2) {
                        boolean fl4;
                        boolean fl3 = y1 < clip.y && y2 < clip.y;
                        boolean bl4 = fl4 = y1 > clip.y + clip.height && y2 > clip.y + clip.height;
                        if (isTDS) {
                            this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false);
                        }
                        if ((double)x1 < xi) {
                            xi = x1;
                        }
                        if ((double)x2 > xx) {
                            xx = x2;
                        }
                    }
                    x1 = x2;
                    y1 = y2;
                }
                if (isTDS) {
                    this.drawDataPoint(g2d, x1, y1, x2, y2, y0, intColorFg, false);
                    continue;
                }
                int d = 3;
                if (!(x1 < clip.x && x2 < clip.x || x1 > clip.x + clip.width && x2 > clip.x + clip.width)) {
                    this.actValueX = x1 - d;
                    this.drawDataPoint(g2d, x1 - d, y1, x1 + d, y1, y0, intColorFg, false);
                    this.drawDataPoint(g2d, x1, y1 - d, x1, y1 + d, y0, intColorFg, false);
                    continue;
                }
                this.actValueX = 0;
            }
        }
    }
}

