/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSFindDataPoint;
import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotCanvas;
import DOOCSPlot.DOOCSPlotHist;
import DOOCSPlot.DOOCSPlotMath;
import DOOCSPlot.DOOCSPlotSelection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;

public class DOOCSDataContainer {
    public DOOCSChannel channel;
    protected Point2D pt_s;
    protected Point2D pt;
    public EqData data;
    public EqCall eq;
    public String eguText = "";
    public String errorMsg = "";
    public String descriptionMsg = "";
    public String mathResult;
    protected Color color;
    protected boolean firstRead;
    public boolean hasData = false;
    public boolean hasNewData = false;
    public int chDataType;
    public ChanDisplayMode dispMode = ChanDisplayMode.DISP_DEFAULT;

    public DOOCSDataContainer() {
        this.pt = new Point();
        this.pt_s = new Point2D.Double();
        this.color = new Color(0, 0, 0);
        this.chDataType = 0;
    }

    public DOOCSDataContainer(DOOCSChannel ch) {
        this.channel = ch;
        this.pt = new Point();
        this.pt_s = new Point2D.Double();
        this.color = new Color(0, 0, 0);
        this.firstRead = true;
        this.chDataType = 0;
    }

    public String getStatusMsg(int idx) {
        if (this.errorMsg != null && this.errorMsg.length() > 0) {
            return this.errorMsg;
        }
        return this.descriptionMsg + " " + this.eguText;
    }

    public String getLocationAdr(int idx) {
        if (this.channel.plot.plotType == DOOCSPlot.PlotType.PLOTLOCATION) {
            return this.getXString(idx);
        }
        EqAdr ea = new EqAdr(this.channel.doocsAdr);
        return ea.location();
    }

    public void readEGU(EqAdr adrEgu) {
        String adrStrEgu;
        String adrStrActual;
        if (this.channel.doocsAdr.endsWith(".HIST")) {
            adrStrActual = this.channel.doocsAdr.substring(0, this.channel.doocsAdr.length() - 5);
            adrStrEgu = adrStrActual + ".EGU";
        } else {
            adrStrActual = this.channel.doocsAdr;
            adrStrEgu = this.channel.doocsAdr + ".EGU";
        }
        this.descriptionMsg = adrStrActual;
        adrEgu.adr(adrStrEgu);
        if (this.channel.doocsReadEGU) {
            try {
                this.data.init();
                this.data.set_type(16);
                EqData ed = new EqData();
                this.eq.get(adrEgu, ed, this.data);
                if (this.data.error() == 0) {
                    String txt = this.data.get_string_arg().trim();
                    this.eguText = txt.length() > 0 ? "[" + txt + "]" : "";
                    int i = this.data.get_int(0);
                    if (i == 1) {
                        this.channel.plot.doocsPlotAxisY.setIsLog(true);
                    } else {
                        this.channel.plot.doocsPlotAxisY.setIsLog(false);
                    }
                    if (i == 2) {
                        ((DOOCSPlotHist)this.channel.plot).isLogicPlot = true;
                    }
                    if (i == 1 | i == 2) {
                        ((DOOCSPlotHist)this.channel.plot).doocsPlotAxisY.setHasGrid(true);
                    }
                    double f1 = this.data.get_float(1);
                    double f2 = this.data.get_float(2);
                    if (f1 == 0.0 && f2 == 0.0) {
                        this.channel.plot.doocsPlotAxisY.setAutoScale(true);
                    } else {
                        this.channel.plot.doocsPlotAxisY.setAutoScale(false);
                        this.channel.plot.doocsPlotAxisY.setActMinMax(f1, f2);
                    }
                } else {
                    this.eguText = "";
                }
                if (((DOOCSPlotHist)this.channel.plot).isLogicPlot) {
                    this.channel.plot.doocsPlotAxisY.setIsLog(false);
                    ((DOOCSPlotHist)this.channel.plot).readBitNames(adrStrActual);
                }
            }
            catch (Exception e) {
                this.errorMsg = "EGU read error";
            }
        }
    }

    public String getEguText() {
        return this.eguText;
    }

    public String getToolTipText(double dataX, double dataY, String adrString) {
        double y = this.channel.plot.doocsPlotAxisY.isLog ? Math.pow(10.0, dataY) : dataY;
        return String.format("X=%g, Y=%g : %s", dataX, y, adrString);
    }

    public float[] getSelectedData() {
        return null;
    }

    public int getDataLength() {
        return 0;
    }

    public double getDataInc() {
        return 0.0;
    }

    public double getDataOffset() {
        return 0.0;
    }

    public double getYData(int idx) {
        return this.data.get_float();
    }

    public double getYofX(double x) {
        return 0.0;
    }

    public double getXData(int idx) {
        return 1.0;
    }

    public String getXString(int idx) {
        return "";
    }

    public boolean hasValidData() {
        return this.data.error() == 0;
    }

    public int getDataType() {
        return this.chDataType;
    }

    public void print(String fileName) {
        System.out.println("Data of " + this.channel.doocsAdr + "; Description=" + this.getStatusMsg(0));
        if (this.mathResult != null && this.mathResult.length() > 2) {
            System.out.println("Math result = " + this.mathResult);
        }
        int l = this.getDataLength();
        for (int i = 0; i < l; ++i) {
            System.out.println(this.getXData(i) + " " + this.getYData(i));
        }
    }

    public void findClosestDataPoint(DOOCSFindDataPoint dp, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double xmin = xaxis.actMin;
        double xmax = xaxis.actMax;
        double ymin = yaxis.actMin;
        double ymax = yaxis.actMax;
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        if (this.hasValidData()) {
            int len;
            if (xaxis.isLog) {
                xmin = Math.log10(xmin);
                xmax = Math.log10(xmax);
            }
            if (yaxis.isLog) {
                ymin = Math.log10(ymin);
                ymax = Math.log10(ymax);
            }
            if ((len = this.getDataLength()) == 0) {
                float f = this.data.get_float();
                double x = xaxis.actMin;
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                xmax = xaxis.actMax;
                if (xaxis.isLog) {
                    xmax = xmax <= 0.0 ? -20.0 : Math.log10(xmax);
                }
                double y = f;
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                this.pt_s.setLocation(x, y);
                tr.transform(this.pt_s, this.pt);
                int x1 = (int)this.pt.getX();
                int y1 = (int)this.pt.getY();
                this.pt_s.setLocation(xmax, y);
                tr.transform(this.pt_s, this.pt);
                int x2 = (int)this.pt.getX();
                dp.find(x1, y1, x, y, this.getLocationAdr(0), this.getStatusMsg(0), this.channel);
                dp.find(x2, y1, x, y, this.getLocationAdr(0), this.getStatusMsg(0), this.channel);
            } else if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    double x = this.getXData(i);
                    if (xaxis.isLog) {
                        x = x <= 0.0 ? -20.0 : Math.log10(x);
                    }
                    double y = (float)this.getYData(i);
                    if (yaxis.isLog) {
                        y = y <= 0.0 ? -20.0 : Math.log10(y);
                    }
                    this.pt_s.setLocation(x, y);
                    tr.transform(this.pt_s, this.pt);
                    int x2 = (int)this.pt.getX();
                    int y2 = (int)this.pt.getY();
                    if (!(x >= xmin) || !(x <= xmax) || !(y >= ymin) || !(y <= ymax)) continue;
                    dp.find(x2, y2, x, y, this.getLocationAdr(i), this.getStatusMsg(i), this.channel);
                }
            }
        }
    }

    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.data.error() == 0 && this.data.type() == 19) {
            double f = this.getXData(0);
            if (f < xaxis.actMin) {
                xaxis.actMin = f;
            }
            if ((f = this.getXData(this.getDataLength() - 1)) > xaxis.actMax) {
                xaxis.actMax = f;
            }
        }
    }

    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.data.error() == 0 && this.data.type() == 19) {
            for (int i = 0; i < this.getDataLength(); ++i) {
                double x = this.getXData(i);
                if (!(x >= xaxis.actMin) || !(x <= xaxis.actMax)) continue;
                double f = this.getYData(i);
                if (f < yaxis.actMin) {
                    yaxis.actMin = f;
                }
                if (!(f > yaxis.actMax)) continue;
                yaxis.actMax = f;
            }
        }
    }

    public boolean update() {
        return false;
    }

    public void drawLine(Graphics2D g2d, int x1, int y1, int x2, int y2, int intColorFg) {
        DOOCSPlotCanvas canvas = this.channel.plot.getCanvas();
        if (canvas != null) {
            canvas.drawLine(x1, y1, x2, y2, intColorFg);
        } else {
            g2d.drawLine(x1, y1, x2, y2);
        }
    }

    public void drawDataPoint(Graphics2D g2d, int x1, int y1, int x2, int y2, int y0, int intColorFg, boolean noLineDraw) {
        int w = (int)this.channel.strokeSize.getLineWidth();
        DOOCSPlotCanvas canvas = this.channel.plot.getCanvas();
        if (canvas != null) {
            canvas.drawLine(x1, y1, x2, y2, intColorFg);
        } else {
            switch (this.channel.lineStyle) {
                case LineFilled: {
                    if (noLineDraw || x1 == x2 && y0 == y1) break;
                    if (x1 == x2) {
                        ++x2;
                    }
                    if (y0 != y1 || y0 == y2) {
                        // empty if block
                    }
                    int[] x = new int[]{x1, x1, x2, x2};
                    int[] y = new int[]{y0, ++y1, ++y2, y0};
                    g2d.fillPolygon(x, y, 4);
                    break;
                }
                case Bar: {
                    g2d.fillRect(x1 - w / 2, y1 < y0 ? y1 : y0, w, Math.abs(y1 - y0));
                    break;
                }
                case BarFilled: {
                    w = Math.abs(x2 - x1) + 1;
                    g2d.fillRect(x1 - w / 2, y1 < y0 ? y1 : y0, w, Math.abs(y1 - y0));
                    break;
                }
                case VarBar: {
                    int m = this.channel.plot.doocsAdrList.nChannels;
                    int i = m - this.channel.channelIndex;
                    w = Math.round((float)(i * Math.abs(x2 - x1)) * 0.8f / (float)m);
                    if (w <= 0) {
                        w = 1;
                    }
                    g2d.fillRect(x1 - w / 2, y1 < y0 ? y1 : y0, w, Math.abs(y1 - y0));
                    break;
                }
                case Line: {
                    if (noLineDraw) break;
                    g2d.drawLine(x1, y1, x2, y2);
                    break;
                }
            }
            w = (int)((double)w * 1.5);
            if (w < 2) {
                w = 2;
            }
            switch (this.channel.marks) {
                case Dot: {
                    if (this.channel.lineStyle != DOOCSChannel.LineStyle.None) break;
                    g2d.drawLine(x1, y1, x1 + w / 2, y1 + w / 2);
                    break;
                }
                case Cross: {
                    g2d.drawLine(x1 - w, y1, x1 + w, y1);
                    g2d.drawLine(x1, y1 - w, x1, y1 + w);
                    break;
                }
                case CrossSmall: {
                    g2d.drawLine(x1 - 1, y1, x1 + 1, y1);
                    g2d.drawLine(x1, y1 - 1, x1, y1 + 1);
                    break;
                }
                case Square: {
                    g2d.drawRect(x1 - w, y1 - w, 2 * w, 2 * w);
                    break;
                }
                case Cross45: {
                    g2d.drawLine(x1 - w, y1 - w, x1 + w, y1 + w);
                    g2d.drawLine(x1 - w, y1 + w, x1 + w, y1 - w);
                    break;
                }
                case Circle: {
                    g2d.drawOval(x1 - w, y1 - w, 2 * w, 2 * w);
                    break;
                }
                case Triangle: {
                    int[] xPoints = new int[]{x1 - w, x1, x1 + w};
                    int[] yPoints = new int[]{y1 + w, y1 - w, y1 + w};
                    g2d.drawPolygon(xPoints, yPoints, 3);
                    break;
                }
                case Diamond: {
                    int[] xPts = new int[]{x1 - w, x1, x1 + w, x1};
                    int[] yPts = new int[]{y1, y1 + w, y1, y1 - w};
                    g2d.drawPolygon(xPts, yPts, 4);
                    break;
                }
            }
        }
    }

    public int prepareDraw(Graphics g, Color col, AffineTransform tr, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setStroke(this.channel.strokeSize);
        if (this.channel.plot.getCanvas() == null) {
            g2d.setColor(col);
        }
        return 0xFF000000 | col.getRed() << 16 | col.getGreen() << 8 | col.getBlue();
    }

    void cancel() {
    }

    void startMonitoring() {
    }

    private void drawResult(Graphics2D g2d, String tmp, int x, int y) {
        g2d.setColor(this.color);
        g2d.drawString(tmp, x, y);
    }

    public void paintMathFct(Graphics g, DOOCSPlotMath fct, DOOCSPlotSelection sel, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        double res = 0.0;
        double resMin = 1.0E10;
        double resMax = -1.0E10;
        double s = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        double sxx = 0.0;
        double sxy = 0.0;
        double c = 0.0;
        double m = 0.0;
        int count = 0;
        double y = 0.0;
        double y_2 = 0.0;
        double xMi = 0.0;
        double xMa = 0.0;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.channel.lineColor);
        g2d.setStroke(this.channel.strokeMath);
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        if (this.hasValidData() && this.channel.plot.doocsPlotSelection.isActive()) {
            double x;
            for (int i = 0; i < this.getDataLength(); ++i) {
                x = this.getXData(i);
                if (!sel.isIn(x, y = this.getYData(i))) continue;
                switch (sel.mathType) {
                    case RMS: {
                        res += y * y;
                        break;
                    }
                    case MINMAX: {
                        if (y > resMax) {
                            resMax = y;
                            xMa = x;
                        }
                        if (!(y < resMin)) break;
                        resMin = y;
                        xMi = x;
                        break;
                    }
                    case MEAN: {
                        res += y;
                        sxx += y * y;
                        break;
                    }
                    case DFT: {
                        break;
                    }
                    case FITLINE: {
                        sx += x;
                        sy += y;
                        sxx += x * x;
                        sxy += x * y;
                        break;
                    }
                    case GAUSS: {
                        res += y;
                        sxx += y * y;
                    }
                }
                ++count;
            }
            if (count > 0) {
                x = this.channel.plot.selectionXMin();
                if (x < xaxis.actMin) {
                    x = xaxis.actMin;
                }
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                double x_2 = this.channel.plot.selectionXMax();
                if (x > xaxis.actMax) {
                    x = xaxis.actMax;
                }
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                switch (sel.mathType) {
                    case RMS: {
                        y_2 = res = Math.sqrt(res / (double)count);
                        y = res;
                        break;
                    }
                    case MINMAX: {
                        y = resMax;
                        y_2 = resMin;
                        break;
                    }
                    case MEAN: {
                        s = ((double)count * sxx - res * res) / (double)((count - 1) * count);
                        s = Math.sqrt(s);
                        y_2 = res /= (double)count;
                        y = res;
                        break;
                    }
                    case DFT: {
                        break;
                    }
                    case FITLINE: {
                        s = count;
                        double del = s * sxx - sx * sx;
                        c = (sxx * sy - sx * sxy) / del;
                        m = (s * sxy - sx * sy) / del;
                        y = x * m + c;
                        y_2 = x_2 * m + c;
                        break;
                    }
                    case GAUSS: {
                        y = sxx = Math.sqrt(sxx / (double)count);
                        s = ((double)count * sxx - res * res) / (double)((count - 1) * count);
                        s = Math.sqrt(s);
                        y_2 = res /= (double)count;
                    }
                }
                if (xaxis.isLog) {
                    x = x <= 0.0 ? -20.0 : Math.log10(x);
                }
                if (yaxis.isLog) {
                    y = y <= 0.0 ? -20.0 : Math.log10(y);
                }
                Point2D.Double po = new Point2D.Double();
                ((Point2D)po).setLocation(x, y);
                tr.transform(po, this.pt);
                int x1 = (int)this.pt.getX();
                int y1 = (int)this.pt.getY();
                if (xaxis.isLog) {
                    x_2 = x_2 <= 0.0 ? -20.0 : Math.log10(x_2);
                }
                if (yaxis.isLog) {
                    y_2 = y_2 <= 0.0 ? -20.0 : Math.log10(y_2);
                }
                ((Point2D)po).setLocation(x_2, y_2);
                tr.transform(po, this.pt);
                int x2 = (int)this.pt.getX();
                int y2 = (int)this.pt.getY();
                switch (sel.mathType) {
                    case RMS: {
                        g2d.drawLine(x1, y1, x2, y1);
                        g2d.setColor(xaxis.getForeground());
                        g2d.setBackground(xaxis.getBackground());
                        this.mathResult = String.format("RMS=%.4g", res);
                        break;
                    }
                    case MEAN: {
                        g2d.drawLine(x1, y1, x2, y1);
                        g2d.setColor(xaxis.getForeground());
                        this.mathResult = String.format("Mean=%.4g, SD=%.4g", res, s);
                        break;
                    }
                    case MINMAX: {
                        ((Point2D)po).setLocation(xMi, y_2);
                        tr.transform(po, this.pt);
                        x1 = (int)this.pt.getX();
                        ((Point2D)po).setLocation(xMa, y_2);
                        tr.transform(po, this.pt);
                        x2 = (int)this.pt.getX();
                        if (xMa > xMi) {
                            g2d.drawRect(x1, y1, Math.abs(x2 - x1), Math.abs(y2 - y1));
                        } else {
                            g2d.drawRect(x2, y1, Math.abs(x1 - x2), Math.abs(y2 - y1));
                        }
                        g2d.setColor(xaxis.getForeground());
                        this.mathResult = String.format("min=%.4g ,max=%.4g", resMin, resMax);
                        break;
                    }
                    case FITLINE: {
                        if (count < 2) break;
                        g2d.drawLine(x1, y1, x2, y2);
                        this.mathResult = String.format("y = %.4g * x + %.4g", m, c);
                        break;
                    }
                    case GAUSS: {
                        this.mathResult = String.format("Mean=%.4g, SD=%.4g, RMS=%.4g", res, s, y);
                    }
                }
            } else {
                this.mathResult = "";
            }
        }
    }

    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        Point2D.Double po = new Point2D.Double();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.channel.lineColor);
        BasicStroke myStroke = new BasicStroke(1.0f);
        g2d.setStroke(myStroke);
        AffineTransform tr = this.channel.plot.doocsAdrList.transformer;
        if (this.data.error() == 0) {
            float f = this.data.get_float();
            double x = xaxis.actMin;
            if (xaxis.isLog) {
                x = x <= 0.0 ? -20.0 : Math.log10(x);
            }
            double xmax = xaxis.actMax;
            if (xaxis.isLog) {
                xmax = xmax <= 0.0 ? -20.0 : Math.log10(xmax);
            }
            double y = f;
            if (yaxis.isLog) {
                y = y <= 0.0 ? -20.0 : Math.log10(y);
            }
            this.pt_s.setLocation(x, y);
            tr.transform(this.pt_s, this.pt);
            int x1 = (int)this.pt.getX();
            int y1 = (int)this.pt.getY();
            this.pt_s.setLocation(xmax, y);
            tr.transform(this.pt_s, this.pt);
            int x2 = (int)this.pt.getX();
            g2d.drawLine(x1, y1, x2, y1);
        }
    }

    public static enum ChanDisplayMode {
        DISP_DEFAULT,
        DISP_I,
        DISP_Q,
        DISP_AMPL,
        DISP_PHASE;

    }
}

