/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSDataContainer;
import DOOCSPlot.DOOCSDataContainerHist;
import DOOCSPlot.DOOCSDataContainerHistDAQ;
import DOOCSPlot.DOOCSDataContainerHistXY;
import DOOCSPlot.DOOCSDataContainerLocation;
import DOOCSPlot.DOOCSDataContainerLocationFile;
import DOOCSPlot.DOOCSDataContainerRefDFT;
import DOOCSPlot.DOOCSDataContainerRefHISTOGRAM;
import DOOCSPlot.DOOCSDataContainerSpect;
import DOOCSPlot.DOOCSDataContainerSpectDAQ;
import DOOCSPlot.DOOCSDataContainerSpectFile;
import DOOCSPlot.DOOCSDataContainerSpectXY;
import DOOCSPlot.DOOCSFindDataPoint;
import DOOCSPlot.DOOCSInfoTip;
import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotAxis;
import DOOCSPlot.DOOCSPlotMath;
import DOOCSPlot.DOOCSPlotSelection;
import DOOCSPlot.utils.MarksComboBox;
import DOOCSPlot.utils.PlotDataTable;
import DOOCSPlot.utils.StyleComboBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.File;
import java.util.List;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;

public class DOOCSChannel {
    public DOOCSDataContainer dataContainer;
    public DOOCSDataContainer refContainer;
    public Color lineColor;
    public int channelIndex;
    public boolean isRefChannel = false;
    public LineStyle lineStyle = LineStyle.Line;
    public BasicStroke strokeSize;
    public Marks marks = Marks.None;
    public BasicStroke strokeMath;
    public DOOCSPlot plot;
    public String doocsAdr;
    private DOOCSPlotMath mathFct;
    public DOOCSPlotSelection selection;
    public boolean doocsReadEGU = true;
    public boolean isInitialized = false;
    public boolean isVisible = true;
    public String chanErrorMsg = null;
    public DOOCSInfoTip infoTip;
    private Container tipContainer = null;
    protected static final Color[] colTab = new Color[]{new Color(0, 80, 120), new Color(0, 250, 0), new Color(0, 0, 250), new Color(250, 200, 0), new Color(0, 250, 250), new Color(250, 0, 250), new Color(80, 130, 250), new Color(250, 130, 130), new Color(130, 250, 0), new Color(0, 250, 130), new Color(200, 130, 0), new Color(0, 130, 250), new Color(130, 0, 250), new Color(130, 250, 130), new Color(130, 80, 250), new Color(200, 130, 130), new Color(0, 130, 0), new Color(130, 0, 0), new Color(0, 0, 130), new Color(0, 130, 130), new Color(130, 130, 0), new Color(130, 0, 130), new Color(120, 200, 120), new Color(100, 100, 100), new Color(0, 150, 50), new Color(0, 200, 150), new Color(80, 200, 50), new Color(150, 200, 200), new Color(80, 200, 250), new Color(80, 150, 200), new Color(80, 250, 50), new Color(80, 150, 250), new Color(0, 200, 100), new Color(0, 250, 120), new Color(0, 250, 200), new Color(50, 150, 0), new Color(50, 200, 0), new Color(50, 50, 100), new Color(50, 50, 200), new Color(80, 250, 0), new Color(80, 50, 50), new Color(80, 50, 150), new Color(80, 50, 250), new Color(80, 100, 50), new Color(80, 100, 100), new Color(80, 150, 50), new Color(80, 100, 150), new Color(80, 150, 250), new Color(80, 150, 150), new Color(120, 100, 200), new Color(80, 150, 100), new Color(120, 150, 200), new Color(80, 200, 50), new Color(80, 200, 150), new Color(120, 200, 250), new Color(80, 250, 50), new Color(80, 200, 200), new Color(120, 200, 100), new Color(80, 250, 250), new Color(80, 250, 100), new Color(100, 250, 250), new Color(120, 250, 200), new Color(150, 250, 250), new Color(250, 250, 250), new Color(50, 250, 150)};
    public static Color colRed = new Color(1.0f, 0.0f, 0.0f);
    public static Color colOff = new Color(0.5f, 0.5f, 0.5f);
    public static Color colTrans = new Color(1.0f, 1.0f, 0.0f);
    public static Color colAlt = new Color(1.0f, 0.0f, 1.0f);
    public static Color colOffLine = new Color(0.25f, 0.25f, 0.25f);

    public DOOCSChannel(DOOCSPlot p, String adr) {
        this.plot = p;
        this.doocsAdr = adr;
        this.dataContainer = null;
        this.chanErrorMsg = null;
        this.lineColor = this.createColorByIndex(p.colorIndex, p.getBackground());
        ++this.plot.colorIndex;
        this.strokeSize = new BasicStroke(2.0f);
        float[] dash = new float[]{4.0f, 2.0f};
        this.strokeMath = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        this.infoTip = new DOOCSInfoTip(p);
    }

    static DOOCSChannel clone(DOOCSPlot plotSrc, DOOCSPlot p, DOOCSChannel chan, DOOCSPlot.PlotType plotT) {
        if (chan.dataContainer == null) {
            System.out.println("Ref == NULL!! " + chan.toString());
        }
        DOOCSChannel ch = new DOOCSChannel(plotSrc, chan.doocsAdr);
        if (plotT == DOOCSPlot.PlotType.PLOTDFTREF || plotT == DOOCSPlot.PlotType.PLOTHISTOGRAMREF) {
            ch.refContainer = chan.dataContainer;
        }
        ch.lineColor = chan.lineColor;
        ch.doocsAdr = chan.doocsAdr;
        return ch;
    }

    public Color createColorByIndex(int i, Color bg) {
        if (bg == null && this.plot.getParent() != null) {
            bg = this.plot.getParent().getBackground();
        }
        if (bg == null) {
            bg = Color.WHITE;
        }
        return colTab[i % 63];
    }

    void initDFTRef(DataSource src, File file) {
        this.dataContainer = new DOOCSDataContainerRefDFT(this, this.refContainer);
        if (this.refContainer != null) {
            this.dataContainer.eguText = this.refContainer.eguText;
        }
    }

    void initHISTOGRAMRef(DataSource src, File file) {
        this.dataContainer = new DOOCSDataContainerRefHISTOGRAM(this, this.refContainer);
        if (this.refContainer != null) {
            this.plot.doocsPlotAxisX.setEguText(this.refContainer.eguText);
        }
        this.lineStyle = LineStyle.BarFilled;
    }

    void initSpect(DataSource src, File file) {
        switch (src) {
            case DOOCS: {
                this.dataContainer = new DOOCSDataContainerSpect(this);
                break;
            }
            case FILE: {
                this.dataContainer = new DOOCSDataContainerSpectFile(this, file);
                break;
            }
            default: {
                this.dataContainer = null;
            }
        }
    }

    void initSpectDAQ(DataSource src, String file) {
        switch (src) {
            case DAQ: {
                this.dataContainer = new DOOCSDataContainerSpectDAQ(this, file);
                break;
            }
            default: {
                this.dataContainer = null;
            }
        }
    }

    void initHist(DataSource src, File file, String strFile) {
        switch (src) {
            case DOOCS: {
                this.dataContainer = new DOOCSDataContainerHist(this);
                break;
            }
            case FILE: {
                this.dataContainer = new DOOCSDataContainerHist(this);
                break;
            }
            case DAQ: {
                this.dataContainer = new DOOCSDataContainerHistDAQ(this, strFile);
                break;
            }
            default: {
                this.dataContainer = null;
            }
        }
    }

    void initLocation(DataSource src, File file) {
        switch (src) {
            case DOOCS: {
                this.dataContainer = new DOOCSDataContainerLocation(this);
                break;
            }
            case FILE: {
                this.dataContainer = new DOOCSDataContainerLocationFile(this, file);
                break;
            }
            default: {
                this.dataContainer = null;
            }
        }
    }

    void initXY(DataSource src, File file) {
        switch (src) {
            case DOOCS: {
                this.dataContainer = new DOOCSDataContainerSpectXY(this);
                break;
            }
            case DOOCS_HIST: {
                this.dataContainer = new DOOCSDataContainerHistXY(this);
                break;
            }
            case FILE: {
                this.dataContainer = new DOOCSDataContainerHistXY(this);
                break;
            }
            default: {
                this.dataContainer = null;
            }
        }
    }

    void init() {
        block37: {
            String tmp = this.doocsAdr;
            if (this.doocsAdr == null) {
                tmp = "";
            }
            boolean chAdr = true;
            if (tmp.length() < 5) {
                chAdr = false;
            }
            if (tmp.contains("/")) {
                tmp = tmp.substring(tmp.indexOf("/") + 1);
            }
            if (tmp.contains("/")) {
                tmp = tmp.substring(tmp.indexOf("/") + 1);
            }
            if (!tmp.contains("/")) {
                chAdr = false;
            }
            if (tmp.startsWith("/")) {
                chAdr = false;
            }
            if (tmp.startsWith("file:")) {
                chAdr = false;
            }
            if (this.doocsAdr == null) {
                chAdr = true;
            }
            if (chAdr) {
                switch (this.plot.plotType) {
                    case PLOTSPECTRUM: {
                        this.initSpect(DataSource.DOOCS, null);
                        break;
                    }
                    case PLOTHIST: {
                        this.initHist(DataSource.DOOCS, null, null);
                        break;
                    }
                    case PLOTLOCATION: {
                        this.initLocation(DataSource.DOOCS, null);
                        break;
                    }
                    case PLOTXY: {
                        EqAdr adr = new EqAdr(this.doocsAdr + ".HIST");
                        EqData inData = new EqData();
                        EqData resData = new EqData();
                        EqCall eqCall = new EqCall();
                        eqCall.get(adr, inData, resData);
                        if (resData.error() == 0) {
                            this.initXY(DataSource.DOOCS_HIST, null);
                            break;
                        }
                        this.initXY(DataSource.DOOCS, null);
                        break;
                    }
                    case PLOTDFTREF: {
                        this.initDFTRef(DataSource.DOOCS, null);
                        break;
                    }
                    case PLOTHISTOGRAMREF: {
                        this.initHISTOGRAMRef(DataSource.DOOCS, null);
                        break;
                    }
                }
            } else {
                String fName = this.doocsAdr;
                if (fName.startsWith("file:")) {
                    fName = fName.substring(5);
                    try {
                        File file = new File(fName);
                        if (file.canRead()) {
                            switch (this.plot.plotType) {
                                case PLOTSPECTRUM: {
                                    this.initSpect(DataSource.FILE, file);
                                    break;
                                }
                                case PLOTHIST: {
                                    this.initHist(DataSource.FILE, file, null);
                                    break;
                                }
                                case PLOTLOCATION: {
                                    this.initLocation(DataSource.FILE, file);
                                    break;
                                }
                                case PLOTXY: {
                                    this.initXY(DataSource.FILE, file);
                                    break;
                                }
                                case PLOTDFTREF: {
                                    this.initDFTRef(DataSource.FILE, file);
                                    break;
                                }
                                case PLOTHISTOGRAMREF: {
                                    this.initHISTOGRAMRef(DataSource.FILE, file);
                                    break;
                                }
                            }
                            break block37;
                        }
                        String str = file.getAbsolutePath();
                        this.chanErrorMsg = "Can't read file error: " + str;
                    }
                    catch (Exception e) {
                        this.chanErrorMsg = "read file error: " + e.toString();
                    }
                } else if (fName.startsWith("daq:")) {
                    fName = fName.substring(4);
                    switch (this.plot.plotType) {
                        case PLOTSPECTRUM: {
                            this.initSpectDAQ(DataSource.DAQ, fName);
                            break;
                        }
                        case PLOTHIST: {
                            this.initHist(DataSource.DAQ, null, fName);
                            break;
                        }
                    }
                }
            }
        }
        this.isInitialized = true;
    }

    public void findClosestDataPoint(DOOCSFindDataPoint dp, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.dataContainer != null) {
            this.dataContainer.findClosestDataPoint(dp, xaxis, yaxis);
        }
    }

    public String getToolTipText(double dataX, double dataY, String adrString) {
        return this.dataContainer.getToolTipText(dataX, dataY, adrString);
    }

    public int isOnDataTip(int x, int y) {
        return this.infoTip.isOnIndex(x, y);
    }

    public String getDataTipText(int idx) {
        return this.infoTip.getText(idx);
    }

    public Point getDataTipPosition(int idx) {
        return this.infoTip.getPosition(idx);
    }

    public void setLegend(List<DOOCSChannel> listChan) {
        if (this.dataContainer != null) {
            listChan.add(this);
        }
    }

    void setDataTable(PlotDataTable table) {
        table.setRow(this.channelIndex, this);
    }

    void setDataParameter(int index, String parameter, Object obj) {
        if (this.channelIndex == index) {
            if (parameter.startsWith("Style")) {
                this.lineStyle = ((StyleComboBox)obj).getStyle();
            } else if (parameter.startsWith("Marks")) {
                this.marks = ((MarksComboBox)obj).getStyle();
            }
        }
    }

    public String getLegendString() {
        StringBuffer tmp = new StringBuffer("");
        if (this.chanErrorMsg != null && this.chanErrorMsg.length() > 0) {
            tmp.append(this.chanErrorMsg);
        } else if (this.dataContainer != null && this.dataContainer.hasData) {
            tmp.append(this.dataContainer.descriptionMsg);
            if (this.dataContainer.eguText != null && this.dataContainer.eguText.length() < 30) {
                tmp.append(" ");
                tmp.append(this.dataContainer.eguText);
            }
            if (this.dataContainer.mathResult != null) {
                tmp.append(" : ");
                tmp.append(this.dataContainer.mathResult);
            }
        } else {
            tmp.append("Error: no data");
        }
        return tmp.toString();
    }

    public boolean getLegendError() {
        return this.chanErrorMsg != null && this.chanErrorMsg.length() > 0;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color col) {
        this.lineColor = col;
        this.plot.doocsAdrList.setLegend();
    }

    public int getStrokeSize() {
        return (int)this.strokeSize.getLineWidth();
    }

    public void setStrokeSize(int s) {
        this.strokeSize = new BasicStroke(s);
    }

    public void setLineStyle(String value) {
        this.lineStyle = LineStyle.valueOf(value);
    }

    public String getLineStyle() {
        return this.lineStyle.name();
    }

    public void setLineMark(String value) {
        this.marks = Marks.valueOf(value);
    }

    public String getLineMark() {
        return this.marks.name();
    }

    public void autoScaleX(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.isInitialized && this.dataContainer != null) {
            this.dataContainer.autoScaleX(xaxis, yaxis);
        }
    }

    public void autoScaleY(DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.isInitialized && this.dataContainer != null) {
            this.dataContainer.autoScaleY(xaxis, yaxis);
        }
    }

    public void cancel() {
        if (this.dataContainer != null) {
            this.dataContainer.cancel();
        }
    }

    public void startMonitoring() {
        if (this.dataContainer != null) {
            this.dataContainer.startMonitoring();
        }
    }

    boolean update() {
        boolean flag = false;
        if (this.dataContainer != null) {
            flag = this.dataContainer.update();
            this.channelIndex = this.plot.doocsAdrList.countChannels++;
        }
        return flag;
    }

    public void print(String fileName) {
        this.dataContainer.print(fileName);
    }

    public Color getErrorColor(int lastSts) {
        int i = lastSts & 0xF;
        switch (i) {
            case 1: {
                return colRed;
            }
            case 2: {
                return colOff;
            }
            case 3: {
                return colTrans;
            }
            case 4: {
                return colAlt;
            }
            case 6: {
                return colOffLine;
            }
        }
        return this.lineColor;
    }

    public void createMathFct(DOOCSPlotMath fct, DOOCSPlotSelection sel) {
        this.mathFct = fct;
        this.selection = sel;
    }

    public void paintMathFct(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.dataContainer != null && this.selection != null) {
            if (this.selection.mathType != DOOCSPlotSelection.MathType.NULL) {
                this.dataContainer.paintMathFct(g, this.mathFct, this.selection, xaxis, yaxis);
            } else {
                this.dataContainer.mathResult = null;
            }
        }
    }

    void paintComponent(Graphics g, DOOCSPlotAxis xaxis, DOOCSPlotAxis yaxis) {
        if (this.isInitialized && this.dataContainer != null && this.isVisible) {
            this.dataContainer.paintComponent(g, xaxis, yaxis);
        }
        if (this.infoTip != null && this.plot.showDataTip) {
            this.infoTip.paintComponent(g);
        }
    }

    void paintLegend(Graphics g, int x0, int y0, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        String stsMsg = null;
        stsMsg = this.chanErrorMsg != null ? this.chanErrorMsg : "";
        if (this.dataContainer != null && this.dataContainer.getStatusMsg(0) != null) {
            stsMsg = this.dataContainer.getStatusMsg(0);
        }
        if (!this.plot.doocsPlotLegend.isVisible()) {
            if (this.chanErrorMsg != null && this.chanErrorMsg.length() > 0) {
                g2d.setColor(Color.RED);
                g2d.drawString(this.chanErrorMsg, x0, y0);
            } else {
                g2d.drawString(stsMsg, x0, y0);
            }
        }
    }

    int paintEGU(Graphics g, int x0, int y0, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        String egu = null;
        if (this.dataContainer != null) {
            egu = this.dataContainer.getEguText();
        }
        if (egu != null) {
            g2d.drawString(egu, x0, y0);
            return (int)g2d.getFontMetrics().getStringBounds(egu, g).getWidth();
        }
        return 0;
    }

    public static enum DataSource {
        NONE,
        DOOCS,
        FILE,
        DOOCS_HIST,
        DAQ;

    }

    public static enum Marks {
        None,
        Dot,
        Cross,
        CrossSmall,
        Square,
        Cross45,
        Circle,
        Triangle,
        Diamond;

    }

    public static enum LineStyle {
        None,
        Line,
        LineFilled,
        Bar,
        BarFilled,
        VarBar;

    }
}

