/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import DOOCSPlot.DOOCSPlotHist;
import editor.DoocsFrameCache;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import layoutmanager.ScaleConstraints;
import layoutmanager.ScaleLayout;

public class DOOCSValueShowHist
extends JFrame {
    JScrollPane scrollPane;
    DOOCSLayeredPane EditorPanel = new DOOCSLayeredPane();
    DOOCSPlotHist PlotHist1 = new DOOCSPlotHist();
    private static String doocsAdr = null;

    public DOOCSValueShowHist(Component vcomp, boolean isLogicPlot) {
        this.initComponents(isLogicPlot);
        this.setLocationRelativeTo(vcomp);
        int newx = this.getX() + this.getWidth() / 2;
        int newy = this.getY() + this.getHeight() / 2;
        this.setLocation(newx, newy);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DOOCSValueShowHist.this.EditorPanel.setRunMode(false);
                DoocsFrameCache.getInstance().removeDOOCSLayeredPane("Hist:" + DOOCSValueShowHist.this.EditorPanel.getDoocsAddress());
            }
        });
        DoocsFrameCache.getInstance().addDOOCSLayeredPane("Hist:" + doocsAdr, this.EditorPanel);
    }

    private void initComponents(boolean isLogicPlot) {
        this.setDefaultCloseOperation(2);
        this.EditorPanel.setPreferredSize(new Dimension(379, 256));
        this.EditorPanel.setLayout(new ScaleLayout(new Dimension(379, 256)));
        this.EditorPanel.add((Component)this.PlotHist1, new ScaleConstraints(0, 0, 379, 256));
        this.EditorPanel.setDoocsAddress(doocsAdr);
        this.PlotHist1.setDOOCSParameter("adr0", doocsAdr);
        this.PlotHist1.setDOOCSParameter("doubleClickPanel", "HIST_properties.xml");
        this.PlotHist1.setIsLogicPlot(isLogicPlot);
        if (isLogicPlot) {
            this.PlotHist1.setDOOCSParameter("yLimitMax", "24");
            this.PlotHist1.setDOOCSParameter("yLimitMin", "0");
            this.PlotHist1.setDOOCSParameter("yMax", "16");
            this.PlotHist1.setDOOCSParameter("yMin", "0");
        }
        this.scrollPane = new JScrollPane(this.EditorPanel);
        this.setContentPane(this.scrollPane);
        this.EditorPanel.setRunMode(true);
        if (isLogicPlot) {
            this.setTitle("ShowStatusRegisterHist");
        } else {
            this.setTitle("ShowHist");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DOOCSValueShowHist.this.EditorPanel.setRunMode(false);
            }
        });
        this.pack();
    }

    public static void showHist(String adr, final Component vcomp) {
        doocsAdr = adr;
        DOOCSLayeredPane panel = DoocsFrameCache.getInstance().getDOOCSLayeredPane("Hist:" + doocsAdr);
        if (panel != null) {
            JFrame frameComp = DOOCSParameter.getParentFrame(panel);
            frameComp.toFront();
            frameComp.requestFocus();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DOOCSValueShowHist(vcomp, false).setVisible(true);
            }
        });
    }

    public static void showStatusRegisterHist(String adr, final Component vcomp) {
        doocsAdr = adr;
        DOOCSLayeredPane panel = DoocsFrameCache.getInstance().getDOOCSLayeredPane("Hist:" + doocsAdr);
        if (panel != null) {
            JFrame frameComp = DOOCSParameter.getParentFrame(panel);
            frameComp.toFront();
            frameComp.requestFocus();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DOOCSValueShowHist(vcomp, true).setVisible(true);
            }
        });
    }
}

