/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;

public class DOOCSToggleButtonUI
extends BasicButtonUI {
    private Color defaultBackground = null;
    private Color defaultSelectBackground = null;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);
    protected int angle;

    DOOCSToggleButtonUI(int angle) {
        this.angle = angle;
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.defaultSelectBackground = defaults.getColor("Button.select");
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JToggleButton button = (JToggleButton)c;
        ButtonModel model = button.getModel();
        String text = button.getText();
        Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        if (button.isSelected()) {
            if (this.defaultBackground == null) {
                this.defaultBackground = button.getBackground();
            }
            button.setBackground(this.defaultSelectBackground);
        } else if (this.defaultBackground != null) {
            button.setBackground(this.defaultBackground);
        }
        FontMetrics fm = g.getFontMetrics();
        paintViewInsets = c.getInsets(paintViewInsets);
        DOOCSToggleButtonUI.paintViewR.x = DOOCSToggleButtonUI.paintViewInsets.left;
        DOOCSToggleButtonUI.paintViewR.y = DOOCSToggleButtonUI.paintViewInsets.top;
        DOOCSToggleButtonUI.paintViewR.height = c.getWidth() - (DOOCSToggleButtonUI.paintViewInsets.left + DOOCSToggleButtonUI.paintViewInsets.right);
        DOOCSToggleButtonUI.paintViewR.width = c.getHeight() - (DOOCSToggleButtonUI.paintViewInsets.top + DOOCSToggleButtonUI.paintViewInsets.bottom);
        DOOCSToggleButtonUI.paintIconR.height = 0;
        DOOCSToggleButtonUI.paintIconR.width = 0;
        DOOCSToggleButtonUI.paintIconR.y = 0;
        DOOCSToggleButtonUI.paintIconR.x = 0;
        DOOCSToggleButtonUI.paintTextR.height = 0;
        DOOCSToggleButtonUI.paintTextR.width = 0;
        DOOCSToggleButtonUI.paintTextR.y = 0;
        DOOCSToggleButtonUI.paintTextR.x = 0;
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        if (this.angle == 90) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -c.getWidth());
        }
        if (this.angle == 270) {
            g2.rotate(-1.5707963267948966);
            g2.translate(-c.getHeight(), 0);
        }
        if (this.angle == 90 || this.angle == 270) {
            DOOCSToggleButtonUI.paintViewR.y = c.getWidth() / 2 - (int)fm.getStringBounds(text, g).getHeight() / 2;
            if (icon != null) {
                DOOCSToggleButtonUI.paintIconR.x = c.getHeight() / 2 - ((int)fm.getStringBounds(text, g).getWidth() + button.getIconTextGap() + icon.getIconWidth()) / 2;
                DOOCSToggleButtonUI.paintViewR.x = DOOCSToggleButtonUI.paintIconR.x + button.getIconTextGap() + icon.getIconWidth();
                DOOCSToggleButtonUI.paintIconR.y = c.getWidth() / 2 - icon.getIconHeight() / 2;
            } else {
                DOOCSToggleButtonUI.paintViewR.x = c.getHeight() / 2 - (int)fm.getStringBounds(text, g).getWidth() / 2;
            }
        }
        if (icon != null) {
            icon.paintIcon(c, g, DOOCSToggleButtonUI.paintIconR.x, DOOCSToggleButtonUI.paintIconR.y);
        }
        if (text != null) {
            int textX = DOOCSToggleButtonUI.paintTextR.x;
            int textY = DOOCSToggleButtonUI.paintTextR.y + fm.getAscent();
            this.paintText(g, c, new Rectangle(DOOCSToggleButtonUI.paintViewR.x, DOOCSToggleButtonUI.paintViewR.y, textX, textY), text);
        }
        g2.setTransform(tr);
    }
}

