/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSGroup;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSTimerGroupSetList;
import java.awt.Component;
import java.util.Vector;

public class DOOCSTimerGroup
extends DOOCSGroup
implements Runnable {
    private transient Thread th;
    private boolean stop = false;
    private float doocsUpdateTime = 10.0f;
    private DOOCSTimerGroupSetList doocsSetList = new DOOCSTimerGroupSetList();

    public void stopThreads() {
        this.stop = true;
    }

    public void startThreads() {
        this.stop = false;
        this.th = new Thread(this);
        this.th.start();
    }

    public void setUpdateInterval(float interval) {
        if (interval == 0.0f || (double)interval > 0.1) {
            this.doocsUpdateTime = interval;
        }
    }

    public float getUpdateInterval() {
        return this.doocsUpdateTime;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters1 = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL)};
        DOOCSParameter[] parameters2 = this.doocsSetList.getDOOCSParameterList();
        DOOCSParameter[] parameters3 = new DOOCSParameter[]{new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        DOOCSParameter[] parameters = new DOOCSParameter[parameters1.length + parameters2.length + parameters3.length];
        System.arraycopy(parameters1, 0, parameters, 0, parameters1.length);
        System.arraycopy(parameters2, 0, parameters, parameters1.length, parameters2.length);
        System.arraycopy(parameters3, 0, parameters, parameters1.length + parameters2.length, parameters3.length);
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.startsWith("property") && !parameter.startsWith("propertyValue")) {
            return this.getParameterNamesList();
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTimerGroup ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("\n");
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append("</DOOCSTimerGroup>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setUpdateInterval(Float.parseFloat(value));
        } else if (parameter.startsWith("property") && !parameter.startsWith("propertyValue")) {
            this.doocsSetList.setDoocsProperty(parameter, value);
        } else if (parameter.startsWith("propertyValue")) {
            this.doocsSetList.setDoocsPropertyValue(parameter, value);
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSTimerGroup.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getUpdateInterval());
        }
        if (parameter.startsWith("property") && !parameter.startsWith("propertyValue")) {
            return this.doocsSetList.getDoocsProperty(parameter);
        }
        if (parameter.startsWith("propertyValue")) {
            return this.doocsSetList.getDoocsPropertyValue(parameter);
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSTimerGroup.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public String[] getParameterNamesList() {
        int i;
        Vector<String> props = new Vector<String>();
        DOOCSParameter[] paramList = ((DOOCSComponent)((Object)this.getComponent(0))).getDOOCSParameterList();
        for (i = 0; i < paramList.length; ++i) {
            props.add(paramList[i].parameter);
        }
        for (i = 1; i < this.getComponentCount(); ++i) {
            DOOCSParameter[] actList = ((DOOCSComponent)((Object)this.getComponent(i))).getDOOCSParameterList();
            Vector<String> tempProps = new Vector<String>();
            tempProps.add("");
            block2: for (int prop_count = 0; prop_count < props.size(); ++prop_count) {
                for (int item_count = 0; item_count < actList.length; ++item_count) {
                    if (!((String)props.get(prop_count)).equalsIgnoreCase(actList[item_count].parameter)) continue;
                    if (actList[item_count].parameter.equalsIgnoreCase("name") || actList[item_count].parameter.equalsIgnoreCase("bounds") || actList[item_count].parameter.equalsIgnoreCase("layer") || actList[item_count].parameter.equalsIgnoreCase("scale") || actList[item_count].parameter.equalsIgnoreCase("toolTipText")) continue block2;
                    tempProps.add((String)props.get(prop_count));
                    continue block2;
                }
            }
            props = tempProps;
        }
        String[] criteria = new String[props.size()];
        return props.toArray(criteria);
    }

    @Override
    public void setRunMode(boolean bRun) {
        super.setRunMode(bRun);
        if (bRun) {
            this.startThreads();
        } else {
            this.stopThreads();
        }
    }

    @Override
    public void run() {
        String pname;
        Vector<String[]> defaultValues = new Vector<String[]>();
        for (int j = 0; j < this.doocsSetList.size(); ++j) {
            String[] werte = new String[this.getComponentCount()];
            for (int i = 0; i < this.getComponentCount(); ++i) {
                pname = this.doocsSetList.getDoocsProperty(i);
                werte[i] = ((DOOCSComponent)((Object)this.getComponent(i))).getDOOCSParameter(pname).toString();
            }
            defaultValues.add(werte);
        }
        int counter = 0;
        while (!this.stop) {
            if (!this.isRunMode()) continue;
            if (++counter > this.doocsSetList.size()) {
                counter = 0;
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (counter == 0) {
                    for (int j = 0; j < this.doocsSetList.size(); ++j) {
                        pname = this.doocsSetList.getDoocsProperty(j);
                        ((DOOCSComponent)((Object)this.getComponent(i))).setDOOCSParameter(pname, ((String[])defaultValues.get(i))[j]);
                    }
                    continue;
                }
                String pname2 = this.doocsSetList.getDoocsProperty(counter - 1);
                String pvalue = this.doocsSetList.getDoocsPropertyValue(counter - 1);
                ((DOOCSComponent)((Object)this.getComponent(i))).setDOOCSParameter(pname2, pvalue);
            }
            try {
                if ((double)this.doocsUpdateTime == 0.0) {
                    Thread.sleep(10000L);
                    continue;
                }
                if ((double)this.doocsUpdateTime < 0.1) {
                    Thread.sleep(100L);
                    continue;
                }
                Thread.sleep((long)(this.doocsUpdateTime * 1000.0f));
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
    }
}

