/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ReverseFileReader;
import editor.undo.SetProperty;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import jsvnbrowser.JSVNFileInfo;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSTextArea
extends JScrollPane
implements Runnable,
DOOCSComponent {
    private transient Thread th;
    private boolean stop = false;
    private JTextArea textArea;
    private String errorMessage = null;
    private String doocsFile;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private int doocsMaxLineNumbers = 0;
    private String doocsToolTipText = null;
    private float doocsUpdateTime = 10.0f;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;

    public DOOCSTextArea() {
        this.setPreferredSize(new Dimension(250, 150));
        this.setSize(new Dimension(250, 150));
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.getViewport().add(this.textArea);
        this.setEnabled(this.doocsRunMode);
    }

    public void stopThreads() {
        this.stop = true;
    }

    public void startThreads() {
        this.stop = false;
        this.th = new Thread(this);
        this.th.start();
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsFile(String file) {
        this.doocsFile = file;
        if (file != null) {
            this.doocsAddress = null;
        }
    }

    public String getDoocsFile() {
        return this.doocsFile;
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
        if (address != null) {
            this.doocsFile = null;
        }
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsMaxLineNumbers(int lines) {
        this.doocsMaxLineNumbers = lines;
    }

    public int getDoocsMaxLineNumbers() {
        return this.doocsMaxLineNumbers;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            this.startThreads();
        } else {
            this.stopThreads();
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("file", DOOCSParameter.ParameterTypes.FILE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("maxLineNumbers", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL, "Display all lines if maxLineNumbers = 0."), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTextArea ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSTextArea>\n");
        return xmlStructure;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.textArea.addMouseListener(ml);
        this.textArea.addMouseMotionListener(ml);
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("file")) {
            this.setDoocsFile(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("maxLineNumbers")) {
            this.setDoocsMaxLineNumbers(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("textColor")) {
            this.textArea.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.textArea.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.textArea.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSTextArea.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("file")) {
            return this.getDoocsFile();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("maxLineNumbers")) {
            return this.getDoocsMaxLineNumbers();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("textColor")) {
            return DOOCSParameter.getDoocsColor(this.textArea.getForeground());
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.textArea.getFont());
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.textArea.getBackground());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSTextArea.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void run() {
        EqCall eq = new EqCall();
        EqData ed = new EqData();
        EqData data = new EqData();
        EqAdr ea = null;
        String oldAdr = "";
        while (!this.stop) {
            if (this.doocsRunMode) {
                JSVNFileInfo fInfo;
                final StringBuffer buffer = new StringBuffer("");
                if (this.doocsFile != null && (fInfo = DOOCSParameter.getDoocsFilePath(this.doocsFile, this)) != null) {
                    if (fInfo.filepath.startsWith("/svn/")) {
                        StringTokenizer tokenizer = new StringTokenizer(new String(fInfo.buf), "\n");
                        int lineCounter = tokenizer.countTokens();
                        for (int i = 0; i < lineCounter; ++i) {
                            String line = tokenizer.nextToken();
                            if (this.doocsMaxLineNumbers == 0) {
                                buffer.append(line);
                                if (i + 1 >= lineCounter) continue;
                                buffer.append("\n");
                                continue;
                            }
                            if (i < lineCounter - this.doocsMaxLineNumbers) continue;
                            buffer.append(line);
                            if (i + 1 >= lineCounter) continue;
                            buffer.append("\n");
                        }
                    } else if (this.doocsMaxLineNumbers == 0) {
                        try {
                            String str;
                            BufferedReader in = new BufferedReader(new FileReader(DOOCSParameter.getDoocsFilePath((String)this.doocsFile, (DOOCSComponent)this).filepath));
                            while ((str = in.readLine()) != null) {
                                buffer.append(str + "\n");
                            }
                            buffer.delete(buffer.length() - 1, buffer.length());
                            in.close();
                        }
                        catch (FileNotFoundException ffe) {
                            System.out.println("FileNotFoundException: " + ffe);
                        }
                        catch (IOException ioe) {
                            System.out.println("IOException: " + ioe);
                        }
                    } else {
                        ReverseFileReader fileReader = null;
                        try {
                            fileReader = new ReverseFileReader(DOOCSParameter.getDoocsFilePath((String)this.doocsFile, (DOOCSComponent)this).filepath);
                        }
                        catch (Exception e) {
                            System.out.println("Exception: " + e);
                        }
                        for (int i = 0; i < this.doocsMaxLineNumbers; ++i) {
                            try {
                                String tmp = fileReader.readLine();
                                if (tmp != null) {
                                    if (i == 0) {
                                        buffer.insert(0, tmp);
                                        continue;
                                    }
                                    buffer.insert(0, tmp + "\n");
                                    continue;
                                }
                                break;
                            }
                            catch (Exception e) {
                                System.out.println("Exception: " + e);
                            }
                        }
                    }
                }
                if (this.fullDoocsAddress != null && this.fullDoocsAddress.length() > 5) {
                    if (!oldAdr.equalsIgnoreCase(this.fullDoocsAddress) || ea == null) {
                        oldAdr = this.fullDoocsAddress;
                        ea = new EqAdr(this.fullDoocsAddress);
                    }
                    data.init();
                    eq.get(ea, ed, data);
                    if (data.error() == 0) {
                        this.errorMessage = null;
                        for (int i = 0; i < data.length(); ++i) {
                            buffer.append(data.get_string_arg(i));
                            buffer.append("\n");
                        }
                    } else if (this.errorMessage == null) {
                        this.errorMessage = data.get_string_arg();
                        System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
                        buffer.append(this.errorMessage);
                    }
                }
                if (!this.textArea.getText().equalsIgnoreCase(buffer.toString())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DOOCSTextArea.this.textArea.setText(buffer.toString());
                            DOOCSTextArea.this.textArea.moveCaretPosition(buffer.length());
                            DOOCSTextArea.this.textArea.setSelectionStart(buffer.length());
                            DOOCSTextArea.this.textArea.setSelectionEnd(buffer.length());
                        }
                    });
                }
            }
            try {
                if ((double)this.doocsUpdateTime == 0.0) {
                    Thread.sleep(10000L);
                    continue;
                }
                if ((double)this.doocsUpdateTime < 0.1) {
                    Thread.sleep(100L);
                    continue;
                }
                Thread.sleep((long)(this.doocsUpdateTime * 1000.0f));
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

