/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSTab;
import DOOCSComponents.DOOCSTabbedPaneUI;
import editor.undo.SetProperty;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.TabbedPaneUI;
import layoutmanager.ScaleConstraints;
import layoutmanager.ScaleLayout;

public class DOOCSTabbedPane
extends JTabbedPane
implements DOOCSComponent {
    private Cursor defaultCursor = new Cursor(0);
    private Cursor waitCursor = new Cursor(3);
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private String doocsTabPlacement = "Top";
    private String doocsActiveTab = "";
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private MouseInputListener m_DOOCSMouse;
    private Rectangle m_initialBounds;
    private TabbedPaneUI defaultUI;

    public DOOCSTabbedPane() {
        this.setPreferredSize(new Dimension(100, 100));
        this.setSize(new Dimension(100, 100));
        this.setMinimumSize(new Dimension(10, 10));
        this.m_DOOCSMouse = null;
        this.defaultUI = this.getUI();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DOOCSTabbedPane.this.DOOCSTabbedPaneStateChanged(evt);
            }
        });
    }

    public void addTabs() {
        DOOCSTab tab0 = new DOOCSTab();
        tab0.setInitialBounds(tab0.getBounds());
        DOOCSTab tab1 = new DOOCSTab();
        tab1.setInitialBounds(tab1.getBounds());
        ScaleConstraints constr = new ScaleConstraints(0, 0, this.getWidth(), this.getHeight());
        this.add((Component)tab0, constr);
        this.add((Component)tab1, constr);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof DOOCSTab) {
            ((DOOCSTab)comp).setIndex(this.getTabCount());
            if (comp.getName() == null) {
                comp.setName("Tab" + this.getTabCount());
            }
            this.addTab("", comp);
            ((DOOCSComponent)((Object)comp)).addDOOCSMouseListener(this.m_DOOCSMouse);
        } else if (this.getTabCount() > 0) {
            ((DOOCSTab)this.getSelectedComponent()).add(comp, constraints);
        }
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        for (int i = 0; i < this.getTabCount(); ++i) {
            ((DOOCSTab)this.getComponentAt(i)).setIndex(i);
        }
    }

    @Override
    public Component getComponentAt(int x, int y) {
        return this.getSelectedComponent();
    }

    private void DOOCSTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.isRunMode()) {
            DOOCSParameter.getParentFrame(this).setCursor(this.waitCursor);
        }
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        if (this.doocsRunMode) {
            this.setTabsRunMode();
        }
        if (this.isRunMode()) {
            DOOCSParameter.getParentFrame(this).setCursor(this.defaultCursor);
        }
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
    }

    @Override
    public String getDoocsToolTipText() {
        return null;
    }

    public void setDoocsTabPlacement(String tabPlacement) {
        if (tabPlacement.equalsIgnoreCase("Top")) {
            this.setTabPlacement(1);
        }
        if (tabPlacement.equalsIgnoreCase("Bottom")) {
            this.setTabPlacement(3);
        }
        if (tabPlacement.equalsIgnoreCase("Left")) {
            this.setTabPlacement(2);
        }
        this.doocsTabPlacement = tabPlacement;
        if (tabPlacement.equalsIgnoreCase("Left")) {
            this.setUI(new DOOCSTabbedPaneUI());
        } else {
            this.setUI(this.defaultUI);
        }
    }

    public String getDoocsTabPlacement() {
        return this.doocsTabPlacement;
    }

    public void setDoocsActiveTab(String activeTab) {
        if (activeTab != null) {
            this.doocsActiveTab = activeTab;
            for (int i = 0; i < this.getTabCount(); ++i) {
                if (!activeTab.equalsIgnoreCase(this.getTitleAt(i))) continue;
                this.setSelectedIndex(i);
            }
        }
    }

    public String getDoocsActiveTab() {
        return this.doocsActiveTab;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
        for (int i = 0; i < this.getTabCount(); ++i) {
            ((DOOCSTab)this.getComponentAt(i)).setDoocsLayer(layer);
        }
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setTabsRunMode();
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    private void setTabsRunMode() {
        if (this.doocsRunMode) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                if (i == this.getSelectedIndex()) {
                    ((DOOCSTab)this.getComponentAt(i)).setRunMode(true);
                    ((ScaleLayout)((Container)this.getComponentAt(i)).getLayout()).resetStoredFactors();
                    continue;
                }
                ((DOOCSTab)this.getComponentAt(i)).setRunMode(false);
            }
        } else {
            for (int i = 0; i < this.getTabCount(); ++i) {
                ((DOOCSTab)this.getComponentAt(i)).setRunMode(false);
            }
        }
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setShowGrid(boolean grid) {
        ((DOOCSTab)this.getComponentAt(this.getSelectedIndex())).setShowGrid(grid);
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("tabPlacement", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("activeTab", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("tabPlacement")) {
            String[] allowedValues = new String[]{"Top", "Bottom", "Left"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTabbedPane ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        String activeTab = null;
        for (int i = 0; i < param.length; ++i) {
            if (!(param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds") || param[i].parameter.equalsIgnoreCase("activeTab"))) {
                xmlStructure.append("<" + param[i].parameter + ">");
                if (this.getDOOCSParameter(param[i].parameter) != null) {
                    xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
                }
                xmlStructure.append("</" + param[i].parameter + ">");
            }
            if (!param[i].parameter.equalsIgnoreCase("activeTab")) continue;
            activeTab = "<activeTab>" + this.getDOOCSParameter(param[i].parameter) + "</activeTab>\n";
        }
        xmlStructure.append("\n");
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append(activeTab);
        xmlStructure.append("</DOOCSTabbedPane>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("tabPlacement")) {
            this.setDoocsTabPlacement(value);
        } else if (parameter.equalsIgnoreCase("activeTab")) {
            this.setDoocsActiveTab(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSTabbedPane.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("tabPlacement")) {
            return this.getDoocsTabPlacement();
        }
        if (parameter.equalsIgnoreCase("activeTab")) {
            return this.getDoocsActiveTab();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSTabbedPane.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.m_DOOCSMouse = ml;
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((DOOCSComponent)((Object)this.getComponent(i))).addDOOCSMouseListener(ml);
        }
    }

    public void setNewBounds(int x, int y, int w, int h, boolean controlPressed) {
        if (!controlPressed) {
            double xFactor = (double)w / (double)this.m_initialBounds.width;
            double yFactor = (double)h / (double)this.m_initialBounds.height;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component comp = this.getComponent(i);
                DOOCSComponent dcomp = (DOOCSComponent)((Object)comp);
                Rectangle compBounds = dcomp.getInitialBounds();
                int xnew = (int)Math.round(compBounds.getX() * xFactor);
                int ynew = (int)Math.round(compBounds.getY() * yFactor);
                int wnew = (int)Math.round(compBounds.getWidth() * xFactor);
                int hnew = (int)Math.round(compBounds.getHeight() * yFactor);
                if (comp instanceof DOOCSLayeredPane) {
                    ((DOOCSLayeredPane)comp).setNewBounds(xnew, ynew, wnew, hnew, controlPressed);
                    continue;
                }
                comp.setBounds(xnew, ynew, wnew, hnew);
            }
        }
        this.setBounds(x, y, w, h);
    }

    public boolean isSelected(int x, int y) {
        boolean selected = false;
        if (x < 5 || x > this.getSize().width - 5) {
            selected = true;
        }
        if (y < 5 || y > this.getSize().height - 5) {
            selected = true;
        }
        int tabHeight = this.getUI().getTabBounds((JTabbedPane)this, (int)0).height;
        if (this.doocsTabPlacement.equalsIgnoreCase("Top") && y < tabHeight) {
            selected = true;
        }
        if (this.doocsTabPlacement.equalsIgnoreCase("Bottom") && y > this.getHeight() - tabHeight) {
            selected = true;
        }
        if (this.doocsTabPlacement.equalsIgnoreCase("Left") && x < tabHeight) {
            selected = true;
        }
        return selected;
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        String oldValue = this.getDoocsTabPlacement();
        if (oldValue.equalsIgnoreCase("Top")) {
            this.setDoocsTabPlacement("Bottom");
        }
        if (oldValue.equalsIgnoreCase("Bottom")) {
            this.setDoocsTabPlacement("Top");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsTabPlacement())) {
            change.add(new SetProperty(this, "tabPlacement", oldValue, this.getDoocsTabPlacement()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsTabPlacement();
        if (oldValue.equalsIgnoreCase("Top")) {
            this.setDoocsTabPlacement("Left");
        }
        if (oldValue.equalsIgnoreCase("Left")) {
            this.setDoocsTabPlacement("Bottom");
        }
        if (oldValue.equalsIgnoreCase("Bottom")) {
            this.setDoocsTabPlacement("Left");
        }
        change.add(new SetProperty(this, "tabPlacement", oldValue, this.getDoocsTabPlacement()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsTabPlacement();
        if (oldValue.equalsIgnoreCase("Top")) {
            this.setDoocsTabPlacement("Left");
        }
        if (oldValue.equalsIgnoreCase("Left")) {
            this.setDoocsTabPlacement("Top");
        }
        if (oldValue.equalsIgnoreCase("Bottom")) {
            this.setDoocsTabPlacement("Left");
        }
        change.add(new SetProperty(this, "tabPlacement", oldValue, this.getDoocsTabPlacement()));
        return change;
    }
}

