/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSSwitch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import xmlparser.IntegerParser;

public class DOOCSSwitchCase
extends DOOCSLayeredPane {
    public final int NO_COMP = -1;
    public final int EQUAL = 0;
    public final int NO_EQUAL = 1;
    public final int LESS = 2;
    public final int GREATER = 3;
    public final int LESS_EQUAL = 4;
    public final int GREATER_EQUAL = 5;
    public final int AVAILABLE = 6;
    private String doocsLowCase = "0";
    private String doocsHighCase = "1";
    private int doocsLowComparator = -1;
    private int doocsHighComparator = 0;
    private int doocsLowRadix = 10;
    private int doocsHighRadix = 10;

    public DOOCSSwitchCase() {
        this.setEnabled(false);
        this.setOpaque(false);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof DOOCSSwitchCase) {
            this.getParent().add(comp, constraints);
            return;
        }
        super.add(comp, constraints);
    }

    @Override
    public String toString() {
        String sCase = "";
        if (this.doocsLowComparator == -1 && this.doocsHighComparator == -1) {
            return "otherwise";
        }
        if (this.doocsLowComparator == 6 || this.doocsHighComparator == 6) {
            return "available";
        }
        switch (this.doocsLowComparator) {
            case 0: {
                sCase = sCase + this.doocsLowCase + " = X";
                break;
            }
            case 1: {
                sCase = sCase + this.doocsLowCase + " != X";
                break;
            }
            case 3: {
                sCase = sCase + this.doocsLowCase + " < X";
                break;
            }
            case 5: {
                sCase = sCase + this.doocsLowCase + " =< X";
                break;
            }
            default: {
                sCase = sCase + "X";
            }
        }
        switch (this.doocsHighComparator) {
            case 0: {
                sCase = sCase + " = " + this.doocsHighCase;
                break;
            }
            case 1: {
                sCase = sCase + " != " + this.doocsHighCase;
                break;
            }
            case 2: {
                sCase = sCase + " < " + this.doocsHighCase;
                break;
            }
            case 4: {
                sCase = sCase + " =< " + this.doocsHighCase;
                break;
            }
        }
        return sCase;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (name != null && name.equalsIgnoreCase("otherwise")) {
            this.doocsHighComparator = -1;
        }
    }

    public void showThisCase() {
        ((DOOCSSwitch)this.getParent()).showCase(this);
    }

    public void setLowCase(String casevalue) {
        this.doocsLowCase = casevalue;
        this.setName(this.toString());
    }

    public String getLowCase() {
        return this.doocsLowCase;
    }

    public void setHighCase(String casevalue) {
        this.doocsHighCase = casevalue;
        this.setName(this.toString());
    }

    public String getHighCase() {
        return this.doocsHighCase;
    }

    public void setLowComparator(int value) {
        if (value == 0 || value == 1 || value == 3 || value == 5 || value == 6 || value == -1) {
            this.doocsLowComparator = value;
            this.setName(this.toString());
        }
    }

    public int getLowComparator() {
        return this.doocsLowComparator;
    }

    public void setHighComparator(int value) {
        if (value == 0 || value == 1 || value == 2 || value == 4 || value == 6 || value == -1) {
            this.doocsHighComparator = value;
            this.setName(this.toString());
        }
    }

    public int getHighComparator() {
        return this.doocsHighComparator;
    }

    protected int parseComparator(String value) {
        if (value.equals("greater")) {
            return 3;
        }
        if (value.equals("greater or equal")) {
            return 5;
        }
        if (value.equals("equal")) {
            return 0;
        }
        if (value.equals("not equal")) {
            return 1;
        }
        if (value.equals("less")) {
            return 2;
        }
        if (value.equals("less or equal")) {
            return 4;
        }
        if (value.equals("available")) {
            return 6;
        }
        return -1;
    }

    protected String comparatorToString(int value) {
        switch (value) {
            case 0: {
                return "equal";
            }
            case 1: {
                return "not equal";
            }
            case 2: {
                return "less";
            }
            case 4: {
                return "less or equal";
            }
            case 3: {
                return "greater";
            }
            case 5: {
                return "greater or equal";
            }
            case 6: {
                return "available";
            }
        }
        return "ignore";
    }

    public boolean evaluateCase(Object doocsValue, int dataType) {
        if (this.doocsLowComparator == -1 && this.doocsHighComparator == -1) {
            return true;
        }
        if (doocsValue == null) {
            return false;
        }
        if (dataType == 7 || dataType == 3 || dataType == 103 || dataType == 16 || dataType == 5) {
            if (this.doocsLowComparator == 6 || this.doocsHighComparator == 6) {
                return true;
            }
            String sValue = (String)doocsValue;
            if (this.doocsLowComparator == 0) {
                return sValue.equalsIgnoreCase(this.doocsLowCase);
            }
            if (this.doocsHighComparator == 0) {
                return sValue.equalsIgnoreCase(this.doocsHighCase);
            }
            if (this.doocsLowComparator == 1) {
                return !sValue.equalsIgnoreCase(this.doocsLowCase);
            }
            if (this.doocsHighComparator == 1) {
                return !sValue.equalsIgnoreCase(this.doocsHighCase);
            }
        } else {
            if (dataType == 8 || dataType == 115 || dataType == 1 || dataType == 105 || dataType == 4 || dataType == 119 || dataType == 14) {
                Integer numLowCase = 0;
                Integer numHighCase = 0;
                if (this.doocsLowComparator == 6 || this.doocsHighComparator == 6) {
                    return true;
                }
                numLowCase = this.doocsLowCase == null ? 0 : IntegerParser.parseInt(this.doocsLowCase, this.doocsLowRadix);
                numHighCase = this.doocsHighCase == null ? 0 : IntegerParser.parseInt(this.doocsHighCase, this.doocsHighRadix);
                Integer numValue = (Integer)doocsValue;
                boolean isTrue = true;
                if (this.doocsLowComparator == 0) {
                    return numValue.equals(numLowCase);
                }
                if (this.doocsHighComparator == 0) {
                    return numValue.equals(numHighCase);
                }
                if (this.doocsLowComparator == 1) {
                    return !numValue.equals(numLowCase);
                }
                if (this.doocsHighComparator == 1) {
                    return !numValue.equals(numHighCase);
                }
                if (this.doocsLowComparator == 3) {
                    isTrue = numValue > numLowCase;
                } else if (this.doocsLowComparator == 5) {
                    boolean bl = isTrue = numValue >= numLowCase;
                }
                if (this.doocsHighComparator == 2) {
                    isTrue = isTrue && numValue < numHighCase;
                } else if (this.doocsHighComparator == 4) {
                    isTrue = isTrue && numValue <= numHighCase;
                }
                return isTrue;
            }
            if (dataType == 2 || dataType == 100) {
                Double numLowCase = 0.0;
                Double numHighCase = 0.0;
                if (this.doocsLowComparator == 6 || this.doocsHighComparator == 6) {
                    return true;
                }
                numLowCase = this.doocsLowCase == null ? 0.0 : Double.parseDouble(this.doocsLowCase);
                numHighCase = this.doocsHighCase == null ? 0.0 : Double.parseDouble(this.doocsHighCase);
                Double numValue = (Double)doocsValue;
                boolean isTrue = true;
                if (this.doocsLowComparator == 0) {
                    return numValue.equals(numLowCase);
                }
                if (this.doocsHighComparator == 0) {
                    return numValue.equals(numHighCase);
                }
                if (this.doocsLowComparator == 1) {
                    return !numValue.equals(numLowCase);
                }
                if (this.doocsHighComparator == 1) {
                    return !numValue.equals(numHighCase);
                }
                if (this.doocsLowComparator == 3) {
                    isTrue = numValue > numLowCase;
                } else if (this.doocsLowComparator == 5) {
                    boolean bl = isTrue = numValue >= numLowCase;
                }
                if (this.doocsHighComparator == 2) {
                    isTrue = isTrue && numValue < numHighCase;
                } else if (this.doocsHighComparator == 4) {
                    isTrue = isTrue && numValue <= numHighCase;
                }
                return isTrue;
            }
        }
        return false;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        if (this.doocsLowComparator == -1 && this.doocsHighComparator == -1) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{};
            return parameters;
        }
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("lowCase", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lowComparator", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("highCase", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("highComparator", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("lowcomparator")) {
            String[] allowedValues = new String[]{"ignore", "available", "equal", "not equal", "greater", "greater or equal"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("highcomparator")) {
            String[] allowedValues = new String[]{"ignore", "available", "equal", "not equal", "less", "less or equal"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSSwitchCase ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("<grid>" + this.getDoocsGrid() + "</grid>");
        xmlStructure.append("\n");
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append("</DOOCSSwitchCase>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("lowCase")) {
            this.setLowCase(value);
        } else if (parameter.equalsIgnoreCase("lowComparator")) {
            this.setLowComparator(this.parseComparator(value));
        } else if (parameter.equalsIgnoreCase("highCase")) {
            this.setHighCase(value);
        } else if (parameter.equalsIgnoreCase("highComparator")) {
            this.setHighComparator(this.parseComparator(value));
        } else if (parameter.equalsIgnoreCase("grid")) {
            this.setDoocsGrid(value);
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else {
            System.out.println("DOOCSSwitchCase.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("lowCase")) {
            return this.getLowCase();
        }
        if (parameter.equalsIgnoreCase("lowComparator")) {
            return this.comparatorToString(this.getLowComparator());
        }
        if (parameter.equalsIgnoreCase("highCase")) {
            return this.getHighCase();
        }
        if (parameter.equalsIgnoreCase("highComparator")) {
            return this.comparatorToString(this.getHighComparator());
        }
        System.out.println("DOOCSSwitchCase.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isRunMode()) {
            super.paintComponent(g);
            Color col = g.getColor();
            g.setColor(Color.GRAY);
            Font font = g.getFont();
            g.setFont(new Font("Arial", 0, 12));
            g.drawString(this.toString(), 2, this.getHeight() - 2);
            g.setColor(col);
            g.setFont(font);
        }
    }

    @Override
    public void setRunMode(boolean bRun) {
        super.setRunMode(bRun);
        this.setEnabled(bRun);
    }
}

