/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSIfCase;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSSwitchCase;
import DOOCSComponents.ShowException;
import DOOCSComponents.switchcase.SwitchLayout;
import editor.EditorPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.event.MouseInputListener;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSSwitch
extends DOOCSLayeredPane
implements EqCallback {
    private boolean stop = false;
    private String errorMessage = null;
    private float doocsUpdateTime = 3.0f;
    private int doocsDataIndex = 0;
    private int doocsBitMask = 0;
    private boolean doocsUseBitMask = false;
    private Component m_actCase = null;
    private int lastCase;
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData readData = new EqData();
    private EqAdr adrData = null;

    public DOOCSSwitch() {
        this.setLayout(new SwitchLayout());
        this.setMinimumSize(new Dimension(10, 10));
        this.setOpaque(false);
        this.lastCase = -100;
    }

    public void addCases() {
        DOOCSSwitchCase ifif = new DOOCSSwitchCase();
        ifif.setInitialBounds(ifif.getBounds());
        this.add(ifif);
        DOOCSSwitch.removeOldMouseListeners(ifif);
        ifif.addDOOCSMouseListener(this.m_DOOCSMouse);
        DOOCSSwitchCase ifelse = new DOOCSSwitchCase();
        ifelse.setInitialBounds(ifif.getBounds());
        ifelse.setLowComparator(-1);
        ifelse.setHighComparator(-1);
        this.add(ifelse);
        DOOCSSwitch.removeOldMouseListeners(ifif);
        ifif.addDOOCSMouseListener(this.m_DOOCSMouse);
        this.showCase(ifelse);
    }

    public DOOCSSwitch(boolean bAddDefaultCase) {
        this();
        if (bAddDefaultCase) {
            DOOCSSwitchCase defaultcase = new DOOCSSwitchCase();
            defaultcase.setLowComparator(-1);
            defaultcase.setHighComparator(-1);
            this.add(defaultcase);
        }
    }

    @Override
    public void setFullDoocsAddress(String address) {
        String oldAdr = this.fullDoocsAddress;
        super.setFullDoocsAddress(address);
        if (address == null) {
            return;
        }
        if (oldAdr == null || !address.startsWith(oldAdr)) {
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
        }
        if (this.adrData == null || !this.adrData.isValidAdr()) {
            this.adrData = null;
        } else if (this.doocsRunMode) {
            this.startMonitors();
        }
    }

    private void startMonitors() {
        if (this.adrData == null) {
            return;
        }
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.readData, 1, this.doocsUpdateTime, (EqCallback)this, (Object)0);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.readData, 2, this.doocsUpdateTime, (EqCallback)this, (Object)0);
        }
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof DOOCSSwitchCase || comp instanceof DOOCSIfCase) {
            this.add(comp);
            DOOCSSwitch.removeOldMouseListeners(comp);
            ((DOOCSComponent)((Object)comp)).addDOOCSMouseListener(this.m_DOOCSMouse);
            this.showCase(comp);
        } else if (this.m_actCase != null) {
            if (this.m_actCase instanceof DOOCSSwitchCase) {
                ((DOOCSSwitchCase)this.m_actCase).add(comp, constraints);
            }
            if (this.m_actCase instanceof DOOCSIfCase) {
                ((DOOCSIfCase)this.m_actCase).add(comp, constraints);
            }
        }
    }

    public void showCase(Component comp) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) == comp) {
                this.getComponent(i).setVisible(true);
                this.m_actCase = comp;
                for (Container parent = this.getParent(); parent != null && !(parent instanceof EditorPanel); parent = parent.getParent()) {
                    if (parent instanceof DOOCSIfCase) {
                        ((DOOCSIfCase)parent).showThisCase();
                    }
                    if (!(parent instanceof DOOCSSwitchCase)) continue;
                    ((DOOCSSwitchCase)parent).showThisCase();
                }
                continue;
            }
            this.getComponent(i).setVisible(false);
        }
    }

    public void showCase(int index) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (index == i) {
                this.getComponent(i).setVisible(true);
                if (!((DOOCSComponent)((Object)this.getComponent(i))).isRunMode()) {
                    ((DOOCSComponent)((Object)this.getComponent(i))).setRunMode(true);
                }
                this.m_actCase = this.getComponent(i);
                continue;
            }
            this.getComponent(i).setVisible(false);
            if (!((DOOCSComponent)((Object)this.getComponent(i))).isRunMode()) continue;
            ((DOOCSComponent)((Object)this.getComponent(i))).setRunMode(false);
        }
    }

    @Override
    public Component getComponentAt(int x, int y) {
        if (this.m_actCase != null) {
            return this.m_actCase;
        }
        return super.getComponentAt(x, y);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.doLayout();
    }

    public void setDataIndex(int dataIndex) {
        this.doocsDataIndex = dataIndex;
    }

    public int getDataIndex() {
        return this.doocsDataIndex;
    }

    public void setBitMask(String bitmask) {
        this.doocsBitMask = IntegerParser.parseInt(bitmask, 16);
    }

    public String getBitMask() {
        return Integer.toHexString(this.doocsBitMask);
    }

    public void setUseBitMask(boolean value) {
        this.doocsUseBitMask = value;
    }

    public boolean getUseBitMask() {
        return this.doocsUseBitMask;
    }

    public void setUpdateInterval(float interval) {
        if ((double)interval != 0.0 && (double)interval < 0.1) {
            interval = 0.1f;
        }
        this.doocsUpdateTime = interval;
    }

    public float getUpdateInterval() {
        return this.doocsUpdateTime;
    }

    @Override
    public void setDoocsGrid(String grid) {
        super.setDoocsGrid(grid);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((DOOCSLayeredPane)this.getComponent(i)).setDoocsGrid(grid);
        }
    }

    @Override
    public void setRunMode(boolean bRun) {
        super.setRunMode(bRun);
        if (bRun) {
            this.stop = false;
            this.startMonitors();
            this.setOpaque(false);
        } else {
            this.stop = true;
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.setOpaque(true);
        }
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderType", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("grid", DOOCSParameter.ParameterTypes.GRID, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("dataIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bitMask", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("useBitMask", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("borderType")) {
            String[] allowedValues = new String[]{"no border", "line border", "3D border"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSSwitch ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("\n");
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append("</DOOCSSwitch>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("borderType")) {
            this.setDoocsBorderType(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("grid")) {
            this.setDoocsGrid(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("dataIndex")) {
            this.setDataIndex(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("bitMask")) {
            this.setBitMask(value);
        } else if (parameter.equalsIgnoreCase("useBitMask")) {
            this.setUseBitMask(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setUpdateInterval(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSSwitch.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("borderType")) {
            return this.getDoocsBorderType();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("grid")) {
            return this.getDoocsGrid();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("dataIndex")) {
            return this.getDataIndex();
        }
        if (parameter.equalsIgnoreCase("bitMask")) {
            return this.getBitMask();
        }
        if (parameter.equalsIgnoreCase("useBitMask")) {
            return this.getUseBitMask();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getUpdateInterval());
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSSwitch.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.m_DOOCSMouse = ml;
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((DOOCSComponent)((Object)this.getComponent(i))).addDOOCSMouseListener(ml);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isRunMode()) {
            Graphics2D g2 = (Graphics2D)g;
            Color col = g2.getColor();
            g2.setColor(Color.BLACK);
            Stroke str = g2.getStroke();
            g2.setStroke(new BasicStroke(1.0f, 0, 1, 0.0f, new float[]{10.0f, 10.0f}, 0.0f));
            g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2.setColor(col);
            g2.setStroke(str);
        }
    }

    public void dataCallback(EqData dataOut, Object userData) {
        Object actValue = null;
        if (dataOut.error() == 0 && dataOut.type() != 0) {
            this.errorMessage = null;
            switch (dataOut.type()) {
                case 3: 
                case 5: 
                case 7: 
                case 16: 
                case 103: 
                case 113: 
                case 117: 
                case 118: {
                    if (dataOut.array_length() > 1) {
                        actValue = dataOut.get_string_arg(this.doocsDataIndex);
                        break;
                    }
                    actValue = dataOut.get_string_arg();
                    break;
                }
                case 1: 
                case 8: 
                case 14: 
                case 105: 
                case 115: {
                    if (this.doocsUseBitMask) {
                        actValue = dataOut.get_int(this.doocsDataIndex) & this.doocsBitMask;
                        break;
                    }
                    actValue = dataOut.get_int(this.doocsDataIndex);
                    break;
                }
                case 2: 
                case 100: {
                    actValue = (double)dataOut.get_float(this.doocsDataIndex);
                    break;
                }
                case 4: 
                case 119: {
                    actValue = dataOut.get_int(this.doocsDataIndex);
                    break;
                }
                default: {
                    new ShowException(null, "DOOCSSwitch", "to Elke: insert new Data type " + dataOut.type() + " in DOOCSSwitch.java and DOOCSLogicGroup.java");
                    break;
                }
            }
        } else {
            actValue = null;
            if (this.errorMessage == null) {
                this.errorMessage = dataOut.get_string_arg();
                System.out.println(DOOCSParameter.getFullName(this) + ": " + this.getFullDoocsAddress() + ": " + this.errorMessage);
            }
        }
        int caseNumber = 0;
        if (actValue != null) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (this.getComponent(i) instanceof DOOCSSwitchCase && ((DOOCSSwitchCase)this.getComponent(i)).evaluateCase(actValue, dataOut.type())) {
                    caseNumber = i;
                    if (!((DOOCSSwitchCase)this.getComponent(i)).toString().equalsIgnoreCase("otherwise")) break;
                }
                if (!(this.getComponent(i) instanceof DOOCSIfCase) || !((DOOCSIfCase)this.getComponent(i)).evaluateCase(actValue, dataOut.type())) continue;
                caseNumber = i;
                if (!((DOOCSIfCase)this.getComponent(i)).toString().equalsIgnoreCase("else")) break;
            }
            if (!this.stop && this.lastCase != caseNumber) {
                this.lastCase = caseNumber;
                this.showCase(caseNumber);
            }
        }
    }
}

