/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ShowException;
import editor.EditorPanel;
import editor.undo.SetProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.IIII;
import xmlparser.IntegerParser;

public class DOOCSSlider
extends JPanel
implements Runnable,
ChangeListener,
DOOCSComponent {
    private transient Thread th;
    private boolean stop = false;
    private String errorMessage = null;
    private boolean init = true;
    private JSlider slider;
    private JLabel minimumLabel;
    private JLabel maximumLabel;
    private String doocsTextFont = "Arial,1,12";
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private EqAdr ea = null;
    private int doocsIndex = 0;
    private String doocsToolTipText = null;
    private float doocsUpdateTime = 10.0f;
    private boolean doocsOrientation = false;
    private boolean doocsShowRange = false;
    private double doocsMinimum = 0.0;
    private double doocsMaximum = 100.0;
    private double doocsMinorTickSpacing = 10.0;
    private double doocsMajorTickSpacing = 20.0;
    private int doocsPrecision = 1;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;

    public DOOCSSlider() {
        this.setPreferredSize(new Dimension(250, 50));
        this.setSize(new Dimension(250, 50));
        this.slider = new JSlider();
        this.slider.setMaximum(this.getIntegerValue(100.0));
        this.slider.setMinimum(this.getIntegerValue(0.0));
        this.slider.setMinorTickSpacing(this.getIntegerValue(10.0));
        this.setDoocsMajorTickSpacing(20.0);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(this);
        this.slider.setEnabled(this.doocsRunMode);
        this.minimumLabel = new JLabel("");
        this.maximumLabel = new JLabel("");
        this.setLayout(new BorderLayout());
        this.add((Component)this.minimumLabel, "West");
        this.add((Component)this.slider, "Center");
        this.add((Component)this.maximumLabel, "East");
    }

    @Override
    public void setToolTipText(String ttt) {
        this.slider.setToolTipText(ttt);
    }

    @Override
    public String getToolTipText() {
        return this.slider.getToolTipText();
    }

    public void stopThreads() {
        this.stop = true;
    }

    public void startThreads() {
        this.stop = false;
        this.th = new Thread(this);
        this.th.start();
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsTextFont(String font) {
        this.doocsTextFont = font;
        Dictionary dict = this.slider.getLabelTable();
        Enumeration e = dict.elements();
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (!(element instanceof JComponent)) continue;
            ((JComponent)element).setFont(DOOCSParameter.convertToFont(font));
        }
    }

    public String getDoocsTextFont() {
        return this.doocsTextFont;
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
        this.ea = new EqAdr(this.fullDoocsAddress);
        if (!this.ea.isValidAdr()) {
            this.ea = null;
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsIndex(int index) {
        this.doocsIndex = index;
    }

    public int getDoocsIndex() {
        return this.doocsIndex;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsOrientation(boolean orientation) {
        Container parent;
        this.doocsOrientation = orientation;
        if (orientation) {
            this.slider.setOrientation(1);
            this.remove(this.maximumLabel);
            this.remove(this.minimumLabel);
            this.maximumLabel.setHorizontalAlignment(0);
            this.minimumLabel.setHorizontalAlignment(0);
            this.add((Component)this.minimumLabel, "South");
            this.add((Component)this.maximumLabel, "North");
        } else {
            this.slider.setOrientation(0);
            this.remove(this.maximumLabel);
            this.remove(this.minimumLabel);
            this.maximumLabel.setHorizontalAlignment(2);
            this.minimumLabel.setHorizontalAlignment(4);
            this.add((Component)this.minimumLabel, "West");
            this.add((Component)this.maximumLabel, "East");
        }
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (orientation && width > height) {
            this.setSize(new Dimension(height, width));
        }
        if (!orientation && height > width) {
            this.setSize(new Dimension(height, width));
        }
        if (!((parent = this.getParent()) == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
            if (this.getX() < 0) {
                this.setLocation(0, this.getY());
            }
            if (this.getY() < 0) {
                this.setLocation(this.getX(), 0);
            }
            if (this.getX() + this.getWidth() > parent.getWidth()) {
                this.setLocation(parent.getWidth() - this.getWidth(), this.getY());
            }
            if (this.getY() + this.getHeight() > parent.getHeight()) {
                this.setLocation(this.getX(), parent.getHeight() - this.getHeight());
            }
        }
    }

    public boolean getDoocsOrientation() {
        return this.doocsOrientation;
    }

    public void setDoocsShowRange(boolean range) {
        this.doocsShowRange = range;
        if (range) {
            if (this.slider.getInverted()) {
                this.minimumLabel.setText(this.getDisplayedValue(this.doocsMaximum));
                this.maximumLabel.setText(this.getDisplayedValue(this.doocsMinimum));
            } else {
                this.minimumLabel.setText(this.getDisplayedValue(this.doocsMinimum));
                this.maximumLabel.setText(this.getDisplayedValue(this.doocsMaximum));
            }
        } else {
            this.maximumLabel.setText("");
            this.minimumLabel.setText("");
        }
    }

    public boolean getDoocsShowRange() {
        return this.doocsShowRange;
    }

    public void setDoocsMinimum(double mini) {
        this.doocsMinimum = mini;
        this.slider.setMinimum(this.getIntegerValue(mini));
        this.setDoocsShowRange(this.getDoocsShowRange());
        this.setDoocsMajorTickSpacing(this.getDoocsMajorTickSpacing());
    }

    public double getDoocsMinimum() {
        return this.doocsMinimum;
    }

    public void setDoocsMaximum(double maxi) {
        this.doocsMaximum = maxi;
        this.slider.setMaximum(this.getIntegerValue(maxi));
        this.setDoocsShowRange(this.getDoocsShowRange());
        this.setDoocsMajorTickSpacing(this.getDoocsMajorTickSpacing());
    }

    public double getDoocsMaximum() {
        return this.doocsMaximum;
    }

    public void setDoocsMajorTickSpacing(double major) {
        this.doocsMajorTickSpacing = major;
        this.slider.setMajorTickSpacing(this.getIntegerValue(major));
        this.slider.setLabelTable(this.slider.createStandardLabels(this.getIntegerValue(major)));
        Dictionary dict = this.slider.getLabelTable();
        Enumeration e = dict.elements();
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (!(element instanceof JLabel)) continue;
            int oldValue = IntegerParser.parseInt(((JLabel)element).getText());
            double newValue = oldValue;
            for (int i = 0; i < this.getDoocsPrecision(); ++i) {
                newValue /= 10.0;
            }
            ((JLabel)element).setText(this.getDisplayedValue(newValue));
        }
        this.slider.setLabelTable(dict);
        this.setDoocsTextFont(this.doocsTextFont);
    }

    public double getDoocsMajorTickSpacing() {
        return this.doocsMajorTickSpacing;
    }

    public void setDoocsMinorTickSpacing(double minor) {
        this.doocsMinorTickSpacing = minor;
        this.slider.setMinorTickSpacing(this.getIntegerValue(minor));
    }

    public double getDoocsMinorTickSpacing() {
        return this.doocsMinorTickSpacing;
    }

    public void setDoocsPrecision(int precision) {
        this.doocsPrecision = precision;
        this.setDoocsShowRange(this.getDoocsShowRange());
        this.setDoocsMaximum(this.getDoocsMaximum());
        this.setDoocsMinimum(this.getDoocsMinimum());
        this.setDoocsMinorTickSpacing(this.getDoocsMinorTickSpacing());
    }

    public int getDoocsPrecision() {
        return this.doocsPrecision;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.slider.setEnabled(bRun);
        if (bRun) {
            this.startThreads();
        } else {
            this.stopThreads();
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("index", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("orientation", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("paintLabels", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("paintTicks", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("showRange", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("snapToTicks", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("maximum", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("minimum", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("majorTickSpacing", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("minorTickSpacing", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("precision", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("inverted", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSSlider ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSSlider>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("index")) {
            this.setDoocsIndex(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("orientation")) {
            this.setDoocsOrientation(Boolean.parseBoolean(value));
            this.checkBounds();
        } else if (parameter.equalsIgnoreCase("paintLabels")) {
            this.slider.setPaintLabels(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("paintTicks")) {
            this.slider.setPaintTicks(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("showRange")) {
            this.setDoocsShowRange(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("snapToTicks")) {
            this.slider.setSnapToTicks(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setDoocsTextFont(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("maximum")) {
            this.setDoocsMaximum(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("minimum")) {
            this.setDoocsMinimum(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("majorTickSpacing")) {
            this.setDoocsMajorTickSpacing(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("minorTickSpacing")) {
            this.setDoocsMinorTickSpacing(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("precision")) {
            this.setDoocsPrecision(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("inverted")) {
            this.slider.setInverted(Boolean.parseBoolean(value));
            this.setDoocsShowRange(this.getDoocsShowRange());
        } else if (parameter.equalsIgnoreCase("textColor")) {
            this.slider.setForeground(DOOCSParameter.convertToColor(value));
            this.setForeground(DOOCSParameter.convertToColor(value));
            this.minimumLabel.setForeground(DOOCSParameter.convertToColor(value));
            this.maximumLabel.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.slider.setBackground(DOOCSParameter.convertToColor(value));
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSSlider.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("index")) {
            return this.getDoocsIndex();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("orientation")) {
            return this.getDoocsOrientation();
        }
        if (parameter.equalsIgnoreCase("paintLabels")) {
            return this.slider.getPaintLabels();
        }
        if (parameter.equalsIgnoreCase("paintTicks")) {
            return this.slider.getPaintTicks();
        }
        if (parameter.equalsIgnoreCase("showRange")) {
            return this.getDoocsShowRange();
        }
        if (parameter.equalsIgnoreCase("snapToTicks")) {
            return this.slider.getSnapToTicks();
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return this.getDoocsTextFont();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("maximum")) {
            return this.getDoocsMaximum();
        }
        if (parameter.equalsIgnoreCase("minimum")) {
            return this.getDoocsMinimum();
        }
        if (parameter.equalsIgnoreCase("majorTickSpacing")) {
            return this.getDoocsMajorTickSpacing();
        }
        if (parameter.equalsIgnoreCase("minorTickSpacing")) {
            return this.getDoocsMinorTickSpacing();
        }
        if (parameter.equalsIgnoreCase("precision")) {
            return this.getDoocsPrecision();
        }
        if (parameter.equalsIgnoreCase("inverted")) {
            return this.slider.getInverted();
        }
        if (parameter.equalsIgnoreCase("textColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSSlider.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    private int getIntegerValue(double value) {
        for (int i = 0; i < this.getDoocsPrecision(); ++i) {
            value *= 10.0;
        }
        return (int)value;
    }

    private String getDisplayedValue(double value) {
        String displayedValue;
        if (this.doocsPrecision == 0) {
            displayedValue = Integer.toString(Math.round((float)value));
        } else {
            double tmp = Math.pow(10.0, this.doocsPrecision);
            double dvalue = Math.rint(value * tmp) / tmp;
            String tmpValue = Double.toString(dvalue);
            int komma = tmpValue.indexOf(".");
            for (int i = 0; i < this.doocsPrecision; ++i) {
                if (tmpValue.substring(komma + 1).length() >= this.doocsPrecision) continue;
                tmpValue = tmpValue + "0";
            }
            displayedValue = tmpValue;
        }
        return displayedValue;
    }

    public void checkBounds() {
        Container parent = this.getParent();
        if (!(parent == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
            if (this.getX() < 0) {
                this.setLocation(0, this.getY());
            }
            if (this.getY() < 0) {
                this.setLocation(this.getX(), 0);
            }
            if (this.getX() + this.getWidth() > parent.getWidth()) {
                this.setLocation(parent.getWidth() - this.getWidth() - 1, this.getY());
            }
            if (this.getY() + this.getHeight() > parent.getHeight()) {
                this.setLocation(this.getX(), parent.getHeight() - this.getHeight() - 1);
            }
        }
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.slider.addMouseListener(ml);
        this.slider.addMouseMotionListener(ml);
    }

    @Override
    public void run() {
        EqCall eq = new EqCall();
        EqData ed = new EqData();
        EqData data = new EqData();
        while (!this.stop) {
            if (this.doocsRunMode && this.ea != null && !this.slider.getValueIsAdjusting()) {
                data.init();
                eq.get(this.ea, ed, data);
                if (data.error() == 0) {
                    this.errorMessage = null;
                    double value = data.get_double(this.doocsIndex);
                    final int intValue = this.getIntegerValue(value);
                    if (intValue != this.slider.getValue()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DOOCSSlider.this.init = true;
                                DOOCSSlider.this.slider.setValue(intValue);
                            }
                        });
                    }
                } else if (this.errorMessage == null) {
                    this.errorMessage = data.get_string_arg();
                    System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
                }
            }
            try {
                if ((double)this.doocsUpdateTime == 0.0) {
                    Thread.sleep(10000L);
                    continue;
                }
                if ((double)this.doocsUpdateTime < 0.1) {
                    Thread.sleep(100L);
                    continue;
                }
                Thread.sleep((long)(this.doocsUpdateTime * 1000.0f));
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.init) {
            this.init = false;
            return;
        }
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            float doocsValue = source.getValue();
            for (int i = 0; i < this.getDoocsPrecision(); ++i) {
                doocsValue /= 10.0f;
            }
            if (this.doocsRunMode && this.ea != null) {
                EqCall eq = new EqCall();
                EqData ed = new EqData();
                EqData data = new EqData();
                eq.get(this.ea, ed, data);
                switch (data.type()) {
                    case 1: 
                    case 105: {
                        ed.set(Math.round(doocsValue));
                        break;
                    }
                    case 2: 
                    case 100: {
                        ed.set(doocsValue);
                        break;
                    }
                    case 14: {
                        IIII iiiivalue = data.get_iiii();
                        if (this.doocsIndex == 0) {
                            iiiivalue.i1_data = source.getValue();
                        }
                        if (this.doocsIndex == 1) {
                            iiiivalue.i2_data = source.getValue();
                        }
                        if (this.doocsIndex == 2) {
                            iiiivalue.i3_data = source.getValue();
                        }
                        if (this.doocsIndex == 3) {
                            iiiivalue.i4_data = source.getValue();
                        }
                        ed.set(iiiivalue);
                        break;
                    }
                    default: {
                        System.out.println("to Elke: add new DataType " + data.type() + " to DOOCSSlider!");
                    }
                }
                eq.set(this.ea, ed, data);
                if (data.error() != 0) {
                    new ShowException(null, DOOCSParameter.getFullName(this), data.get_string());
                }
            }
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = String.valueOf(this.getDoocsOrientation());
        if (this.getDoocsOrientation()) {
            this.setDoocsOrientation(false);
        } else {
            this.setDoocsOrientation(true);
        }
        change.add(new SetProperty(this, "orientation", oldValue, String.valueOf(this.getDoocsOrientation())));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = String.valueOf(this.getDoocsOrientation());
        if (this.getDoocsOrientation()) {
            this.setDoocsOrientation(false);
        } else {
            this.setDoocsOrientation(true);
        }
        change.add(new SetProperty(this, "orientation", oldValue, String.valueOf(this.getDoocsOrientation())));
        return change;
    }
}

