/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSDynamicList;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSTab;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import editor.DoocsCache;
import editor.DoocsFrameCache;
import editor.EditorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JViewport;
import jsvnbrowser.JSVNBrowser;
import jsvnbrowser.JSVNFileInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xmlparser.DOOCSParser;
import xmlparser.IntegerParser;

public class DOOCSParameter {
    public String parameter;
    public String tooltip;
    public ParameterTypes type;
    public Levels level;

    public DOOCSParameter(String param, ParameterTypes pt, Levels lev) {
        this.parameter = param;
        this.type = pt;
        this.level = lev;
    }

    public DOOCSParameter(String param, ParameterTypes pt, Levels lev, String tt) {
        this.parameter = param;
        this.type = pt;
        this.level = lev;
        this.tooltip = tt;
    }

    public static Color convertToColor(String colorString) {
        if (colorString == null || colorString.length() < 5) {
            return null;
        }
        int komma1 = colorString.indexOf(",");
        int komma2 = colorString.indexOf(",", komma1 + 1);
        if (komma1 < 0 || komma2 < 0) {
            return null;
        }
        int r = IntegerParser.parseInt(colorString.substring(0, komma1));
        int g = IntegerParser.parseInt(colorString.substring(komma1 + 1, komma2));
        int b = IntegerParser.parseInt(colorString.substring(komma2 + 1));
        Color colorParam = new Color(r, g, b);
        return colorParam;
    }

    public static Font convertToFont(String fontString) {
        if (fontString == null) {
            return null;
        }
        int komma1 = fontString.indexOf(",");
        int komma2 = fontString.indexOf(",", komma1 + 1);
        if (komma1 < 0 || komma2 < 0) {
            return null;
        }
        String name = fontString.substring(0, komma1);
        int style = IntegerParser.parseInt(fontString.substring(komma1 + 1, komma2));
        int size = IntegerParser.parseInt(fontString.substring(komma2 + 1));
        Font fontParam = new Font(name, style, size);
        return fontParam;
    }

    public static Rectangle convertToBounds(String boundsString) {
        if (boundsString == null || boundsString.length() < 3) {
            return null;
        }
        int komma1 = boundsString.indexOf(",");
        int komma2 = boundsString.indexOf(",", komma1 + 1);
        int komma3 = boundsString.indexOf(",", komma2 + 1);
        if (komma1 < 0 || komma2 < 0 || komma3 < 0) {
            return null;
        }
        int x = IntegerParser.parseInt(boundsString.substring(0, komma1));
        int y = IntegerParser.parseInt(boundsString.substring(komma1 + 1, komma2));
        int width = IntegerParser.parseInt(boundsString.substring(komma2 + 1, komma3));
        int height = IntegerParser.parseInt(boundsString.substring(komma3 + 1));
        Rectangle rect = new Rectangle(x, y, width, height);
        return rect;
    }

    public static Dimension convertToSize(String sizeString) {
        if (sizeString == null || sizeString.length() < 3) {
            return null;
        }
        int komma = sizeString.indexOf(",");
        if (komma < 0) {
            return null;
        }
        int width = IntegerParser.parseInt(sizeString.substring(0, komma));
        int height = IntegerParser.parseInt(sizeString.substring(komma + 1));
        return new Dimension(width, height);
    }

    public static Integer convertToAlignX(String alignX) {
        if (alignX.equalsIgnoreCase("LEFT")) {
            return 2;
        }
        if (alignX.equalsIgnoreCase("RIGHT")) {
            return 4;
        }
        return 0;
    }

    public static Integer convertToAlignY(String alignY) {
        if (alignY.equalsIgnoreCase("TOP")) {
            return 1;
        }
        if (alignY.equalsIgnoreCase("BOTTOM")) {
            return 3;
        }
        return 0;
    }

    public static String getDoocsBounds(Rectangle rect) {
        if (rect == null) {
            return null;
        }
        return rect.x + "," + rect.y + "," + rect.width + "," + rect.height;
    }

    public static String getDoocsSize(Dimension size) {
        if (size == null) {
            return null;
        }
        return size.width + "," + size.height;
    }

    public static String getDoocsColor(Color col) {
        if (col == null) {
            return null;
        }
        return col.getRed() + "," + col.getGreen() + "," + col.getBlue();
    }

    public static String getDoocsFont(Font f) {
        if (f == null) {
            return null;
        }
        return f.getName() + "," + f.getStyle() + "," + f.getSize();
    }

    public static String getAlignX(int alignX) {
        if (alignX == 2) {
            return "LEFT";
        }
        if (alignX == 4) {
            return "RIGHT";
        }
        return "CENTER";
    }

    public static String getAlignY(int alignY) {
        if (alignY == 1) {
            return "TOP";
        }
        if (alignY == 3) {
            return "BOTTOM";
        }
        return "CENTER";
    }

    public static String correct(String text) {
        if (text != null) {
            StringBuffer ttt = new StringBuffer(text.length());
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == '>') {
                    ttt.append("&#62;");
                    continue;
                }
                if (text.charAt(i) == '<') {
                    ttt.append("&#60;");
                    continue;
                }
                if (text.charAt(i) == '&') {
                    ttt.append("&#38;");
                    continue;
                }
                if (text.charAt(i) == '\"') {
                    ttt.append("&quot;");
                    continue;
                }
                if (text.charAt(i) == '\u00e4') {
                    ttt.append("&#228;");
                    continue;
                }
                if (text.charAt(i) == '\u00f6') {
                    ttt.append("&#246;");
                    continue;
                }
                if (text.charAt(i) == '\u00fc') {
                    ttt.append("&#252;");
                    continue;
                }
                if (text.charAt(i) == '\u00c4') {
                    ttt.append("&#196;");
                    continue;
                }
                if (text.charAt(i) == '\u00d6') {
                    ttt.append("&#214;");
                    continue;
                }
                if (text.charAt(i) == '\u00dc') {
                    ttt.append("&#220;");
                    continue;
                }
                if (text.charAt(i) == '\u00df') {
                    ttt.append("&#223;");
                    continue;
                }
                if (text.charAt(i) == '\t') {
                    ttt.append(" ");
                    continue;
                }
                if ((text.charAt(i) >= '\u007f' || text.charAt(i) <= '\u001f') && text.charAt(i) != '\n' && text.charAt(i) != '\r') {
                    ttt.append("&#xBF;");
                    continue;
                }
                if (text.charAt(i) == '\n' || text.charAt(i) == '\r') continue;
                ttt.append(text.charAt(i));
            }
            text = ttt.toString();
        }
        return text;
    }

    public static String getFullName(DOOCSComponent dcomp) {
        String filePath;
        String fullName = dcomp.getName();
        Component comp = (Component)((Object)dcomp);
        while (comp.getParent() != null && !(comp.getParent() instanceof JViewport)) {
            if ((comp = comp.getParent()).getParent() != null && comp.getParent().getParent() instanceof DOOCSDynamicList) {
                comp = comp.getParent();
            }
            if (!(comp instanceof DOOCSComponent)) continue;
            fullName = comp.getName() + "/" + fullName;
        }
        if (!(comp instanceof DOOCSLayeredPane)) {
            return fullName;
        }
        String fileName = filePath = ((DOOCSLayeredPane)comp).getDoocsXmlFilePath();
        if (filePath != null) {
            if (filePath.contains(File.separator)) {
                fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            } else if (filePath.contains("/")) {
                fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            }
        }
        return fileName + ": " + fullName;
    }

    public static DOOCSComponent getBgDoocsComponent(Component comp) {
        while (!(comp instanceof DOOCSComponent) || comp instanceof DOOCSTab) {
            comp = comp.getParent();
        }
        return (DOOCSComponent)((Object)comp);
    }

    public static DOOCSLayeredPane getParentLayeredPane(DOOCSComponent dcomp) {
        Component comp;
        if (dcomp instanceof DOOCSLayeredPane) {
            return (DOOCSLayeredPane)dcomp;
        }
        for (comp = (Component)((Object)dcomp); comp != null && !(comp instanceof DOOCSLayeredPane); comp = comp.getParent()) {
        }
        return (DOOCSLayeredPane)comp;
    }

    public static DOOCSLayeredPane getLastLayeredPane(DOOCSComponent dcomp) {
        Component comp = (Component)((Object)dcomp);
        while (!(comp.getParent() instanceof JPanel) && comp.getParent() != null && !(comp.getParent() instanceof JViewport)) {
            comp = comp.getParent();
        }
        return (DOOCSLayeredPane)comp;
    }

    public static JFrame getParentFrame(DOOCSComponent dcomp) {
        Container comp = dcomp.getParent();
        while (!(comp instanceof JFrame)) {
            comp = comp.getParent();
        }
        return (JFrame)comp;
    }

    public static JSVNFileInfo getDoocsFilePath(String filename, DOOCSComponent dcomp) {
        if (filename != null) {
            DoocsCache cache = DoocsCache.getInstance();
            String fName = filename;
            if (filename.contains(File.separator)) {
                fName = fName.substring(fName.lastIndexOf(File.separator) + 1);
            } else if (filename.contains("/")) {
                fName = fName.substring(fName.lastIndexOf("/") + 1);
            }
            JSVNFileInfo fInfo = cache.getFileInfo(fName);
            if (fInfo != null) {
                return fInfo;
            }
            fInfo = DOOCSParameter.getDoocsPath(filename, dcomp);
            if (fInfo != null) {
                cache.addFileInfo(fInfo);
            } else {
                cache.addFileInfo(new JSVNFileInfo(filename, "", null, 0L, 0L, null, null));
            }
            return fInfo;
        }
        return null;
    }

    public static JSVNFileInfo getDoocsPath(String filename, DOOCSComponent dcomp) {
        if (filename != null) {
            if (filename.startsWith(File.separator) && !filename.startsWith("/svn/") && new File(filename).exists()) {
                return DOOCSParameter.getFileInfo(filename);
            }
            if (filename.startsWith("/svn/")) {
                filename = filename.substring(5);
                JSVNBrowser browser = new JSVNBrowser();
                return browser.openFile(filename);
            }
            String path = null;
            if (dcomp != null) {
                Component comp = (Component)((Object)dcomp);
                while (!(comp instanceof EditorPanel) && comp.getParent() != null && !(comp.getParent() instanceof JViewport)) {
                    if ((comp = comp.getParent()).getParent() == null || comp.getParent().getParent() == null || !(comp.getParent().getParent() instanceof DOOCSDynamicList)) continue;
                    comp = comp.getParent().getParent();
                }
                if (comp instanceof DOOCSLayeredPane && ((DOOCSLayeredPane)comp).getDoocsXmlFilePath() != null) {
                    path = ((DOOCSLayeredPane)comp).getDoocsXmlFilePath();
                    path = path.contains(File.separator) ? path.substring(0, path.lastIndexOf(File.separatorChar) + 1) : path.substring(0, path.lastIndexOf("/") + 1);
                }
            }
            if (path != null && path.startsWith("/svn/")) {
                JSVNBrowser browser = new JSVNBrowser();
                JSVNFileInfo fInfo = browser.openFile((path = path.substring(5)) + filename);
                if (fInfo != null) {
                    return fInfo;
                }
                fInfo = filename.endsWith(".xml") ? browser.openFile(path + "includes/" + filename) : browser.openFile(path + "images/" + filename);
                if (fInfo != null) {
                    return fInfo;
                }
                String mainPath = path.substring(0, path.indexOf(File.separatorChar) + 1);
                fInfo = browser.searchFile(mainPath, filename);
                if (fInfo != null) {
                    return fInfo;
                }
                fInfo = browser.searchFile("global/", filename);
                if (fInfo != null) {
                    return fInfo;
                }
            }
            if (path != null && !path.startsWith("/svn/")) {
                if (new File(path + filename).exists()) {
                    return DOOCSParameter.getFileInfo(path + filename);
                }
                if (filename.endsWith(".xml") && new File(path + "includes" + File.separatorChar + filename).exists()) {
                    return DOOCSParameter.getFileInfo(path + "includes" + File.separatorChar + filename);
                }
                if (!filename.endsWith(".xml") && new File(path + "images" + File.separatorChar + filename).exists()) {
                    return DOOCSParameter.getFileInfo(path + "images" + File.separatorChar + filename);
                }
                return DOOCSParameter.searchFile(path, filename);
            }
            if (path == null) {
                path = System.getProperty("user.dir") + File.separatorChar + filename;
                if (new File(path).exists()) {
                    return DOOCSParameter.getFileInfo(path);
                }
                path = System.getProperty("user.dir") + File.separatorChar + "includes" + File.separatorChar + filename;
                if (filename.endsWith(".xml") && new File(path).exists()) {
                    return DOOCSParameter.getFileInfo(path);
                }
                path = System.getProperty("user.dir") + File.separatorChar + "images" + File.separatorChar + filename;
                if (!filename.endsWith(".xml") && new File(path).exists()) {
                    return DOOCSParameter.getFileInfo(path);
                }
                path = System.getProperty("user.home") + File.separatorChar + filename;
                if (new File(path).exists()) {
                    return DOOCSParameter.getFileInfo(path);
                }
                path = System.getProperty("user.home") + File.separatorChar + "jddd" + File.separatorChar + filename;
                if (new File(path).exists()) {
                    return DOOCSParameter.getFileInfo(path);
                }
                path = System.getProperty("user.home") + File.separatorChar + "ddd" + File.separatorChar + filename;
                if (new File(path).exists()) {
                    return DOOCSParameter.getFileInfo(path);
                }
                path = System.getProperty("user.home") + File.separatorChar + "includes" + File.separatorChar + filename;
                if (filename.endsWith(".xml") && new File(path).exists()) {
                    return DOOCSParameter.getFileInfo(path);
                }
                path = System.getProperty("user.home") + File.separatorChar + "images" + File.separatorChar + filename;
                if (!filename.endsWith(".xml") && new File(path).exists()) {
                    return DOOCSParameter.getFileInfo(path);
                }
                if (new File(filename).exists()) {
                    return DOOCSParameter.getFileInfo(filename);
                }
            }
        }
        return null;
    }

    private static JSVNFileInfo searchFile(String path, String filename) {
        JSVNFileInfo fInfo = null;
        if (!filename.endsWith(".xml") && path.endsWith("images" + File.separatorChar) && new File(path + filename).exists()) {
            return DOOCSParameter.getFileInfo(path + filename);
        }
        if (filename.endsWith(".xml") && !path.endsWith("images" + File.separatorChar) && new File(path + filename).exists()) {
            return DOOCSParameter.getFileInfo(path + filename);
        }
        File dir = new File(path);
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; !(i >= files.length || files[i].isDirectory() && (fInfo = DOOCSParameter.searchFile(files[i].getPath() + File.separatorChar, filename)) != null); ++i) {
            }
        }
        return fInfo;
    }

    private static JSVNFileInfo getFileInfo(String path) {
        if (!new File(path).exists()) {
            return null;
        }
        try {
            int offset;
            FileInputStream is = new FileInputStream(path);
            long length = new File(path).length();
            if (length > Integer.MAX_VALUE) {
                System.out.println("File is too large.");
                return new JSVNFileInfo(path, "", null, 0L, 0L, null, null);
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                System.out.println("Could not completely read file " + path);
            }
            ((InputStream)is).close();
            return new JSVNFileInfo(path, "", null, 0L, 0L, bytes, null);
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe);
            return new JSVNFileInfo(path, "", null, 0L, 0L, null, null);
        }
    }

    public static String getDoocsFileTitle(String filename) {
        if (filename == null) {
            return null;
        }
        if (filename.contains(String.valueOf("/"))) {
            return filename.substring(filename.lastIndexOf("/") + 1);
        }
        if (filename.contains(File.separator)) {
            return filename.substring(filename.lastIndexOf(File.separator) + 1);
        }
        return filename;
    }

    public static ImageIcon getThumbnailIcon(File file) {
        Node rootNode;
        Document doc;
        if (file != null && file.exists() && (doc = DOOCSParser.parseXmlFile(file, false)) != null && (rootNode = doc.getLastChild()).getNodeName().equalsIgnoreCase("jdddPanel")) {
            NodeList list = rootNode.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node subNode = list.item(i);
                if (!subNode.getNodeName().equalsIgnoreCase("thumbnail")) continue;
                byte[] ImageAsRawBytes = Base64.decode(subNode.getLastChild().getNodeValue());
                return new ImageIcon(ImageAsRawBytes);
            }
        }
        return null;
    }

    public static ImageIcon getThumbnailIcon(Document doc) {
        Node rootNode;
        if (doc != null && (rootNode = doc.getLastChild()).getNodeName().equalsIgnoreCase("jdddPanel")) {
            NodeList list = rootNode.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node subNode = list.item(i);
                if (!subNode.getNodeName().equalsIgnoreCase("thumbnail")) continue;
                byte[] ImageAsRawBytes = Base64.decode(subNode.getLastChild().getNodeValue());
                return new ImageIcon(ImageAsRawBytes);
            }
        }
        return null;
    }

    public static boolean compareRegex(String type, String text) {
        if (type.equalsIgnoreCase("BOUNDS") || type.equalsIgnoreCase("POINTS")) {
            return text.matches("^\\d{1,4},\\d{1,4},\\d{1,4},\\d{1,4}$");
        }
        if (type.equalsIgnoreCase("INTEGER")) {
            return text.matches("^-?\\d*$");
        }
        if (type.equalsIgnoreCase("FLOAT")) {
            return text.matches("^-?[0-9]*\\.?[0-9]*[Ee]?-?[0-9]*$");
        }
        if (type.equalsIgnoreCase("DOUBLE")) {
            return text.matches("^-?[0-9]*\\.?[0-9]*[Ee]?-?[0-9]*$");
        }
        if (type.equalsIgnoreCase("FONT")) {
            Pattern pattern = Pattern.compile(",[0-3],\\d{1,2}$");
            Matcher matcher = pattern.matcher(text);
            return matcher.find();
        }
        if (type.equalsIgnoreCase("COLOR")) {
            if (text.matches("^\\d{1,3},\\d{1,3},\\d{1,3}$")) {
                int komma1 = text.indexOf(",");
                int komma2 = text.indexOf(",", komma1 + 1);
                int zahl1 = IntegerParser.parseInt(text.substring(0, komma1));
                int zahl2 = IntegerParser.parseInt(text.substring(komma1 + 1, komma2));
                int zahl3 = IntegerParser.parseInt(text.substring(komma2 + 1));
                return zahl1 < 256 && zahl2 < 256 && zahl3 < 256;
            }
            return false;
        }
        if (type.equalsIgnoreCase("GRID") || type.equalsIgnoreCase("SIZE")) {
            if (text.matches("^\\d{1,3},\\d{1,3}$")) {
                return true;
            }
            return type.equalsIgnoreCase("GRID") && text.matches("^[0-9]*\\.?[0-9]*,[0-9]*\\.?[0-9]*$");
        }
        if (type.equalsIgnoreCase("XMLFILE")) {
            Pattern pattern = Pattern.compile("\\.xml$");
            Matcher matcher = pattern.matcher(text);
            return matcher.find();
        }
        if (type.equalsIgnoreCase("DOOCSADDRESS")) {
            if (text.equalsIgnoreCase("")) {
                return true;
            }
            String tmp = text;
            boolean slash = true;
            if (tmp.contains("/")) {
                tmp = tmp.substring(tmp.indexOf("/") + 1);
            }
            if (tmp.contains("/")) {
                tmp = tmp.substring(tmp.indexOf("/") + 1);
            }
            if (!tmp.contains("/")) {
                slash = false;
            }
            if (text.startsWith("file:")) {
                slash = true;
            }
            if (text.startsWith("daq:")) {
                slash = true;
            }
            if (text.startsWith("tine:")) {
                slash = true;
            }
            if (text.startsWith("tango:")) {
                slash = true;
            }
            if (text.startsWith("epics:")) {
                slash = true;
            }
            return slash;
        }
        return true;
    }

    public static void setInAll(JFrame frame, String compClass, String parameter, String value) {
        if (frame != null) {
            DOOCSParameter.searchComponent(frame.getLayeredPane(), compClass, parameter, value);
        } else {
            for (Map.Entry<String, DOOCSLayeredPane> entry : DoocsFrameCache.getInstance().myCache.entrySet()) {
                DOOCSLayeredPane lpane = entry.getValue();
                DOOCSParameter.searchComponent(lpane, compClass, parameter, value);
            }
        }
    }

    private static void searchComponent(JComponent comp, String compClass, String parameter, String value) {
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            Component subComp = comp.getComponent(i);
            if (subComp.getClass().getName().equalsIgnoreCase(compClass) && subComp instanceof DOOCSComponent) {
                ((DOOCSComponent)((Object)subComp)).setDOOCSParameter(parameter, value);
            }
            if (!(subComp instanceof JComponent) || ((JComponent)subComp).getComponentCount() <= 0) continue;
            DOOCSParameter.searchComponent((JComponent)subComp, compClass, parameter, value);
        }
    }

    public static enum Levels {
        NORMAL,
        EXPERT,
        SCALE;

    }

    public static enum ParameterTypes {
        STRING,
        BOOLEAN,
        INTEGER,
        FLOAT,
        DOUBLE,
        COLOR,
        FONT,
        CHOICE,
        DOOCSADDRESS,
        FILE,
        XMLFILE,
        AUDIOFILE,
        ICONFILE,
        GRID,
        LAYER,
        ALIGNX,
        ALIGNY,
        BOUNDS,
        POINTS,
        SIZE,
        COMPONENT;

    }
}

