/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSGroup;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ShowException;
import java.awt.Component;
import java.util.Vector;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSLogicGroup
extends DOOCSGroup
implements Runnable {
    public final int NO_COMP = -1;
    public final int EQUAL = 0;
    public final int NO_EQUAL = 1;
    public final int LESS = 2;
    public final int GREATER = 3;
    public final int LESS_EQUAL = 4;
    public final int GREATER_EQUAL = 5;
    public final int AVAILABLE = 6;
    private transient Thread th;
    private boolean logicStatus = false;
    private boolean stop = false;
    private String errorMessage = null;
    private String doocsLogicAddress = null;
    private EqAdr ea = null;
    private int doocsDataIndex = 0;
    private int doocsBitMask = 0;
    private boolean doocsUseBitMask = false;
    private int doocsComparator = 0;
    private String doocsCase = "1";
    private int doocsRadix = 10;
    private String doocsParamName = null;
    private String doocsParamValue = null;
    private float doocsUpdateTime = 1.0f;

    public DOOCSLogicGroup() {
        this.setEnabled(false);
    }

    public void stopThreads() {
        this.stop = true;
    }

    public void startThreads() {
        this.stop = false;
        this.th = new Thread(this);
        this.th.start();
    }

    public void setDoocsLogicAddress(String address) {
        this.doocsLogicAddress = address;
    }

    public String getDoocsLogicAddress() {
        return this.doocsLogicAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        super.setFullDoocsAddress(address);
        this.ea = new EqAdr(address);
        if (!this.ea.isValidAdr()) {
            this.ea = null;
        }
    }

    public void setDataIndex(int dataIndex) {
        this.doocsDataIndex = dataIndex;
    }

    public int getDataIndex() {
        return this.doocsDataIndex;
    }

    public void setBitMask(String bitmask) {
        this.doocsBitMask = IntegerParser.parseInt(bitmask, 16);
    }

    public String getBitMask() {
        return Integer.toHexString(this.doocsBitMask);
    }

    public void setUseBitMask(boolean value) {
        this.doocsUseBitMask = value;
    }

    public boolean getUseBitMask() {
        return this.doocsUseBitMask;
    }

    public void setUpdateInterval(float interval) {
        if (interval == 0.0f || (double)interval > 0.1) {
            this.doocsUpdateTime = interval;
        }
    }

    public float getUpdateInterval() {
        return this.doocsUpdateTime;
    }

    public void setCase(String casevalue) {
        this.doocsCase = casevalue;
        this.setName(this.toString());
    }

    public String getCase() {
        return this.doocsCase;
    }

    public void setComparator(int value) {
        this.doocsComparator = value;
        this.setName(this.toString());
    }

    public int getComparator() {
        return this.doocsComparator;
    }

    protected int parseComparator(String value) {
        if (value.equals("greater")) {
            return 3;
        }
        if (value.equals("greater or equal")) {
            return 5;
        }
        if (value.equals("equal")) {
            return 0;
        }
        if (value.equals("not equal")) {
            return 1;
        }
        if (value.equals("less")) {
            return 2;
        }
        if (value.equals("less or equal")) {
            return 4;
        }
        if (value.equals("available")) {
            return 6;
        }
        return -1;
    }

    protected String comparatorToString(int value) {
        switch (value) {
            case 0: {
                return "equal";
            }
            case 1: {
                return "not equal";
            }
            case 2: {
                return "less";
            }
            case 4: {
                return "less or equal";
            }
            case 3: {
                return "greater";
            }
            case 5: {
                return "greater or equal";
            }
            case 6: {
                return "available";
            }
        }
        return "ignore";
    }

    public boolean evaluateCase(Object doocsValue, int dataType) {
        if (this.doocsComparator == -1) {
            return true;
        }
        if (doocsValue == null) {
            return false;
        }
        if (dataType == 7 || dataType == 3 || dataType == 103 || dataType == 16 || dataType == 5) {
            if (this.doocsComparator == 6) {
                return true;
            }
            String sValue = (String)doocsValue;
            if (this.doocsComparator == 0) {
                return sValue.equalsIgnoreCase(this.doocsCase);
            }
            if (this.doocsComparator == 1) {
                return !sValue.equalsIgnoreCase(this.doocsCase);
            }
        } else {
            if (dataType == 1 || dataType == 105 || dataType == 4 || dataType == 119 || dataType == 14) {
                Integer numCase = 0;
                if (this.doocsComparator == 6) {
                    return true;
                }
                numCase = this.doocsCase == null ? 0 : IntegerParser.parseInt(this.doocsCase, this.doocsRadix);
                Integer numValue = (Integer)doocsValue;
                boolean isTrue = true;
                if (this.doocsComparator == 0) {
                    return numValue.equals(numCase);
                }
                if (this.doocsComparator == 1) {
                    return !numValue.equals(numCase);
                }
                if (this.doocsComparator == 3) {
                    isTrue = numValue > numCase;
                } else if (this.doocsComparator == 5) {
                    boolean bl = isTrue = numValue >= numCase;
                }
                if (this.doocsComparator == 2) {
                    isTrue = isTrue && numValue < numCase;
                } else if (this.doocsComparator == 4) {
                    isTrue = isTrue && numValue <= numCase;
                }
                return isTrue;
            }
            if (dataType == 2 || dataType == 100) {
                Double numCase = 0.0;
                if (this.doocsComparator == 6) {
                    return true;
                }
                numCase = this.doocsCase == null ? 0.0 : Double.parseDouble(this.doocsCase);
                Double numValue = (Double)doocsValue;
                boolean isTrue = true;
                if (this.doocsComparator == 0) {
                    return numValue.equals(numCase);
                }
                if (this.doocsComparator == 1) {
                    return !numValue.equals(numCase);
                }
                if (this.doocsComparator == 3) {
                    isTrue = numValue > numCase;
                } else if (this.doocsComparator == 5) {
                    boolean bl = isTrue = numValue >= numCase;
                }
                if (this.doocsComparator == 2) {
                    isTrue = isTrue && numValue < numCase;
                } else if (this.doocsComparator == 4) {
                    isTrue = isTrue && numValue <= numCase;
                }
                return isTrue;
            }
        }
        return false;
    }

    public void setDoocsParamName(String p) {
        this.doocsParamName = p;
    }

    public String getDoocsParamName() {
        return this.doocsParamName;
    }

    public void setDoocsParamValue(String p) {
        this.doocsParamValue = p;
    }

    public String getDoocsParamValue() {
        return this.doocsParamValue;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("logicAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("dataIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bitMask", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("useBitMask", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("comparator", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("compareValue", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("parameterName", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("parameterValue", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("comparator")) {
            String[] allowedValues = new String[]{"available", "equal", "not equal", "less", "less or equal", "greater", "greater or equal"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("parameterName")) {
            return this.getParameterNamesList();
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSLogicGroup ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("\n");
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append("</DOOCSLogicGroup>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("logicAdr")) {
            this.setDoocsLogicAddress(value);
        } else if (parameter.equalsIgnoreCase("dataIndex")) {
            this.setDataIndex(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("bitMask")) {
            this.setBitMask(value);
        } else if (parameter.equalsIgnoreCase("useBitMask")) {
            this.setUseBitMask(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("compareValue")) {
            this.setCase(value);
        } else if (parameter.equalsIgnoreCase("comparator")) {
            this.setComparator(this.parseComparator(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setUpdateInterval(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("parameterName")) {
            this.setDoocsParamName(value);
        } else if (parameter.equalsIgnoreCase("parameterValue")) {
            this.setDoocsParamValue(value);
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSLogicGroup.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("logicAdr")) {
            return this.getDoocsLogicAddress();
        }
        if (parameter.equalsIgnoreCase("dataIndex")) {
            return this.getDataIndex();
        }
        if (parameter.equalsIgnoreCase("bitMask")) {
            return this.getBitMask();
        }
        if (parameter.equalsIgnoreCase("useBitMask")) {
            return this.getUseBitMask();
        }
        if (parameter.equalsIgnoreCase("compareValue")) {
            return this.getCase();
        }
        if (parameter.equalsIgnoreCase("comparator")) {
            return this.comparatorToString(this.getComparator());
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getUpdateInterval());
        }
        if (parameter.equalsIgnoreCase("parameterName")) {
            return this.getDoocsParamName();
        }
        if (parameter.equalsIgnoreCase("parameterValue")) {
            return this.getDoocsParamValue();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSLogicGroup.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public String[] getParameterNamesList() {
        int i;
        Vector<String> props = new Vector<String>();
        DOOCSParameter[] paramList = ((DOOCSComponent)((Object)this.getComponent(0))).getDOOCSParameterList();
        for (i = 0; i < paramList.length; ++i) {
            props.add(paramList[i].parameter);
        }
        for (i = 1; i < this.getComponentCount(); ++i) {
            DOOCSParameter[] actList = ((DOOCSComponent)((Object)this.getComponent(i))).getDOOCSParameterList();
            Vector tempProps = new Vector();
            block2: for (int prop_count = 0; prop_count < props.size(); ++prop_count) {
                for (int item_count = 0; item_count < actList.length; ++item_count) {
                    if (!((String)props.get(prop_count)).equalsIgnoreCase(actList[item_count].parameter)) continue;
                    if (actList[item_count].parameter.equalsIgnoreCase("name") || actList[item_count].parameter.equalsIgnoreCase("bounds") || actList[item_count].parameter.equalsIgnoreCase("layer") || actList[item_count].parameter.equalsIgnoreCase("scale") || actList[item_count].parameter.equalsIgnoreCase("toolTipText")) continue block2;
                    tempProps.add(props.get(prop_count));
                    continue block2;
                }
            }
            props = tempProps;
        }
        String[] criteria = new String[props.size()];
        return props.toArray(criteria);
    }

    @Override
    public void setRunMode(boolean bRun) {
        super.setRunMode(bRun);
        this.setEnabled(bRun);
        if (bRun) {
            this.startThreads();
        } else {
            this.stopThreads();
        }
    }

    @Override
    public void run() {
        EqCall eq = new EqCall();
        EqData ed = new EqData();
        EqData data = new EqData();
        Vector<String> defaultValue = new Vector<String>();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.doocsParamName == null) continue;
            defaultValue.add(((DOOCSComponent)((Object)this.getComponent(i))).getDOOCSParameter(this.doocsParamName).toString());
        }
        while (!this.stop) {
            if (this.isRunMode() && this.ea != null) {
                Object actValue = null;
                eq.get(this.ea, ed, data);
                if (data.error() == 0 && data.type() != 0) {
                    this.errorMessage = null;
                    switch (data.type()) {
                        case 3: 
                        case 5: 
                        case 7: 
                        case 16: 
                        case 103: {
                            if (data.array_length() > 1) {
                                actValue = data.get_string_arg(this.doocsDataIndex);
                                break;
                            }
                            actValue = data.get_string_arg();
                            break;
                        }
                        case 1: 
                        case 8: 
                        case 14: 
                        case 105: 
                        case 115: {
                            if (this.doocsUseBitMask) {
                                actValue = data.get_int(this.doocsDataIndex) & this.doocsBitMask;
                                break;
                            }
                            actValue = data.get_int(this.doocsDataIndex);
                            break;
                        }
                        case 2: 
                        case 100: {
                            actValue = (double)data.get_float(this.doocsDataIndex);
                            break;
                        }
                        case 4: 
                        case 119: {
                            actValue = data.get_int(this.doocsDataIndex);
                            break;
                        }
                        default: {
                            new ShowException(null, "DOOCSLogicGroup", "to Elke: insert new Data type " + data.type() + " in DOOCSLogicGroup.java and DOOCSSwitch.java");
                        }
                    }
                    boolean status = this.evaluateCase(actValue, data.type());
                    if (status != this.logicStatus) {
                        this.logicStatus = status;
                        for (int i = 0; i < this.getComponentCount(); ++i) {
                            if (this.logicStatus) {
                                ((DOOCSComponent)((Object)this.getComponent(i))).setDOOCSParameter(this.doocsParamName, this.doocsParamValue);
                                continue;
                            }
                            ((DOOCSComponent)((Object)this.getComponent(i))).setDOOCSParameter(this.doocsParamName, (String)defaultValue.get(i));
                        }
                    }
                } else {
                    actValue = null;
                    if (this.errorMessage == null) {
                        this.errorMessage = data.get_string_arg();
                        System.out.println(DOOCSParameter.getFullName(this) + ": " + this.doocsLogicAddress + ": " + this.errorMessage);
                    }
                }
            }
            try {
                if ((double)this.doocsUpdateTime == 0.0) {
                    Thread.sleep(10000L);
                    continue;
                }
                if ((double)this.doocsUpdateTime < 0.1) {
                    Thread.sleep(100L);
                    continue;
                }
                Thread.sleep((long)(this.doocsUpdateTime * 1000.0f));
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
    }
}

