/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import editor.undo.SetProperty;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.metal.MetalComboBoxButton;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.DOOCSParser;

public class DOOCSLocationChooser
extends JComboBox
implements DOOCSComponent,
ActionListener {
    private String doocsLocationFilter = null;
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String fullDoocsAddress = null;
    private boolean startup = false;
    private MouseListener buttonMouseListener;

    public DOOCSLocationChooser() {
        this.setPreferredSize(new Dimension(100, 20));
        this.setEnabled(this.doocsRunMode);
        this.addActionListener(this);
        this.buttonMouseListener = ((MetalComboBoxButton)this.getComponent(0)).getMouseListeners()[0];
        ((MetalComboBoxButton)this.getComponent(0)).removeMouseListener(this.buttonMouseListener);
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsLocationFilter(String filter) {
        this.doocsLocationFilter = filter;
    }

    public String getDoocsLocationFilter() {
        return this.doocsLocationFilter;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            ((MetalComboBoxButton)this.getComponent(0)).addMouseListener(this.buttonMouseListener);
            if (this.fullDoocsAddress != null) {
                this.startup = true;
                this.removeAllItems();
                int slash1 = this.fullDoocsAddress.indexOf("/");
                int slash2 = this.fullDoocsAddress.indexOf("/", slash1 + 1);
                int slash3 = this.fullDoocsAddress.indexOf("/", slash2 + 1);
                String path = this.fullDoocsAddress.substring(0, slash2) + "/*/";
                String location = null;
                if (slash3 > 0) {
                    location = this.fullDoocsAddress.substring(slash2 + 1, slash3);
                }
                if (this.doocsLocationFilter != null && this.doocsLocationFilter.endsWith("*")) {
                    this.doocsLocationFilter = this.doocsLocationFilter.substring(0, this.doocsLocationFilter.length() - 1);
                }
                EqCall ec = new EqCall();
                EqData data = ec.names(new EqAdr(path));
                for (int i = 0; i < data.length(); ++i) {
                    String item = data.get_string_arg(i).trim();
                    if (item.contains("._SVR")) continue;
                    if (this.doocsLocationFilter == null) {
                        this.addItem(item);
                    }
                    if (this.doocsLocationFilter == null || !item.startsWith(this.doocsLocationFilter)) continue;
                    this.addItem(item);
                }
                if (location != null) {
                    this.setSelectedItem(location);
                }
                this.startup = false;
            }
        } else {
            ((MetalComboBoxButton)this.getComponent(0)).removeMouseListener(this.buttonMouseListener);
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("locationFilter", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "to display only locations starting with this String"), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSLocationChooser ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSLocationChooser>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("locationFilter")) {
            this.setDoocsLocationFilter(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSLocationChooser.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("locationFilter")) {
            return this.getDoocsLocationFilter();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSLocationChooser.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.getComponent(0).addMouseListener(ml);
        this.getComponent(0).addMouseMotionListener(ml);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.doocsRunMode && !this.startup) {
            String parentAddress = ((DOOCSLayeredPane)this.getParent()).getFullDoocsAddress();
            int slash1 = parentAddress.indexOf("/");
            int slash2 = parentAddress.indexOf("/", slash1 + 1);
            int slash3 = parentAddress.indexOf("/", slash2 + 1);
            String newAddress = parentAddress.substring(0, slash2 + 1) + this.getSelectedItem() + parentAddress.substring(slash3);
            ((DOOCSLayeredPane)this.getParent()).setFullDoocsAddress(newAddress);
            DOOCSParser.inherit((DOOCSComponent)((Object)this.getParent()));
            if (((DOOCSLayeredPane)this.getParent()).showToolTip) {
                ((DOOCSLayeredPane)this.getParent()).switchToolTipText((DOOCSLayeredPane)this.getParent(), true);
            }
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

