/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import editor.EditorPanel;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.MouseInputListener;
import jsvnbrowser.JSVNFileInfo;

public class DOOCSIcon
extends JLabel
implements DOOCSComponent {
    private String doocsIconFile = null;
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsRotate = "0";
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;

    public DOOCSIcon() {
        this.setEnabled(this.doocsRunMode);
        this.setPreferredSize(new Dimension(20, 20));
        this.setSize(new Dimension(20, 20));
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(1);
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        if (icon != null) {
            int x = this.getX();
            int y = this.getY();
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            DOOCSComponent bgcomponent = (DOOCSComponent)((Object)this.getParent());
            if (x + width > bgcomponent.getWidth()) {
                x = bgcomponent.getWidth() - width;
            }
            if (y + height > bgcomponent.getHeight()) {
                y = bgcomponent.getHeight() - height;
            }
            if (x < 0) {
                x = 0;
                if (bgcomponent.getWidth() < width) {
                    width = bgcomponent.getWidth();
                }
            }
            if (y < 0) {
                y = 0;
                if (bgcomponent.getHeight() < height) {
                    height = bgcomponent.getHeight();
                }
            }
            Rectangle rect = new Rectangle(x, y, width, height);
            this.setBounds(rect);
            this.setInitialBounds(rect);
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    public void setDoocsIconFile(String file) {
        this.doocsIconFile = file;
        if (file != null) {
            if (file.startsWith("http://")) {
                try {
                    this.setIcon(new ImageIcon(new URL(file)));
                }
                catch (MalformedURLException mue) {
                    System.out.println(this.getName() + mue);
                }
            } else {
                JSVNFileInfo fInfo = DOOCSParameter.getDoocsFilePath(file, this);
                if (fInfo != null && fInfo.buf != null) {
                    this.setIcon(new ImageIcon(fInfo.buf));
                } else {
                    this.setIcon(null);
                }
                if (fInfo != null && fInfo.buf == null) {
                    System.err.println("Couldn't open file: " + file);
                }
            }
        } else {
            this.setIcon(null);
        }
    }

    public String getDoocsIconFile() {
        return this.doocsIconFile;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setFullDoocsAddress(String address) {
    }

    @Override
    public String getFullDoocsAddress() {
        return null;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsRotate(String rotate) {
        if ((this.doocsRotate.equalsIgnoreCase("0") || this.doocsRotate.equalsIgnoreCase("180")) && (rotate.equalsIgnoreCase("90") || rotate.equalsIgnoreCase("270")) || (this.doocsRotate.equalsIgnoreCase("90") || this.doocsRotate.equalsIgnoreCase("270")) && (rotate.equalsIgnoreCase("0") || rotate.equalsIgnoreCase("180"))) {
            this.setPreferredSize(new Dimension(this.getHeight(), this.getWidth()));
            this.setSize(this.getHeight(), this.getWidth());
            Container parent = this.getParent();
            if (!(parent == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
                if (this.getX() < 0) {
                    this.setLocation(0, this.getY());
                }
                if (this.getY() < 0) {
                    this.setLocation(this.getX(), 0);
                }
                if (this.getX() + this.getWidth() > parent.getWidth()) {
                    this.setLocation(parent.getWidth() - this.getWidth(), this.getY());
                }
                if (this.getY() + this.getHeight() > parent.getHeight()) {
                    this.setLocation(this.getX(), parent.getHeight() - this.getHeight());
                }
            }
        }
        this.doocsRotate = rotate;
        if (this.doocsRotate.equalsIgnoreCase("180")) {
            this.setHorizontalAlignment(4);
            this.setVerticalAlignment(3);
        } else {
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(1);
        }
    }

    public String getDoocsRotate() {
        return this.doocsRotate;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFile", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("rotate")) {
            String[] allowedValues = new String[]{"0", "90", "180", "270"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSIcon ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSIcon>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("iconFile")) {
            this.setDoocsIconFile(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("rotate")) {
            this.setDoocsRotate(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSIcon.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("iconFile")) {
            return this.getDoocsIconFile();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            return this.getDoocsRotate();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSIcon.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    @Override
    public void paintComponent(Graphics g) {
        int height;
        int width;
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.doocsRotate.equalsIgnoreCase("0") || this.doocsRotate.equalsIgnoreCase("180")) {
            width = this.getSize().width;
            height = this.getSize().height;
        } else {
            width = this.getSize().height;
            height = this.getSize().width;
        }
        if (this.getIcon() != null) {
            double xFactor = (double)width / (double)this.getIcon().getIconWidth();
            double yFactor = (double)height / (double)this.getIcon().getIconHeight();
            if (xFactor != 1.0 || yFactor != 1.0) {
                if (this.doocsRotate.equalsIgnoreCase("0") || this.doocsRotate.equalsIgnoreCase("180")) {
                    g2d.scale(xFactor, yFactor);
                } else {
                    g2d.scale(yFactor, xFactor);
                }
            }
            if (this.doocsRotate.equalsIgnoreCase("90")) {
                g2d.rotate(1.5707963267948966);
                g2d.translate(0.0, (double)(-this.getWidth()) / yFactor);
            }
            if (this.doocsRotate.equalsIgnoreCase("180")) {
                g2d.rotate(Math.PI);
                g2d.translate(-this.getWidth(), -this.getHeight());
            }
            if (this.doocsRotate.equalsIgnoreCase("270")) {
                g2d.rotate(-1.5707963267948966);
                g2d.translate((double)(-this.getHeight()) / xFactor, 0.0);
            }
        } else {
            g2d.setColor(Color.GRAY);
            g2d.drawRect(0, 0, width - 1, height - 1);
        }
        super.paintComponent(g2d);
        g2d.dispose();
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("90");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("0");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("0");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("180");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("0");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }
}

