/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ShowException;
import editor.undo.SetProperty;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.metal.MetalComboBoxButton;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSComboBox
extends JComboBox
implements DOOCSComponent,
ActionListener,
Runnable {
    private transient Thread th;
    private boolean stop = false;
    private String errorMessage = null;
    private boolean init = true;
    private String doocsAddress = null;
    private float doocsUpdateTime = 0.0f;
    private String doocsText = null;
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String fullDoocsAddress = null;
    private MouseListener buttonMouseListener;

    public DOOCSComboBox() {
        this.setPreferredSize(new Dimension(100, 20));
        this.setEnabled(this.doocsRunMode);
        this.addActionListener(this);
        this.buttonMouseListener = ((MetalComboBoxButton)this.getComponent(0)).getMouseListeners()[0];
        ((MetalComboBoxButton)this.getComponent(0)).removeMouseListener(this.buttonMouseListener);
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void stopThreads() {
        this.stop = true;
    }

    public void startThreads() {
        this.stop = false;
        this.th = new Thread(this);
        this.th.start();
    }

    public void setDoocsText(String text) {
        this.doocsText = text;
        if (text != null) {
            this.removeAllItems();
            StringTokenizer st = new StringTokenizer(text, ";");
            while (st.hasMoreTokens()) {
                this.init = true;
                this.addItem(st.nextToken());
            }
        }
    }

    public String getDoocsText() {
        return this.doocsText;
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            ((MetalComboBoxButton)this.getComponent(0)).addMouseListener(this.buttonMouseListener);
            this.startThreads();
        } else {
            ((MetalComboBoxButton)this.getComponent(0)).removeMouseListener(this.buttonMouseListener);
            this.stopThreads();
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "item1;item2;item3"), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSComboBox ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSComboBox>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("text")) {
            this.setDoocsText(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSComboBox.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("text")) {
            return this.getDoocsText();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSComboBox.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.getComponent(0).addMouseListener(ml);
        this.getComponent(0).addMouseMotionListener(ml);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.init) {
            this.init = false;
            return;
        }
        if (this.doocsRunMode && this.fullDoocsAddress != null && this.fullDoocsAddress.length() > 5) {
            EqCall eq = new EqCall();
            EqAdr ea = new EqAdr(this.fullDoocsAddress);
            EqData ed = new EqData();
            EqData data = new EqData();
            data.init();
            eq.get(ea, ed, data);
            if (data.error() == 0) {
                String doocsValue = this.getSelectedItem().toString();
                try {
                    switch (data.type()) {
                        case 1: 
                        case 105: {
                            ed.set(IntegerParser.parseInt(doocsValue));
                            break;
                        }
                        case 2: 
                        case 100: {
                            ed.set(Float.parseFloat(doocsValue));
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 7: 
                        case 103: {
                            ed.set_type(data.type());
                            ed.set_from_string(doocsValue);
                            break;
                        }
                        default: {
                            new ShowException(null, "DOOCSComboBox", "to Elke: insert new Data type " + data.type() + " in DOOCSComboBox.java");
                        }
                    }
                    eq.set(ea, ed, data);
                    if (data.error() != 0) {
                        new ShowException(null, this.getName(), data.get_string_arg());
                    }
                }
                catch (NumberFormatException nfe) {
                    new ShowException(null, DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress, nfe);
                }
            } else {
                new ShowException(null, this.getName(), data.get_string_arg());
            }
        }
    }

    @Override
    public void run() {
        EqCall eq = new EqCall();
        EqData ed = new EqData();
        EqData data = new EqData();
        EqAdr ea = null;
        String oldAdr = "";
        while (!this.stop) {
            if (this.doocsRunMode && this.fullDoocsAddress != null && this.fullDoocsAddress.length() > 5) {
                String value;
                if (!oldAdr.equalsIgnoreCase(this.fullDoocsAddress) || ea == null) {
                    oldAdr = this.fullDoocsAddress;
                    ea = new EqAdr(this.fullDoocsAddress);
                }
                data.init();
                eq.get(ea, ed, data);
                if (data.error() == 0) {
                    this.errorMessage = null;
                    value = data.array_length() > 1 ? data.get_string(0) : data.get_string();
                    if (!value.equalsIgnoreCase(this.getSelectedItem().toString())) {
                        this.init = true;
                        boolean containsValue = false;
                        for (int i = 0; i < this.getItemCount(); ++i) {
                            if (!value.equalsIgnoreCase(this.getItemAt(i).toString())) continue;
                            this.setSelectedIndex(i);
                            containsValue = true;
                        }
                        if (!containsValue) {
                            this.addItem(value);
                        }
                    }
                } else {
                    value = data.get_string_arg();
                    if (this.errorMessage == null) {
                        this.errorMessage = value;
                        System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
                    }
                }
            }
            try {
                if ((double)this.doocsUpdateTime == 0.0) {
                    Thread.sleep(10000L);
                    continue;
                }
                if ((double)this.doocsUpdateTime < 0.1) {
                    Thread.sleep(100L);
                    continue;
                }
                Thread.sleep((long)(this.doocsUpdateTime * 1000.0f));
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

