/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ShowException;
import editor.undo.SetProperty;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import jsvnbrowser.JSVNFileInfo;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;

public class DOOCSAudio
extends JLabel
implements Runnable,
DOOCSComponent,
MouseListener {
    private transient Thread th;
    private boolean stop = false;
    private String errorMessage = null;
    private String doocsFunction = "Play .wav file";
    private String doocsAudioFile = null;
    private String doocsAudioURL = null;
    private String doocsVolume = "muted";
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private String doocsToolTipText = null;
    private float doocsUpdateTime = 1.0f;
    private float doocsRangeMax = 100.0f;
    private float doocsRangeMin = 1.0f;
    private double doocsVolumeDouble = 0.0;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private transient Clip clip = null;
    private ImageIcon iconmute = new ImageIcon(this.getClass().getResource("icons/audio-volume-muted.png"));
    private ImageIcon iconlow = new ImageIcon(this.getClass().getResource("icons/audio-volume-low.png"));
    private ImageIcon iconmedium = new ImageIcon(this.getClass().getResource("icons/audio-volume-medium.png"));
    private ImageIcon iconhigh = new ImageIcon(this.getClass().getResource("icons/audio-volume-high.png"));
    transient AudioFormat audioFormat;
    private byte[] audioData = new byte[32000];
    private static float sampleRate = 16000.0f;
    private static int sampleSizeInBits = 16;
    private static int channels = 1;
    private static int bytesPerSamp = 2;
    private static int fMin = 300;
    private static int fMax = 1000;
    private float a;
    private float b;
    private transient AudioInputStream audioInputStream;

    public DOOCSAudio() {
        this.setOpaque(false);
        this.setIcon(this.iconmute);
        int width = this.iconmute.getIconWidth();
        int height = this.iconmute.getIconHeight();
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(new Dimension(width, height));
    }

    public void stopThreads() {
        this.stop = true;
        if (this.clip != null && this.clip.isRunning()) {
            this.clip.stop();
            this.clip.setFramePosition(0);
        }
    }

    public void startThreads() {
        this.stop = false;
        if (this.getDoocsFunction().equalsIgnoreCase("Dynamic Beep")) {
            this.th = new Thread(this);
            this.th.start();
        } else if (this.clip != null && !this.clip.isRunning() && this.doocsVolumeDouble > 0.0) {
            this.clip.loop(-1);
        }
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsFunction(String function) {
        this.doocsFunction = function;
    }

    public String getDoocsFunction() {
        return this.doocsFunction;
    }

    public void setDoocsAudioFile(String file) {
        if (file != null) {
            this.doocsAudioURL = null;
        }
        this.doocsAudioFile = file;
        if (this.doocsAudioFile != null) {
            JSVNFileInfo fInfo = DOOCSParameter.getDoocsFilePath(this.doocsAudioFile, this);
            if (fInfo != null) {
                try {
                    AudioInputStream stream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(fInfo.buf));
                    this.fillAudioClip(stream);
                }
                catch (IOException e) {
                    new ShowException(null, "DOOCSAudio", e);
                }
                catch (UnsupportedAudioFileException e) {
                    new ShowException(null, "DOOCSAudio", e);
                }
            } else {
                this.clip = null;
            }
        } else {
            this.clip = null;
        }
        this.setVolume(this.doocsVolumeDouble);
    }

    public String getDoocsAudioFile() {
        return this.doocsAudioFile;
    }

    public void setDoocsAudioURL(String url) {
        if (url != null) {
            this.doocsAudioFile = null;
        }
        this.doocsAudioURL = url;
        if (this.doocsAudioURL != null) {
            try {
                AudioInputStream stream = AudioSystem.getAudioInputStream(new URL(this.doocsAudioURL));
                this.fillAudioClip(stream);
            }
            catch (IOException e) {
                new ShowException(null, "DOOCSAudio", e);
            }
            catch (UnsupportedAudioFileException e) {
                new ShowException(null, "DOOCSAudio", e);
            }
        }
    }

    public String getDoocsAudioURL() {
        return this.doocsAudioURL;
    }

    public void setDoocsVolume(String volume, double value) {
        this.doocsVolume = volume;
        this.doocsVolumeDouble = value;
        if (volume.equalsIgnoreCase("muted")) {
            if (value > 1.0) {
                this.doocsVolumeDouble = 0.0;
            }
            this.setIcon(this.iconmute);
        }
        if (volume.equalsIgnoreCase("low")) {
            if (value > 1.0) {
                this.doocsVolumeDouble = 0.33;
            }
            this.setIcon(this.iconlow);
        }
        if (volume.equalsIgnoreCase("medium")) {
            if (value > 1.0) {
                this.doocsVolumeDouble = 0.66;
            }
            this.setIcon(this.iconmedium);
        }
        if (volume.equalsIgnoreCase("high")) {
            if (value > 1.0) {
                this.doocsVolumeDouble = 1.0;
            }
            this.setIcon(this.iconhigh);
        }
        this.setVolume(this.doocsVolumeDouble);
    }

    public String getDoocsVolume() {
        return this.doocsVolume;
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        this.fullDoocsAddress = address;
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsRangeMax(float max) {
        this.doocsRangeMax = max;
        this.a = (float)(fMax - fMin) / (this.doocsRangeMax - this.doocsRangeMin);
        this.b = (float)fMin - this.a * this.doocsRangeMin;
    }

    public float getDoocsRangeMax() {
        return this.doocsRangeMax;
    }

    public void setDoocsRangeMin(float min) {
        this.doocsRangeMin = min;
        this.a = (float)(fMax - fMin) / (this.doocsRangeMax - this.doocsRangeMin);
        this.b = (float)fMin - this.a * this.doocsRangeMin;
    }

    public float getDoocsRangeMin() {
        return this.doocsRangeMin;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        if (bRun) {
            this.startThreads();
            this.addMouseListener(this);
        } else {
            this.stopThreads();
            this.removeMouseListener(this);
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        if (this.doocsFunction.equalsIgnoreCase("Play .wav file")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("function", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("audioFile", DOOCSParameter.ParameterTypes.AUDIOFILE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("audioURL", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("volume", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("function", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rangeMax", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rangeMin", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("volume", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("function")) {
            String[] allowedValues = new String[]{"Play .wav file", "Dynamic Beep"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("volume")) {
            String[] allowedValues = new String[]{"muted", "low", "medium", "high"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSAudio ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSAudio>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("function")) {
            this.setDoocsFunction(value);
        } else if (parameter.equalsIgnoreCase("audioFile")) {
            this.setDoocsAudioFile(value);
        } else if (parameter.equalsIgnoreCase("audioURL")) {
            this.setDoocsAudioURL(value);
        } else if (parameter.equalsIgnoreCase("volume")) {
            this.setDoocsVolume(value, 2.0);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("rangeMax")) {
            this.setDoocsRangeMax(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("rangeMin")) {
            this.setDoocsRangeMin(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else {
            if (parameter.equalsIgnoreCase("size")) {
                return;
            }
            if (parameter.equalsIgnoreCase("runMode")) {
                this.setRunMode(Boolean.parseBoolean(value));
            } else {
                System.out.println("DOOCSAudio.setDOOCSParameter: wrong parameter " + parameter);
            }
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("function")) {
            return this.getDoocsFunction();
        }
        if (parameter.equalsIgnoreCase("audioFile")) {
            return this.getDoocsAudioFile();
        }
        if (parameter.equalsIgnoreCase("audioURL")) {
            return this.getDoocsAudioURL();
        }
        if (parameter.equalsIgnoreCase("volume")) {
            return this.getDoocsVolume();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("rangeMax")) {
            return Float.valueOf(this.getDoocsRangeMax());
        }
        if (parameter.equalsIgnoreCase("rangeMin")) {
            return Float.valueOf(this.getDoocsRangeMin());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSAudio.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (this.clip != null && this.doocsRunMode) {
            final JSlider slider = new JSlider(1, 0, 100, (int)(this.doocsVolumeDouble * 100.0));
            slider.setPaintLabels(true);
            slider.setPaintTicks(true);
            slider.setBorder(BorderFactory.createBevelBorder(0));
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DOOCSAudio.this.doocsVolumeDouble = (double)slider.getValue() / 100.0;
                    if (DOOCSAudio.this.doocsVolumeDouble == 0.0) {
                        DOOCSAudio.this.setDoocsVolume("muted", DOOCSAudio.this.doocsVolumeDouble);
                        if (DOOCSAudio.this.clip != null && DOOCSAudio.this.clip.isRunning()) {
                            DOOCSAudio.this.clip.stop();
                            DOOCSAudio.this.clip.setFramePosition(0);
                        }
                    }
                    if (DOOCSAudio.this.doocsVolumeDouble > 0.0 && DOOCSAudio.this.clip != null && !DOOCSAudio.this.clip.isRunning()) {
                        DOOCSAudio.this.clip.loop(-1);
                    }
                    if (DOOCSAudio.this.doocsVolumeDouble > 0.0 && DOOCSAudio.this.doocsVolumeDouble <= 0.33) {
                        DOOCSAudio.this.setDoocsVolume("low", DOOCSAudio.this.doocsVolumeDouble);
                    }
                    if (DOOCSAudio.this.doocsVolumeDouble > 0.33 && DOOCSAudio.this.doocsVolumeDouble <= 0.66) {
                        DOOCSAudio.this.setDoocsVolume("medium", DOOCSAudio.this.doocsVolumeDouble);
                    }
                    if (DOOCSAudio.this.doocsVolumeDouble > 0.66 && DOOCSAudio.this.doocsVolumeDouble <= 1.0) {
                        DOOCSAudio.this.setDoocsVolume("high", DOOCSAudio.this.doocsVolumeDouble);
                    }
                }
            });
            JPopupMenu pop = new JPopupMenu();
            pop.add(slider);
            pop.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void setVolume(double gain) {
        if (this.clip != null) {
            FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
            float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
            gainControl.setValue(dB);
        }
    }

    private void fillAudioClip(AudioInputStream stream) {
        try {
            if (this.clip != null) {
                this.clip.close();
            }
            this.audioFormat = stream.getFormat();
            if (this.audioFormat.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                this.audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.audioFormat.getSampleRate(), this.audioFormat.getSampleSizeInBits(), this.audioFormat.getChannels(), this.audioFormat.getFrameSize(), this.audioFormat.getFrameRate(), true);
                stream = AudioSystem.getAudioInputStream(this.audioFormat, stream);
            }
            DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * this.audioFormat.getFrameSize());
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(stream);
        }
        catch (IOException e) {
            new ShowException(null, "DOOCSAudio", e);
        }
        catch (LineUnavailableException e) {
            new ShowException(null, "DOOCSAudio", e);
        }
    }

    private void createBeep(double freq) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.audioData);
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        int byteLength = this.audioData.length;
        int sampLength = byteLength / bytesPerSamp;
        for (int cnt = 0; cnt < sampLength; ++cnt) {
            double time = (float)cnt / sampleRate;
            double sinValue = (Math.sin(Math.PI * 2 * freq * time) + Math.sin(Math.PI * 2 * (freq / 1.8) * time) + Math.sin(Math.PI * 2 * (freq / 1.5) * time)) / 3.0;
            shortBuffer.put((short)(16000.0 * sinValue));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.audioData);
        this.audioFormat = new AudioFormat(sampleRate, sampleSizeInBits, channels, true, true);
        this.audioInputStream = new AudioInputStream(byteArrayInputStream, this.audioFormat, this.audioData.length / this.audioFormat.getFrameSize());
        DataLine.Info dataLineInfo = new DataLine.Info(Clip.class, this.audioFormat);
        try {
            if (this.clip != null && this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip = (Clip)AudioSystem.getLine(dataLineInfo);
            if (!this.clip.isOpen()) {
                this.clip.open(this.audioInputStream);
            }
            this.clip.loop(-1);
        }
        catch (LineUnavailableException lue) {
            lue.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void run() {
        EqCall eq = new EqCall();
        EqData ed = new EqData();
        EqData data = new EqData();
        EqAdr ea = null;
        String oldAdr = "";
        while (!this.stop) {
            if (this.doocsRunMode && this.fullDoocsAddress != null && this.fullDoocsAddress.length() > 5) {
                if (!oldAdr.equalsIgnoreCase(this.fullDoocsAddress) || ea == null) {
                    oldAdr = this.fullDoocsAddress;
                    ea = new EqAdr(this.fullDoocsAddress);
                }
                double value = 950.0;
                data.init();
                eq.get(ea, ed, data);
                if (data.error() == 0) {
                    if (data.type() == 2 || data.type() == 1 || data.type() == 100 || data.type() == 105) {
                        value = data.get_float(0);
                    }
                    double freq = (double)this.a * value + (double)this.b;
                    this.createBeep(freq);
                } else if (this.errorMessage == null) {
                    this.errorMessage = data.get_string_arg();
                    System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
                }
            }
            try {
                if ((double)this.doocsUpdateTime == 0.0) {
                    Thread.sleep(10000L);
                    continue;
                }
                if ((double)this.doocsUpdateTime < 0.1) {
                    Thread.sleep(100L);
                    continue;
                }
                Thread.sleep((long)(this.doocsUpdateTime * 1000.0f));
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
        if (this.clip != null) {
            this.clip.stop();
        }
        if (this.clip != null) {
            this.clip.close();
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

