/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.ShowException;
import java.io.IOException;

public class BrowserControl {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static String UNIX_PATH = "/opt2/firefox1.0/firefox";
    private static final String UNIX_FLAG = "-remote 'openurl";

    public static void displayURL(String url) {
        block6: {
            boolean windows = BrowserControl.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Runtime.getRuntime().exec(cmd);
                    break block6;
                }
                cmd = UNIX_PATH + " " + url;
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = UNIX_PATH + " " + url;
                        Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException x) {
                    new ShowException(null, "InterruptedException", "Error bringing up browser, cmd: " + cmd + "\nCaught: " + x);
                }
            }
            catch (IOException x) {
                new ShowException(null, "IOException", "Could not invoke browser, command: " + cmd + "\nCaught: " + x);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        if (os != null && os.startsWith(WIN_ID)) {
            return true;
        }
        if (os != null && os.equalsIgnoreCase("Linux")) {
            UNIX_PATH = "/usr/bin/firefox";
        }
        return false;
    }

    public static void main(String[] args) {
        BrowserControl.displayURL("http://www.javaworld.com");
    }
}

