/*
 * Decompiled with CFR 0.152.
 */
package daq;

import daq.RunCtlTags;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class daq_xml_request
extends DefaultHandler
implements RunCtlTags {
    public long tstart;
    public long tstop;
    public int runfirst;
    public int runlast;
    public String exp;
    public String data_dir;
    public String c_dir;
    public Vector chans;
    public Vector<Integer> dtypes;
    public Vector files;
    public int req_id;
    public int scan_mode;
    public int req_type;
    public int comm_mode;
    public String conf;
    boolean rootf;
    int conv_error;
    boolean init_in_start;
    private int error;

    public int isValid() {
        int n;
        if (this.conf != null && !this.conf.isEmpty() && (n = this.parse_xml_request(this.conf)) != 0) {
            return n;
        }
        if (this.req_id <= 0) {
            return -9;
        }
        if (this.tstart < 0L && this.tstop < 0L && this.runfirst < 0 && this.runlast < 0) {
            return -2;
        }
        if ((this.exp == null || this.exp.isEmpty()) && this.files.size() == 0) {
            return -3;
        }
        if (this.req_type < 1 || this.req_type > 3) {
            return -5;
        }
        if (this.comm_mode < 1 || this.comm_mode > 2) {
            return -6;
        }
        if (this.runfirst > this.runlast && (this.files == null || this.files.size() == 0)) {
            System.out.println("run_first: " + this.runfirst + " run_last: " + this.runlast);
            return -9;
        }
        return 0;
    }

    public daq_xml_request(long l, long l2, int n, int n2, String string, String string2, String string3, int n3, int n4, int n5, int n6, String string4) {
        this.tstart = l;
        this.tstop = l2;
        this.runfirst = n;
        this.runlast = n2;
        this.exp = string;
        this.data_dir = string2;
        this.c_dir = string3;
        this.chans = null;
        this.dtypes = null;
        this.files = null;
        this.req_id = n3;
        this.scan_mode = n4 == 0 ? 15 : n4;
        this.req_type = n5 == 0 ? 2 : n5;
        this.comm_mode = n6 == 0 ? 1 : n6;
        this.conf = string4;
        Date date = new Date();
        this.req_id = (int)(date.getTime() / 1000L);
        this.init_in_start(false);
    }

    public boolean init_in_start(boolean bl) {
        this.init_in_start = bl;
        return bl;
    }

    public daq_xml_request() {
        this.tstart = -1L;
        this.tstop = -1L;
        this.runfirst = -1;
        this.runlast = -1;
        this.exp = new String("linac");
        this.data_dir = new String("/daq/ttf2_ext/LINAC");
        this.c_dir = new String("/daq/ttf2/admtemp/");
        this.chans = null;
        this.dtypes = null;
        this.files = null;
        Date date = new Date();
        this.req_id = (int)(date.getTime() / 1000L);
        this.scan_mode = 15;
        this.req_type = 2;
        this.comm_mode = 1;
        this.conf = null;
        this.init_in_start(true);
    }

    public int add_channel(String string, int n) {
        if (this.chans == null) {
            this.chans = new Vector();
            this.dtypes = new Vector();
        }
        this.chans.add(string);
        this.dtypes.add(new Integer(n));
        return this.chans.size();
    }

    public int add_file(String string) {
        if (this.files == null) {
            this.files = new Vector();
        }
        this.files.add(string);
        return this.files.size();
    }

    public String get_xml_request() {
        Object[] objectArray;
        String[] stringArray;
        Comparable<File> comparable;
        String string = new String();
        if (this.conf != null && ((File)(comparable = new File(this.conf))).exists() && ((File)comparable).canRead()) {
            stringArray = null;
            try {
                stringArray = new BufferedReader(new FileReader((File)comparable));
                StringBuffer stringBuffer = new StringBuffer();
                objectArray = new char[512];
                try {
                    int n = 0;
                    while ((n = stringArray.read((char[])objectArray)) > -1) {
                        stringBuffer.append((char[])objectArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.parse_xml_request(stringBuffer.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (stringArray != null) {
                try {
                    stringArray.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        comparable = new StringBuffer(daq_request_tags[0] + "\n");
        ((StringBuffer)comparable).append(daq_request_tags[1] + this.req_id + "'/>" + "\n");
        if (this.tstart != -1L) {
            ((StringBuffer)comparable).append(daq_request_tags[5] + this.print_time_stamp(this.tstart) + "'/>" + "\n");
        }
        if (this.tstop != -1L) {
            ((StringBuffer)comparable).append(daq_request_tags[6] + this.print_time_stamp(this.tstop) + "'/>" + "\n");
        }
        if (this.runfirst != -1) {
            ((StringBuffer)comparable).append(daq_request_tags[8] + this.runfirst + "'/>" + "\n");
        }
        if (this.runlast != -1) {
            ((StringBuffer)comparable).append(daq_request_tags[9] + this.runlast + "'/>" + "\n");
        }
        if (this.exp != null) {
            ((StringBuffer)comparable).append(daq_request_tags[7] + this.exp + "'/>" + "\n");
        }
        if (this.data_dir != null) {
            ((StringBuffer)comparable).append(daq_request_tags[10] + this.data_dir + "'/>" + "\n");
        }
        if (this.c_dir != null) {
            ((StringBuffer)comparable).append(daq_request_tags[11] + this.c_dir + "'/>" + "\n");
        }
        if (this.scan_mode != 15) {
            ((StringBuffer)comparable).append(daq_request_tags[2] + this.scan_mode + "'/>" + "\n");
        }
        if (this.req_type == 2) {
            ((StringBuffer)comparable).append(daq_request_tags[3] + this.req_type + "'/>" + "\n");
        }
        if (this.comm_mode != 1) {
            ((StringBuffer)comparable).append(daq_request_tags[4] + this.comm_mode + "'/>" + "\n");
        }
        if (this.chans != null) {
            stringArray = daq_request_attrs[12].split(":");
            for (int i = 0; i < this.chans.size(); ++i) {
                objectArray = ((String)this.chans.elementAt(i)).split("@");
                if (objectArray.length == 1) {
                    ((StringBuffer)comparable).append(daq_request_tags[12] + (String)this.chans.elementAt(i) + "'");
                    if (this.dtypes.elementAt(i) != 0) {
                        ((StringBuffer)comparable).append(" " + stringArray[stringArray.length - 1] + "='" + this.dtypes.elementAt(i) + "'");
                    }
                    ((StringBuffer)comparable).append("/>\n");
                    continue;
                }
                ((StringBuffer)comparable).append(daq_request_tags[12] + (String)objectArray[0] + "'");
                if (this.dtypes.elementAt(i) != 0) {
                    ((StringBuffer)comparable).append(" " + stringArray[stringArray.length - 1] + "='" + this.dtypes.elementAt(i) + "'");
                }
                for (int j = 1; j < objectArray.length && j < stringArray.length - 1; ++j) {
                    ((StringBuffer)comparable).append(" " + stringArray[j] + "='" + (String)objectArray[j] + "'");
                }
                ((StringBuffer)comparable).append("/>\n");
            }
        }
        if (this.files != null) {
            for (int i = 0; i < this.files.size(); ++i) {
                ((StringBuffer)comparable).append(daq_request_tags[13] + (String)this.files.elementAt(i) + "'/>" + "\n");
            }
        }
        ((StringBuffer)comparable).append(daq_request_tags[15] + "\n");
        return ((StringBuffer)comparable).toString();
    }

    public String print_time_stamp(long l) {
        Date date = new Date();
        date.setTime(l * 1000L);
        String string = "yyyy-MM-dd";
        String string2 = "HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string2);
        return new String(simpleDateFormat.format(date) + "T" + simpleDateFormat2.format(date));
    }

    public void startDocument() throws SAXException {
        if (this.init_in_start) {
            this.tstart = -1L;
            this.tstop = -1L;
            this.runfirst = -1;
            this.runlast = -1;
            this.exp = new String("linac");
            this.data_dir = new String("/daq/ttf2_ext/LINAC");
            this.c_dir = new String("/daq/ttf2/admtemp/");
            this.chans = null;
            this.files = null;
            Date date = new Date();
            this.req_id = (int)(date.getTime() / 1000L);
            this.scan_mode = 15;
            this.req_type = 2;
            this.comm_mode = 1;
            this.conf = null;
        }
    }

    public void endDocument() throws SAXException {
        if (!this.rootf) {
            this.error = -5;
        }
        this.rootf = false;
    }

    public int get_time_in_sec(String string) {
        if (string != null) {
            String string2 = "yyyy-MM-dd_HH:mm:ss";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            String[] stringArray = string.split("T");
            String string3 = new String(stringArray[0] + "_" + stringArray[1]);
            try {
                Date date = simpleDateFormat.parse(string3);
                if (date != null) {
                    return (int)(date.getTime() / 1000L);
                }
                return -1;
            }
            catch (ParseException parseException) {
                System.out.println("Exception: " + parseException.toString());
            }
        }
        return -1;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase(daq_request_tags_s[0])) {
            this.rootf = true;
            return;
        }
        if (this.rootf) {
            String string4;
            if (string3.equalsIgnoreCase(daq_request_tags_s[1])) {
                int n = this.get_int(attributes.getValue(daq_request_attrs[1]));
                this.req_id = this.conv_error == 0 ? n : 0;
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[2])) {
                int n = this.get_int(attributes.getValue(daq_request_attrs[2]));
                if (this.conv_error == 0) {
                    this.scan_mode = n;
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[3])) {
                int n = this.get_int(attributes.getValue(daq_request_attrs[3]));
                if (this.conv_error == 0) {
                    this.req_type = n;
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[4])) {
                int n = this.get_int(attributes.getValue(daq_request_attrs[4]));
                if (this.conv_error == 0) {
                    this.comm_mode = n;
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[5])) {
                this.tstart = this.get_time_in_sec(attributes.getValue(daq_request_attrs[5]));
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[6])) {
                this.tstop = this.get_time_in_sec(attributes.getValue(daq_request_attrs[6]));
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[7])) {
                String string5 = attributes.getValue(daq_request_attrs[7]);
                if (string5 != null) {
                    this.exp = string5;
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[8])) {
                int n = this.get_int(attributes.getValue(daq_request_attrs[8]));
                if (this.conv_error == 0) {
                    this.runfirst = n;
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[9])) {
                int n = this.get_int(attributes.getValue(daq_request_attrs[9]));
                if (this.conv_error == 0) {
                    this.runlast = n;
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[10])) {
                String string6 = attributes.getValue(daq_request_attrs[10]);
                if (string6 != null) {
                    this.data_dir = string6;
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[11])) {
                String string7 = attributes.getValue(daq_request_attrs[11]);
                if (string7 != null) {
                    this.c_dir = string7;
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[12])) {
                String[] stringArray = daq_request_attrs[12].split(":");
                String string8 = attributes.getValue(stringArray[0]);
                if (string8 != null) {
                    int n;
                    String string9 = null;
                    int n2 = 0;
                    for (n = 1; n < stringArray.length - 1; ++n) {
                        string9 = attributes.getValue(stringArray[n]);
                        if (string9 == null) continue;
                        ++n2;
                    }
                    if (n2 != 0) {
                        for (n = 1; n < stringArray.length - 1; ++n) {
                            string9 = attributes.getValue(stringArray[n]);
                            string8 = string9 != null ? string8 + "@" + string9 : string8 + "@" + "-1";
                        }
                    }
                    n = 0;
                    string9 = attributes.getValue(stringArray[stringArray.length - 1]);
                    if (string9 != null) {
                        n = Integer.parseInt(string9);
                    }
                    this.add_channel(string8, n);
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[13])) {
                String string10 = attributes.getValue(daq_request_attrs[13]);
                if (string10 != null) {
                    this.add_file(string10);
                }
            } else if (string3.equalsIgnoreCase(daq_request_tags_s[14]) && (string4 = attributes.getValue(daq_request_attrs[14])) != null) {
                this.conf = string4;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.rootf) {
            // empty if block
        }
    }

    public void characters(char[] cArray, int n, int n2) {
    }

    public int get_int(String string) {
        this.conv_error = 0;
        if (string == null) {
            this.conv_error = -1;
            return -1;
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.indexOf("\n"));
        } else if (string.startsWith("\n")) {
            string = string.substring(string.indexOf("\n"));
        }
        try {
            Integer n = new Integer(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            this.conv_error = -1;
            return -1;
        }
    }

    public float get_float(String string) {
        this.conv_error = 0;
        try {
            Float f = new Float(string);
            return f.floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            this.conv_error = -1;
            return -1.0f;
        }
    }

    public int parse_xml_request(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2 = null;
        this.error = 0;
        if (string.indexOf("<") == -1) {
            System.out.println("parse_xml_request() Reading file: " + string);
            object4 = new File(string);
            if (((File)object4).exists() && ((File)object4).canRead()) {
                object3 = null;
                try {
                    object3 = new BufferedReader(new FileReader((File)object4));
                    object2 = new StringBuffer();
                    object = new char[512];
                    try {
                        int n = 0;
                        while ((n = ((Reader)object3).read((char[])object)) > -1) {
                            ((StringBuffer)object2).append((char[])object, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        return -4;
                    }
                    string2 = new String(((StringBuffer)object2).toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return -5;
                }
                if (object3 != null) {
                    try {
                        ((BufferedReader)object3).close();
                    }
                    catch (IOException iOException) {
                        return -6;
                    }
                }
            }
        } else {
            string2 = new String(string);
        }
        try {
            object3 = SAXParserFactory.newInstance();
            object4 = ((SAXParserFactory)object3).newSAXParser();
        }
        catch (Exception exception) {
            System.err.println("error: Unable to instantiate parser ");
            this.error = -1;
            return this.error;
        }
        object3 = string2.lastIndexOf(0) != -1 ? string2.substring(0, string2.lastIndexOf(0)) : string2;
        object2 = new StringReader((String)object3);
        try {
            ((SAXParser)object4).parse(new InputSource((Reader)object2), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            this.error = -1;
        }
        catch (IOException iOException) {
            this.error = -2;
        }
        if (this.conf != null && this.conf.length() > 0) {
            this.init_in_start(false);
            object = this.conf;
            this.conf = null;
            return this.parse_xml_request((String)object);
        }
        return this.error;
    }

    public void print_xml_request() {
        int n;
        System.out.println("DAQ XML REQUEST");
        System.out.println("RedId: " + this.req_id);
        if (this.tstart > 0L) {
            System.out.println("Start: " + this.print_time_stamp(this.tstart) + " (" + this.tstart + ")");
        }
        if (this.tstop > 0L) {
            System.out.println("Stop: " + this.print_time_stamp(this.tstop) + " (" + this.tstop + ")");
        }
        if (this.runfirst > 0) {
            System.out.println("First Run: " + this.runfirst);
        }
        if (this.runlast > 0) {
            System.out.println("Last Run: " + this.runlast);
        }
        if (this.exp != null) {
            System.out.println("Experiment: " + this.exp);
        }
        if (this.data_dir != null) {
            System.out.println("Data Dir: " + this.data_dir);
        }
        if (this.c_dir != null) {
            System.out.println("Adm Dir: " + this.c_dir);
        }
        if (this.chans != null && this.chans.size() != 0) {
            System.out.println("Channels");
            for (n = 0; n < this.chans.size(); ++n) {
                if (this.chans.elementAt(n) == null) continue;
                System.out.println("[" + n + "] " + this.chans.elementAt(n));
            }
        }
        if (this.files != null && this.files.size() != 0) {
            System.out.println("Files");
            for (n = 0; n < this.files.size(); ++n) {
                if (this.files.elementAt(n) == null) continue;
                System.out.println("[" + n + "] " + this.files.elementAt(n));
            }
        }
        System.out.println("ScanMode: " + this.scan_mode);
        System.out.println("ReqType: " + this.req_type);
        System.out.println("CommMode: " + this.comm_mode);
        if (this.conf != null) {
            System.out.println("ConfFile: " + this.conf);
        }
    }

    public int same_requests(daq_xml_request daq_xml_request2) {
        int n;
        boolean bl;
        int n2;
        if (daq_xml_request2 == null) {
            return 0;
        }
        String string = "/daq/ttf2/";
        string = string + "POOL/";
        if (daq_xml_request2.req_id != this.req_id) {
            return -2;
        }
        if (this.runfirst == -1) {
            if (daq_xml_request2.tstart != this.tstart) {
                return -3;
            }
            if (daq_xml_request2.tstop != this.tstop) {
                return -4;
            }
        } else {
            if (daq_xml_request2.runfirst != this.runfirst) {
                return -16;
            }
            if (this.runlast != -1 && daq_xml_request2.runlast != this.runlast) {
                return -17;
            }
        }
        if (daq_xml_request2.exp != null && this.exp == null || daq_xml_request2.exp == null && this.exp != null || daq_xml_request2.exp != null && this.exp != null && !this.exp.equals(daq_xml_request2.exp)) {
            return -5;
        }
        if (daq_xml_request2.data_dir != null && this.data_dir == null || daq_xml_request2.data_dir == null && this.data_dir != null || daq_xml_request2.data_dir != null && this.data_dir != null && !this.data_dir.equals(daq_xml_request2.data_dir)) {
            return -6;
        }
        if (daq_xml_request2.c_dir != null && this.c_dir == null || daq_xml_request2.c_dir == null && this.c_dir != null || daq_xml_request2.c_dir != null && this.c_dir != null && !this.c_dir.equals(daq_xml_request2.c_dir)) {
            return -7;
        }
        if (daq_xml_request2.conf != null && daq_xml_request2.conf.length() != 0 && this.conf == null || daq_xml_request2.conf == null && this.conf != null && this.conf.length() != 0 || daq_xml_request2.conf != null && this.conf != null && !this.conf.equals(daq_xml_request2.conf)) {
            return -8;
        }
        if (daq_xml_request2.scan_mode != this.scan_mode) {
            return -9;
        }
        if (daq_xml_request2.comm_mode != this.comm_mode) {
            return -10;
        }
        if (daq_xml_request2.req_type != this.req_type) {
            return -11;
        }
        if (daq_xml_request2.chans != null && this.chans == null || daq_xml_request2.chans == null && this.chans != null || daq_xml_request2.chans != null && this.chans != null && daq_xml_request2.chans.size() != this.chans.size()) {
            return -12;
        }
        if (daq_xml_request2.files != null && this.files == null || daq_xml_request2.files == null && this.files != null || daq_xml_request2.files != null && this.files != null && daq_xml_request2.files.size() != this.files.size()) {
            return -14;
        }
        if (this.chans != null) {
            for (n2 = 0; n2 < daq_xml_request2.chans.size(); ++n2) {
                bl = false;
                for (n = 0; n < this.chans.size(); ++n) {
                    if (!daq_xml_request2.chans.elementAt(n2).equals(this.chans.elementAt(n))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return -13;
            }
        }
        if (this.files != null) {
            for (n2 = 0; n2 < daq_xml_request2.files.size(); ++n2) {
                bl = false;
                for (n = 0; n < this.files.size(); ++n) {
                    if (!daq_xml_request2.files.elementAt(n2).equals(this.files.elementAt(n))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return -15;
            }
        }
        return 1;
    }

    public boolean copy(daq_xml_request daq_xml_request2) {
        if (daq_xml_request2 == null) {
            return true;
        }
        this.tstart = daq_xml_request2.tstart;
        this.tstop = daq_xml_request2.tstop;
        this.runfirst = daq_xml_request2.runfirst;
        this.runlast = daq_xml_request2.runlast;
        this.exp = daq_xml_request2.exp;
        this.data_dir = daq_xml_request2.data_dir;
        this.c_dir = daq_xml_request2.c_dir;
        this.chans = daq_xml_request2.chans;
        this.files = daq_xml_request2.files;
        this.req_id = daq_xml_request2.req_id;
        this.scan_mode = daq_xml_request2.scan_mode;
        this.req_type = daq_xml_request2.req_type;
        this.comm_mode = daq_xml_request2.comm_mode;
        this.conf = daq_xml_request2.conf;
        return false;
    }
}

