/*
 * Decompiled with CFR 0.152.
 */
package daq;

import java.nio.ByteBuffer;

public class EventHeader {
    int pattern = 0;
    public int event_length = 0;
    public int event_number = 0;
    public int event_type = 0;
    public int time_up = 0;
    public int time_low = 0;
    public int tmask = 0;
    public int status = 0;
    public int num_svr_block = 0;
    int my_size = 36;
    public static final int TTF2_EVENT_PATTERN = -1114130;

    public EventHeader() {
        this.clear();
    }

    public int size() {
        return this.my_size;
    }

    public void clear() {
        this.pattern = 0;
        this.event_length = 0;
        this.event_number = 0;
        this.event_type = 0;
        this.time_up = 0;
        this.time_low = 0;
        this.tmask = 0;
        this.status = 0;
        this.num_svr_block = 0;
    }

    public void copy(EventHeader eventHeader) {
        if (eventHeader == null) {
            this.clear();
        } else {
            this.pattern = eventHeader.pattern;
            this.event_length = eventHeader.event_length;
            this.event_number = eventHeader.event_number;
            this.event_type = eventHeader.event_type;
            this.time_up = eventHeader.time_up;
            this.time_low = eventHeader.time_low;
            this.tmask = eventHeader.tmask;
            this.status = eventHeader.status;
            this.num_svr_block = eventHeader.num_svr_block;
        }
    }

    public static int BytesToInt(byte[] byArray, int n) {
        int n2 = ((byArray[n++] & 0xFF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
        return n2;
    }

    public boolean is_valid() {
        return this.pattern != 0;
    }

    public void print() {
        if (this.is_valid()) {
            System.out.println("EventHeader: type:" + this.event_type + " len: " + this.event_length + " #sb: " + this.num_svr_block + " " + this.time_up + ":" + this.time_low + "_" + this.event_number + " tmask: " + this.tmask + " status: " + this.status);
        } else {
            System.out.println("EventHeader NOT SET");
        }
    }

    public byte[] get_buffer(byte[] byArray) {
        byte[] byArray2 = null;
        byArray2 = byArray != null && byArray.length >= this.my_size ? byArray : new byte[this.my_size];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.putInt(this.pattern);
        byteBuffer.putInt(this.event_length);
        byteBuffer.putInt(this.event_number);
        byteBuffer.putInt(this.event_type);
        byteBuffer.putInt(this.time_up);
        byteBuffer.putInt(this.time_low);
        byteBuffer.putInt(this.tmask);
        byteBuffer.putInt(this.status);
        byteBuffer.putInt(this.num_svr_block);
        return byArray2;
    }

    public boolean fill(byte[] byArray) {
        if (byArray == null || byArray.length < this.my_size) {
            return true;
        }
        int n = 0;
        this.pattern = EventHeader.BytesToInt(byArray, n);
        if (this.pattern != -1114130) {
            this.pattern = 0;
            return true;
        }
        this.event_length = EventHeader.BytesToInt(byArray, n += 4);
        this.event_number = EventHeader.BytesToInt(byArray, n += 4);
        this.event_type = EventHeader.BytesToInt(byArray, n += 4);
        this.time_up = EventHeader.BytesToInt(byArray, n += 4);
        this.time_low = EventHeader.BytesToInt(byArray, n += 4);
        this.tmask = EventHeader.BytesToInt(byArray, n += 4);
        this.status = EventHeader.BytesToInt(byArray, n += 4);
        this.num_svr_block = EventHeader.BytesToInt(byArray, n += 4);
        return false;
    }
}

