/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj.impl.requests;

import com.cosylab.epics.caj.impl.Transport;
import com.cosylab.epics.caj.impl.requests.AbstractCARequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class HostNameRequest
extends AbstractCARequest {
    public HostNameRequest(Transport transport) throws UnknownHostException {
        super(transport);
        int dotPos;
        if (transport.getMinorRevision() < 1) {
            return;
        }
        InetAddress localAddress = InetAddress.getLocalHost();
        String hostName = localAddress.getHostName();
        if (System.getProperties().contains("CAJ_STRIP_HOSTNAME") && (dotPos = hostName.indexOf(46)) > 0) {
            hostName = hostName.substring(0, dotPos);
        }
        int alignedMessageSize = HostNameRequest.calculateAlignedSize(8, 16 + hostName.length() + 1);
        this.requestMessage = ByteBuffer.allocate(alignedMessageSize);
        this.requestMessage = HostNameRequest.insertCAHeader(transport, this.requestMessage, (short)21, (short)(alignedMessageSize - 16), (short)0, 0, 0, 0);
        this.requestMessage.put(hostName.getBytes());
        this.requestMessage.put((byte)0);
        this.requestMessage = HostNameRequest.alignBuffer(8, this.requestMessage);
    }

    public byte getPriority() {
        return 100;
    }
}

