/*
 * Decompiled with CFR 0.152.
 */
package org.tango.logconsumer;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.logviewer.EventDetails;
import fr.esrf.logviewer.MyTableModel;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.logconsumer.SourceSet;
import org.tango.server.InvocationContext;
import org.tango.server.ServerManager;
import org.tango.server.annotation.AroundInvoke;
import org.tango.server.annotation.Command;
import org.tango.server.annotation.Delete;
import org.tango.server.annotation.Device;
import org.tango.server.annotation.DeviceManagement;
import org.tango.server.annotation.DynamicManagement;
import org.tango.server.annotation.Init;
import org.tango.server.annotation.State;
import org.tango.server.annotation.Status;
import org.tango.server.device.DeviceManager;
import org.tango.server.dynamic.DynamicManager;

@Device
public class LogConsumer {
    protected static final Logger logger = LoggerFactory.getLogger(LogConsumer.class);
    protected static final XLogger xlogger = XLoggerFactory.getXLogger(LogConsumer.class);
    private static HashMap<String, LogConsumer> deviceInstances = new HashMap();
    private MyTableModel myTableModel;
    @DynamicManagement
    protected DynamicManager dynamicManager;
    @DeviceManagement
    DeviceManager deviceManager;
    @State
    private DevState state = DevState.UNKNOWN;
    @Status
    private String status = "Server is starting. The device state is unknown";

    @Init(lazyLoading=false)
    public void initDevice() throws DevFailed {
        xlogger.entry(new Object[0]);
        logger.debug("init device " + this.deviceManager.getName());
        deviceInstances.put(this.deviceManager.getName(), this);
        xlogger.exit();
    }

    @Delete
    public void deleteDevice() throws DevFailed {
        xlogger.entry(new Object[0]);
        xlogger.exit();
    }

    @AroundInvoke
    public void aroundInvoke(InvocationContext ctx) throws DevFailed {
        xlogger.entry(new Object[0]);
        xlogger.exit();
    }

    public void setDynamicManager(DynamicManager dynamicManager) throws DevFailed {
        this.dynamicManager = dynamicManager;
    }

    public void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }

    public final DevState getState() throws DevFailed {
        return this.state;
    }

    public void setState(DevState state) {
        this.state = state;
    }

    public final String getStatus() throws DevFailed {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Command(name="Log", inTypeDesc="The log", outTypeDesc="")
    public void Log(String[] logIn) throws DevFailed {
        xlogger.entry(new Object[0]);
        int num_logs = logIn.length / 6;
        if (num_logs != 0) {
            try {
                int idx = 0;
                String[] loc = new String[]{""};
                for (int i = 0; i < num_logs; ++i) {
                    this.myTableModel.addEvent(new EventDetails(Long.parseLong(logIn[idx]), Level.toLevel((String)logIn[idx + 1]), logIn[idx + 2], logIn[idx + 4], logIn[idx + 5], logIn[idx + 3], loc, ""));
                    idx += 6;
                }
            }
            catch (OutOfMemoryError e) {
                xlogger.entry(new Object[]{"myTableModel.addEvent failed: OutOfMemoryError caught"});
            }
            catch (Throwable e) {
                xlogger.entry(new Object[]{"myTableModel.addEvent failed: unknown exception caught"});
                xlogger.entry(new Object[]{e});
            }
        }
        xlogger.exit();
    }

    @Command(name="LogXml", inTypeDesc="The log", outTypeDesc="")
    public void LogXml(String logXmlIn) throws DevFailed {
        xlogger.entry(new Object[0]);
        xlogger.exit();
    }

    @Command(name="Register", inTypeDesc="The name of logging source to register", outTypeDesc="")
    public void Register(String registerIn) throws DevFailed {
        xlogger.entry(new Object[0]);
        this.myTableModel.addEvent(new EventDetails(System.currentTimeMillis(), Level.toLevel((String)"INFO"), "LogViewer", "", "Local Thread", "Registering logging source: " + registerIn, new String[]{""}, ""));
        SourceSet.instance().add(registerIn);
        xlogger.exit();
    }

    @Command(name="UnRegister", inTypeDesc="The name of logging source to unregister", outTypeDesc="")
    public void UnRegister(String unRegisterIn) throws DevFailed {
        xlogger.entry(new Object[0]);
        String[] loc = new String[]{""};
        this.myTableModel.addEvent(new EventDetails(System.currentTimeMillis(), Level.toLevel((String)"INFO"), "LogViewer", "", "Local Thread", "Unregistering logging source: " + unRegisterIn, loc, ""));
        SourceSet.instance().remove(unRegisterIn);
        xlogger.exit();
    }

    public void setModel(MyTableModel aModel) {
        this.myTableModel = aModel;
    }

    public static LogConsumer getDeviceInstance(String deviceName) {
        return deviceInstances.get(deviceName);
    }

    public static void main(String[] args) {
        ServerManager.getInstance().start(args, LogConsumer.class);
        System.out.println("------- Started -------------");
    }
}

