/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.logviewer.HistoryArea;
import fr.esrf.logviewer.MyTableModel;
import fr.esrf.tangoatk.core.ATKException;
import java.net.InetAddress;
import java.util.List;
import java.util.Random;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.tango.logconsumer.LogConsumer;
import org.tango.logconsumer.SourceSet;
import org.tango.server.ServerManager;

class TangoLoggingReceiver
extends Thread {
    private static final Logger LOG = Logger.getLogger(TangoLoggingReceiver.class);
    private static final String DYN_DEV_NAME_PREFIX = "tmp/log/";
    private String deviceName;
    private static final SourceSet mSet = SourceSet.instance();
    private boolean mRunningInStaticMode = false;
    private static final String LOG_SRC_PROPERTY = "logging_source";
    private HistoryArea mHistoryArea;
    private String instanceName;
    private static final String className = "LogConsumer";

    TangoLoggingReceiver(String[] aArgs, MyTableModel aModel, HistoryArea aHistoryArea) throws Exception {
        this.setDaemon(true);
        this.mHistoryArea = aHistoryArea;
        try {
            boolean instanceNameProvided = true;
            Random rand = new Random(System.currentTimeMillis());
            String dev_name_suffix = "@" + rand.nextInt(128);
            if (aArgs.length == 0 || !aArgs[0].contains("/")) {
                LOG.debug((Object)"No instance name provided.");
                instanceNameProvided = false;
                String hostname = InetAddress.getLocalHost().getHostName();
                String[] tokens = hostname.split(".");
                if (tokens.length != 0) {
                    hostname = tokens[0];
                }
                this.instanceName = hostname + dev_name_suffix;
                this.deviceName = DYN_DEV_NAME_PREFIX + this.instanceName;
            } else {
                LOG.debug((Object)("Provided device name: " + aArgs[0]));
                this.deviceName = aArgs[0];
                int pos = this.deviceName.lastIndexOf(47);
                if (pos == -1) {
                    LOG.fatal((Object)"Invalid device name specified. Quiting");
                    JOptionPane.showMessageDialog(null, "Invalid device name specified. Quiting", "Tango Log Viewer", 0);
                    System.exit(1);
                }
                this.instanceName = this.deviceName.substring(pos + 1);
                this.mRunningInStaticMode = true;
            }
            String serverName = "LogConsumer/" + this.instanceName;
            LOG.debug((Object)("Device name is " + this.deviceName));
            LOG.debug((Object)"Registering the LogConsumer into the database");
            DbDevInfo dinfo = new DbDevInfo(this.deviceName, className, serverName);
            ApiUtil.get_db_obj().add_device(dinfo);
            String[] args = instanceNameProvided ? new String[aArgs.length] : new String[aArgs.length + 1];
            args[0] = this.instanceName;
            int i = instanceNameProvided ? 1 : 0;
            int j = 1;
            while (i < aArgs.length) {
                args[j] = aArgs[i];
                ++i;
                ++j;
            }
            LOG.debug((Object)"Initializing the util singleton");
            LOG.debug((Object)"Passing following args to Util.init:");
            for (i = 0; i < args.length; ++i) {
                LOG.debug((Object)("\targs[" + String.valueOf(i) + "]: " + args[i]));
            }
            LOG.debug((Object)("Starting " + serverName));
            ServerManager.getInstance().start(args, LogConsumer.class);
            LogConsumer consumer = LogConsumer.getDeviceInstance(this.deviceName);
            consumer.setModel(aModel);
            if (this.mRunningInStaticMode) {
                this.getLoggingSourceProperty();
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }

    public void setTableModel(MyTableModel aModel) {
        LogConsumer.getDeviceInstance(this.deviceName).setModel(aModel);
    }

    public void setHistoryArea(HistoryArea aHistoryArea) {
        this.mHistoryArea = aHistoryArea;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public boolean isRunningInStaticMode() {
        return this.mRunningInStaticMode;
    }

    @Override
    public void run() {
        LOG.debug((Object)"Device server started");
    }

    private String[] getDeviceList(String pattern) {
        String[] dev_list = new String[]{};
        try {
            DeviceData argin = new DeviceData();
            argin.insert(pattern);
            DeviceData argout = ApiUtil.get_db_obj().command_inout("DbGetDeviceExportedList", argin);
            dev_list = argout.extractStringArray();
        }
        catch (Exception e) {
            this.displayException(e);
        }
        return dev_list;
    }

    public int addLoggingSources(String pattern) {
        String[] deviceList;
        int result = 0;
        for (String device : deviceList = this.getDeviceList(pattern)) {
            if (this.addLoggingSource(device) != -1) continue;
            result = -1;
        }
        return result;
    }

    public int addCoLocatedSources(String dev_name) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(dev_name);
            DeviceProxy adminProxy = new DeviceProxy(deviceProxy.adm_name());
            String[] argIn = new String[]{"*", "device::" + this.deviceName};
            DeviceData deviceData = new DeviceData();
            deviceData.insert(argIn);
            adminProxy.command_inout("AddLoggingTarget", deviceData);
            String server_name = deviceProxy.adm_name().substring(deviceProxy.adm_name().indexOf(47) + 1);
            LOG.debug((Object)("TangoLoggingReceiver::addCoLocatedSources::server_name is " + server_name));
            String[] dev_list = ApiUtil.get_db_obj().get_device_class_list(server_name);
            for (int i = 0; i < dev_list.length; i += 2) {
                LOG.debug((Object)("TangoLoggingReceiver::addCoLocatedSources::mSet adding " + dev_list[i]));
                mSet.add(dev_list[i]);
            }
            LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int addLoggingSource(String dev_name) {
        try {
            LOG.debug((Object)("Adding " + dev_name + " to logging sources list"));
            DeviceProxy deviceProxy = new DeviceProxy(dev_name);
            DeviceProxy adminProxy = new DeviceProxy(deviceProxy.adm_name());
            String[] argin = new String[]{dev_name, "device::" + this.deviceName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            adminProxy.command_inout("AddLoggingTarget", dd);
            mSet.add(dev_name);
            LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int addTangoCoreLogger(String dev_name) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(dev_name);
            DeviceProxy adminProxy = new DeviceProxy(deviceProxy.adm_name());
            LOG.debug((Object)("Adding " + adminProxy.get_name() + " to logging sources list"));
            String[] argin = new String[]{adminProxy.get_name(), "device::" + this.deviceName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            adminProxy.command_inout("AddLoggingTarget", dd);
            mSet.add(dev_name);
            LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int removeLoggingSources(String pattern) {
        String[] deviceList;
        int result = 0;
        for (String device : deviceList = this.getDeviceList(pattern)) {
            if (this.removeLoggingSource(device) != -1) continue;
            result = -1;
        }
        return result;
    }

    public int removeLoggingSource(String devName) {
        return this.removeLoggingSource(devName, true);
    }

    private int removeLoggingSource(String dev_name, boolean removeFromSet) {
        try {
            LOG.debug((Object)("Removing " + dev_name + " from logging sources list"));
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            String[] argin = new String[]{dev_name, "device::" + this.deviceName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            dsp.command_inout("RemoveLoggingTarget", dd);
            if (removeFromSet) {
                mSet.remove(dev_name);
                LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
            }
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int removeTangoCoreLogger(String dev_name) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            LOG.debug((Object)("Removing " + dsp.get_name() + " from logging sources list"));
            String[] argin = new String[]{dsp.get_name(), "device::" + this.deviceName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            dsp.command_inout("RemoveLoggingTarget", dd);
            mSet.remove(dsp.get_name());
            LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int removeCoLocatedSources(String dev_name) {
        return this.removeCoLocatedSources(dev_name, true);
    }

    public int removeCoLocatedSources(String dev_name, boolean removeFromSet) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            String[] argin = new String[]{"*", "device::" + this.deviceName};
            DeviceData dd = new DeviceData();
            dd.insert(argin);
            dsp.command_inout("RemoveLoggingTarget", dd);
            if (removeFromSet) {
                String server_name = dp.adm_name().substring(dp.adm_name().indexOf(47) + 1);
                LOG.debug((Object)("TangoLoggingReceiver::removeCoLocatedSources::server_name is " + server_name));
                String[] dev_list = ApiUtil.get_db_obj().get_device_class_list(server_name);
                for (int i = 0; i < dev_list.length; i += 2) {
                    LOG.debug((Object)("TangoLoggingReceiver::removeCoLocatedSources::mSet removing " + dev_list[i]));
                    mSet.remove(dev_list[i]);
                }
                LOG.debug((Object)("Logging sources set contains " + mSet.size() + " entries"));
            }
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public boolean removeAllSources() {
        LOG.debug((Object)"Removing all logging sources");
        List<String> contentList = mSet.content();
        boolean failed = false;
        for (String content : contentList) {
            if (this.removeCoLocatedSources(content, false) != -1) continue;
            failed = true;
        }
        mSet.clear();
        return !failed;
    }

    public int getDeviceLoggingLevel(String dev_name) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            String[] dvsa = new String[]{dev_name};
            DeviceData ddin = new DeviceData();
            ddin.insert(dvsa);
            DeviceData ddout = dsp.command_inout("GetLoggingLevel", ddin);
            DevVarLongStringArray dvlsa = ddout.extractLongStringArray();
            if (dvlsa.lvalue.length > 0) {
                return dvlsa.lvalue[0];
            }
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int setDevicesLoggingLevel(String pattern, int level) {
        String[] deviceList;
        int result = 0;
        for (String device : deviceList = this.getDeviceList(pattern)) {
            if (this.setDeviceLoggingLevel(device, level, false) != -1) continue;
            result = -1;
        }
        return result;
    }

    public int setDeviceLoggingLevel(String devName, int level, boolean add_before) {
        try {
            DeviceProxy deviceProxy = new DeviceProxy(devName);
            DeviceProxy adminProxy = new DeviceProxy(deviceProxy.adm_name());
            if (add_before) {
                String[] argIn = new String[]{devName, "device::" + this.deviceName};
                DeviceData deviceData = new DeviceData();
                deviceData.insert(argIn);
                adminProxy.command_inout("AddLoggingTarget", deviceData);
            }
            DevVarLongStringArray longStringArray = new DevVarLongStringArray();
            longStringArray.lvalue = new int[1];
            longStringArray.lvalue[0] = level;
            longStringArray.svalue = new String[1];
            longStringArray.svalue[0] = devName;
            DeviceData argIn = new DeviceData();
            argIn.insert(longStringArray);
            adminProxy.command_inout("SetLoggingLevel", argIn);
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int setCoLocatedDevicesLoggingLevel(String dev_name, int level) {
        try {
            DeviceProxy dp = new DeviceProxy(dev_name);
            DeviceProxy dsp = new DeviceProxy(dp.adm_name());
            DevVarLongStringArray dvlsa = new DevVarLongStringArray();
            dvlsa.lvalue = new int[1];
            dvlsa.lvalue[0] = level;
            dvlsa.svalue = new String[1];
            dvlsa.svalue[0] = "*";
            DeviceData argin = new DeviceData();
            argin.insert(dvlsa);
            dsp.command_inout("SetLoggingLevel", argin);
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public List<String> getLoggingSources() {
        return mSet.content();
    }

    protected void displayException(Exception e) {
        LOG.error((Object)e);
        Exception exception = e instanceof DevFailed ? new ATKException((DevFailed)((Object)e)) : e;
        this.mHistoryArea.write(exception);
    }

    public int setLoggingSourceProperty() {
        LOG.debug((Object)"Saving current logging source list into the TANGO database");
        List<String> content = mSet.content();
        String[] list = new String[content.size()];
        for (int i = 0; i < content.size(); ++i) {
            list[i] = content.get(i);
        }
        DbDatum[] dbd = new DbDatum[]{new DbDatum(LOG_SRC_PROPERTY, list)};
        try {
            ApiUtil.get_db_obj().put_device_property(this.deviceName, dbd);
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int deleteLoggingSourceProperty() {
        try {
            ApiUtil.get_db_obj().delete_device_property(this.deviceName, LOG_SRC_PROPERTY);
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public int getLoggingSourceProperty() {
        try {
            DbDatum datum = ApiUtil.get_db_obj().get_device_property(this.deviceName, LOG_SRC_PROPERTY);
            if (datum.is_empty()) {
                LOG.debug((Object)"Restore sources::nothing to restore");
                return 0;
            }
            String[] sources = datum.extractStringArray();
            LOG.debug((Object)("Restore sources::#source to add " + sources.length));
            for (String source : sources) {
                LOG.debug((Object)("Restore sources::adding " + source));
                this.addLoggingSource(source);
            }
        }
        catch (Exception e) {
            this.displayException(e);
            return -1;
        }
        return 0;
    }

    public void cleanup() {
        int user_answer;
        if (this.mRunningInStaticMode && mSet.size() != 0 && (user_answer = JOptionPane.showConfirmDialog(null, "Save current source list before quitting?", "Tango LogViewer", 0)) == 0) {
            this.setLoggingSourceProperty();
        }
        this.removeAllSources();
        try {
            if (!this.mRunningInStaticMode) {
                String serverName = "LogConsumer/" + this.instanceName;
                LOG.debug((Object)("Deleting" + serverName + " server from the TANGO database"));
                ApiUtil.get_db_obj().delete_server(serverName);
            }
        }
        catch (Exception e) {
            this.displayException(e);
        }
    }
}

