/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import java.util.GregorianCalendar;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class EventDetails {
    private final long mTimeStamp;
    private final String mTimeStampStr;
    private final Level mLevel;
    private final String mCategoryName;
    private final String mNDC;
    private final String mThreadName;
    private final String mMessage;
    private final String[] mThrowableStrRep;
    private final String mLocationDetails;

    public static String formatDate(long ms) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(ms);
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1) - 2000;
        int hour = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        int millis = calendar.get(14);
        return String.format("%02d/%02d/%02d  %02d:%02d:%02d.%03d", day, month, year, hour, minutes, seconds, millis);
    }

    public EventDetails(long aTimeStamp, Level aLevel, String aCategoryName, String aNDC, String aThreadName, String aMessage, String[] aThrowableStrRep, String aLocationDetails) {
        this.mTimeStamp = aTimeStamp;
        this.mTimeStampStr = EventDetails.formatDate(aTimeStamp);
        this.mLevel = aLevel;
        this.mCategoryName = aCategoryName;
        this.mNDC = aNDC;
        this.mThreadName = aThreadName;
        this.mMessage = aMessage;
        this.mThrowableStrRep = aThrowableStrRep;
        this.mLocationDetails = aLocationDetails;
    }

    EventDetails(LoggingEvent anEvent) {
        this(anEvent.timeStamp, anEvent.getLevel(), anEvent.getLoggerName(), anEvent.getNDC(), anEvent.getThreadName(), anEvent.getRenderedMessage(), anEvent.getThrowableStrRep(), anEvent.getLocationInformation() == null ? null : anEvent.getLocationInformation().fullInfo);
    }

    long getTimeStamp() {
        return this.mTimeStamp;
    }

    String getRenderedTimeStamp() {
        return this.mTimeStampStr;
    }

    Level getLevel() {
        return this.mLevel;
    }

    String getCategoryName() {
        return this.mCategoryName;
    }

    String getNDC() {
        return this.mNDC;
    }

    String getThreadName() {
        return this.mThreadName;
    }

    String getMessage() {
        return this.mMessage;
    }

    String getLocationDetails() {
        return this.mLocationDetails;
    }

    String[] getThrowableStrRep() {
        return this.mThrowableStrRep;
    }
}

