/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import java.awt.BorderLayout;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import jive.JiveUtils;
import jive3.Action;
import jive3.AttributeNode;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskAttributeNode;
import jive3.TaskDevicePropertyNode;
import jive3.TaskEventNode;
import jive3.TaskLoggingNode;
import jive3.TaskPipeNode;
import jive3.TaskPollingNode;
import jive3.TreePanel;

public class TreePanelAlias
extends TreePanel {
    String aliasFilterString = "*";
    Pattern aliasPattern = null;

    public TreePanelAlias() {
        this.self = this;
        this.setLayout(new BorderLayout());
    }

    @Override
    public TangoNode createRoot() {
        return new RootNode();
    }

    public void applyFilter(String filter) {
        this.aliasFilterString = filter;
        if (filter.equals("*")) {
            this.aliasPattern = null;
        } else if (filter.length() == 0) {
            this.aliasPattern = null;
        } else {
            try {
                String f = this.filterToRegExp(this.aliasFilterString);
                this.aliasPattern = Pattern.compile(f);
            }
            catch (PatternSyntaxException e) {
                JOptionPane.showMessageDialog(invoker, e.getMessage());
            }
        }
    }

    public String getFilter() {
        return this.aliasFilterString;
    }

    class AliasNode
    extends TangoNode {
        private String aliasName = null;
        private String devName = null;

        AliasNode(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        void populateNode() throws DevFailed {
            this.devName = TreePanelAlias.this.db.get_device_from_alias(this.aliasName);
            this.add(new TaskDevicePropertyNode(TreePanelAlias.this.self, TreePanelAlias.this.db, this.devName));
            this.add(new TaskPollingNode(TreePanelAlias.this.db, this.devName));
            this.add(new TaskEventNode(TreePanelAlias.this.db, this.devName));
            this.add(new TaskAttributeNode(TreePanelAlias.this.db, this.devName));
            this.add(new TaskPipeNode(TreePanelAlias.this.db, this.devName));
            this.add(new AttributeNode(TreePanelAlias.this.self, this.devName, TreePanelAlias.this.db));
            this.add(new TaskLoggingNode(TreePanelAlias.this.db, this.devName));
        }

        @Override
        public String toString() {
            return this.aliasName;
        }

        @Override
        public ImageIcon getIcon() {
            return TangoNodeRenderer.devicon;
        }

        @Override
        public Action[] getAction() {
            if (JiveUtils.readOnly) {
                return new Action[]{TreePanel.getAction(11), TreePanel.getAction(13)};
            }
            return new Action[]{TreePanel.getAction(11), TreePanel.getAction(13), TreePanel.getAction(3)};
        }

        public void goToDeviceNode() {
            try {
                if (this.devName == null) {
                    this.devName = TreePanelAlias.this.db.get_device_from_alias(this.aliasName);
                }
                TreePanel.invoker.goToDeviceNode(this.devName);
            }
            catch (DevFailed e) {
                JiveUtils.showTangoError(e);
            }
        }

        @Override
        public void execAction(int actionNumber, boolean multipleCall) throws IOException {
            switch (actionNumber) {
                case 3: {
                    if (multipleCall) {
                        try {
                            TreePanelAlias.this.db.delete_device_alias(this.aliasName);
                            break;
                        }
                        catch (DevFailed e) {
                            throw new IOException(this.aliasName + ":" + e.errors[0].desc);
                        }
                    }
                    int ok = JOptionPane.showConfirmDialog(TreePanel.invoker, "Delete alias " + this.aliasName + " ?", "Confirm delete", 0);
                    if (ok != 0) break;
                    try {
                        TreePanelAlias.this.db.delete_device_alias(this.aliasName);
                    }
                    catch (DevFailed e) {
                        JiveUtils.showTangoError(e);
                    }
                    TreePanelAlias.this.refresh();
                    break;
                }
                case 11: {
                    TreePanelAlias.this.testDevice(this.aliasName);
                    break;
                }
                case 13: {
                    this.goToDeviceNode();
                }
            }
        }

        @Override
        String getValue() {
            if (this.devName == null) {
                try {
                    this.devName = TreePanelAlias.this.db.get_device_from_alias(this.aliasName);
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                }
            }
            return TreePanelAlias.this.getDeviceInfo(this.devName);
        }

        @Override
        String getTitle() {
            return "Device Info";
        }
    }

    class RootNode
    extends TangoNode {
        RootNode() {
        }

        @Override
        void populateNode() throws DevFailed {
            String[] list = TreePanelAlias.this.db.get_device_alias_list("*");
            for (int i = 0; i < list.length; ++i) {
                if (TreePanelAlias.this.aliasPattern != null) {
                    Matcher matcher = TreePanelAlias.this.aliasPattern.matcher(list[i].toLowerCase());
                    if (!matcher.find() || matcher.start() != 0 || matcher.end() != list[i].length()) continue;
                    this.add(new AliasNode(list[i]));
                    continue;
                }
                this.add(new AliasNode(list[i]));
            }
        }

        @Override
        public String toString() {
            return "Alias:";
        }

        @Override
        void execAction(int number, boolean multipleCall) {
        }
    }
}

