/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

public class TaskSingleAttributeNode
extends TangoNode {
    private Database db;
    private String devName;
    private String attributeName;
    private String shortAttName;
    private int idl;
    private String pollingPeriod = "";
    private boolean isPolled = false;
    private String min_alarm = "None";
    private String max_alarm = "None";
    private String min_warning = "None";
    private String max_warning = "None";
    private String delta_t = "None";
    private String delta_val = "None";
    private String unit = "None";
    private String display_unit = "None";
    private String standard_unit = "None";
    private String min = "None";
    private String max = "None";
    private String format = "None";
    private String label = "None";
    private String descr = "None";
    private String abs_change = "None";
    private String rel_change = "None";
    private String periodic = "None";
    private String archive_abs_change = "None";
    private String archive_rel_change = "None";
    private String archive_period = "None";

    TaskSingleAttributeNode(TreePanel parent, Database db, String devName, String attributeName, int idl) {
        this.db = db;
        this.devName = devName;
        this.attributeName = attributeName;
        this.parentPanel = parent;
        this.idl = idl;
        this.shortAttName = attributeName.substring(attributeName.lastIndexOf(47) + 1);
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.atticon;
    }

    @Override
    public String toString() {
        return "Config";
    }

    @Override
    String getTitle() {
        return this.attributeName;
    }

    String getShortAttName() {
        return this.shortAttName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    void execAction(int number, boolean multipleCall) {
    }

    public boolean isPolled() {
        return this.isPolled;
    }

    public String getPollingPeriod() {
        return this.pollingPeriod;
    }

    public String getRelativeChange() {
        return this.rel_change;
    }

    public String getAbsoluteChange() {
        return this.abs_change;
    }

    public String getArchRelativeChange() {
        return this.archive_rel_change;
    }

    public String getArchAbsoluteChange() {
        return this.archive_rel_change;
    }

    public String getArchPeriod() {
        return this.archive_period;
    }

    public String getPeriodic() {
        return this.periodic;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFormat() {
        return this.format;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getDisplayUnit() {
        return this.display_unit;
    }

    public String getStandardUnit() {
        return this.standard_unit;
    }

    public String getMin() {
        return this.min;
    }

    public String getMax() {
        return this.max;
    }

    public String getMinAlarm() {
        return this.min_alarm;
    }

    public String getMaxAlarm() {
        return this.max_alarm;
    }

    public String getMinWarning() {
        return this.min_warning;
    }

    public String getMaxWarning() {
        return this.max_warning;
    }

    public String getDeltaT() {
        return this.delta_t;
    }

    public String getDeltaVal() {
        return this.delta_val;
    }

    public String getDescr() {
        return this.descr;
    }

    void setAttributePolling(boolean isPolled, String period) {
        int polling_period = 3000;
        if (isPolled) {
            if (period != "") {
                try {
                    polling_period = Integer.parseInt(period);
                }
                catch (NumberFormatException e) {
                    JiveUtils.showJiveError("Invalid period value for attribute " + this.shortAttName + "\n" + e.getMessage());
                }
            }
            try {
                DeviceProxy ds = new DeviceProxy(this.devName);
                ds.poll_attribute(this.shortAttName, polling_period);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        } else {
            try {
                DeviceProxy ds = new DeviceProxy(this.devName);
                ds.stop_poll_attribute(this.shortAttName);
            }
            catch (DevFailed ex) {
                JiveUtils.showTangoError(ex);
            }
        }
    }

    void setAbsoluteChange(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
                ai.events.ch_event.abs_change = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setRelativeChange(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
                ai.events.ch_event.rel_change = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setArchAbsoluteChange(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
                ai.events.arch_event.abs_change = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setArchRelativeChange(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
                ai.events.arch_event.rel_change = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setArchPeriod(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
                ai.events.arch_event.period = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setPeriod(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            if (ds.get_idl_version() >= 3) {
                AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
                ai.events.per_event.period = value;
                ds.set_attribute_info(new AttributeInfoEx[]{ai});
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setLabel(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            ai.label = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setFormat(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            ai.format = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setUnit(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            ai.unit = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setDisplayUnit(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            ai.display_unit = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setStandardUnit(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            ai.standard_unit = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMin(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            ai.min_value = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMax(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            ai.max_value = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMinAlarm(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            if (ai.alarms != null) {
                ai.alarms.min_alarm = value;
            } else {
                ai.min_alarm = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMaxAlarm(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            if (ai.alarms != null) {
                ai.alarms.max_alarm = value;
            } else {
                ai.max_alarm = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMinWarning(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            if (ai.alarms != null) {
                ai.alarms.min_warning = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setMaxWarning(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            if (ai.alarms != null) {
                ai.alarms.max_warning = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setDeltaT(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            if (ai.alarms != null) {
                ai.alarms.delta_t = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setDeltaVal(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            if (ai.alarms != null) {
                ai.alarms.delta_val = value;
            }
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    void setDescr(String value) {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            ai.description = value;
            ds.set_attribute_info(new AttributeInfoEx[]{ai});
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    public void updatePollingInfo() {
        String[] ps = null;
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            ps = ds.polling_status();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        String[] pinfo = null;
        boolean found = false;
        int i = 0;
        while (i < ps.length && !found) {
            pinfo = JiveUtils.extractPollingInfo(ps[i]);
            found = pinfo[0].equalsIgnoreCase("attribute") && pinfo[1].equalsIgnoreCase(this.shortAttName);
            if (found) continue;
            ++i;
        }
        if (found) {
            this.pollingPeriod = pinfo[2];
            this.isPolled = true;
        } else {
            this.pollingPeriod = "";
            this.isPolled = false;
        }
    }

    private String reformat(String s) {
        if (s.equalsIgnoreCase("Not specified") || s.equalsIgnoreCase("No standard unit") || s.equalsIgnoreCase("No unit") || s.equalsIgnoreCase("No description") || s.equalsIgnoreCase("No display unit")) {
            return "None";
        }
        return s;
    }

    void browseAttributeInfo() {
        try {
            DeviceProxy ds = new DeviceProxy(this.devName);
            AttributeInfoEx ai = ds.get_attribute_info_ex(this.shortAttName);
            if (ai != null) {
                if (ai.alarms != null) {
                    this.min_alarm = this.reformat(ai.alarms.min_alarm);
                    this.max_alarm = this.reformat(ai.alarms.max_alarm);
                    this.min_warning = this.reformat(ai.alarms.min_warning);
                    this.max_warning = this.reformat(ai.alarms.max_warning);
                    this.delta_t = this.reformat(ai.alarms.delta_t);
                    this.delta_val = this.reformat(ai.alarms.delta_val);
                } else {
                    this.min_alarm = this.reformat(ai.min_alarm);
                    this.max_alarm = this.reformat(ai.max_alarm);
                    this.min_warning = "None";
                    this.max_warning = "None";
                    this.delta_t = "None";
                    this.delta_val = "None";
                }
                this.unit = this.reformat(ai.unit);
                this.display_unit = this.reformat(ai.display_unit);
                this.standard_unit = this.reformat(ai.standard_unit);
                this.min = this.reformat(ai.min_value);
                this.max = this.reformat(ai.max_value);
                this.format = this.reformat(ai.format);
                this.label = this.reformat(ai.label);
                this.descr = this.reformat(ai.description);
                if (ai.events != null) {
                    this.rel_change = ai.events.ch_event.rel_change;
                    this.abs_change = ai.events.ch_event.abs_change;
                    this.archive_rel_change = ai.events.arch_event.rel_change;
                    this.archive_abs_change = ai.events.arch_event.abs_change;
                    this.archive_period = ai.events.arch_event.period;
                    this.periodic = ai.events.per_event.period;
                }
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }
}

