/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.DbFileWriter;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

class TaskDeviceAttributePropertyNode
extends PropertyNode {
    private Database db;
    private String devName;
    private String attributeName;
    private int idl;
    private boolean dbAttribute;

    TaskDeviceAttributePropertyNode(TreePanel parent, Database db, String devName, String attributeName, int idl, boolean isDB) {
        this.db = db;
        this.devName = devName;
        this.attributeName = attributeName;
        this.parentPanel = parent;
        this.idl = idl;
        this.dbAttribute = isDB;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        if (this.dbAttribute) {
            return TangoNodeRenderer.uleaficon;
        }
        return TangoNodeRenderer.leaficon;
    }

    @Override
    public String toString() {
        return this.attributeName;
    }

    @Override
    String getTitle() {
        return "Device attribute properties";
    }

    String getDevName() {
        return this.devName;
    }

    @Override
    String getName() {
        return this.devName + "/" + this.attributeName;
    }

    String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void viewHistory() {
        TreePanel.invoker.historyDlg.viewDeviceAttPropertyHistory(this.devName, this.attributeName, "*");
        TreePanel.invoker.showHistory();
    }

    @Override
    void saveProperties() {
        try {
            DbFileWriter.SaveDeviceAttributeProperties(this.devName, this.attributeName);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        catch (IOException e2) {
            JiveUtils.showJiveError(e2.getMessage());
        }
    }

    @Override
    String[][] getProperties() {
        String[][] ret = new String[0][0];
        try {
            int i;
            DbAttribute lst = this.db.get_device_attribute_property(this.devName, this.attributeName);
            String[] plist = lst.get_property_list();
            Vector<String> pvec = new Vector<String>();
            for (i = 0; i < plist.length; ++i) {
                if (JiveUtils.IsAttCfgItem(plist[i], this.idl) >= 0) continue;
                pvec.add(plist[i]);
            }
            ret = new String[pvec.size()][2];
            for (i = 0; i < pvec.size(); ++i) {
                ret[i][0] = (String)pvec.get(i);
                ret[i][1] = lst.get_string_value((String)pvec.get(i));
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        return ret;
    }

    @Override
    void setProperty(String propName, String value) {
        try {
            DbAttribute att = new DbAttribute(this.attributeName);
            att.add(propName, JiveUtils.makeStringArray(value));
            this.db.put_device_attribute_property(this.devName, att);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    @Override
    void deleteProperty(String propName) {
        try {
            this.db.delete_device_attribute_property(this.devName, this.attributeName, propName);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    @Override
    public void execAction(int number, boolean multipleCall) {
        switch (number) {
            case 0: {
                JiveUtils.the_clipboard.clear();
                String[][] props = this.getProperties();
                for (int i = 0; i < props.length; ++i) {
                    JiveUtils.the_clipboard.add(props[i][0], this.attributeName, props[i][1]);
                }
                break;
            }
            case 1: {
                int i;
                JiveUtils.the_clipboard.parse();
                for (i = 0; i < JiveUtils.the_clipboard.getAttPropertyLength(); ++i) {
                    this.setProperty(JiveUtils.the_clipboard.getAttPropertyName(i), JiveUtils.the_clipboard.getAttPropertyValue(i));
                }
                for (i = 0; i < JiveUtils.the_clipboard.getObjectPropertyLength(); ++i) {
                    this.setProperty(JiveUtils.the_clipboard.getObjectPropertyName(i), JiveUtils.the_clipboard.getObjectPropertyValue(i));
                }
                this.parentPanel.refreshValues();
                break;
            }
            case 28: {
                this.viewHistory();
                break;
            }
            case 44: {
                this.saveProperties();
            }
        }
    }
}

