/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import java.io.IOException;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.DbFileWriter;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

class TaskClassPropertyNode
extends PropertyNode {
    private Database db;
    private String className;

    TaskClassPropertyNode(TreePanel parent, Database db, String className) {
        this.db = db;
        this.className = className;
        this.parentPanel = parent;
    }

    @Override
    void populateNode() throws DevFailed {
    }

    @Override
    ImageIcon getIcon() {
        return TangoNodeRenderer.leaficon;
    }

    @Override
    public String toString() {
        return "Properties";
    }

    @Override
    void execAction(int number, boolean multipleCall) {
        this.defaultPropertyAction(number);
    }

    @Override
    String getTitle() {
        return "Class properties";
    }

    @Override
    String getName() {
        return this.className;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void viewHistory() {
        TreePanel.invoker.historyDlg.viewClassPropertyHistory(this.className, "*");
        TreePanel.invoker.showHistory();
    }

    @Override
    void saveProperties() {
        try {
            DbFileWriter.SaveClassProperties(this.className);
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        catch (IOException e2) {
            JiveUtils.showJiveError(e2.getMessage());
        }
    }

    @Override
    String[][] getProperties() {
        String[][] ret = new String[0][0];
        try {
            String[] plist = this.db.get_class_property_list(this.className, "*");
            ret = new String[plist.length][2];
            for (int i = 0; i < plist.length; ++i) {
                String[] res = this.db.get_class_property(this.className, plist[i]).extractStringArray();
                ret[i][0] = plist[i];
                ret[i][1] = JiveUtils.stringArrayToString(res);
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        return ret;
    }

    @Override
    void setProperty(String propName, String value) {
        try {
            this.db.put_class_property(this.className, JiveUtils.makeDbDatum(propName, value));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    @Override
    void deleteProperty(String propName) {
        try {
            this.db.delete_class_property(this.className, JiveUtils.makeDbDatum(propName, ""));
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }
}

