/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jive3.TreePanelHostCollection;

public class ServerInfoDlg
extends JDialog {
    public static final int RET_CANCEL = 2;
    public static final int RET_OK = 0;
    private DbServInfo server_info;
    private JButton unregisterBtn;
    private boolean unregister = false;
    private Component parent;
    private JRadioButton yesButton;
    private JRadioButton noButton;
    private JComboBox<String> levelCombo;
    private JLabel title;
    private int returnStatus = 2;
    private boolean manage_unregister = true;

    public ServerInfoDlg(JFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.levelCombo.addItem("None");
        for (int i = 1; i <= TreePanelHostCollection.NB_LEVELS; ++i) {
            String s = "Level " + i;
            this.levelCombo.addItem(s);
        }
        this.setTitle("Change Startup Level");
    }

    private void initComponents() {
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        JPanel centerPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.yesButton = new JRadioButton();
        this.yesButton.setFont(ATKConstant.labelFont);
        this.noButton = new JRadioButton();
        this.noButton.setFont(ATKConstant.labelFont);
        JLabel jLabel2 = new JLabel();
        this.levelCombo = new JComboBox();
        this.levelCombo.setPreferredSize(new Dimension(200, 25));
        this.title = new JLabel();
        this.title.setForeground(Color.black);
        this.title.setFont(new Font("Dialog", 1, 16));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ServerInfoDlg.this.closeDialog(evt);
            }
        });
        buttonPanel.setLayout(new FlowLayout(2));
        this.unregisterBtn = new JButton("Remove startup level info");
        this.unregisterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerInfoDlg.this.unregisterBtnActionPerformed(evt);
            }
        });
        buttonPanel.add(this.unregisterBtn);
        okButton.setText("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerInfoDlg.this.okButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(okButton);
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerInfoDlg.this.cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        centerPanel.setLayout(new GridBagLayout());
        centerPanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        centerPanel.add((Component)this.title, gridBagConstraints);
        jLabel1.setText("Controlled by Astor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        centerPanel.add((Component)jLabel1, gridBagConstraints);
        this.yesButton.setText("Yes");
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerInfoDlg.this.yesnoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        centerPanel.add((Component)this.yesButton, gridBagConstraints);
        this.noButton.setText("No");
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerInfoDlg.this.yesnoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        centerPanel.add((Component)this.noButton, gridBagConstraints);
        jLabel2.setText("Startup Level");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 10, 5);
        centerPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 10, 5);
        centerPanel.add(this.levelCombo, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
    }

    private void unregisterBtnActionPerformed(ActionEvent evt) {
        this.unregister = JOptionPane.showConfirmDialog(this.parent, "Are you sure to want to remove " + this.server_info.name + " startup info ?", "Confirm Dialog", 0) == 0;
        if (this.unregister) {
            this.doClose(0);
        }
    }

    private void yesnoButtonActionPerformed(ActionEvent evt) {
        String org = evt.getActionCommand();
        if (org.equals("Yes")) {
            this.updateButtons(true, this.server_info.startup_level);
        } else {
            this.updateButtons(false, 0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(2);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean ctrl = this.yesButton.getSelectedObjects() != null;
        int level = this.levelCombo.getSelectedIndex();
        if (!ctrl || level == 0) {
            level = 0;
        }
        if (ctrl != this.server_info.controlled || level != this.server_info.startup_level) {
            this.doClose(0);
        } else {
            this.doClose(2);
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(2);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    private void updateButtons(boolean ctrl, int level) {
        this.yesButton.setSelected(ctrl);
        this.noButton.setSelected(!ctrl);
        this.levelCombo.setEnabled(ctrl);
        if (ctrl) {
            this.server_info.startup_level = level;
            this.levelCombo.setSelectedIndex(level);
            this.unregisterBtn.setVisible(false);
        } else {
            this.levelCombo.setSelectedIndex(0);
            if (this.server_info.name.length() > 0 && this.manage_unregister) {
                this.unregisterBtn.setVisible(true);
            } else {
                this.unregisterBtn.setVisible(false);
            }
        }
    }

    public int showDialog(DbServInfo info) {
        this.server_info = info;
        this.title.setText("  " + info.name + " running on " + info.host + "  ");
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.updateButtons(info.controlled, info.startup_level);
        this.setVisible(true);
        return this.returnStatus;
    }

    public int showDialog(DbServInfo info, int level) {
        this.server_info = info;
        this.manage_unregister = false;
        this.title.setText("  Servers (Level " + level + ")   running on " + info.host + "  ");
        this.updateButtons(info.controlled, info.startup_level);
        this.pack();
        this.setVisible(true);
        return this.returnStatus;
    }

    public DbServInfo getSelection() {
        if (this.unregister) {
            return null;
        }
        boolean ctrl = this.yesButton.getSelectedObjects() != null;
        int level = this.levelCombo.getSelectedIndex();
        if (!ctrl || level == 0) {
            level = 0;
        }
        return new DbServInfo(this.server_info.name, this.server_info.host, ctrl, level);
    }
}

