/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.Frame;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JFrame;
import javax.swing.tree.TreePath;
import jive.JiveUtils;
import jive.ThreadDlg;
import jive3.TangoNode;

public class SearchEngine {
    int scanProgress;
    Stack<TangoNode> searchStack = null;
    String searchText;
    boolean searchIgnoreCase;
    boolean searchPath;
    boolean searchProperty;
    boolean searchPolling;
    boolean searchAttConfig;
    boolean searchEvent;
    boolean searchAttProperty;
    boolean searchUseRegexp;
    boolean searchOnlyLeaf;
    TreePath searchResult;
    ThreadDlg searchDlg;
    JFrame parent;
    TangoNode focusedNode;

    SearchEngine(JFrame parent) {
        this.parent = parent;
        this.scanProgress = 0;
        this.searchStack = new Stack();
        this.searchIgnoreCase = true;
        this.searchPath = true;
        this.searchProperty = false;
        this.searchPolling = false;
        this.searchAttConfig = false;
        this.searchEvent = false;
        this.searchAttProperty = false;
        this.searchUseRegexp = false;
        this.focusedNode = null;
    }

    public boolean isStackEmpty() {
        if (this.searchStack == null) {
            return true;
        }
        return this.searchStack.empty();
    }

    public void resetSearch(TangoNode focusedNode) {
        this.focusedNode = focusedNode;
        this.searchStack.clear();
    }

    public void setSearchText(String searchText) {
        this.searchText = this.searchIgnoreCase ? searchText.toLowerCase() : searchText;
    }

    public TreePath findText(String value, TangoNode root) {
        this.scanProgress = 0;
        this.searchStack.clear();
        this.searchStack.push(root);
        this.searchText = this.searchIgnoreCase ? value.toLowerCase() : value;
        Thread doSearch = new Thread(){

            @Override
            public void run() {
                SearchEngine.this.searchResult = SearchEngine.this.findTextTask();
                SearchEngine.this.searchDlg.hideDlg();
            }
        };
        this.searchResult = null;
        this.searchDlg = new ThreadDlg((Frame)this.parent, "Searching the database", false, doSearch);
        this.searchDlg.showDlg();
        try {
            doSearch.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        doSearch = null;
        return this.searchResult;
    }

    public TreePath findNext() {
        if (this.focusedNode != null) {
            this.searchStack.clear();
            this.searchStack.push((TangoNode)this.focusedNode.getRoot());
            this.createStackTask();
            this.focusedNode = null;
        }
        Thread doSearch = new Thread(){

            @Override
            public void run() {
                SearchEngine.this.searchResult = SearchEngine.this.findTextTask();
                SearchEngine.this.searchDlg.hideDlg();
            }
        };
        this.searchResult = null;
        this.searchDlg = new ThreadDlg((Frame)this.parent, "Searching the database", false, doSearch);
        this.searchDlg.showDlg();
        try {
            doSearch.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        doSearch = null;
        return this.searchResult;
    }

    private TreePath findTextTask() {
        Pattern p = null;
        TangoNode node = null;
        if (this.searchUseRegexp) {
            try {
                p = Pattern.compile(this.searchText);
            }
            catch (PatternSyntaxException e) {
                JiveUtils.showJiveError("Invalid regular expression\n" + e.getDescription());
                return null;
            }
        }
        boolean found = false;
        while (!(this.searchStack.empty() || ThreadDlg.stopflag || found)) {
            node = (TangoNode)this.searchStack.get(0);
            this.searchStack.remove(0);
            ++this.scanProgress;
            String pathText = null;
            if (this.searchPath) {
                TreePath path = node.getCompletePath();
                pathText = JiveUtils.getPathAsText(path);
                if (this.searchIgnoreCase) {
                    pathText = pathText.toLowerCase();
                }
                if (this.searchUseRegexp) {
                    found = p.matcher(pathText).matches();
                } else {
                    boolean bl = found = pathText.indexOf(this.searchText) != -1;
                }
            }
            if (found) continue;
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.searchStack.add((TangoNode)node.getChildAt(i));
            }
        }
        if (found) {
            return node.getCompletePath();
        }
        return null;
    }

    private void createStackTask() {
        TangoNode node = null;
        boolean found = false;
        while (!(this.searchStack.empty() || ThreadDlg.stopflag || found)) {
            node = (TangoNode)this.searchStack.get(0);
            this.searchStack.remove(0);
            found = node == this.focusedNode;
            if (found) continue;
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.searchStack.add((TangoNode)node.getChildAt(i));
            }
        }
    }
}

