/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jive.JiveUtils;

public class ResDlg
extends JDialog
implements ActionListener {
    private JTextArea resText;
    private JLabel warningLabel;
    private JScrollPane resScrollPane;
    private JButton loadButton;
    private JButton cancelButton;
    private boolean okFlag;

    public ResDlg(JFrame parent, String fileName) {
        super((Frame)parent, true);
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        this.resText = new JTextArea();
        this.resText.setFont(new Font("Monospaced", 0, 12));
        this.resScrollPane = new JScrollPane(this.resText);
        this.resScrollPane.setPreferredSize(new Dimension(600, 400));
        innerPanel.add((Component)this.resScrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets.left = 5;
        gbc.insets.top = 3;
        gbc.insets.bottom = 3;
        this.warningLabel = new JLabel("");
        this.warningLabel.setForeground(Color.RED);
        buttonPanel.add((Component)this.warningLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        this.loadButton = new JButton("Load");
        this.loadButton.addActionListener(this);
        buttonPanel.add((Component)this.loadButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets.right = 5;
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add((Component)this.cancelButton, gbc);
        innerPanel.add((Component)buttonPanel, "South");
        this.readFile(fileName);
        this.setTitle("Load resource [" + fileName + "]");
        this.setContentPane(innerPanel);
    }

    private void readFile(String fileName) {
        boolean warning = false;
        try {
            StringBuffer sb = new StringBuffer();
            FileReader f = new FileReader(fileName);
            while (f.ready()) {
                char c = (char)f.read();
                if (!warning) {
                    warning = c > '\u007f';
                }
                sb.append(c);
            }
            f.close();
            this.resText.setText(sb.toString());
        }
        catch (IOException e) {
            JiveUtils.showJiveError("Cannot read " + fileName + "\n" + e.getMessage());
        }
        if (warning) {
            this.warningLabel.setText("File contains special char !");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.loadButton) {
            this.okFlag = true;
            this.setVisible(false);
        } else if (src == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public boolean showDlg() {
        this.okFlag = false;
        ATKGraphicsUtils.centerDialog((Dialog)this);
        this.setVisible(true);
        return this.okFlag;
    }
}

