/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;
import jive3.MultiLineInputDlg;
import jive3.PItem;

public class MultiplePropertySelectionDlg
extends JFrame
implements ActionListener {
    Database db = null;
    String[] colName = new String[]{"Name", "Value"};
    private MultiLineCellEditor editor;
    JTextField selectionText;
    JLabel selectionLabel;
    JButton searchButton;
    JButton applyAllButton;
    JButton applyButton;
    JButton dismissButton;
    JLabel infoLabel;
    DefaultTableModel dm;
    JTable theTable;
    String selectText;
    ArrayList<PItem> items;

    public MultiplePropertySelectionDlg() {
        this.initComponents();
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public void clear() {
        this.items.clear();
        this.infoLabel.setText(this.items.size() + " item(s)");
        Object[][] prop = new String[0][2];
        this.dm.setDataVector(prop, this.colName);
        this.editor.updateRows();
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.theTable.validate();
        ((JPanel)this.getContentPane()).revalidate();
    }

    void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        JLabel selectionLabel = new JLabel(" Selection ");
        selectionLabel.setFont(ATKConstant.labelFont);
        innerPanel.add((Component)selectionLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.selectionText = new JTextField();
        this.selectionText.addActionListener(this);
        this.selectionText.setFont(ATKConstant.labelFont);
        innerPanel.add((Component)this.selectionText, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(this);
        innerPanel.add((Component)this.searchButton, gbc);
        JPanel innerPanel2 = new JPanel();
        innerPanel2.setLayout(new FlowLayout(2));
        this.infoLabel = new JLabel("0 item(s)");
        this.infoLabel.setFont(ATKConstant.labelFont);
        innerPanel2.add(this.infoLabel);
        this.applyAllButton = new JButton("Apply to all ...");
        this.applyAllButton.setToolTipText("Ask for a value and apply it to the current selection");
        this.applyAllButton.addActionListener(this);
        innerPanel2.add(this.applyAllButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setToolTipText("Apply change to the database");
        this.applyButton.addActionListener(this);
        this.applyButton.setEnabled(false);
        innerPanel2.add(this.applyButton);
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.addActionListener(this);
        innerPanel2.add(this.dismissButton);
        this.getContentPane().add((Component)innerPanel, "North");
        this.getContentPane().add((Component)innerPanel2, "South");
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    MultiplePropertySelectionDlg.this.items.get((int)row).value = JiveUtils.makeStringArray((String)aValue);
                    MultiplePropertySelectionDlg.this.items.get((int)row).updated = true;
                    MultiplePropertySelectionDlg.this.applyButton.setEnabled(true);
                }
            }
        };
        this.theTable = new JTable(this.dm);
        this.editor = new MultiLineCellEditor(this.theTable);
        this.theTable.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer renderer = new MultiLineCellRenderer(false, false, false);
        this.theTable.setDefaultRenderer(String.class, renderer);
        this.theTable.setSelectionMode(0);
        JScrollPane textView = new JScrollPane(this.theTable);
        this.getContentPane().add((Component)textView, "Center");
        this.setTitle("Multiple property selection");
        this.setPreferredSize(new Dimension(800, 600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MultiplePropertySelectionDlg.this.exitDlg();
                super.windowClosing(e);
            }
        });
        this.items = new ArrayList();
        this.clear();
    }

    private void selectProperty() {
        this.refresh();
    }

    private void refresh() {
        String selectText = this.selectionText.getText().trim();
        String[] fields = selectText.split("/");
        if (fields.length != 4 && fields.length != 5) {
            JiveUtils.showJiveError("Invalid selection pattern, 4 or 5 slash separated fields expected");
            return;
        }
        try {
            this.items.clear();
            String devName = fields[0] + "/" + fields[1] + "/" + fields[2];
            if (fields.length == 4) {
                String propName = fields[3];
                String[] devNames = this.db.get_device_list(devName);
                for (int i = 0; i < devNames.length; ++i) {
                    String[] pList = this.db.get_device_property_list(devNames[i], propName);
                    for (int j = 0; j < pList.length; ++j) {
                        PItem pi = new PItem();
                        pi.devName = devNames[i];
                        pi.attName = null;
                        pi.pName = pList[j];
                        pi.updated = false;
                        DbDatum dbd = this.db.get_device_property(pi.devName, pi.pName);
                        pi.value = dbd.extractStringArray();
                        this.items.add(pi);
                    }
                }
            } else {
                devName = devName.replace('*', '%');
                String attName = fields[3].replace('*', '%');
                String propName = fields[4].replace('*', '%');
                DeviceData argin = new DeviceData();
                String request = "select distinct device,attribute,name,count,value from property_attribute_device where device like '" + devName + "' and attribute like '" + attName + "'and name like '" + propName + "' order by device,attribute,name,count asc;";
                argin.insert(request);
                DeviceData argout = this.db.command_inout("DbMySqlSelect", argin);
                DevVarLongStringArray arg = argout.extractLongStringArray();
                PItem it = null;
                ArrayList<String> value = new ArrayList<String>();
                for (int i = 0; i < arg.svalue.length; i += 5) {
                    if (arg.lvalue[i / 5] == 0) continue;
                    String dbDevName = arg.svalue[i + 0];
                    String dbAttName = arg.svalue[i + 1];
                    String dbPropName = arg.svalue[i + 2];
                    if (!(it != null && dbDevName.equalsIgnoreCase(it.devName) && dbAttName.equalsIgnoreCase(it.attName) && dbPropName.equalsIgnoreCase(it.pName))) {
                        if (it != null) {
                            it.value = value.toArray(new String[value.size()]);
                            this.items.add(it);
                            value.clear();
                        }
                        it = new PItem();
                        it.devName = dbDevName;
                        it.attName = dbAttName;
                        it.pName = dbPropName;
                    }
                    value.add(arg.svalue[i + 4]);
                }
                if (it != null) {
                    it.value = value.toArray(new String[value.size()]);
                    this.items.add(it);
                }
            }
            if (this.items.size() == 0) {
                JOptionPane.showMessageDialog(this, "No property found");
            }
            this.infoLabel.setText(this.items.size() + " item(s)");
            this.refreshTable();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
    }

    private void refreshTable() {
        Object[][] prop = new String[this.items.size()][3];
        for (int i = 0; i < this.items.size(); ++i) {
            PItem it = this.items.get(i);
            prop[i][0] = it.attName == null ? it.devName + "/" + it.pName : it.devName + "/" + it.attName + "/" + it.pName;
            prop[i][1] = it.toString();
        }
        this.dm.setDataVector(prop, this.colName);
        this.editor.updateRows();
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.theTable.validate();
        ((JPanel)this.getContentPane()).revalidate();
    }

    private void applyAll() {
        if (this.items.size() == 0) {
            JOptionPane.showMessageDialog(this, "No selection");
            return;
        }
        String[] newValue = MultiLineInputDlg.getInputText(this, "Apply to all", "Apply to " + this.items.size() + " item(s)", this.items.get((int)0).value);
        if (newValue != null) {
            for (int i = 0; i < this.items.size(); ++i) {
                this.items.get((int)i).value = newValue;
                this.items.get((int)i).updated = true;
            }
            this.apply();
            this.refreshTable();
        }
    }

    private void apply() {
        try {
            for (int i = 0; i < this.items.size(); ++i) {
                PItem pi = this.items.get(i);
                if (pi.updated) {
                    if (pi.attName == null) {
                        DbDatum[] ds = new DbDatum[]{new DbDatum(pi.pName, pi.value)};
                        this.db.put_device_property(pi.devName, ds);
                    } else {
                        DbAttribute da = new DbAttribute(pi.attName);
                        da.add(pi.pName, pi.value);
                        this.db.put_device_attribute_property(pi.devName, da);
                    }
                }
                pi.updated = false;
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        this.applyButton.setEnabled(false);
    }

    public boolean hasChanged() {
        boolean hasChanged = false;
        int i = 0;
        while (!hasChanged && i < this.items.size()) {
            hasChanged = this.items.get((int)i).updated;
            if (hasChanged) continue;
            ++i;
        }
        return hasChanged;
    }

    private void exitDlg() {
        int ok;
        if (this.hasChanged() && (ok = JOptionPane.showConfirmDialog(this, "Some properties have changed\nDo you want to update the database ?", "Confirmation", 0)) == 0) {
            this.apply();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.searchButton || src == this.selectionText) {
            this.selectProperty();
        } else if (src == this.dismissButton) {
            this.exitDlg();
            this.setVisible(false);
        } else if (src == this.applyButton) {
            this.apply();
        } else if (src == this.applyAllButton) {
            this.applyAll();
        }
    }
}

