/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;

public class MultiChangeConfirmDlg
extends JDialog
implements ActionListener {
    private JScrollPane textView;
    private JTable theTable;
    private MultiLineCellEditor editor;
    private DefaultTableModel dm;
    private JButton cancelBtn;
    private JButton performBtn;
    private JPanel btnPanel;
    private JPanel innerPanel = new JPanel();
    private JPanel warningPanel;
    private JTextArea warningText;
    private boolean goFlag;

    public MultiChangeConfirmDlg(Vector propValues, int nbDevice, String extraInfo, String itemName) {
        super((Frame)null, true);
        this.innerPanel.setLayout(new BorderLayout());
        this.warningPanel = new JPanel();
        this.warningPanel.setLayout(new BorderLayout());
        this.innerPanel.add((Component)this.warningPanel, "North");
        JLabel warningIcon = new JLabel();
        warningIcon.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        warningIcon.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 20));
        this.warningPanel.add((Component)warningIcon, "West");
        this.warningText = new JTextArea();
        this.warningText.setEditable(false);
        this.warningText.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.warningText.setBackground(this.innerPanel.getBackground());
        this.warningPanel.add((Component)this.warningText, "Center");
        int nbProp = propValues.size() / 2;
        String nbPropStr = "";
        nbPropStr = nbProp == 1 ? nbProp + itemName : nbProp + this.getPluriel(itemName);
        String verb = "modify";
        String arginName = "New value";
        if (itemName.equalsIgnoreCase("attribute")) {
            verb = "write";
        } else if (itemName.equalsIgnoreCase("command")) {
            arginName = "Input parameters";
            verb = "execute";
        }
        this.warningText.setText("You are going to " + verb + " " + nbPropStr + " on " + nbDevice + " devices" + extraInfo + ".\nDo you want to proceed ?");
        this.dm = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
            }
        };
        this.theTable = new JTable(this.dm);
        this.editor = new MultiLineCellEditor(this.theTable);
        this.theTable.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer renderer = new MultiLineCellRenderer();
        this.theTable.setDefaultRenderer(String.class, renderer);
        this.textView = new JScrollPane(this.theTable);
        this.add((Component)this.textView, "Center");
        this.innerPanel.add((Component)this.textView, "Center");
        Object[] colName = new String[]{itemName, arginName};
        Object[][] prop = new String[propValues.size() / 2][2];
        for (int i = 0; i < propValues.size(); i += 2) {
            prop[i / 2][0] = (String)propValues.get(i);
            prop[i / 2][1] = (String)propValues.get(i + 1);
        }
        this.dm.setDataVector(prop, colName);
        this.editor.updateRows();
        this.theTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.theTable.validate();
        this.btnPanel = new JPanel();
        this.btnPanel.setLayout(new FlowLayout(2));
        this.innerPanel.add((Component)this.btnPanel, "South");
        this.performBtn = new JButton("Proceed");
        this.performBtn.addActionListener(this);
        this.btnPanel.add(this.performBtn);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(this);
        this.btnPanel.add(this.cancelBtn);
        this.setContentPane(this.innerPanel);
        this.setTitle("Multiple change confirmation");
        this.goFlag = false;
    }

    private String getPluriel(String name) {
        if (name.endsWith("y")) {
            return name.substring(0, name.length() - 1) + "ies";
        }
        return name + "s";
    }

    public static boolean confirmChange(Vector propValues, int nbDevice) {
        MultiChangeConfirmDlg dlg = new MultiChangeConfirmDlg(propValues, nbDevice, "", "Property");
        ATKGraphicsUtils.centerDialog((Dialog)dlg);
        dlg.setVisible(true);
        return dlg.isOK();
    }

    public static boolean confirmChange(Vector propValues, int nbDevice, String extra) {
        MultiChangeConfirmDlg dlg = new MultiChangeConfirmDlg(propValues, nbDevice, extra, "Property");
        ATKGraphicsUtils.centerDialog((Dialog)dlg);
        dlg.setVisible(true);
        return dlg.isOK();
    }

    public static boolean confirmChange(Vector propValues, int nbDevice, String extra, String itemName) {
        MultiChangeConfirmDlg dlg = new MultiChangeConfirmDlg(propValues, nbDevice, extra, itemName);
        ATKGraphicsUtils.centerDialog((Dialog)dlg);
        dlg.setVisible(true);
        return dlg.isOK();
    }

    public boolean isOK() {
        return this.goFlag;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.performBtn) {
            this.setVisible(false);
            this.goFlag = true;
        } else if (e.getSource() == this.cancelBtn) {
            this.setVisible(false);
        }
    }
}

