/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jive.MultiLineCellEditor;
import jive.MultiLineCellRenderer;
import jive3.MainPanel;

public class JiveTable
extends JTable {
    private MultiLineCellEditor editor = new MultiLineCellEditor(this);
    private MainPanel parent = null;

    public JiveTable(TableModel model) {
        super(model);
        this.setDefaultEditor(String.class, this.editor);
        MultiLineCellRenderer renderer = new MultiLineCellRenderer(false, true, true);
        this.setDefaultRenderer(String.class, renderer);
    }

    public void setParent(MainPanel parent) {
        this.parent = parent;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        int column;
        MouseEvent me;
        if (e instanceof MouseEvent && (me = (MouseEvent)e).getButton() == 1 && me.getID() == 501 && (column = this.getColumnForLocation(me.getX())) == 1) {
            int row = this.getRowForLocation(me.getY());
            String value = (String)this.getModel().getValueAt(row, column);
            MultiLineCellRenderer c = (MultiLineCellRenderer)this.getCellRenderer(row, column);
            c.setText(value);
            if (c.hasDevice()) {
                int y;
                Rectangle rect = this.getCellRect(row, column, false);
                int x = me.getX() - rect.x;
                String name = c.getDevice(x, y = me.getY() - rect.y);
                if (name != null && this.parent != null) {
                    this.parent.goToDeviceNode(name);
                    return;
                }
            }
        }
        super.processEvent(e);
    }

    public MultiLineCellEditor getEditor() {
        return this.editor;
    }

    public void updateRows() {
        this.editor.updateRows();
    }

    public int getRowForLocation(int y) {
        boolean found = false;
        int i = 0;
        int h = 0;
        while (i < this.getModel().getRowCount() && !found) {
            found = y >= h && y <= h + this.getRowHeight(i);
            if (found) continue;
            h += this.getRowHeight(i);
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    public int getColumnForLocation(int x) {
        boolean found = false;
        int i = 0;
        int w = 0;
        while (i < this.getModel().getColumnCount() && !found) {
            int cWidth = this.getColumnModel().getColumn(i).getWidth();
            found = x >= w && x <= w + cWidth;
            if (found) continue;
            w += cWidth;
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }
}

