/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public final class JTextEditor
extends JComponent
implements FocusListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final int MAX_UNDO = 10;
    private Font plainFont = null;
    private Font boldFont = null;
    private Font italicFont = null;
    private Color defaultColor = new Color(80, 80, 80);
    private Color selBackColor = new Color(220, 220, 255);
    private Color countBackColor = new Color(230, 230, 250);
    private Color countForeColor = new Color(150, 150, 150);
    private Color curLineColor = new Color(255, 255, 200);
    private Clipboard clipboard;
    private int charHeight;
    private int charDescent;
    private int charAscent;
    private int charLeading;
    private int charWidth;
    private EditorContent text = new EditorContent();
    private int mX;
    private int mY = 2;
    private int textCursorWidth;
    private boolean isDragging = false;
    private int cursorPos = 0;
    private int lastCursorPos = 0;
    private boolean cursorVisible = true;
    private int selStart = -1;
    private int selEnd = -1;
    private ArrayList<UndoItem> undoBuffer;
    private int undoPos = 0;
    private boolean isEditable;
    private ArrayList<ActionListener> docListeners;
    private Dimension lastSize = null;
    private JViewport parentViewport = null;
    private String lastSearch = null;
    private static final char[] separatorList = new char[]{'\"', '(', ')', '*', '+', ',', '-', '/', ':', ';', '=', '{', '}'};

    public JTextEditor() {
        this.initializeDefault();
        this.setOpaque(true);
        this.setToolTipText("");
        this.setCursor(new Cursor(2));
        this.textCursorWidth = 2;
        this.setToolTipText(null);
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        this.undoBuffer = new ArrayList();
        this.isEditable = true;
        this.docListeners = new ArrayList();
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void setText(String s) {
        this.text.setText(s);
        this.resetSelection();
        this.cursorPos = 0;
        this.undoBuffer.clear();
        this.undoPos = 0;
        this.updateScroll(true);
    }

    public String getText() {
        return this.text.toString();
    }

    public void setForeground(Color c, int start, int lgth) {
        this.text.setForeground(c, start, lgth);
    }

    public void setStyle(int style, int start, int lgth) {
        this.text.setStyle(style, start, lgth);
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
        this.repaint();
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void addActionListener(ActionListener l) {
        this.docListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.docListeners.remove(l);
    }

    public void setDefaultForegroundColor(Color f) {
        this.defaultColor = f;
    }

    public void clearStyleAndColor() {
        this.text.clearStyleAndColor();
    }

    public void searchText(String toSearch, boolean matchCase) {
        this.searchText(toSearch, matchCase, this.cursorPos);
    }

    private void searchText(String toSearch, boolean matchCase, int from) {
        int i;
        String text = this.getText();
        if (!matchCase) {
            toSearch = toSearch.toLowerCase();
            text = text.toLowerCase();
        }
        if ((i = text.indexOf(toSearch, from)) != -1) {
            this.lastSearch = toSearch;
            this.selStart = i;
            this.selEnd = i + toSearch.length();
            this.cursorPos = i;
            this.lastCursorPos = i;
            this.fireUpdate();
            this.repaint();
            this.scrollToVisible();
        } else {
            this.lastSearch = null;
            int ok = JOptionPane.showConfirmDialog(this, "End of document reached, restart from beginning ?", "Search", 0);
            if (ok == 0) {
                this.searchText(toSearch, matchCase, 0);
            }
        }
    }

    public void searchNext(boolean matchCase) {
        if (this.lastSearch != null) {
            this.searchText(this.lastSearch, matchCase, this.cursorPos + 1);
        }
    }

    public void setScrollPane(JScrollPane parent) {
        parent.getActionMap().put("unitScrollRight", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        parent.getActionMap().put("unitScrollDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        parent.getActionMap().put("unitScrollLeft", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        parent.getActionMap().put("unitScrollUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        parent.getActionMap().put("scrollDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        parent.getActionMap().put("scrollUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.parentViewport = parent.getViewport();
        parent.setWheelScrollingEnabled(false);
        this.addMouseWheelListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        int maxX = 0;
        int maxY = 0;
        int c = 0;
        for (int i = 0; i < this.text.length(); ++i) {
            if (this.text.isNewLine(i)) {
                if (c - 1 > maxX) {
                    maxX = c - 1;
                }
                ++maxY;
                c = 0;
            }
            ++c;
        }
        if (c - 1 > maxX) {
            maxX = c - 1;
        }
        return new Dimension(maxX * this.charWidth + 2 * this.mX, (maxY + 1) * this.charHeight + 2 * this.mY);
    }

    @Override
    public void paint(Graphics g) {
        int sEnd;
        int sStart;
        int sX = this.mX;
        int sY = this.mY;
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(this.defaultColor);
        g.setFont(this.plainFont);
        Color gf = null;
        if (this.selStart > this.selEnd) {
            sStart = this.selEnd;
            sEnd = this.selStart;
        } else {
            sStart = this.selStart;
            sEnd = this.selEnd;
        }
        Point p = this.getPos(this.cursorPos);
        int curLine = 0;
        int curCol = 0;
        g.setFont(this.italicFont);
        g.setColor(this.countBackColor);
        g.fillRect(0, sY - 1, this.mX - 2, this.charHeight + 3);
        g.setColor(this.countForeColor);
        String lineNb = String.format("%03d", curLine);
        g.drawString(lineNb, 3, sY + this.charAscent);
        for (int i = 0; i < this.text.length(); ++i) {
            int c;
            if (curLine == p.y && curCol == 0 && this.isEditable && this.hasFocus()) {
                g.setColor(this.curLineColor);
                g.fillRect(sX - 1, sY - 1, d.width, this.charHeight + 2);
            }
            if (this.cursorPos == i && this.cursorVisible && this.isEditable && this.hasFocus()) {
                g.setColor(Color.BLACK);
                g.fillRect(sX - 1, sY + 1, 2, this.charHeight - 1);
            }
            if ((c = this.text.charAt(i)) != 10) {
                if (i >= sStart && i < sEnd) {
                    g.setColor(this.selBackColor);
                    g.fillRect(sX, sY, this.charWidth, this.charHeight);
                }
                if (gf == null || gf.getRGB() != this.text.getForeground(i)) {
                    gf = new Color(this.text.getForeground(i));
                }
                g.setColor(gf);
                switch (this.text.getStyle(i)) {
                    case 0: {
                        g.setFont(this.plainFont);
                        break;
                    }
                    case 1: {
                        g.setFont(this.boldFont);
                        break;
                    }
                    case 2: {
                        g.setFont(this.italicFont);
                    }
                }
            }
            if (c == 10) {
                sX = this.mX;
                ++curLine;
                curCol = 0;
                g.setFont(this.italicFont);
                g.setColor(this.countBackColor);
                g.fillRect(0, (sY += this.charHeight) - 1, this.mX - 2, this.charHeight + 3);
                g.setColor(this.countForeColor);
                lineNb = String.format("%03d", curLine);
                g.drawString(lineNb, 3, sY + this.charAscent);
                continue;
            }
            if (c == 32) {
                sX += this.charWidth;
                ++curCol;
                continue;
            }
            g.drawString(String.valueOf((char)c), sX, sY + this.charAscent);
            sX += this.charWidth;
            ++curCol;
        }
        if (this.cursorPos == this.text.length() && this.cursorVisible) {
            g.setColor(Color.BLACK);
            g.fillRect(sX - 1, sY, 2, this.charHeight);
        }
    }

    private boolean isSeparator(int idx) {
        char c = (char)this.text.charAt(idx);
        if (c <= ' ') {
            return true;
        }
        return Arrays.binarySearch(separatorList, c) >= 0;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.parentViewport != null) {
            final int scroll = e.getWheelRotation() * this.charHeight;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Point p = JTextEditor.this.parentViewport.getViewPosition();
                    p.y += scroll;
                    if (p.y < 0) {
                        p.y = 0;
                    }
                    Dimension d = JTextEditor.this.parentViewport.getSize();
                    Dimension dv = JTextEditor.this.parentViewport.getViewSize();
                    if (p.y > dv.height - d.height) {
                        p.y = dv.height - d.height;
                    }
                    JTextEditor.this.parentViewport.setViewPosition(p);
                }
            });
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.lastCursorPos = this.cursorPos = this.getCursorPos(e.getX(), e.getY());
            this.selStart = this.cursorPos;
            this.selEnd = this.cursorPos;
            while (this.selStart >= 0 && !this.isSeparator(this.selStart)) {
                --this.selStart;
            }
            ++this.selStart;
            while (this.selEnd <= this.text.length() && !this.isSeparator(this.selEnd)) {
                ++this.selEnd;
            }
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        if (!this.isEditable) {
            return;
        }
        this.lastCursorPos = this.cursorPos = this.getCursorPos(e.getX(), e.getY());
        this.resetSelection();
        this.isDragging = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.isEditable) {
            return;
        }
        this.isDragging = false;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.isEditable) {
            return;
        }
        if (this.isDragging) {
            this.lastCursorPos = this.cursorPos = this.getCursorPos(e.getX(), e.getY());
            this.selEnd = this.cursorPos;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.isEditable) {
            return;
        }
        block0 : switch (e.getKeyCode()) {
            case 33: {
                for (int nbLine = this.getVisibleRect().height / this.charHeight; this.getUpPos() >= 0 && nbLine > 0; --nbLine) {
                    this.cursorPos = this.getUpPos();
                }
                this.resetSelection();
                this.scrollToVisible();
                this.repaint();
                break;
            }
            case 34: {
                for (int nbLine = this.getVisibleRect().height / this.charHeight; nbLine > 0; --nbLine) {
                    this.cursorPos = this.getDownPos();
                }
                this.resetSelection();
                this.scrollToVisible();
                this.repaint();
                break;
            }
            case 39: {
                ++this.cursorPos;
                if (this.cursorPos >= this.text.length()) {
                    this.cursorPos = this.text.length();
                }
                this.lastCursorPos = this.cursorPos;
                if (e.isShiftDown()) {
                    this.selEnd = this.cursorPos;
                } else {
                    this.resetSelection();
                }
                this.scrollToVisible();
                this.repaint();
                break;
            }
            case 37: {
                --this.cursorPos;
                if (this.cursorPos < 0) {
                    this.cursorPos = 0;
                }
                this.lastCursorPos = this.cursorPos;
                if (e.isShiftDown()) {
                    this.selEnd = this.cursorPos;
                } else {
                    this.resetSelection();
                }
                this.scrollToVisible();
                this.repaint();
                break;
            }
            case 38: {
                int s = this.getUpPos();
                if (s < 0) break;
                this.cursorPos = s;
                if (e.isShiftDown()) {
                    this.selEnd = this.cursorPos;
                } else {
                    this.resetSelection();
                }
                this.scrollToVisible();
                this.repaint();
                break;
            }
            case 40: {
                this.cursorPos = this.getDownPos();
                if (e.isShiftDown()) {
                    this.selEnd = this.cursorPos;
                } else {
                    this.resetSelection();
                }
                this.scrollToVisible();
                this.repaint();
                break;
            }
            case 8: {
                if (this.hasSelection()) {
                    this.modify();
                    this.deleteSelection();
                    this.fireUpdate();
                } else if (this.cursorPos > 0) {
                    this.modify();
                    --this.cursorPos;
                    this.lastCursorPos = this.cursorPos;
                    this.text.remove(this.cursorPos, 1);
                    this.resetSelection();
                    this.fireUpdate();
                }
                this.repaint();
                this.scrollToVisible();
                break;
            }
            case 127: {
                if (this.hasSelection()) {
                    this.modify();
                    this.deleteSelection();
                    this.fireUpdate();
                } else if (this.cursorPos < this.text.length()) {
                    this.modify();
                    this.text.remove(this.cursorPos, 1);
                    this.lastCursorPos = this.cursorPos;
                    this.resetSelection();
                    this.fireUpdate();
                }
                this.repaint();
                this.scrollToVisible();
                break;
            }
            case 10: {
                this.modify();
                this.text.insert('\n', this.cursorPos);
                ++this.cursorPos;
                this.resetSelection();
                this.fireUpdate();
                this.repaint();
                this.scrollToVisible();
                break;
            }
            default: {
                if (e.isActionKey()) break;
                char c = e.getKeyChar();
                if (c >= ' ' && c <= '\u00ff') {
                    this.modify();
                    this.deleteSelection();
                    this.text.insert(c, this.cursorPos);
                    ++this.cursorPos;
                    ++this.lastCursorPos;
                    this.resetSelection();
                    this.fireUpdate();
                    this.scrollToVisible();
                    this.repaint();
                    break;
                }
                if (!e.isControlDown()) break;
                switch (e.getKeyCode()) {
                    case 65: {
                        this.selStart = 0;
                        this.selEnd = this.text.length();
                        this.repaint();
                        break block0;
                    }
                    case 67: {
                        this.copy();
                        break block0;
                    }
                    case 86: {
                        String str = this.getClipboardContent();
                        if (str == null || str.length() <= 0) break block0;
                        this.modify();
                        this.deleteSelection();
                        this.paste(str);
                        this.fireUpdate();
                        this.repaint();
                        this.scrollToVisible();
                        break block0;
                    }
                    case 88: {
                        if (!this.hasSelection()) break block0;
                        this.modify();
                        this.copy();
                        this.deleteSelection();
                        this.fireUpdate();
                        this.repaint();
                        this.scrollToVisible();
                        break block0;
                    }
                    case 90: {
                        if (!e.isShiftDown()) {
                            if (this.undoPos <= 0) break block0;
                            if (this.undoPos == this.undoBuffer.size()) {
                                this.modify();
                                --this.undoPos;
                            }
                            --this.undoPos;
                            this.text.setText(this.undoBuffer.get((int)this.undoPos).text);
                            this.cursorPos = this.undoBuffer.get((int)this.undoPos).cursorPos;
                            this.fireUpdate();
                            this.repaint();
                            this.scrollToVisible();
                            break block0;
                        }
                        if (this.undoPos >= this.undoBuffer.size() - 1) break block0;
                        ++this.undoPos;
                        this.text.setText(this.undoBuffer.get((int)this.undoPos).text);
                        this.cursorPos = this.undoBuffer.get((int)this.undoPos).cursorPos;
                        this.fireUpdate();
                        this.repaint();
                        this.scrollToVisible();
                        break block0;
                    }
                    case 70: {
                        String toSearch = JOptionPane.showInputDialog(this, "Search", "");
                        if (toSearch == null) break block0;
                        this.searchText(toSearch, false);
                    }
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    private void fireUpdate() {
        for (int i = 0; i < this.docListeners.size(); ++i) {
            ActionEvent e = new ActionEvent(this, i, "TextChanged");
            this.docListeners.get(i).actionPerformed(e);
        }
        this.updateScroll();
    }

    private void updateScroll() {
        this.updateScroll(false);
    }

    private void scrollToVisible() {
        if (this.parentViewport != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Point p = JTextEditor.this.getPos(JTextEditor.this.cursorPos);
                    Rectangle r = new Rectangle(p.x * JTextEditor.this.charWidth, p.y * JTextEditor.this.charHeight, JTextEditor.this.charWidth + JTextEditor.this.mX, JTextEditor.this.charHeight + JTextEditor.this.mY);
                    JTextEditor.this.scrollRectToVisible(r);
                }
            });
        }
    }

    private void updateScroll(boolean forceUpdate) {
        if (this.parentViewport != null) {
            Dimension dim = this.getPreferredSize();
            if (forceUpdate) {
                this.lastSize = dim;
                this.parentViewport.revalidate();
            } else if (this.lastSize == null || this.lastSize.getWidth() != dim.getWidth() || this.lastSize.getHeight() != dim.getHeight()) {
                this.lastSize = dim;
                this.parentViewport.revalidate();
            }
        }
    }

    private void resetSelection() {
        this.selStart = this.cursorPos;
        this.selEnd = this.cursorPos;
    }

    private boolean hasSelection() {
        int length = Math.abs(this.selEnd - this.selStart);
        return length > 0;
    }

    private boolean deleteSelection() {
        int length = Math.abs(this.selEnd - this.selStart);
        if (length > 0) {
            int idx = Math.min(this.selStart, this.selEnd);
            this.text.remove(idx, length);
            this.cursorPos = idx;
            this.resetSelection();
            return true;
        }
        return false;
    }

    private void modify() {
        int i;
        int toRemove = this.undoBuffer.size() - this.undoPos;
        for (i = 0; i < toRemove; ++i) {
            this.undoBuffer.remove(this.undoBuffer.size() - 1);
        }
        if (this.undoBuffer.size() > 10) {
            toRemove = this.undoBuffer.size() - 10;
            for (i = 0; i < toRemove; ++i) {
                this.undoBuffer.remove(0);
            }
        }
        UndoItem it = new UndoItem();
        it.cursorPos = this.cursorPos;
        it.text = this.text.toString();
        this.undoBuffer.add(it);
        this.undoPos = this.undoBuffer.size();
    }

    private void copy() {
        int length = Math.abs(this.selEnd - this.selStart);
        if (length > 0) {
            int idx = Math.min(this.selStart, this.selEnd);
            String str = this.text.subString(idx, length);
            StringSelection stringSelection = new StringSelection(str);
            this.clipboard.setContents(stringSelection, null);
        }
    }

    private String getClipboardContent() {
        String str = null;
        try {
            str = (String)this.clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return str;
    }

    private void paste(String str) {
        this.text.insert(str, this.cursorPos);
        this.cursorPos += str.length();
        this.resetSelection();
    }

    private int getCursorPos(int x, int y) {
        int i;
        int xP = x - this.mX - this.charWidth / 2 + this.textCursorWidth;
        int yP = (y - this.mY) / this.charHeight;
        int yl = 0;
        for (i = 0; i < this.text.length() && yl < yP; ++i) {
            if (!this.text.isNewLine(i)) continue;
            ++yl;
        }
        for (int xl = 0; i < this.text.length() && xl < xP && !this.text.isNewLine(i); xl += this.charWidth, ++i) {
        }
        return i;
    }

    private int getUpPos() {
        int s = this.getStartLine(this.cursorPos);
        if (s != 0) {
            int c = this.getColumn(this.cursorPos);
            int cp = s - 1;
            int nc = this.getColumn(cp);
            while (nc > c) {
                --nc;
                --cp;
            }
            return cp;
        }
        return -1;
    }

    private int getDownPos() {
        int cp = this.getNextLine(this.cursorPos);
        int c = this.getColumn(this.cursorPos);
        for (int nc = 0; nc < c && cp < this.text.length() && !this.text.isNewLine(cp); ++nc, ++cp) {
        }
        return cp;
    }

    private int getNextLine(int pos) {
        int i;
        for (i = pos; i < this.text.length() && !this.text.isNewLine(i); ++i) {
        }
        if (i < this.text.length()) {
            ++i;
        }
        return i;
    }

    private int getColumn(int pos) {
        int i = pos;
        int c = 0;
        while (i > 0 && !this.text.isNewLine(i - 1)) {
            --i;
            ++c;
        }
        return c;
    }

    private int getStartLine(int pos) {
        int i;
        for (i = pos; i > 0 && !this.text.isNewLine(i - 1); --i) {
        }
        return i;
    }

    private Point getPos(int pos) {
        int l = 0;
        int c = 0;
        for (int i = 0; i < pos; ++i) {
            if (this.text.isNewLine(i)) {
                ++l;
                c = 0;
                continue;
            }
            ++c;
        }
        return new Point(c, l);
    }

    private void initializeDefault() {
        String fontName = "MonoSpaced";
        int fontSize = 12;
        this.plainFont = new Font("MonoSpaced", 0, 12);
        this.boldFont = new Font("MonoSpaced", 1, 12);
        this.italicFont = new Font("MonoSpaced", 2, 12);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.plainFont);
        int plainAscent = fm.getAscent();
        int plainDescent = fm.getDescent();
        int plainLeading = fm.getLeading();
        this.charWidth = fm.charWidth('a');
        fm = Toolkit.getDefaultToolkit().getFontMetrics(this.boldFont);
        int boldAscent = fm.getAscent();
        int boldDescent = fm.getDescent();
        int boldLeading = fm.getLeading();
        this.charAscent = plainAscent;
        if (boldAscent > this.charAscent) {
            this.charAscent = boldAscent;
        }
        this.charDescent = plainDescent;
        if (boldDescent > this.charDescent) {
            this.charDescent = boldDescent;
        }
        this.charLeading = plainLeading > 0 || boldLeading > 0 ? 1 : 0;
        boolean adjustAscent = false;
        boolean adjustDescent = false;
        boolean adjustLeading = false;
        if (this.charAscent + 0 >= 0) {
            this.charAscent += 0;
        }
        if (this.charDescent + 0 >= 0) {
            this.charDescent += 0;
        }
        if (this.charLeading + 0 >= 0) {
            this.charLeading += 0;
        }
        this.charHeight = this.charAscent + this.charDescent + this.charLeading;
        this.mX = this.charWidth * 4 + 4;
    }

    class UndoItem {
        String text;
        int cursorPos;

        UndoItem() {
        }
    }

    final class EditorContent {
        private static final int SPARE_CAPACITY = 128;
        private char[] buffer = new char[128];
        private int[] textInfo = new int[256];
        private int used;

        public final int length() {
            return this.used;
        }

        public final int capacity() {
            return this.buffer.length;
        }

        public final int charAt(int index) {
            if (index >= 0 && index < this.length()) {
                return this.buffer[index];
            }
            return -1;
        }

        public final boolean isNewLine(int index) {
            return this.buffer[index] == '\n';
        }

        public String subString(int begin, int length) {
            return new String(this.buffer, begin, length);
        }

        public void setCharAt(int index, char c) {
            this.buffer[index] = c;
        }

        public void ensureCapacity(int minimumCapacity) {
            if (this.buffer.length < minimumCapacity) {
                int newCapacity = this.buffer.length * 2 + 2;
                if (newCapacity < minimumCapacity) {
                    newCapacity = minimumCapacity;
                }
                char[] newBuffer = new char[newCapacity];
                int[] newTextInfo = new int[2 * newCapacity];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.used);
                System.arraycopy(this.textInfo, 0, newTextInfo, 0, 2 * this.used);
                this.buffer = newBuffer;
                this.textInfo = newTextInfo;
            }
        }

        public void setText(String s) {
            this.used = 0;
            this.append(s);
        }

        public EditorContent append(String s) {
            if (s == null) {
                s = "null";
            }
            int addedLength = s.length();
            int combinedLength = this.used + addedLength;
            this.ensureCapacity(combinedLength);
            s.getChars(0, addedLength, this.buffer, this.used);
            for (int i = 0; i < addedLength; ++i) {
                this.textInfo[2 * (this.used + i)] = JTextEditor.this.defaultColor.getRGB();
                this.textInfo[2 * (this.used + i) + 1] = 0;
            }
            this.used = combinedLength;
            return this;
        }

        public EditorContent append(char c) {
            if (this.used + 1 > this.buffer.length) {
                this.ensureCapacity(this.used + 1);
            }
            this.buffer[this.used] = c;
            this.textInfo[2 * this.used] = JTextEditor.this.defaultColor.getRGB();
            this.textInfo[2 * this.used + 1] = 0;
            ++this.used;
            return this;
        }

        public final String toString() {
            return new String(this.buffer, 0, this.used);
        }

        public void clearStyleAndColor() {
            int rgb = JTextEditor.this.defaultColor.getRGB();
            for (int i = 0; i < this.used; ++i) {
                this.textInfo[2 * i] = rgb;
                this.textInfo[2 * i + 1] = 0;
            }
        }

        public void setForeground(Color c, int start, int lgth) {
            int stop = start + lgth;
            int length = this.length();
            if (stop >= length) {
                stop = length;
            }
            if (start >= length) {
                start = length - 1;
            }
            int rgb = (c.getRed() & 0xFF) << 16 | (c.getGreen() & 0xFF) << 8 | c.getBlue();
            for (int i = start; i < stop; ++i) {
                this.textInfo[2 * i] = rgb;
            }
        }

        public int getForeground(int idx) {
            return this.textInfo[2 * idx];
        }

        public void setStyle(int style, int start, int lgth) {
            int stop = start + lgth;
            int length = this.length();
            if (stop >= length) {
                stop = length;
            }
            if (start >= length) {
                start = length - 1;
            }
            for (int i = start; i < stop; ++i) {
                this.textInfo[2 * i + 1] = style;
            }
        }

        public int getStyle(int idx) {
            return this.textInfo[2 * idx + 1];
        }

        public void remove(int idx, int length) {
            int over = this.length() - (idx + length);
            System.arraycopy(this.buffer, idx + length, this.buffer, idx, over);
            System.arraycopy(this.textInfo, 2 * (idx + length), this.textInfo, 2 * idx, 2 * over);
            this.used -= length;
        }

        public void insert(char c, int idx) {
            this.ensureCapacity(this.used + 1);
            if (idx >= this.length()) {
                this.append(c);
            } else {
                int over = this.length() - idx;
                System.arraycopy(this.buffer, idx, this.buffer, idx + 1, over);
                System.arraycopy(this.textInfo, 2 * idx, this.textInfo, 2 * idx + 2, 2 * over);
                this.buffer[idx] = c;
                this.textInfo[2 * idx] = JTextEditor.this.defaultColor.getRGB();
                this.textInfo[2 * idx + 1] = 0;
                ++this.used;
            }
        }

        public void insert(String s, int idx) {
            this.ensureCapacity(this.used + s.length());
            if (idx >= this.length()) {
                this.append(s);
            } else {
                int over = this.length() - idx;
                System.arraycopy(this.buffer, idx, this.buffer, idx + s.length(), over);
                System.arraycopy(this.textInfo, 2 * idx, this.textInfo, 2 * (idx + s.length()), 2 * over);
                for (int i = 0; i < s.length(); ++i) {
                    this.buffer[idx + i] = s.charAt(i);
                    this.textInfo[2 * (idx + i)] = JTextEditor.this.defaultColor.getRGB();
                    this.textInfo[2 * (idx + i) + 1] = 0;
                    ++this.used;
                }
            }
        }
    }
}

