/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive3.MultiChangeConfirmDlg;
import jive3.ProgressFrame;
import jive3.TaskPipeNode;

public class DevicePipePanel
extends JPanel
implements MouseListener,
ActionListener {
    private JTabbedPane tabPane;
    private JTable displayTable;
    private DefaultTableModel displayModel;
    private JTable descriptionTable;
    private DefaultTableModel descriptionModel;
    private JButton refreshButton;
    private JButton applyButton;
    private JPopupMenu tableMenu;
    private JMenuItem resetMenuItem;
    private JMenuItem resetLMenuItem;
    private JMenuItem resetULMenuItem;
    private JMenuItem resetCULMenuItem;
    private JMenuItem labelMenuItem;
    private JMenuItem descriptionMenuItem;
    private JTable selectedTable;
    private int[] selectedRows;
    private TaskPipeNode[] source = null;

    DevicePipePanel() {
        this.setLayout(new BorderLayout());
        this.displayModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DevicePipePanel.this.source.length;
                    int k = 0;
                    if (DevicePipePanel.this.source.length > 1) {
                        String name = (String)DevicePipePanel.this.displayModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("label");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DevicePipePanel.this.source.length, " for attribute " + name)) {
                            DevicePipePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating label");
                            }
                            for (int i = 0; i < DevicePipePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DevicePipePanel.this.source[i].getName() + "/label", ++k * 100 / nb);
                                DevicePipePanel.this.source[i].setLabel(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DevicePipePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.displayTable = new JTable(this.displayModel);
        this.displayTable.addMouseListener(this);
        JScrollPane displayView = new JScrollPane(this.displayTable);
        this.descriptionModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DevicePipePanel.this.source.length;
                    int k = 0;
                    if (DevicePipePanel.this.source.length > 1) {
                        String name = (String)DevicePipePanel.this.descriptionModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("description");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DevicePipePanel.this.source.length, " for attribute " + name)) {
                            DevicePipePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating description");
                            }
                            for (int i = 0; i < DevicePipePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DevicePipePanel.this.source[i].getName() + "/description", ++k * 100 / nb);
                                DevicePipePanel.this.source[i].setDescription(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DevicePipePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.descriptionTable = new JTable(this.descriptionModel);
        this.descriptionTable.addMouseListener(this);
        JScrollPane descriptionView = new JScrollPane(this.descriptionTable);
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(ATKConstant.labelFont);
        this.tabPane.add("Label", displayView);
        this.tabPane.add("Description", descriptionView);
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.tabPane.setBorder(b);
        this.add((Component)this.tabPane, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        btnPanel.add(this.refreshButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(!JiveUtils.readOnly);
        this.applyButton.addActionListener(this);
        btnPanel.add(this.applyButton);
        this.add((Component)btnPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.resetMenuItem = new JMenuItem("Reset to default value");
        this.resetMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetMenuItem);
        this.resetLMenuItem = new JMenuItem("Return to lib default value");
        this.resetLMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetLMenuItem);
        this.resetULMenuItem = new JMenuItem("Return to code/lib default value");
        this.resetULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetULMenuItem);
        this.resetCULMenuItem = new JMenuItem("Return to class/code/lib default value");
        this.resetCULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetCULMenuItem);
        this.labelMenuItem = new JMenuItem("Set label");
        this.labelMenuItem.addActionListener(this);
        this.tableMenu.add(this.labelMenuItem);
        this.descriptionMenuItem = new JMenuItem("Set description");
        this.descriptionMenuItem.addActionListener(this);
        this.tableMenu.add(this.descriptionMenuItem);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row;
        this.selectedTable = (JTable)e.getSource();
        if (e.getButton() == 3 && e.getClickCount() == 1 && !JiveUtils.readOnly && (row = this.getRowForLocation(e.getY())) != -1) {
            this.selectedTable.addRowSelectionInterval(row, row);
            this.selectedTable.setColumnSelectionInterval(0, this.selectedTable.getColumnCount() - 1);
            this.selectedRows = this.selectedTable.getSelectedRows();
            this.labelMenuItem.setVisible(false);
            this.descriptionMenuItem.setVisible(false);
            if (this.selectedTable == this.displayTable) {
                this.labelMenuItem.setVisible(true);
            } else if (this.selectedTable == this.descriptionTable) {
                this.descriptionMenuItem.setVisible(true);
            }
            this.resetLMenuItem.setVisible(true);
            this.resetULMenuItem.setVisible(true);
            this.resetCULMenuItem.setVisible(true);
            this.tableMenu.show(this.selectedTable, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.refreshButton) {
            this.refreshValue();
        } else if (src == this.resetMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.selectedTable == this.displayTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset label configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting label");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetDisplay(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset description for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetDescription(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (src == this.resetLMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.selectedTable == this.displayTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset label configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting label");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLDisplay(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset description to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLDescription(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (src == this.resetULMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.selectedTable == this.displayTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset label configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting label");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULDisplay(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset description to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULDescription(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (src == this.resetCULMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.selectedTable == this.displayTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset label configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting label");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULDisplay(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset description to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULDescription(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (src == this.labelMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter label", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("label");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating label");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setLabel(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.descriptionMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter description", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("description");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating description");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setDescription(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.applyButton) {
            String t;
            if (this.displayTable.isEditing()) {
                t = ((JTextField)this.displayTable.getEditorComponent()).getText();
                this.displayModel.setValueAt(t, this.displayTable.getEditingRow(), this.displayTable.getEditingColumn());
            }
            if (this.descriptionTable.isEditing()) {
                t = ((JTextField)this.descriptionTable.getEditorComponent()).getText();
                this.descriptionModel.setValueAt(t, this.descriptionTable.getEditingRow(), this.descriptionTable.getEditingColumn());
            }
        }
    }

    void setSource(TaskPipeNode[] src) {
        this.source = src;
        this.refreshValue();
    }

    private int getRowForLocation(int y) {
        boolean found = false;
        int i = 0;
        int h = 0;
        while (i < this.selectedTable.getRowCount() && !found) {
            found = y >= h && y <= h + this.selectedTable.getRowHeight(i);
            if (found) continue;
            h += this.selectedTable.getRowHeight(i);
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    private void refreshValue() {
        if (this.source != null) {
            this.source[0].browsePipeInfo();
            Object[] displayColName = new String[]{"Attribute name", "Label"};
            Object[][] displayInfo = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                displayInfo[i][0] = this.source[0].getAttName(i);
                displayInfo[i][1] = this.source[0].getLabel(i);
            }
            this.displayModel.setDataVector(displayInfo, displayColName);
            this.displayTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            Object[] descrColName = new String[]{"Attribute name", "Description"};
            Object[][] descrInfo = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                descrInfo[i][0] = this.source[0].getAttName(i);
                descrInfo[i][1] = this.source[0].getDescription(i);
            }
            this.descriptionModel.setDataVector(descrInfo, descrColName);
            this.descriptionTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            String title = this.source[0].getTitle();
            title = this.source.length == 1 ? title + " [" + this.source[0].getName() + "]" : title + " [" + this.source.length + " devices selected]";
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
            this.tabPane.setBorder(b);
        }
    }
}

