/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jive.JiveUtils;
import jive3.MultiChangeConfirmDlg;
import jive3.ProgressFrame;
import jive3.TaskAttributeNode;

public class DeviceAttributePanel
extends JPanel
implements MouseListener,
ActionListener {
    private JTabbedPane tabPane;
    private JTable alarmTable;
    private DefaultTableModel alarmModel;
    private JTable unitTable;
    private DefaultTableModel unitModel;
    private JTable rangeTable;
    private DefaultTableModel rangeModel;
    private JTable displayTable;
    private DefaultTableModel displayModel;
    private JTable descriptionTable;
    private DefaultTableModel descriptionModel;
    private JTable aliasTable;
    private DefaultTableModel aliasModel;
    private JButton refreshButton;
    private JButton applyButton;
    private JPopupMenu tableMenu;
    private JMenuItem resetMenuItem;
    private JMenuItem resetLMenuItem;
    private JMenuItem resetULMenuItem;
    private JMenuItem resetCULMenuItem;
    private JMenuItem alarmMinMenuItem;
    private JMenuItem alarmMaxMenuItem;
    private JMenuItem warningMinMenuItem;
    private JMenuItem warningMaxMenuItem;
    private JMenuItem deltaTMenuItem;
    private JMenuItem deltaValMenuItem;
    private JMenuItem rangeMinMenuItem;
    private JMenuItem rangeMaxMenuItem;
    private JMenuItem unitMenuItem;
    private JMenuItem displayUnitMenuItem;
    private JMenuItem standardUnitMenuItem;
    private JMenuItem labelMenuItem;
    private JMenuItem formatMenuItem;
    private JMenuItem descriptionMenuItem;
    private JTable selectedTable;
    private int[] selectedRows;
    private TaskAttributeNode[] source = null;

    DeviceAttributePanel() {
        this.setLayout(new BorderLayout());
        this.alarmModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceAttributePanel.this.source.length;
                    int k = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String name = (String)DeviceAttributePanel.this.alarmModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("min_alarm");
                                break;
                            }
                            case 2: {
                                propChange.add("max_alarm");
                                break;
                            }
                            case 3: {
                                propChange.add("min_warning");
                                break;
                            }
                            case 4: {
                                propChange.add("max_warning");
                                break;
                            }
                            case 5: {
                                propChange.add("delta_t");
                                break;
                            }
                            case 6: {
                                propChange.add("delta_val");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DeviceAttributePanel.this.source.length, " for attribute " + name)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/min_alarm", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setMinAlarm(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/max_alarm", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setMaxAlarm(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 3: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/min_warning", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setMinWarning(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 4: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/max_warning", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setMaxWarning(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 5: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/delta_t", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setDeltaT(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 6: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating alarm");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/delta_val", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setDeltaVal(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.alarmTable = new JTable(this.alarmModel);
        this.alarmTable.addMouseListener(this);
        JScrollPane alarmView = new JScrollPane(this.alarmTable);
        this.unitModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceAttributePanel.this.source.length;
                    int k = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String name = (String)DeviceAttributePanel.this.unitModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("unit");
                                break;
                            }
                            case 2: {
                                propChange.add("display_unit");
                                break;
                            }
                            case 3: {
                                propChange.add("standard_unit");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DeviceAttributePanel.this.source.length, " for attribute " + name)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating unit");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/unit", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setUnit(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating unit");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/display_unit", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setDisplayUnit(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 3: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating unit");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/standard_unit", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setStandardUnit(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.unitTable = new JTable(this.unitModel);
        this.unitTable.addMouseListener(this);
        JScrollPane unitView = new JScrollPane(this.unitTable);
        this.rangeModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceAttributePanel.this.source.length;
                    int k = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String name = (String)DeviceAttributePanel.this.rangeModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("min");
                                break;
                            }
                            case 2: {
                                propChange.add("max");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DeviceAttributePanel.this.source.length, " for attribute " + name)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating range");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/min", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setMin(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating range");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/max", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setMax(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.rangeTable = new JTable(this.rangeModel);
        this.rangeTable.addMouseListener(this);
        JScrollPane rangeView = new JScrollPane(this.rangeTable);
        this.displayModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceAttributePanel.this.source.length;
                    int k = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String name = (String)DeviceAttributePanel.this.displayModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("label");
                                break;
                            }
                            case 2: {
                                propChange.add("format");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DeviceAttributePanel.this.source.length, " for attribute " + name)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating label");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/label", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setLabel(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                            break;
                        }
                        case 2: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating format");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/format", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setFormat(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.displayTable = new JTable(this.displayModel);
        this.displayTable.addMouseListener(this);
        JScrollPane displayView = new JScrollPane(this.displayTable);
        this.descriptionModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceAttributePanel.this.source.length;
                    int k = 0;
                    if (DeviceAttributePanel.this.source.length > 1) {
                        String name = (String)DeviceAttributePanel.this.descriptionModel.getValueAt(row, 0);
                        Vector<String> propChange = new Vector<String>();
                        switch (column) {
                            case 1: {
                                propChange.add("description");
                            }
                        }
                        propChange.add((String)aValue);
                        if (!MultiChangeConfirmDlg.confirmChange(propChange, DeviceAttributePanel.this.source.length, " for attribute " + name)) {
                            DeviceAttributePanel.this.refreshValue();
                            return;
                        }
                    }
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                ProgressFrame.displayProgress("Updating description");
                            }
                            for (int i = 0; i < DeviceAttributePanel.this.source.length; ++i) {
                                ProgressFrame.setProgress("Updating " + DeviceAttributePanel.this.source[i].getName() + "/description", ++k * 100 / nb);
                                DeviceAttributePanel.this.source[i].setDescription(row, (String)aValue);
                            }
                            ProgressFrame.hideProgress();
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.descriptionTable = new JTable(this.descriptionModel);
        this.descriptionTable.addMouseListener(this);
        JScrollPane descriptionView = new JScrollPane(this.descriptionTable);
        this.aliasModel = new DefaultTableModel(){

            public Class getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && !JiveUtils.readOnly;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (!aValue.equals(this.getValueAt(row, column))) {
                    super.setValueAt(aValue, row, column);
                    int nb = DeviceAttributePanel.this.source.length;
                    boolean k = false;
                    switch (column) {
                        case 1: {
                            if (nb > 1) {
                                JiveUtils.showJiveError("Cannot apply attribute alias to multiple instance");
                            } else if (nb == 1) {
                                DeviceAttributePanel.this.source[0].setAlias(row, (String)aValue);
                            }
                            DeviceAttributePanel.this.refreshValue();
                        }
                    }
                }
            }
        };
        this.aliasTable = new JTable(this.aliasModel);
        this.aliasTable.addMouseListener(this);
        JScrollPane aliasView = new JScrollPane(this.aliasTable);
        this.tabPane = new JTabbedPane();
        this.tabPane.setFont(ATKConstant.labelFont);
        this.tabPane.add("Display", displayView);
        this.tabPane.add("Unit", unitView);
        this.tabPane.add("Range", rangeView);
        this.tabPane.add("Alarms", alarmView);
        this.tabPane.add("Description", descriptionView);
        this.tabPane.add("Alias", aliasView);
        TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "...");
        this.tabPane.setBorder(b);
        this.add((Component)this.tabPane, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(0));
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.addActionListener(this);
        btnPanel.add(this.refreshButton);
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(!JiveUtils.readOnly);
        this.applyButton.addActionListener(this);
        btnPanel.add(this.applyButton);
        this.add((Component)btnPanel, "South");
        this.tableMenu = new JPopupMenu();
        this.resetMenuItem = new JMenuItem("Reset to default value");
        this.resetMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetMenuItem);
        this.resetLMenuItem = new JMenuItem("Return to lib default value");
        this.resetLMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetLMenuItem);
        this.resetULMenuItem = new JMenuItem("Return to code/lib default value");
        this.resetULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetULMenuItem);
        this.resetCULMenuItem = new JMenuItem("Return to class/code/lib default value");
        this.resetCULMenuItem.addActionListener(this);
        this.tableMenu.add(this.resetCULMenuItem);
        this.alarmMinMenuItem = new JMenuItem("Set min alarm");
        this.alarmMinMenuItem.addActionListener(this);
        this.tableMenu.add(this.alarmMinMenuItem);
        this.alarmMaxMenuItem = new JMenuItem("Set max alarm");
        this.alarmMaxMenuItem.addActionListener(this);
        this.tableMenu.add(this.alarmMaxMenuItem);
        this.warningMinMenuItem = new JMenuItem("Set min warning");
        this.warningMinMenuItem.addActionListener(this);
        this.tableMenu.add(this.warningMinMenuItem);
        this.warningMaxMenuItem = new JMenuItem("Set max warning");
        this.warningMaxMenuItem.addActionListener(this);
        this.tableMenu.add(this.warningMaxMenuItem);
        this.deltaTMenuItem = new JMenuItem("Set delta time");
        this.deltaTMenuItem.addActionListener(this);
        this.tableMenu.add(this.deltaTMenuItem);
        this.deltaValMenuItem = new JMenuItem("Set delta value");
        this.deltaValMenuItem.addActionListener(this);
        this.tableMenu.add(this.deltaValMenuItem);
        this.rangeMinMenuItem = new JMenuItem("Set min");
        this.rangeMinMenuItem.addActionListener(this);
        this.tableMenu.add(this.rangeMinMenuItem);
        this.rangeMaxMenuItem = new JMenuItem("Set max");
        this.rangeMaxMenuItem.addActionListener(this);
        this.tableMenu.add(this.rangeMaxMenuItem);
        this.unitMenuItem = new JMenuItem("Set unit");
        this.unitMenuItem.addActionListener(this);
        this.tableMenu.add(this.unitMenuItem);
        this.displayUnitMenuItem = new JMenuItem("Set display unit");
        this.displayUnitMenuItem.addActionListener(this);
        this.tableMenu.add(this.displayUnitMenuItem);
        this.standardUnitMenuItem = new JMenuItem("Set standard unit");
        this.standardUnitMenuItem.addActionListener(this);
        this.tableMenu.add(this.standardUnitMenuItem);
        this.labelMenuItem = new JMenuItem("Set label");
        this.labelMenuItem.addActionListener(this);
        this.tableMenu.add(this.labelMenuItem);
        this.formatMenuItem = new JMenuItem("Set format");
        this.formatMenuItem.addActionListener(this);
        this.tableMenu.add(this.formatMenuItem);
        this.descriptionMenuItem = new JMenuItem("Set description");
        this.descriptionMenuItem.addActionListener(this);
        this.tableMenu.add(this.descriptionMenuItem);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row;
        this.selectedTable = (JTable)e.getSource();
        if (e.getButton() == 3 && e.getClickCount() == 1 && !JiveUtils.readOnly && (row = this.getRowForLocation(e.getY())) != -1) {
            this.selectedTable.addRowSelectionInterval(row, row);
            this.selectedTable.setColumnSelectionInterval(0, this.selectedTable.getColumnCount() - 1);
            this.selectedRows = this.selectedTable.getSelectedRows();
            this.alarmMinMenuItem.setVisible(false);
            this.alarmMaxMenuItem.setVisible(false);
            this.warningMinMenuItem.setVisible(false);
            this.warningMaxMenuItem.setVisible(false);
            this.deltaTMenuItem.setVisible(false);
            this.deltaValMenuItem.setVisible(false);
            this.rangeMinMenuItem.setVisible(false);
            this.rangeMaxMenuItem.setVisible(false);
            this.unitMenuItem.setVisible(false);
            this.displayUnitMenuItem.setVisible(false);
            this.standardUnitMenuItem.setVisible(false);
            this.labelMenuItem.setVisible(false);
            this.formatMenuItem.setVisible(false);
            this.descriptionMenuItem.setVisible(false);
            if (this.selectedTable == this.alarmTable) {
                this.alarmMinMenuItem.setVisible(true);
                this.alarmMaxMenuItem.setVisible(true);
                this.warningMinMenuItem.setVisible(true);
                this.warningMaxMenuItem.setVisible(true);
                this.deltaTMenuItem.setVisible(true);
                this.deltaValMenuItem.setVisible(true);
            } else if (this.selectedTable == this.unitTable) {
                this.unitMenuItem.setVisible(true);
                this.displayUnitMenuItem.setVisible(true);
                this.standardUnitMenuItem.setVisible(true);
            } else if (this.selectedTable == this.rangeTable) {
                this.rangeMinMenuItem.setVisible(true);
                this.rangeMaxMenuItem.setVisible(true);
            } else if (this.selectedTable == this.displayTable) {
                this.labelMenuItem.setVisible(true);
                this.formatMenuItem.setVisible(true);
            } else if (this.selectedTable == this.descriptionTable) {
                this.descriptionMenuItem.setVisible(true);
            }
            boolean isTango8 = true;
            for (int i = 0; isTango8 && i < this.source.length; ++i) {
                isTango8 = this.source[i].isTango8();
            }
            if (isTango8) {
                this.resetLMenuItem.setVisible(true);
                this.resetULMenuItem.setVisible(true);
                this.resetCULMenuItem.setVisible(true);
            } else {
                this.resetLMenuItem.setVisible(false);
                this.resetULMenuItem.setVisible(false);
                this.resetCULMenuItem.setVisible(false);
            }
            this.tableMenu.show(this.selectedTable, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.refreshButton) {
            this.refreshValue();
        } else if (src == this.resetMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.selectedTable == this.alarmTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset alarm configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting alarms");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetAlarms(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.unitTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset unit configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting units");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetUnit(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.rangeTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset range configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting ranges");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetRange(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.displayTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset display configuration for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting display");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetDisplay(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset description for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetDescription(this.selectedRows[i]);
                    }
                    this.source[j].restartDevice();
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.aliasTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset alias for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting alias");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.aliasModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].setAlias(this.selectedRows[i], "");
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (src == this.resetLMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.selectedTable == this.alarmTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset alarm configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting alarms");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLAlarms(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.unitTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset unit configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting units");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLUnit(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.rangeTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset range configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting ranges");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLRange(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.displayTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset display configuration to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting display");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLDisplay(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset description to library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetLDescription(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (src == this.resetULMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.selectedTable == this.alarmTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset alarm configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting alarms");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULAlarms(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.unitTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset unit configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting units");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULUnit(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.rangeTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset range configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting ranges");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULRange(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.displayTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset display configuration to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting display");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULDisplay(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset description to code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetULDescription(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (src == this.resetCULMenuItem) {
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.selectedTable == this.alarmTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset alarm configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting alarms");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULAlarms(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.unitTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset unit configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting units");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULUnit(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.rangeTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset range configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting ranges");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULRange(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.displayTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset display configuration to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting display");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULDisplay(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            } else if (this.selectedTable == this.descriptionTable) {
                String message;
                int result;
                if (this.source.length > 1 && (result = JOptionPane.showConfirmDialog(this, message = "You are going to reset description to class/code/library value for " + this.source.length + " device(s) and " + this.selectedRows.length + " attribute(s).\nDo you want to proceed ?", "Confirmation", 0, 2)) == 1) {
                    return;
                }
                if (nb > 1) {
                    ProgressFrame.displayProgress("Reseting description");
                }
                for (int j = 0; j < this.source.length; ++j) {
                    for (int i = 0; i < this.selectedRows.length; ++i) {
                        ProgressFrame.setProgress("Reseting " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                        this.source[j].resetCULDescription(this.selectedRows[i]);
                    }
                }
                ProgressFrame.hideProgress();
                this.refreshValue();
            }
        } else if (src == this.labelMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter label", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("label");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating label");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setLabel(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.formatMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter format", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("format");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating format");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.displayModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setFormat(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.unitMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter unit", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("unit");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating unit");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setUnit(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.displayUnitMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter display unit", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("display_unit");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating display unit");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setDisplayUnit(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.standardUnitMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter standard unit", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("standard_unit");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating standard unit");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.unitModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setStandardUnit(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.rangeMinMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter min", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("min");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating min");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setMin(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.rangeMaxMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter max", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("max");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating max");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.rangeModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setMax(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.alarmMinMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter min alarm", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("min_alarm");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating min alarm");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setMinAlarm(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.alarmMaxMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter max alarm", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("max_alarm");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating max alarm");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setMaxAlarm(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.warningMinMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter min warning", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("min_warning");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating min warning");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setMinWarning(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.warningMaxMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter max warning", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("max_warning");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating max warning");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setMaxWarning(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.deltaTMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter delta T", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("delta_t");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating delta T");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setDeltaT(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.deltaValMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter delta value", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("delta_val");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating delta value");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.alarmModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setDeltaVal(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.descriptionMenuItem) {
            String val = JOptionPane.showInputDialog(null, "Enter description", "");
            if (val == null) {
                return;
            }
            int nb = this.selectedRows.length * this.source.length;
            int k = 0;
            if (this.source.length > 1) {
                Vector<String> propChange = new Vector<String>();
                propChange.add("description");
                propChange.add(val);
                if (!MultiChangeConfirmDlg.confirmChange(propChange, this.source.length, " and " + this.selectedRows.length + " attribute(s)")) {
                    return;
                }
            }
            if (nb > 1) {
                ProgressFrame.displayProgress("Updating description");
            }
            for (int j = 0; j < this.source.length; ++j) {
                for (int i = 0; i < this.selectedRows.length; ++i) {
                    ProgressFrame.setProgress("Updating " + this.source[j].getName() + "/" + this.descriptionModel.getValueAt(this.selectedRows[i], 0), ++k * 100 / nb);
                    this.source[j].setDescription(this.selectedRows[i], val);
                }
            }
            ProgressFrame.hideProgress();
            this.refreshValue();
        } else if (src == this.applyButton) {
            String t;
            if (this.alarmTable.isEditing()) {
                t = ((JTextField)this.alarmTable.getEditorComponent()).getText();
                this.alarmModel.setValueAt(t, this.alarmTable.getEditingRow(), this.alarmTable.getEditingColumn());
            }
            if (this.unitTable.isEditing()) {
                t = ((JTextField)this.unitTable.getEditorComponent()).getText();
                this.unitModel.setValueAt(t, this.unitTable.getEditingRow(), this.unitTable.getEditingColumn());
            }
            if (this.rangeTable.isEditing()) {
                t = ((JTextField)this.rangeTable.getEditorComponent()).getText();
                this.rangeModel.setValueAt(t, this.rangeTable.getEditingRow(), this.rangeTable.getEditingColumn());
            }
            if (this.displayTable.isEditing()) {
                t = ((JTextField)this.displayTable.getEditorComponent()).getText();
                this.displayModel.setValueAt(t, this.displayTable.getEditingRow(), this.displayTable.getEditingColumn());
            }
            if (this.descriptionTable.isEditing()) {
                t = ((JTextField)this.descriptionTable.getEditorComponent()).getText();
                this.descriptionModel.setValueAt(t, this.descriptionTable.getEditingRow(), this.descriptionTable.getEditingColumn());
            }
            if (this.aliasTable.isEditing()) {
                t = ((JTextField)this.aliasTable.getEditorComponent()).getText();
                this.aliasModel.setValueAt(t, this.aliasTable.getEditingRow(), this.aliasTable.getEditingColumn());
            }
        }
    }

    void setSource(TaskAttributeNode[] src) {
        this.source = src;
        this.refreshValue();
    }

    private int getRowForLocation(int y) {
        boolean found = false;
        int i = 0;
        int h = 0;
        while (i < this.selectedTable.getRowCount() && !found) {
            found = y >= h && y <= h + this.selectedTable.getRowHeight(i);
            if (found) continue;
            h += this.selectedTable.getRowHeight(i);
            ++i;
        }
        if (found) {
            return i;
        }
        return -1;
    }

    private void refreshValue() {
        if (this.source != null) {
            this.source[0].browseAttributeInfo();
            Object[] alarmColName = new String[]{"Attribute name", "Min alarm", "Max alarm", "Min Warning", "Max Warning", "Delta t", "Delta val"};
            Object[][] alarmInfo = new Object[this.source[0].getAttributeNumber()][7];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                alarmInfo[i][0] = this.source[0].getAttName(i);
                alarmInfo[i][1] = this.source[0].getMinAlarm(i);
                alarmInfo[i][2] = this.source[0].getMaxAlarm(i);
                alarmInfo[i][3] = this.source[0].getMinWarning(i);
                alarmInfo[i][4] = this.source[0].getMaxWarning(i);
                alarmInfo[i][5] = this.source[0].getDeltaT(i);
                alarmInfo[i][6] = this.source[0].getDeltaVal(i);
            }
            this.alarmModel.setDataVector(alarmInfo, alarmColName);
            this.alarmTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] unitColName = new String[]{"Attribute name", "Unit", "Display Unit", "Standard Unit"};
            Object[][] unitInfo = new Object[this.source[0].getAttributeNumber()][4];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                unitInfo[i][0] = this.source[0].getAttName(i);
                unitInfo[i][1] = this.source[0].getUnit(i);
                unitInfo[i][2] = this.source[0].getDisplayUnit(i);
                unitInfo[i][3] = this.source[0].getStandardUnit(i);
            }
            this.unitModel.setDataVector(unitInfo, unitColName);
            this.unitTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] rangeColName = new String[]{"Attribute name", "Min value", "Max value"};
            Object[][] rangeInfo = new Object[this.source[0].getAttributeNumber()][3];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                rangeInfo[i][0] = this.source[0].getAttName(i);
                rangeInfo[i][1] = this.source[0].getMin(i);
                rangeInfo[i][2] = this.source[0].getMax(i);
            }
            this.rangeModel.setDataVector(rangeInfo, rangeColName);
            this.rangeTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] displayColName = new String[]{"Attribute name", "Label", "Format"};
            Object[][] displayInfo = new Object[this.source[0].getAttributeNumber()][3];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                displayInfo[i][0] = this.source[0].getAttName(i);
                displayInfo[i][1] = this.source[0].getLabel(i);
                displayInfo[i][2] = this.source[0].getFormat(i);
            }
            this.displayModel.setDataVector(displayInfo, displayColName);
            this.displayTable.getColumnModel().getColumn(0).setPreferredWidth(200);
            Object[] descrColName = new String[]{"Attribute name", "Description"};
            Object[][] descrInfo = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                descrInfo[i][0] = this.source[0].getAttName(i);
                descrInfo[i][1] = this.source[0].getDescription(i);
            }
            this.descriptionModel.setDataVector(descrInfo, descrColName);
            this.descriptionTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            Object[] aliasColName = new String[]{"Attribute name", "Alias"};
            Object[][] aliasInfo = new Object[this.source[0].getAttributeNumber()][2];
            for (int i = 0; i < this.source[0].getAttributeNumber(); ++i) {
                descrInfo[i][0] = this.source[0].getAttName(i);
                descrInfo[i][1] = this.source[0].getAlias(i);
            }
            this.aliasModel.setDataVector(descrInfo, aliasColName);
            this.aliasTable.getColumnModel().getColumn(1).setPreferredWidth(200);
            String title = this.source[0].getTitle();
            title = this.source.length == 1 ? title + " [" + this.source[0].getName() + "]" : title + " [" + this.source.length + " devices selected]";
            TitledBorder b = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title);
            this.tabPane.setBorder(b);
        }
    }
}

