/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceProxy;
import java.io.IOException;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.Action;
import jive3.DbFileWriter;
import jive3.TangoNode;
import jive3.TangoNodeRenderer;
import jive3.TaskDeviceAttributePropertyNode;
import jive3.TreePanel;

public class AttributeNode
extends TangoNode {
    private String devName;
    private TreePanel self;
    private Database db;

    AttributeNode(TreePanel self, String devName, Database db) {
        this.devName = devName;
        this.self = self;
        this.db = db;
    }

    @Override
    void populateNode() throws DevFailed {
        int i;
        String[] list = new String[]{};
        String[] devList = new String[]{};
        String[] dbList = new String[]{};
        int idl = 0;
        DeviceProxy ds = new DeviceProxy(this.devName);
        try {
            devList = ds.get_attribute_list();
            idl = ds.get_idl_version();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        dbList = this.db.get_device_attribute_list(this.devName);
        JiveUtils.sortList(list);
        for (i = 0; i < devList.length; ++i) {
            this.add(new TaskDeviceAttributePropertyNode(this.self, this.db, this.devName, devList[i], idl, false));
        }
        for (i = 0; i < dbList.length; ++i) {
            if (JiveUtils.contains(devList, dbList[i])) continue;
            this.add(new TaskDeviceAttributePropertyNode(this.self, this.db, this.devName, dbList[i], idl, true));
        }
    }

    @Override
    public Action[] getAction() {
        return new Action[]{TreePanel.getAction(0), TreePanel.getAction(43), TreePanel.getAction(1), TreePanel.getAction(30), TreePanel.getAction(44)};
    }

    @Override
    public void execAction(int actionNumber, boolean multipleCall) {
        switch (actionNumber) {
            case 30: {
                this.self.createEmptyAttributeProperty(this.devName);
                break;
            }
            case 0: {
                int nbAtt = this.getChildCount();
                JiveUtils.the_clipboard.clear();
                for (int i = 0; i < nbAtt; ++i) {
                    TaskDeviceAttributePropertyNode node = (TaskDeviceAttributePropertyNode)this.getChildAt(i);
                    String[][] props = node.getProperties();
                    for (int j = 0; j < props.length; ++j) {
                        if (props[j][0].equalsIgnoreCase("__value")) continue;
                        JiveUtils.the_clipboard.add(props[j][0], node.getAttributeName(), props[j][1]);
                    }
                }
                break;
            }
            case 43: {
                int nbAtt2 = this.getChildCount();
                JiveUtils.the_clipboard.clear();
                for (int i = 0; i < nbAtt2; ++i) {
                    TaskDeviceAttributePropertyNode node = (TaskDeviceAttributePropertyNode)this.getChildAt(i);
                    String[][] props = node.getProperties();
                    for (int j = 0; j < props.length; ++j) {
                        if (!props[j][0].equalsIgnoreCase("__value")) continue;
                        JiveUtils.the_clipboard.add(props[j][0], node.getAttributeName(), props[j][1]);
                    }
                }
                break;
            }
            case 1: {
                JiveUtils.the_clipboard.parse();
                for (int i = 0; i < JiveUtils.the_clipboard.getAttPropertyLength(); ++i) {
                    this.self.putAttributeProperty(this.devName, JiveUtils.the_clipboard.getAttName(i), JiveUtils.the_clipboard.getAttPropertyName(i), JiveUtils.the_clipboard.getAttPropertyValue(i));
                }
                break;
            }
            case 44: {
                try {
                    DbFileWriter.SaveDeviceAttributesProperties(this.devName);
                    break;
                }
                catch (DevFailed e) {
                    JiveUtils.showTangoError(e);
                    break;
                }
                catch (IOException e2) {
                    JiveUtils.showJiveError(e2.getMessage());
                }
            }
        }
    }

    @Override
    public String toString() {
        return "Attribute properties";
    }

    @Override
    public ImageIcon getIcon() {
        return TangoNodeRenderer.atticon;
    }
}

