/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Vector;
import jive.JiveUtils;

public class TangoFileReader {
    private final int NUMBER = 1;
    private final int STRING = 2;
    private final int COMA = 3;
    private final int COLON = 4;
    private final int SLASH = 5;
    private final int ASLASH = 6;
    private final int ARROW = 7;
    private final String[] lexical_word = new String[]{"NULL", "NUMBER", "STRING", "COMA", "COLON", "SLASH", "BackSLASH", "->"};
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    private char NextChar;
    private Database db;
    private boolean DELETE_ENTRY;
    private String word;

    public TangoFileReader(Database d) {
        this.db = d;
    }

    private void read_char(Reader f) throws IOException {
        this.CurrentChar = this.NextChar;
        this.NextChar = f.ready() ? (char)f.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    private void jump_line(Reader f) throws IOException {
        while (this.CurrentChar != '\n' && this.CurrentChar != '\u0000') {
            this.read_char(f);
        }
        this.read_char(f);
    }

    private void jump_space(Reader f) throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char(f);
        }
    }

    private String read_word(Reader f) throws IOException {
        StringBuffer ret_word = new StringBuffer();
        this.jump_space(f);
        while (this.CurrentChar == '#') {
            this.jump_line(f);
            this.jump_space(f);
        }
        if (this.CurrentChar == '/') {
            this.read_char(f);
            if (this.CurrentChar == '*') {
                boolean end = false;
                this.read_char(f);
                while (end) {
                    while (this.CurrentChar != '*') {
                        this.read_char(f);
                    }
                    this.read_char(f);
                    end = this.CurrentChar == '/';
                }
                this.read_char(f);
                this.jump_space(f);
            } else {
                return "/";
            }
        }
        this.StartLine = this.CrtLine;
        if (this.CurrentChar == ':' || this.CurrentChar == '/' || this.CurrentChar == ',' || this.CurrentChar == '\\' || this.CurrentChar == '-' && this.NextChar == '>') {
            if (this.CurrentChar != '-') {
                ret_word.append(this.CurrentChar);
            } else {
                ret_word.append(this.CurrentChar);
                this.read_char(f);
                ret_word.append(this.CurrentChar);
            }
            this.read_char(f);
            return ret_word.toString();
        }
        if (this.CurrentChar == '\"') {
            this.read_char(f);
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000' && this.CurrentChar != '\n') {
                ret_word.append(this.CurrentChar);
                this.read_char(f);
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException e = new IOException("String too long at line " + this.StartLine);
                throw e;
            }
            this.read_char(f);
            return ret_word.toString();
        }
        while (this.CurrentChar > ' ' && this.CurrentChar != ':' && this.CurrentChar != '/' && this.CurrentChar != '\\' && this.CurrentChar != ',' && (this.CurrentChar != '-' || this.NextChar != '>')) {
            ret_word.append(this.CurrentChar);
            this.read_char(f);
        }
        if (ret_word.length() == 0) {
            return null;
        }
        return ret_word.toString();
    }

    private FullWordInfo read_full_word(Reader f) throws IOException {
        FullWordInfo ret_word = new FullWordInfo();
        ret_word.word = "";
        ret_word.lex = 0;
        this.StartLine = this.CrtLine;
        this.jump_space(f);
        if (this.CurrentChar == ',' || this.CurrentChar == '\\') {
            ret_word.word = ret_word.word + this.CurrentChar;
            ret_word.lex = this.class_lex(ret_word.word);
            this.read_char(f);
            return ret_word;
        }
        if (this.CurrentChar == '\"') {
            boolean eos;
            this.read_char(f);
            boolean bl = eos = this.CurrentChar == '\"' || this.CurrentChar == '\u0000' || this.CurrentChar == '\n';
            while (!eos) {
                if (this.CurrentChar == '\\' && this.NextChar == '\"') {
                    ret_word.word = ret_word.word + '\"';
                    this.read_char(f);
                    this.read_char(f);
                } else if (this.CurrentChar == '\\' && this.NextChar == '\\') {
                    ret_word.word = ret_word.word + '\\';
                    this.read_char(f);
                    this.read_char(f);
                } else {
                    ret_word.word = ret_word.word + this.CurrentChar;
                    this.read_char(f);
                }
                eos = this.CurrentChar == '\"' || this.CurrentChar == '\u0000' || this.CurrentChar == '\n';
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException e = new IOException("String too long at line " + this.StartLine);
                throw e;
            }
            this.read_char(f);
            ret_word.lex = 2;
            return ret_word;
        }
        while (this.CurrentChar > ' ' && this.CurrentChar != '\\' && this.CurrentChar != ',') {
            ret_word.word = ret_word.word + this.CurrentChar;
            this.read_char(f);
        }
        if (ret_word.word.length() == 0) {
            return null;
        }
        ret_word.lex = this.class_lex(ret_word.word);
        return ret_word;
    }

    private int class_lex(String word) {
        if (word == null) {
            return 0;
        }
        if (word.length() == 0) {
            return 2;
        }
        if (word.equals("/")) {
            return 5;
        }
        if (word.equals("\\")) {
            return 6;
        }
        if (word.equals(",")) {
            return 3;
        }
        if (word.equals(":")) {
            return 4;
        }
        if (word.equals("->")) {
            return 7;
        }
        return 2;
    }

    private DbDatum[] makeDbDatum(String prop_name, String[] value) {
        DbDatum[] ret = new DbDatum[1];
        this.DELETE_ENTRY = false;
        if (value.length == 0) {
            throw new IllegalStateException("Unexpected empty value");
        }
        if (value.length == 1) {
            ret[0] = new DbDatum(prop_name, value[0]);
            this.DELETE_ENTRY = value[0].compareTo("%") == 0;
        } else {
            ret[0] = new DbDatum(prop_name, value);
        }
        return ret;
    }

    private void checkAttDatum(String[] value) {
        this.DELETE_ENTRY = false;
        if (value.length == 0) {
            throw new IllegalStateException("Unexpected empty value");
        }
        if (value.length == 1) {
            this.DELETE_ENTRY = value[0].compareTo("%") == 0;
        }
    }

    private String prtValue(String[] value) {
        String ret = ": ";
        for (int j = 0; j < value.length; ++j) {
            ret = ret + value[j];
            if (j >= value.length - 1) continue;
            ret = ret + ',';
        }
        return ret;
    }

    private boolean compareResValue(String dbValue, String[] fileValue) {
        String fileValueStr = JiveUtils.stringArrayToString(fileValue);
        return fileValueStr.compareTo(dbValue) == 0;
    }

    private boolean compareResValue(String[] dbValue, String[] fileValue) {
        String dbValueStr = JiveUtils.stringArrayToString(dbValue);
        String fileValueStr = JiveUtils.stringArrayToString(fileValue);
        return fileValueStr.compareTo(dbValueStr) == 0;
    }

    private void put_tango_dev_attr_prop(String devname, String att_name, String prop_name, String[] arr) throws DevFailed {
        this.checkAttDatum(arr);
        if (prop_name.equals("__alias")) {
            if (!this.DELETE_ENTRY) {
                this.db.put_attribute_alias(devname + "/" + att_name, arr[0]);
            }
            return;
        }
        DbAttribute att = new DbAttribute(att_name);
        if (arr.length == 0) {
            throw new IllegalStateException("Unexpected empty value");
        }
        if (arr.length == 1) {
            att.add(prop_name, arr[0]);
        } else {
            att.add(prop_name, arr);
        }
        if (this.DELETE_ENTRY) {
            this.db.delete_device_attribute_property(devname, att);
        } else {
            this.db.put_device_attribute_property(devname, att);
        }
    }

    private void check_tango_dev_attr_prop(String devname, String att_name, String prop_name, String[] arr, Vector diff) throws DevFailed {
        if (arr.length == 1 && arr[0].compareTo("%") == 0 || prop_name.equals("__alias")) {
            return;
        }
        String dbValue = "";
        DbAttribute att = this.db.get_device_attribute_property(devname, att_name);
        if (!att.isEmpty()) {
            dbValue = att.get_string_value(prop_name);
        }
        if (dbValue == null) {
            dbValue = "";
        }
        if (!this.compareResValue(dbValue, arr)) {
            diff.add(devname + "/" + att_name + "->" + prop_name);
            diff.add(dbValue);
            diff.add(JiveUtils.stringArrayToString(arr));
        }
    }

    private void put_tango_class_attr_prop(String classname, String att_name, String prop_name, String[] arr) throws DevFailed {
        this.checkAttDatum(arr);
        DbAttribute att = new DbAttribute(att_name);
        if (arr.length == 0) {
            throw new IllegalStateException("Unexpected empty value");
        }
        if (arr.length == 1) {
            att.add(prop_name, arr[0]);
        } else {
            att.add(prop_name, arr);
        }
        if (!this.DELETE_ENTRY) {
            this.db.put_class_attribute_property(classname, att);
        }
    }

    private void check_tango_class_attr_prop(String classname, String att_name, String prop_name, String[] arr, Vector diff) throws DevFailed {
        if (arr.length == 1 && arr[0].compareTo("%") == 0) {
            return;
        }
        String dbValue = "";
        DbAttribute att = this.db.get_class_attribute_property(classname, att_name);
        if (!att.isEmpty()) {
            dbValue = att.get_string_value(prop_name);
        }
        if (!this.compareResValue(dbValue, arr)) {
            diff.add("CLASS/" + classname + "/" + att_name + "->" + prop_name);
            diff.add(dbValue);
            diff.add(JiveUtils.stringArrayToString(arr));
        }
    }

    private void put_tango_res(String devname, String resname, String[] arr) throws DevFailed {
        if (resname.equals("__alias")) {
            if (!this.DELETE_ENTRY) {
                this.db.put_device_alias(devname, arr[0]);
            }
            return;
        }
        DbDatum[] d = this.makeDbDatum(resname, arr);
        if (this.DELETE_ENTRY) {
            this.db.delete_device_property(devname, d);
        } else {
            this.db.put_device_property(devname, d);
        }
    }

    private void check_tango_res(String devname, String resname, String[] arr, Vector diff) throws DevFailed {
        if (arr.length == 1 && arr[0].compareTo("%") == 0) {
            return;
        }
        String[] res = this.db.get_device_property(devname, resname).extractStringArray();
        if (!this.compareResValue(res, arr)) {
            diff.add(devname + "->" + resname);
            diff.add(JiveUtils.stringArrayToString(res));
            diff.add(JiveUtils.stringArrayToString(arr));
        }
    }

    private void put_free_tango_res(String freename, String resname, String[] arr) throws DevFailed {
        DbDatum[] d = this.makeDbDatum(resname, arr);
        if (this.DELETE_ENTRY) {
            this.db.delete_property(freename, d);
        } else {
            this.db.put_property(freename, d);
        }
    }

    private void check_free_tango_res(String freename, String resname, String[] arr, Vector diff) throws DevFailed {
        if (arr.length == 1 && arr[0].compareTo("%") == 0) {
            return;
        }
        String[] res = this.db.get_property(freename, resname).extractStringArray();
        if (!this.compareResValue(res, arr)) {
            diff.add("FREE/" + freename + "->" + resname);
            diff.add(JiveUtils.stringArrayToString(res));
            diff.add(JiveUtils.stringArrayToString(arr));
        }
    }

    private void put_tango_res_class(String classname, String resname, String[] arr) throws DevFailed {
        DbDatum[] d = this.makeDbDatum(resname, arr);
        if (this.DELETE_ENTRY) {
            this.db.delete_class_property(classname, d);
        } else {
            this.db.put_class_property(classname, d);
        }
    }

    private void check_tango_res_class(String classname, String resname, String[] arr, Vector diff) throws DevFailed {
        if (arr.length == 1 && arr[0].compareTo("%") == 0) {
            return;
        }
        String[] res = this.db.get_class_property(classname, resname).extractStringArray();
        if (!this.compareResValue(res, arr)) {
            diff.add("CLASS/" + classname + "->" + resname);
            diff.add(JiveUtils.stringArrayToString(res));
            diff.add(JiveUtils.stringArrayToString(arr));
        }
    }

    private boolean IsMember(String dev_name, String[] list) {
        int i = 0;
        boolean found = false;
        while (i < list.length && !found) {
            found = list[i].equalsIgnoreCase(dev_name);
            if (found) continue;
            ++i;
        }
        return found;
    }

    private void add_tango_devices(String _class, String server, String[] arr) throws DevFailed {
        int i;
        String[] dev_list = this.db.get_device_name(server, _class);
        for (i = 0; i < arr.length; ++i) {
            if (this.IsMember(arr[i], dev_list)) continue;
            this.db.add_device(arr[i], _class, server);
        }
        for (i = 0; i < dev_list.length; ++i) {
            if (this.IsMember(dev_list[i], arr)) continue;
            this.db.delete_device(dev_list[i]);
        }
    }

    private void check_tango_devices(String _class, String server, String[] arr, Vector diff) throws DevFailed {
        String[] dev_list = this.db.get_device_name(server, _class);
        if (dev_list.length != arr.length) {
            diff.add(server + "/device/" + _class);
            diff.add(JiveUtils.stringArrayToString(dev_list));
            diff.add(JiveUtils.stringArrayToString(arr));
            return;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (this.IsMember(arr[i], dev_list)) continue;
            diff.add(server + "/device/" + _class);
            diff.add(JiveUtils.stringArrayToString(dev_list));
            diff.add(JiveUtils.stringArrayToString(arr));
            return;
        }
    }

    private void CHECK_LEX(int lt, int le) {
        if (lt != le) {
            throw new IllegalStateException("Error at line " + this.StartLine + ", " + this.lexical_word[le] + " expected");
        }
    }

    private String[] parse_resource_value(Reader f) throws IOException {
        Vector<String> values = new Vector<String>();
        int lex = 3;
        while ((lex == 3 || lex == 6) && this.word != null) {
            FullWordInfo wi = this.read_full_word(f);
            if (wi.lex == 6) {
                wi = this.read_full_word(f);
            }
            this.CHECK_LEX(wi.lex, 2);
            values.add(wi.word);
            this.word = this.read_word(f);
            lex = this.class_lex(this.word);
        }
        return (String[])Arrays.copyOf(values.toArray(), values.size(), String[].class);
    }

    public String check_res_file(String file_name, Vector diff) {
        boolean eof = false;
        this.CrtLine = 1;
        this.NextChar = (char)32;
        this.CurrentChar = (char)32;
        try {
            FileReader f = new FileReader(file_name);
            this.word = this.read_word(f);
            if (this.word == null) {
                return file_name + " is empty...";
            }
            int lex = this.class_lex(this.word);
            while (!eof) {
                block1 : switch (lex) {
                    case 2: {
                        String domain = this.word;
                        this.word = this.read_word(f);
                        lex = this.class_lex(this.word);
                        this.CHECK_LEX(lex, 5);
                        this.word = this.read_word(f);
                        lex = this.class_lex(this.word);
                        this.CHECK_LEX(lex, 2);
                        String family = this.word;
                        this.word = this.read_word(f);
                        lex = this.class_lex(this.word);
                        switch (lex) {
                            case 5: {
                                String[] values;
                                this.word = this.read_word(f);
                                lex = this.class_lex(this.word);
                                this.CHECK_LEX(lex, 2);
                                String member = this.word;
                                this.word = this.read_word(f);
                                lex = this.class_lex(this.word);
                                switch (lex) {
                                    case 5: {
                                        String prop_name;
                                        this.word = this.read_word(f);
                                        lex = this.class_lex(this.word);
                                        this.CHECK_LEX(lex, 2);
                                        String name = this.word;
                                        this.word = this.read_word(f);
                                        lex = this.class_lex(this.word);
                                        switch (lex) {
                                            case 4: {
                                                if (member.equalsIgnoreCase("device")) {
                                                    values = this.parse_resource_value(f);
                                                    lex = this.class_lex(this.word);
                                                    this.check_tango_devices(name, domain + "/" + family, values, diff);
                                                    break block1;
                                                }
                                                return "Invalid syntax (may be -> should be used instead of COLON) at line " + this.StartLine;
                                            }
                                            case 7: {
                                                this.word = this.read_word(f);
                                                lex = this.class_lex(this.word);
                                                this.CHECK_LEX(lex, 2);
                                                prop_name = this.word;
                                                this.word = this.read_word(f);
                                                lex = this.class_lex(this.word);
                                                this.CHECK_LEX(lex, 4);
                                                values = this.parse_resource_value(f);
                                                lex = this.class_lex(this.word);
                                                this.check_tango_dev_attr_prop(domain + "/" + family + "/" + member, name, prop_name, values, diff);
                                                break block1;
                                            }
                                        }
                                        return "COLON or -> expected at line " + this.StartLine;
                                    }
                                    case 7: {
                                        this.word = this.read_word(f);
                                        lex = this.class_lex(this.word);
                                        this.CHECK_LEX(lex, 2);
                                        String prop_name = this.word;
                                        this.word = this.read_word(f);
                                        lex = this.class_lex(this.word);
                                        if (lex == 5) {
                                            this.word = this.read_word(f);
                                            lex = this.class_lex(this.word);
                                            this.CHECK_LEX(lex, 2);
                                            prop_name = prop_name + "/" + this.word;
                                            this.word = this.read_word(f);
                                            lex = this.class_lex(this.word);
                                        }
                                        this.CHECK_LEX(lex, 4);
                                        values = this.parse_resource_value(f);
                                        lex = this.class_lex(this.word);
                                        if (domain.equalsIgnoreCase("class")) {
                                            this.check_tango_class_attr_prop(family, member, prop_name, values, diff);
                                            break block1;
                                        }
                                        this.check_tango_res(domain + "/" + family + "/" + member, prop_name, values, diff);
                                        break block1;
                                    }
                                }
                                return "SLASH or -> expected at line " + this.StartLine;
                            }
                            case 7: {
                                this.word = this.read_word(f);
                                lex = this.class_lex(this.word);
                                this.CHECK_LEX(lex, 2);
                                String member = this.word;
                                this.word = this.read_word(f);
                                lex = this.class_lex(this.word);
                                String[] values = this.parse_resource_value(f);
                                lex = this.class_lex(this.word);
                                if (domain.equalsIgnoreCase("class")) {
                                    this.check_tango_res_class(family, member, values, diff);
                                    break block1;
                                }
                                if (domain.equalsIgnoreCase("free")) {
                                    this.check_free_tango_res(family, member, values, diff);
                                    break block1;
                                }
                                return "Invlalid class property syntax on " + domain + "/" + family + "/" + member;
                            }
                        }
                        return "SLASH or -> expected at line " + this.StartLine;
                    }
                    default: {
                        return "Invalid resource name get " + this.lexical_word[lex] + " instead of STRING al line " + this.StartLine;
                    }
                }
                eof = this.word == null;
            }
            return "";
        }
        catch (Exception ex) {
            if (ex instanceof DevFailed) {
                String result = "";
                DevFailed e = (DevFailed)((Object)ex);
                for (int i = 0; i < e.errors.length; ++i) {
                    result = result + "Desc -> " + e.errors[i].desc + "\n";
                    result = result + "Reason -> " + e.errors[i].reason + "\n";
                    result = result + "Origin -> " + e.errors[i].origin + "\n";
                }
                return result;
            }
            if (ex instanceof NullPointerException) {
                ex.printStackTrace();
                return "NullPointerException";
            }
            return ex.getMessage();
        }
    }

    public String parse_res_file(String file_name) {
        boolean eof = false;
        this.CrtLine = 1;
        this.NextChar = (char)32;
        this.CurrentChar = (char)32;
        try {
            FileReader f = new FileReader(file_name);
            this.word = this.read_word(f);
            if (this.word == null) {
                return file_name + " is empty...";
            }
            int lex = this.class_lex(this.word);
            while (!eof) {
                block1 : switch (lex) {
                    case 2: {
                        String domain = this.word;
                        this.word = this.read_word(f);
                        lex = this.class_lex(this.word);
                        this.CHECK_LEX(lex, 5);
                        this.word = this.read_word(f);
                        lex = this.class_lex(this.word);
                        this.CHECK_LEX(lex, 2);
                        String family = this.word;
                        this.word = this.read_word(f);
                        lex = this.class_lex(this.word);
                        switch (lex) {
                            case 5: {
                                String[] values;
                                this.word = this.read_word(f);
                                lex = this.class_lex(this.word);
                                this.CHECK_LEX(lex, 2);
                                String member = this.word;
                                this.word = this.read_word(f);
                                lex = this.class_lex(this.word);
                                switch (lex) {
                                    case 5: {
                                        String prop_name;
                                        this.word = this.read_word(f);
                                        lex = this.class_lex(this.word);
                                        this.CHECK_LEX(lex, 2);
                                        String name = this.word;
                                        this.word = this.read_word(f);
                                        lex = this.class_lex(this.word);
                                        switch (lex) {
                                            case 4: {
                                                if (member.equalsIgnoreCase("device")) {
                                                    values = this.parse_resource_value(f);
                                                    lex = this.class_lex(this.word);
                                                    this.add_tango_devices(name, domain + "/" + family, values);
                                                    break block1;
                                                }
                                                return "Invalid syntax (may be -> should be used instead of COLON) at line " + this.StartLine;
                                            }
                                            case 7: {
                                                this.word = this.read_word(f);
                                                lex = this.class_lex(this.word);
                                                this.CHECK_LEX(lex, 2);
                                                prop_name = this.word;
                                                this.word = this.read_word(f);
                                                lex = this.class_lex(this.word);
                                                this.CHECK_LEX(lex, 4);
                                                values = this.parse_resource_value(f);
                                                lex = this.class_lex(this.word);
                                                this.put_tango_dev_attr_prop(domain + "/" + family + "/" + member, name, prop_name, values);
                                                break block1;
                                            }
                                        }
                                        return "COLON or -> expected at line " + this.StartLine;
                                    }
                                    case 7: {
                                        this.word = this.read_word(f);
                                        lex = this.class_lex(this.word);
                                        this.CHECK_LEX(lex, 2);
                                        String prop_name = this.word;
                                        this.word = this.read_word(f);
                                        lex = this.class_lex(this.word);
                                        if (lex == 5) {
                                            this.word = this.read_word(f);
                                            lex = this.class_lex(this.word);
                                            this.CHECK_LEX(lex, 2);
                                            prop_name = prop_name + "/" + this.word;
                                            this.word = this.read_word(f);
                                            lex = this.class_lex(this.word);
                                        }
                                        this.CHECK_LEX(lex, 4);
                                        values = this.parse_resource_value(f);
                                        lex = this.class_lex(this.word);
                                        if (domain.equalsIgnoreCase("class")) {
                                            this.put_tango_class_attr_prop(family, member, prop_name, values);
                                            break block1;
                                        }
                                        this.put_tango_res(domain + "/" + family + "/" + member, prop_name, values);
                                        break block1;
                                    }
                                }
                                return "SLASH or -> expected at line " + this.StartLine;
                            }
                            case 7: {
                                this.word = this.read_word(f);
                                lex = this.class_lex(this.word);
                                this.CHECK_LEX(lex, 2);
                                String member = this.word;
                                this.word = this.read_word(f);
                                lex = this.class_lex(this.word);
                                String[] values = this.parse_resource_value(f);
                                lex = this.class_lex(this.word);
                                if (domain.equalsIgnoreCase("class")) {
                                    this.put_tango_res_class(family, member, values);
                                    break block1;
                                }
                                if (domain.equalsIgnoreCase("free")) {
                                    this.put_free_tango_res(family, member, values);
                                    break block1;
                                }
                                return "Invlalid class property syntax on " + domain + "/" + family + "/" + member;
                            }
                        }
                        return "SLASH or -> expected at line " + this.StartLine;
                    }
                    default: {
                        return "Invalid resource name get " + this.lexical_word[lex] + " instead of STRING al line " + this.StartLine;
                    }
                }
                eof = this.word == null;
            }
            return "";
        }
        catch (Exception ex) {
            if (ex instanceof DevFailed) {
                String result = "";
                DevFailed e = (DevFailed)((Object)ex);
                for (int i = 0; i < e.errors.length; ++i) {
                    result = result + "Desc -> " + e.errors[i].desc + "\n";
                    result = result + "Reason -> " + e.errors[i].reason + "\n";
                    result = result + "Origin -> " + e.errors[i].origin + "\n";
                }
                return result;
            }
            return ex.getMessage();
        }
    }

    class FullWordInfo {
        String word;
        int lex;

        FullWordInfo() {
        }
    }
}

