/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import jive.DevItem;
import jive.JiveUtils;

public class MultiLineCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final Font TABLE_FONT = new Font("Dialog", 0, 12);
    private static final Font TABLE_FONT_BOLD = new Font("Dialog", 1, 12);
    private static BufferedImage arrowButton = null;
    Color selColor = new Color(200, 200, 255);
    Border selBorder = BorderFactory.createLineBorder(this.selColor);
    private boolean doBold = false;
    private boolean doSelection = false;
    private Vector items;
    private boolean hasDevice = false;
    private boolean doDevice = true;

    public MultiLineCellRenderer() {
        this.setLayout(null);
        this.setEditable(false);
        this.setLineWrap(false);
        this.setWrapStyleWord(false);
        this.items = new Vector();
        if (arrowButton == null) {
            try {
                arrowButton = ImageIO.read(MultiLineCellRenderer.class.getResource("/jive/arrow_btn.gif"));
            }
            catch (IOException e) {
                System.out.println("Warning, /jive/arrow_btn.gif is missing");
            }
        }
    }

    public MultiLineCellRenderer(boolean doBold, boolean doSelection, boolean doDevice) {
        this();
        this.doBold = doBold;
        this.doSelection = doSelection;
        this.doDevice = doDevice;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean selectable = true;
        if (value instanceof String) {
            if (this.doBold) {
                String str = (String)value;
                if (str.startsWith("/B")) {
                    this.setFont(TABLE_FONT_BOLD);
                    this.setText(str.substring(2));
                    selectable = false;
                } else {
                    this.setFont(TABLE_FONT);
                    this.setText(str);
                }
            } else {
                this.setText((String)value);
            }
        } else {
            this.setText("");
        }
        if (this.doSelection && selectable) {
            int[] selRows = table.getSelectedRows();
            if (JiveUtils.contains(selRows, row) && column == 0) {
                this.setBackground(this.selColor);
            } else {
                this.setBackground(Color.WHITE);
            }
            if (isSelected && column >= 1) {
                this.setBorder(this.selBorder);
            } else {
                this.setBorder(null);
            }
        } else {
            this.setBackground(Color.WHITE);
            this.setBorder(null);
        }
        return this;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (!this.doDevice) {
            return;
        }
        this.items.clear();
        if (text.length() == 0) {
            this.hasDevice = false;
            return;
        }
        String[] lines = JiveUtils.makeStringArray(text);
        int y = 0;
        boolean hasDev = false;
        for (int i = 0; i < lines.length; ++i) {
            boolean isDev = JiveUtils.isDeviceName(lines[i]);
            Dimension d = ATKGraphicsUtils.measureString((String)lines[i], (Font)this.getFont());
            DevItem di = new DevItem();
            di.str = lines[i];
            di.x = 16;
            di.y = y + 1;
            di.h = d.height - 2;
            di.isDevice = isDev;
            this.items.add(di);
            y += d.height + 1;
            if (!isDev) continue;
            hasDev = true;
        }
        this.hasDevice = hasDev;
    }

    public boolean hasDevice() {
        return this.hasDevice;
    }

    public String getDevice(int x, int y) {
        int i = 0;
        boolean found = false;
        while (!found && i < this.items.size()) {
            DevItem di = (DevItem)this.items.get(i);
            found = x < di.x - 2 && x > 2 && y > di.y + 2 && y < di.y + 2 + di.h;
            if (found) continue;
            ++i;
        }
        if (found) {
            String devName = ((DevItem)this.items.get((int)i)).str;
            if (devName.startsWith("tango:")) {
                return devName.substring(6);
            }
            return devName;
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        if (!this.hasDevice) {
            super.paint(g);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            g2.setFont(this.getFont());
            g2.setColor(this.getForeground());
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            for (int i = 0; i < this.items.size(); ++i) {
                DevItem di = (DevItem)this.items.get(i);
                g2.drawString(di.str, di.x, di.y + di.h - 1);
                if (!di.isDevice) continue;
                g.drawImage(arrowButton, 2, di.y + 2, null);
            }
        }
    }
}

