/*
 * Decompiled with CFR 0.152.
 */
package jive;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import jive.ClipboardDlg;
import jive.Item;
import jive.JiveUtils;

public class Clipboard {
    java.awt.datatransfer.Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private Vector Obj_Items = new Vector();
    private Vector Att_Items = new Vector();
    private Vector Srv_Items = new Vector();
    private Reader theStream;
    private char nextNextChar;
    private char nextChar;
    private char currentChar;
    private boolean backSlashed;

    private void read_char() {
        this.backSlashed = false;
        try {
            int c = this.theStream.read();
            this.currentChar = this.nextChar;
            this.nextChar = this.nextNextChar;
            this.nextNextChar = c < 0 ? (char)'\u0000' : (char)c;
        }
        catch (Exception e) {
            this.nextNextChar = '\u0000';
            this.nextChar = '\u0000';
            this.currentChar = '\u0000';
        }
        if (this.currentChar == '\\' && this.nextChar == '\"') {
            this.read_char();
            this.backSlashed = true;
        }
    }

    private void jump_space() {
        while (this.currentChar <= ' ' && this.currentChar > '\u0000') {
            this.read_char();
        }
    }

    private String read_word() throws IOException {
        StringBuffer ret_word = new StringBuffer();
        this.jump_space();
        if (this.currentChar == ',' || this.currentChar == ':' || this.currentChar == '/') {
            ret_word.append(this.currentChar);
            this.read_char();
            return ret_word.toString();
        }
        if (this.currentChar == '\"' && !this.backSlashed) {
            this.read_char();
            while ((this.currentChar != '\"' || this.backSlashed) && this.currentChar != '\u0000' && this.currentChar != '\n') {
                ret_word.append(this.currentChar);
                this.read_char();
            }
            if (this.currentChar == '\u0000' || this.currentChar == '\n') {
                IOException e = new IOException("Unterminated string.");
                throw e;
            }
            this.read_char();
            return ret_word.toString();
        }
        while (this.currentChar > ' ' && this.currentChar != ',' && this.currentChar != ':' && this.currentChar != '/') {
            ret_word.append(this.currentChar);
            this.read_char();
        }
        if (ret_word.length() == 0) {
            return null;
        }
        return ret_word.toString();
    }

    private void jump_sep(String sep) throws IOException {
        String w = this.read_word();
        if (w == null) {
            throw new IOException("Separator " + sep + " expected.");
        }
        if (!w.equals(sep)) {
            throw new IOException("Separator " + sep + " expected.");
        }
    }

    Clipboard() {
    }

    private String quoteValue(String value) {
        if (value.length() == 0) {
            return "\"\"";
        }
        if (value.indexOf(34) >= 0) {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == '\"') {
                    b.append('\\');
                }
                b.append(value.charAt(i));
            }
            value = b.toString();
        }
        if (value.indexOf(32) >= 0 || value.indexOf(44) >= 0 || value.indexOf(58) >= 0 || value.indexOf(47) >= 0) {
            return "\"" + value + "\"";
        }
        return value;
    }

    private String getCommaSeparatedValue(String value) {
        String[] split_value = value.split("\n");
        String ret = "";
        for (int i = 0; i < split_value.length; ++i) {
            ret = ret + this.quoteValue(split_value[i]);
            if (i + 1 >= split_value.length) continue;
            ret = ret + ",";
        }
        return ret;
    }

    private String getClipboardContent() {
        String ret = "";
        java.awt.datatransfer.Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            ret = (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException e1) {
            JiveUtils.showJiveError("Clipboard error :" + e1.getMessage());
        }
        catch (IOException e2) {
            JiveUtils.showJiveError("Clipboard error :" + e2.getMessage());
        }
        return ret;
    }

    public void add(String prop_name, String value) {
        String content = this.getClipboardContent();
        content = content + "OBJ_PROPERTY:" + this.quoteValue(prop_name) + ": " + this.getCommaSeparatedValue(value) + "\n";
        StringSelection stringSelection = new StringSelection(content);
        this.clipboard.setContents(stringSelection, null);
    }

    public void add(String prop_name, String att_name, String value) {
        String content = this.getClipboardContent();
        content = content + "ATT_PROPERTY:" + att_name + "/" + this.quoteValue(prop_name) + ": " + this.getCommaSeparatedValue(value) + "\n";
        StringSelection stringSelection = new StringSelection(content);
        this.clipboard.setContents(stringSelection, null);
    }

    public void addDevice(String inst_name, String class_name, String device) {
        String content = this.getClipboardContent();
        content = content + "SRV_INSTANCE:" + inst_name + "/" + class_name + ": " + this.getCommaSeparatedValue(device) + "\n";
        StringSelection stringSelection = new StringSelection(content);
        this.clipboard.setContents(stringSelection, null);
    }

    public String parseValue() throws IOException {
        StringBuffer b = new StringBuffer();
        do {
            if (this.currentChar == ',') {
                this.read_char();
            }
            String s = this.read_word();
            b.append(s);
            if (this.currentChar != ',') continue;
            b.append("\n");
        } while (this.currentChar == ',');
        return b.toString();
    }

    public void parseObject() throws IOException {
        String type = this.read_word();
        if (type == null) {
            return;
        }
        if (type.equals("OBJ_PROPERTY")) {
            this.jump_sep(":");
            Item it = new Item(1);
            it.prop_name = this.read_word();
            this.jump_sep(":");
            it.value = this.parseValue();
            this.Obj_Items.add(it);
        } else if (type.equals("ATT_PROPERTY")) {
            this.jump_sep(":");
            Item it = new Item(2);
            it.att_name = this.read_word();
            this.jump_sep("/");
            it.prop_name = this.read_word();
            this.jump_sep(":");
            it.value = this.parseValue();
            this.Att_Items.add(it);
        } else if (type.equals("SRV_INSTANCE")) {
            Item it = new Item(3);
            it.inst_name = this.read_word();
            this.jump_sep("/");
            it.class_name = this.read_word();
            this.jump_sep(":");
            it.value = this.parseValue();
            this.Srv_Items.add(it);
        } else {
            throw new IOException("Unexpected object " + type);
        }
    }

    public void parse() {
        this.Obj_Items.clear();
        this.Att_Items.clear();
        this.Srv_Items.clear();
        String content = this.getClipboardContent();
        this.theStream = new StringReader(content);
        this.read_char();
        this.read_char();
        this.read_char();
        try {
            do {
                this.parseObject();
            } while (this.currentChar != '\u0000');
        }
        catch (IOException e) {
            JiveUtils.showJiveError("Invalid clipboard content\n" + e.getMessage());
        }
    }

    public int getObjectPropertyLength() {
        return this.Obj_Items.size();
    }

    public String getObjectPropertyName(int idx) {
        Item it = (Item)this.Obj_Items.get(idx);
        return it.prop_name;
    }

    public String getObjectPropertyValue(int idx) {
        Item it = (Item)this.Obj_Items.get(idx);
        return it.value;
    }

    public int getAttPropertyLength() {
        return this.Att_Items.size();
    }

    public String getAttName(int idx) {
        Item it = (Item)this.Att_Items.get(idx);
        return it.att_name;
    }

    public String getAttPropertyName(int idx) {
        Item it = (Item)this.Att_Items.get(idx);
        return it.prop_name;
    }

    public String getAttPropertyValue(int idx) {
        Item it = (Item)this.Att_Items.get(idx);
        return it.value;
    }

    public int getSrvInstanceLength() {
        return this.Srv_Items.size();
    }

    public String getInstanceName(int idx) {
        Item it = (Item)this.Srv_Items.get(idx);
        return it.inst_name;
    }

    public String getClassName(int idx) {
        Item it = (Item)this.Srv_Items.get(idx);
        return it.class_name;
    }

    public String getDeviceName(int idx) {
        Item it = (Item)this.Srv_Items.get(idx);
        return it.value;
    }

    public void clear() {
        StringSelection stringSelection = new StringSelection("");
        this.clipboard.setContents(stringSelection, null);
    }

    public boolean empty() {
        return this.Obj_Items.size() + this.Att_Items.size() + this.Srv_Items.size() == 0;
    }

    public void show(Frame parent) {
        ClipboardDlg dlg = new ClipboardDlg(parent, this.getClipboardContent());
        JiveUtils.centerDialog(dlg, 410, 290);
        dlg.setVisible(true);
    }
}

