/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jive.DevWizard;
import jive.DevicePanel;
import jive.FinishPanel;
import jive.JiveUtils;
import jive.PropertyPanel;
import jive.WizardPanel;

class ClassPanel
extends WizardPanel {
    DeviceProxy adminDev;
    String[] allClasses = new String[0];
    JList classList;
    JScrollPane classView;
    String serverName;

    public ClassPanel(DevWizard parent, String serverName, DeviceProxy adm) {
        this.setLayout(null);
        this.parent = parent;
        this.adminDev = adm;
        this.serverName = serverName;
        try {
            DeviceData d = this.adminDev.command_inout("QueryClass");
            this.allClasses = d.extractStringArray();
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        this.classList = new JList<String>(this.allClasses);
        this.classList.setBorder(null);
        this.classList.setFont(DevWizard.wizFont);
        this.classView = new JScrollPane(this.classList);
        this.classView.setBounds(0, 0, 350, 95);
        this.add(this.classView);
        this.panelIcon = new ImageIcon(this.getClass().getResource("/jive/class_wz.gif"));
    }

    @Override
    public String getTitle() {
        return "Class Selection";
    }

    @Override
    public String getDescription() {
        if (this.allClasses.length == 0) {
            return "Sorry, but the server has no class...\nThe Wizard cannot continue.";
        }
        return "The server has been succesfully started and has " + Integer.toString(this.allClasses.length) + " class(es) . Keep in mind that modifying exiting class property may affect other running server.\nClick [Edit Class] to edit properties of the selected class\nClick [Declare device] to continue with device declaration.";
    }

    @Override
    public String getSubTitle() {
        String ret = "Server:\n" + this.serverName;
        return ret;
    }

    @Override
    public boolean getNextState() {
        return this.allClasses.length > 0;
    }

    @Override
    public boolean next() {
        int idx = this.classList.getSelectedIndex();
        if (idx < 0) {
            JiveUtils.showJiveError("Please select a class first.");
            return false;
        }
        this.removeNextPanel();
        try {
            DeviceData classData = new DeviceData();
            classData.insert(this.allClasses[idx]);
            DeviceData ret = this.adminDev.command_inout("QueryWizardClassProperty", classData);
            String[] conf = ret.extractStringArray();
            for (int j = 0; j < conf.length; j += 3) {
                this.parent.addPanel(new PropertyPanel(this.parent, 0, this.serverName, this.allClasses[idx], conf[j], conf[j + 1], conf[j + 2], null));
            }
        }
        catch (DevFailed e) {
            JiveUtils.showTangoError(e);
        }
        DevicePanel devPanel = new DevicePanel(this.parent, this.serverName, this.allClasses[idx]);
        this.parent.addPanel(devPanel);
        this.parent.addPanel(new FinishPanel(this.parent, this.serverName, this, devPanel));
        return true;
    }

    @Override
    public boolean getSkipState() {
        return this.allClasses.length > 0;
    }

    @Override
    public boolean skip() {
        int idx = this.classList.getSelectedIndex();
        if (idx < 0) {
            JiveUtils.showJiveError("Please select a class first.");
            return false;
        }
        this.removeNextPanel();
        DevicePanel devPanel = new DevicePanel(this.parent, this.serverName, this.allClasses[idx]);
        this.parent.addPanel(devPanel);
        this.parent.addPanel(new FinishPanel(this.parent, this.serverName, this, devPanel));
        return true;
    }

    @Override
    public String getSkipText() {
        return "Declare device";
    }

    @Override
    public String getNextText() {
        return "Edit Class";
    }

    @Override
    public boolean back() {
        return true;
    }
}

