/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.attribute.NumberImageViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jive.ArgParser;
import jive.CommonPanel;
import jive.ConsolePanel;
import jive.JiveUtils;
import jive.TransferableString;

class AttributePanel
extends JPanel
implements ActionListener,
ListSelectionListener,
TangoConst,
MouseListener,
ClipboardOwner,
DragGestureListener,
DragSourceListener {
    private AttributeInfoEx[] attList;
    private ConsolePanel console;
    private DeviceProxy device;
    private CommonPanel common;
    private JComboBox arginCombo;
    private JLabel arginLabel;
    private JLabel descrLabel;
    private JList attributeList;
    private JScrollPane attributeView;
    private JTextArea descrList;
    private JScrollPane descrView;
    private JButton readBtn;
    private JButton writeBtn;
    private JButton plotBtn;
    private JFrame chartDlg = null;
    private JLChart chart;
    private JLDataView plotData;
    private JFrame imageDlg = null;
    private NumberImageViewer image;
    private JPopupMenu copyMenu;
    private JMenuItem copyAttributeMenuItem;
    private JMenuItem copyDevAttributeMenuItem;

    AttributePanel(DeviceProxy ds, ConsolePanel console, CommonPanel common) throws DevFailed {
        this.setLayout(null);
        this.console = console;
        this.common = common;
        this.device = ds;
        this.attList = this.getAttributeList();
        this.arginLabel = new JLabel("Argin value");
        this.arginLabel.setFont(ATKConstant.labelFont);
        this.add(this.arginLabel);
        this.descrLabel = new JLabel();
        this.descrLabel.setFont(ATKConstant.labelFont);
        this.descrLabel.setHorizontalAlignment(4);
        this.add(this.descrLabel);
        this.arginCombo = new JComboBox();
        this.arginCombo.setEditable(true);
        this.arginCombo.setFont(ATKConstant.labelFont);
        this.add(this.arginCombo);
        DefaultListModel<String> ml = new DefaultListModel<String>();
        for (int i = 0; i < this.attList.length; ++i) {
            ml.add(i, this.attList[i].name);
        }
        this.attributeList = new JList(ml);
        this.attributeList.addListSelectionListener(this);
        this.attributeList.addMouseListener(this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.attributeList, 2, this);
        this.attributeView = new JScrollPane(this.attributeList);
        this.add(this.attributeView);
        this.descrList = new JTextArea();
        this.descrList.setFont(new Font("monospaced", 0, 12));
        this.descrList.setEditable(false);
        this.descrView = new JScrollPane(this.descrList);
        this.add(this.descrView);
        this.readBtn = new JButton("Read");
        this.readBtn.setFont(ATKConstant.labelFont);
        this.add(this.readBtn);
        this.readBtn.addActionListener(this);
        this.writeBtn = new JButton("Write");
        this.writeBtn.setFont(ATKConstant.labelFont);
        this.add(this.writeBtn);
        this.writeBtn.addActionListener(this);
        this.plotBtn = new JButton("Plot");
        this.plotBtn.setFont(ATKConstant.labelFont);
        this.add(this.plotBtn);
        this.plotBtn.addActionListener(this);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                AttributePanel.this.placeComponents(AttributePanel.this.getSize());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                AttributePanel.this.placeComponents(AttributePanel.this.getSize());
            }
        });
        this.attributeList.setSelectedIndex(0);
        this.copyMenu = new JPopupMenu();
        this.copyAttributeMenuItem = new JMenuItem("Copy attribute");
        this.copyAttributeMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyAttributeMenuItem);
        this.copyDevAttributeMenuItem = new JMenuItem("Copy device/attribute");
        this.copyDevAttributeMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyDevAttributeMenuItem);
    }

    public String indentString(String in, String space) {
        String[] s = in.trim().split("\n");
        if (s.length > 1) {
            String r = s[0] + "\n";
            for (int i = 1; i < s.length; ++i) {
                r = r + space + s[i];
                if (i >= s.length - 1) continue;
                r = r + "\n";
            }
            return r;
        }
        return in;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int idx = this.attributeList.getSelectedIndex();
        if (this.attList.length == 0) {
            return;
        }
        AttributeInfoEx ai = this.attList[idx];
        if (!e.getValueIsAdjusting()) {
            if (this.isWritable((AttributeInfo)ai)) {
                this.descrLabel.setText(this.getExample(ai));
                this.arginCombo.setEnabled(true);
                this.writeBtn.setEnabled(true);
            } else {
                this.descrLabel.setText("");
                this.arginCombo.setEnabled(false);
                this.writeBtn.setEnabled(false);
            }
            String descText = "Name         " + ai.name + "\nLabel        " + ai.label + "\nDesc         " + this.indentString(ai.description, "             ") + "\nWritable     " + AttributePanel.getWriteString((AttributeInfo)ai) + "\nData format  " + AttributePanel.getFormatString((AttributeInfo)ai) + "\nData type    " + Tango_CmdArgTypeName[ai.data_type] + "\nMax Dim X    " + ai.max_dim_x + "\nMax Dim Y    " + ai.max_dim_y + "\nUnit         " + ai.unit + "\nStd Unit     " + ai.standard_unit + "\nDisp Unit    " + ai.display_unit + "\nFormat       " + ai.format + "\nMin value    " + ai.min_value + "\nMax value    " + ai.max_value + "\nMin alarm    " + ai.min_alarm + "\nMax alarm    " + ai.max_alarm;
            if (ai.data_type == 29) {
                descText = descText + "\nEnum values:\n" + JiveUtils.stringArrayToString(ai.enum_label);
            }
            this.descrList.setText(descText);
            this.descrList.setCaretPosition(0);
            this.plotBtn.setEnabled(this.isPlotable((AttributeInfo)ai));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object src = e.getSource();
        if (src == this.attributeList) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.readAttribute();
            }
            if (e.getButton() == 3) {
                this.copyMenu.show(this.attributeList, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new TransferableString(this.getCopyString(false)), this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext context = dragSourceDragEvent.getDragSourceContext();
        context.setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.readBtn) {
            this.readAttribute();
        } else if (src == this.writeBtn) {
            this.writeAttribute();
        } else if (src == this.plotBtn) {
            this.plotAttribute();
        } else if (src == this.copyAttributeMenuItem) {
            this.copyAttributeToClipboard(true);
        } else if (src == this.copyDevAttributeMenuItem) {
            this.copyAttributeToClipboard(false);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimunSize();
    }

    public Dimension getMinimunSize() {
        return new Dimension(470, 210);
    }

    private String getCopyString(boolean copyAttOnly) {
        String copyStr = "";
        AttributeInfoEx ai = this.attList[this.attributeList.getSelectedIndex()];
        copyStr = copyAttOnly ? ai.name : this.device.get_name() + "/" + ai.name;
        return copyStr;
    }

    private void copyAttributeToClipboard(boolean copyAttOnly) {
        StringSelection stringSelection = new StringSelection(this.getCopyString(copyAttOnly));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    static String getFormatString(AttributeInfo ai) {
        switch (ai.data_format.value()) {
            case 0: {
                return "Scalar";
            }
            case 1: {
                return "Spectrum";
            }
            case 2: {
                return "Image";
            }
        }
        return "Unknown";
    }

    static String getWriteString(AttributeInfo ai) {
        switch (ai.writable.value()) {
            case 0: {
                return "READ";
            }
            case 1: {
                return "READ_WITH_WRITE";
            }
            case 3: {
                return "READ_WRITE";
            }
            case 2: {
                return "WRITE";
            }
        }
        return "Unknown";
    }

    private AttributeInfoEx[] getAttributeList() throws DevFailed {
        AttributeInfoEx[] lst = this.device.get_attribute_info_ex();
        boolean end = false;
        int j = lst.length - 1;
        while (!end) {
            end = true;
            for (int i = 0; i < j; ++i) {
                if (lst[i].name.compareToIgnoreCase(lst[i + 1].name) <= 0) continue;
                end = false;
                AttributeInfoEx tmp = lst[i];
                lst[i] = lst[i + 1];
                lst[i + 1] = tmp;
            }
            --j;
        }
        return lst;
    }

    private void placeComponents(Dimension dim) {
        this.arginLabel.setBounds(10, 0, 80, 20);
        this.descrLabel.setBounds(90, 0, dim.width - 100, 20);
        this.arginCombo.setBounds(10, 20, dim.width - 20, 25);
        this.attributeView.setBounds(10, 50, 190, dim.height - 60);
        this.attributeView.revalidate();
        this.descrView.setBounds(205, 50, dim.width - 215, dim.height - 90);
        this.descrView.revalidate();
        int dim2 = (dim.width - 220) / 3;
        this.readBtn.setBounds(205, dim.height - 35, dim2, 25);
        this.writeBtn.setBounds(205 + dim2 + 2, dim.height - 35, dim2, 25);
        this.plotBtn.setBounds(205 + 2 * dim2 + 5, dim.height - 35, dim2, 25);
    }

    private void addArgin(String text) {
        boolean found = false;
        int i = 0;
        while (i < this.arginCombo.getItemCount() && !found) {
            found = text.equals(this.arginCombo.getItemAt(i).toString());
            if (found) continue;
            ++i;
        }
        if (!found) {
            this.arginCombo.addItem(text);
        }
    }

    private boolean isPlotable(AttributeInfo ai) {
        if (ai.data_type == 8 || ai.data_type == 19 || ai.data_type == 1) {
            return false;
        }
        return ai.data_format.value() == 1 || ai.data_format.value() == 2;
    }

    private boolean isWritable(AttributeInfo ai) {
        return ai.writable.value() == 1 || ai.writable.value() == 3 || ai.writable.value() == 2;
    }

    private void writeAttribute() {
        try {
            AttributeInfoEx ai = this.attList[this.attributeList.getSelectedIndex()];
            String att = ai.name;
            String arginStr = (String)this.arginCombo.getSelectedItem();
            if (arginStr != null) {
                this.addArgin(arginStr);
            }
            DeviceAttribute argin = new DeviceAttribute(att);
            this.insertData(arginStr, argin, ai);
            long t0 = System.currentTimeMillis();
            this.device.write_attribute(argin);
            long t1 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Attribute: " + this.device.name() + "/" + att + "\n");
            this.console.print("Duration: " + (t1 - t0) + " msec\n");
            this.console.print("Write OK\n");
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + e1.getMessage());
        }
        catch (DevFailed e2) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e2);
        }
    }

    private void readAttribute() {
        try {
            AttributeInfoEx ai = this.attList[this.attributeList.getSelectedIndex()];
            String att = ai.name;
            long t0 = System.currentTimeMillis();
            DeviceAttribute argout = this.device.read_attribute(att);
            long t1 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Attribute: " + this.device.name() + "/" + att + "\n");
            this.console.print("Duration: " + (t1 - t0) + " msec\n");
            this.console.print(this.extractData(argout, (AttributeInfo)ai));
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + e1.getMessage());
        }
        catch (DevFailed e2) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e2);
        }
    }

    private void plotAttribute() {
        try {
            AttributeInfoEx ai = this.attList[this.attributeList.getSelectedIndex()];
            String att = ai.name;
            DeviceAttribute argout = this.device.read_attribute(att);
            switch (ai.data_format.value()) {
                case 1: {
                    double[] values = this.extractSpectrumPlotData(argout, (AttributeInfo)ai);
                    if (this.chartDlg == null) {
                        this.chart = new JLChart();
                        this.chart.setPreferredSize(new Dimension(640, 480));
                        this.plotData = new JLDataView();
                        this.chart.getY1Axis().addDataView(this.plotData);
                        this.chart.getY1Axis().setAutoScale(true);
                        this.chart.getXAxis().setAnnotation(2);
                        this.chartDlg = new JFrame("Plot attribute [" + this.device.name() + "]");
                        this.chartDlg.setContentPane((Container)this.chart);
                    }
                    this.plotData.reset();
                    this.plotData.setName(att);
                    for (int i = 0; i < values.length; ++i) {
                        this.plotData.add((double)(i + this.common.getAnswerLimitMin()), values[i]);
                    }
                    this.chart.repaint();
                    if (this.chartDlg.isVisible()) break;
                    ATKGraphicsUtils.centerFrameOnScreen((Frame)this.chartDlg);
                    this.chartDlg.setVisible(true);
                    break;
                }
                case 2: {
                    double[][] ivalues = this.extractImagePlotData(argout, (AttributeInfo)ai);
                    if (this.imageDlg == null) {
                        this.image = new NumberImageViewer();
                        this.image.setAutoZoom(true);
                        this.imageDlg = new JFrame("Plot attribute [" + this.device.name() + "]");
                        this.imageDlg.setContentPane((Container)this.image);
                    }
                    this.image.setData(ivalues);
                    if (this.imageDlg.isVisible()) break;
                    ATKGraphicsUtils.centerFrameOnScreen((Frame)this.imageDlg);
                    this.imageDlg.setVisible(true);
                }
            }
        }
        catch (NumberFormatException e1) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + e1.getMessage());
        }
        catch (DevFailed e2) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)e2);
        }
    }

    private String getExample(AttributeInfoEx ai) {
        String ret_string = "";
        switch (ai.data_type) {
            case 19: {
                ret_string = ret_string + "ON,OFF,...";
                break;
            }
            case 22: {
                ret_string = ret_string + "10 or 0xa (unsigned 8bits)";
                break;
            }
            case 1: {
                ret_string = ret_string + "true,false or 0,1";
                break;
            }
            case 6: {
                ret_string = ret_string + "10 or 0xa (unsigned 16bits)";
                break;
            }
            case 2: {
                ret_string = ret_string + "10 or 0xa (signed 16bits)";
                break;
            }
            case 3: {
                ret_string = ret_string + "10 or 0xa (signed 32bits)";
                break;
            }
            case 7: {
                ret_string = ret_string + "10 or 0xa (unsigned 32bits)";
                break;
            }
            case 23: {
                ret_string = ret_string + "10 or 0xa (signed 64bits)";
                break;
            }
            case 24: {
                ret_string = ret_string + "10 or 0xa (unsigned 64bits)";
                break;
            }
            case 4: {
                ret_string = ret_string + "2.3 (32bits float)";
                break;
            }
            case 5: {
                ret_string = ret_string + "2.3 (64bits float)";
                break;
            }
            case 8: {
                ret_string = "quotes needed for string with space or special char";
                break;
            }
            case 29: {
                ret_string = "Enum: ";
                for (int i = 0; i < ai.enum_label.length; ++i) {
                    ret_string = ret_string + ai.enum_label[i];
                    if (i >= ai.enum_label.length - 1) continue;
                    ret_string = ret_string + ",";
                }
                return ret_string;
            }
            default: {
                ret_string = new String("");
            }
        }
        if (ai.data_format.value() == 1) {
            return "Array of " + ret_string + " Ex: a,b,c";
        }
        if (ai.data_format.value() == 2) {
            return "Image of " + ret_string + " Ex: [a,b,c][d,e,f][g,h,i]";
        }
        return "Ex: " + ret_string;
    }

    private int getLimitMax(boolean checkLimit, StringBuffer retStr, int length, boolean writable) {
        if (length > 1) {
            if (writable) {
                retStr.append("Write length: " + length + "\n");
            } else {
                retStr.append("Read length: " + length + "\n");
            }
        }
        if (checkLimit) {
            if (length > this.common.getAnswerLimitMax()) {
                retStr.append("Array cannot be fully displayed. (You may change the AnswerLimitMax)\n");
                return this.common.getAnswerLimitMax();
            }
            return length;
        }
        return length;
    }

    private int getLimitMin(boolean checkLimit, StringBuffer retStr, int length) {
        if (checkLimit) {
            if (length <= this.common.getAnswerLimitMin()) {
                retStr.append("Array cannot be displayed. (You may change the AnswerLimitMin)\n");
                return length;
            }
            return this.common.getAnswerLimitMin();
        }
        return 0;
    }

    private int getLimitMaxForPlot(int length) {
        if (length > this.common.getAnswerLimitMax()) {
            return this.common.getAnswerLimitMax();
        }
        return length;
    }

    private int getLimitMinForPlot(int length) {
        if (length <= this.common.getAnswerLimitMin()) {
            return length;
        }
        return this.common.getAnswerLimitMin();
    }

    private void insertData(String argin, DeviceAttribute send, AttributeInfoEx ai) throws NumberFormatException {
        ArgParser arg = new ArgParser(argin);
        switch (ai.data_type) {
            case 19: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert(arg.parse_state());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_state_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_state_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 22: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert_uc(arg.parse_uchar());
                        break;
                    }
                    case 1: {
                        send.insert_uc(arg.parse_uchar_array());
                        break;
                    }
                    case 2: {
                        send.insert_uc(arg.parse_uchar_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 1: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert(arg.parse_boolean());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_boolean_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_boolean_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 2: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert(arg.parse_short());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_short_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_short_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 6: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert_us(arg.parse_ushort());
                        break;
                    }
                    case 1: {
                        send.insert_us(arg.parse_ushort_array());
                        break;
                    }
                    case 2: {
                        send.insert_us(arg.parse_ushort_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 3: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert(arg.parse_long());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_long_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_long_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 7: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert_ul(arg.parse_ulong());
                        break;
                    }
                    case 1: {
                        send.insert_ul(arg.parse_ulong_array());
                        break;
                    }
                    case 2: {
                        send.insert_ul(arg.parse_ulong_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 23: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert(arg.parse_long64());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_long64_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_long64_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 24: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert_u64(arg.parse_long64());
                        break;
                    }
                    case 1: {
                        send.insert_u64(arg.parse_long64_array());
                        break;
                    }
                    case 2: {
                        send.insert_u64(arg.parse_long64_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 4: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert(arg.parse_float());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_float_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_float_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 5: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert(arg.parse_double());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_double_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_double_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 8: {
                switch (ai.data_format.value()) {
                    case 0: {
                        send.insert(arg.parse_string());
                        break;
                    }
                    case 1: {
                        send.insert(arg.parse_string_array());
                        break;
                    }
                    case 2: {
                        send.insert(arg.parse_string_image(), arg.get_image_width(), arg.get_image_height());
                    }
                }
                break;
            }
            case 29: {
                switch (ai.data_format.value()) {
                    case 0: {
                        String in = arg.parse_string();
                        short idx = (short)JiveUtils.isInsideArray(in, ai.enum_label);
                        if (idx < 0) {
                            throw new NumberFormatException("\"" + in + "\" not known in enum\nPossible values are:\n" + JiveUtils.stringArrayToString(ai.enum_label));
                        }
                        send.insert(idx);
                        break;
                    }
                    case 1: {
                        String[] in = arg.parse_string_array();
                        short[] idx = new short[in.length];
                        for (int i = 0; i < in.length; ++i) {
                            idx[i] = (short)JiveUtils.isInsideArray(in[i], ai.enum_label);
                            if (idx[i] >= 0) continue;
                            throw new NumberFormatException("\"" + in[i] + "\" not known in enum\nPossible values are:\n" + JiveUtils.stringArrayToString(ai.enum_label));
                        }
                        send.insert(idx);
                        break;
                    }
                    case 2: {
                        String[] in = arg.parse_string_image();
                        int width = arg.get_image_width();
                        int height = arg.get_image_height();
                        short[] idx = new short[in.length];
                        for (int i = 0; i < in.length; ++i) {
                            idx[i] = (short)JiveUtils.isInsideArray(in[i], ai.enum_label);
                            if (idx[i] >= 0) continue;
                            throw new NumberFormatException("\"" + in[i] + "\" not known in enum\nPossible values are:\n" + JiveUtils.stringArrayToString(ai.enum_label));
                        }
                        send.insert(idx, width, height);
                    }
                }
                break;
            }
            default: {
                throw new NumberFormatException("Attribute type not supported code=" + ai.data_type);
            }
        }
    }

    private void printArrayItem(StringBuffer str, int idx, boolean printIdx, String value, boolean writeable) {
        if (!writeable) {
            if (printIdx) {
                str.append("Read [" + idx + "]\t" + value + "\n");
            } else {
                str.append("Read:\t" + value + "\n");
            }
        } else if (printIdx) {
            str.append("Set [" + idx + "]\t" + value + "\n");
        } else {
            str.append("Set:\t" + value + "\n");
        }
    }

    private String extractData(DeviceAttribute data, AttributeInfo ai) {
        StringBuffer ret_string = new StringBuffer();
        try {
            TimeVal t = data.getTimeVal();
            Date date = new Date((long)((double)t.tv_sec * 1000.0 + (double)t.tv_usec / 1000.0));
            SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            dateformat.setTimeZone(TimeZone.getDefault());
            ret_string.append("measure date: " + dateformat.format(date) + " + " + t.tv_usec / 1000 + "ms\n");
            AttrQuality q = data.getQuality();
            ret_string.append("quality: ");
            switch (q.value()) {
                case 0: {
                    ret_string.append("VALID\n");
                    break;
                }
                case 1: {
                    ret_string.append("INVALID\n");
                    return ret_string.toString();
                }
                case 2: {
                    ret_string.append("ALARM\n");
                    break;
                }
                case 3: {
                    ret_string.append("CHANGING\n");
                    break;
                }
                case 4: {
                    ret_string.append("WARNING\n");
                    break;
                }
                default: {
                    ret_string.append("UNKNOWN\n");
                }
            }
            boolean printIndex = true;
            boolean checkLimit = true;
            switch (ai.data_format.value()) {
                case 0: {
                    printIndex = false;
                    checkLimit = false;
                    break;
                }
                case 1: {
                    ret_string.append("dim x: " + data.getDimX() + "\n");
                    break;
                }
                case 2: {
                    ret_string.append("dim x: " + data.getDimX() + "\n");
                    ret_string.append("dim y: " + data.getDimY() + "\n");
                    break;
                }
            }
            switch (ai.data_type) {
                case 19: {
                    int i;
                    DevState[] dummy = data.extractDevStateArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Tango_DevStateName[dummy[i].value()], false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Tango_DevStateName[dummy[i + nbRead].value()], true);
                        }
                    }
                    break;
                }
                case 22: {
                    int i;
                    short[] dummy = data.extractUCharArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Short.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Short.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 2: {
                    int i;
                    short[] dummy = data.extractShortArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Short.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Short.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 1: {
                    int i;
                    boolean[] dummy = data.extractBooleanArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Boolean.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Boolean.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 6: {
                    int i;
                    int[] dummy = data.extractUShortArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Integer.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Integer.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 3: {
                    int i;
                    int[] dummy = data.extractLongArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Integer.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Integer.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 7: {
                    int i;
                    long[] dummy = data.extractULongArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Long.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Long.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 23: {
                    int i;
                    long[] dummy = data.extractLong64Array();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Long.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Long.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 24: {
                    int i;
                    long[] dummy = data.extractULong64Array();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Long.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Long.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 5: {
                    int i;
                    double[] dummy = data.extractDoubleArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Double.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Double.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 4: {
                    int i;
                    float[] dummy = data.extractFloatArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, Float.toString(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, Float.toString(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                case 8: {
                    int i;
                    String[] dummy = data.extractStringArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, dummy[i], false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, dummy[i + nbRead], true);
                        }
                    }
                    break;
                }
                case 28: {
                    printIndex = true;
                    DevEncoded e = data.extractDevEncoded();
                    ret_string.append("Format: " + e.encoded_format + "\n");
                    int nbRead = e.encoded_data.length;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (int i = start; i < end; ++i) {
                        short vs = e.encoded_data[i];
                        vs = (short)(vs & 0xFF);
                        this.printArrayItem(ret_string, i, printIndex, Short.toString(vs), false);
                    }
                    break;
                }
                case 29: {
                    int i;
                    AttributeInfoEx info = this.device.get_attribute_info_ex(ai.name);
                    short[] dummy = data.extractShortArray();
                    int nbRead = data.getNbRead();
                    int nbWritten = dummy.length - nbRead;
                    int start = this.getLimitMin(checkLimit, ret_string, nbRead);
                    int end = this.getLimitMax(checkLimit, ret_string, nbRead, false);
                    for (i = start; i < end; ++i) {
                        this.printArrayItem(ret_string, i, printIndex, info.getEnumLabel(dummy[i]), false);
                    }
                    if (this.isWritable(ai)) {
                        start = this.getLimitMin(checkLimit, ret_string, nbWritten);
                        end = this.getLimitMax(checkLimit, ret_string, nbWritten, true);
                        for (i = start; i < end; ++i) {
                            this.printArrayItem(ret_string, i, printIndex, info.getEnumLabel(dummy[i + nbRead]), true);
                        }
                    }
                    break;
                }
                default: {
                    ret_string.append("Unsupported attribute type code=" + ai.data_type + "\n");
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)(this.device.name() + "/" + ai.name), (DevFailed)e);
        }
        return ret_string.toString();
    }

    private double[] extractSpectrumPlotData(DeviceAttribute data, AttributeInfo ai) {
        double[] ret = new double[]{};
        try {
            int start = this.getLimitMinForPlot(data.getNbRead());
            int end = this.getLimitMaxForPlot(data.getNbRead());
            switch (ai.data_type) {
                case 22: {
                    short[] dummy = data.extractUCharArray();
                    ret = new double[end - start];
                    for (int i = start; i < end; ++i) {
                        ret[i - start] = dummy[i];
                    }
                    break;
                }
                case 2: {
                    short[] dummy = data.extractShortArray();
                    ret = new double[end - start];
                    for (int i = start; i < end; ++i) {
                        ret[i - start] = dummy[i];
                    }
                    break;
                }
                case 6: {
                    int[] dummy = data.extractUShortArray();
                    ret = new double[end - start];
                    for (int i = start; i < end; ++i) {
                        ret[i - start] = dummy[i];
                    }
                    break;
                }
                case 3: {
                    int[] dummy = data.extractLongArray();
                    ret = new double[end - start];
                    for (int i = start; i < end; ++i) {
                        ret[i - start] = dummy[i];
                    }
                    break;
                }
                case 5: {
                    double[] dummy = data.extractDoubleArray();
                    ret = new double[end - start];
                    for (int i = start; i < end; ++i) {
                        ret[i - start] = dummy[i];
                    }
                    break;
                }
                case 4: {
                    float[] dummy = data.extractFloatArray();
                    ret = new double[end - start];
                    for (int i = start; i < end; ++i) {
                        ret[i - start] = dummy[i];
                    }
                    break;
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)(this.device.name() + "/" + ai.name), (DevFailed)e);
        }
        return ret;
    }

    private double[][] extractImagePlotData(DeviceAttribute data, AttributeInfo ai) {
        double[][] ret = new double[0][0];
        try {
            int dimx = data.getDimX();
            int dimy = data.getDimY();
            switch (ai.data_type) {
                case 22: {
                    short[] dummy = data.extractUCharArray();
                    ret = new double[dimy][dimx];
                    int k = 0;
                    for (int j = 0; j < dimy; ++j) {
                        for (int i = 0; i < dimx; ++i) {
                            ret[j][i] = dummy[k++];
                        }
                    }
                    break;
                }
                case 2: {
                    short[] dummy = data.extractShortArray();
                    ret = new double[dimy][dimx];
                    int k = 0;
                    for (int j = 0; j < dimy; ++j) {
                        for (int i = 0; i < dimx; ++i) {
                            ret[j][i] = dummy[k++];
                        }
                    }
                    break;
                }
                case 6: {
                    int[] dummy = data.extractUShortArray();
                    ret = new double[dimy][dimx];
                    int k = 0;
                    for (int j = 0; j < dimy; ++j) {
                        for (int i = 0; i < dimx; ++i) {
                            ret[j][i] = dummy[k++];
                        }
                    }
                    break;
                }
                case 3: {
                    int[] dummy = data.extractLongArray();
                    ret = new double[dimy][dimx];
                    int k = 0;
                    for (int j = 0; j < dimy; ++j) {
                        for (int i = 0; i < dimx; ++i) {
                            ret[j][i] = dummy[k++];
                        }
                    }
                    break;
                }
                case 5: {
                    double[] dummy = data.extractDoubleArray();
                    ret = new double[dimy][dimx];
                    int k = 0;
                    for (int j = 0; j < dimy; ++j) {
                        for (int i = 0; i < dimx; ++i) {
                            ret[j][i] = dummy[k++];
                        }
                    }
                    break;
                }
                case 4: {
                    float[] dummy = data.extractFloatArray();
                    ret = new double[dimy][dimx];
                    int k = 0;
                    for (int j = 0; j < dimy; ++j) {
                        for (int i = 0; i < dimx; ++i) {
                            ret[j][i] = dummy[k++];
                        }
                    }
                    break;
                }
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)(this.device.name() + "/" + ai.name), (DevFailed)e);
        }
        return ret;
    }
}

