/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.PipeBlob;
import fr.esrf.TangoApi.PipeDataElement;
import fr.esrf.TangoDs.TangoConst;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import java.util.Vector;

public class ArgParser {
    private Reader theStream;
    private char nextNextChar;
    private char nextChar;
    private char currentChar;
    private boolean backSlashed;
    private int width;
    private int height;

    public ArgParser(String s) throws NumberFormatException {
        if (s == null || s.length() == 0) {
            throw new NumberFormatException("Empty argument, you must specify a value");
        }
        if (s.startsWith("file:/")) {
            try {
                this.theStream = new FileReader(s.substring(6));
            }
            catch (IOException e) {
                throw new NumberFormatException(e.getMessage());
            }
        } else {
            this.theStream = new StringReader(s);
        }
        this.width = 0;
        this.height = 0;
        this.read_char();
        this.read_char();
        this.read_char();
    }

    public String convert_to_hex() throws NumberFormatException {
        StringBuffer ret_string = new StringBuffer();
        String word = "";
        while (word != null) {
            word = this.get_space();
            ret_string.append(word);
            word = this.read_word();
            if (word == null) continue;
            if (this.is_integer(word)) {
                long l = this.get_long64(word);
                ret_string.append("0x" + String.format("%X", l));
                continue;
            }
            ret_string.append(word);
        }
        return ret_string.toString();
    }

    public String convert_to_dec() throws NumberFormatException {
        StringBuffer ret_string = new StringBuffer();
        String word = "";
        while (word != null) {
            word = this.get_space();
            ret_string.append(word);
            word = this.read_word();
            if (word == null) continue;
            if (this.is_integer(word)) {
                long l = this.get_long64(word);
                ret_string.append(String.format("%d", l));
                continue;
            }
            ret_string.append(word);
        }
        return ret_string.toString();
    }

    public PipeBlob parse_pipe() throws NumberFormatException {
        String blobName = this.read_word();
        this.jump_space();
        PipeBlob pb = new PipeBlob(blobName);
        do {
            PipeDataElement de;
            this.jump_sep(",");
            this.jump_space();
            this.jump_sep("[");
            this.jump_space();
            String itemName = this.read_word();
            this.jump_space();
            this.jump_sep(",");
            this.jump_space();
            if (this.currentChar == '[') {
                this.jump_sep("[");
                this.jump_space();
                PipeBlob ipb = this.parse_pipe();
                this.jump_space();
                this.jump_sep("]");
                de = new PipeDataElement(itemName, ipb);
            } else {
                Object[] sa;
                int i;
                Vector tmp = this.parse_array();
                int vSize = tmp.size();
                if (vSize < 2) {
                    throw new NumberFormatException("Typed value expected: typeStr,value");
                }
                String typeStr = (String)tmp.get(0);
                tmp.remove(0);
                --vSize;
                if (typeStr.equalsIgnoreCase("D")) {
                    double[] da = new double[vSize];
                    for (i = 0; i < vSize; ++i) {
                        da[i] = Double.parseDouble((String)tmp.get(i));
                    }
                    de = new PipeDataElement(itemName, da);
                } else if (typeStr.equalsIgnoreCase("F")) {
                    float[] fa = new float[vSize];
                    for (i = 0; i < vSize; ++i) {
                        fa[i] = Float.parseFloat((String)tmp.get(i));
                    }
                    de = new PipeDataElement(itemName, fa);
                } else if (typeStr.equalsIgnoreCase("UC")) {
                    short[] ca = new short[vSize];
                    for (i = 0; i < vSize; ++i) {
                        ca[i] = this.get_uchar((String)tmp.get(i));
                    }
                    de = new PipeDataElement(itemName, ca, true);
                } else if (typeStr.equalsIgnoreCase("S")) {
                    sa = new short[vSize];
                    for (i = 0; i < vSize; ++i) {
                        sa[i] = this.get_short((String)tmp.get(i));
                    }
                    de = new PipeDataElement(itemName, sa);
                } else if (typeStr.equalsIgnoreCase("US")) {
                    int[] usa = new int[vSize];
                    for (i = 0; i < vSize; ++i) {
                        usa[i] = this.get_ushort((String)tmp.get(i));
                    }
                    de = new PipeDataElement(itemName, usa, true);
                } else if (typeStr.equalsIgnoreCase("L")) {
                    int[] la = new int[vSize];
                    for (i = 0; i < vSize; ++i) {
                        la[i] = this.get_long((String)tmp.get(i));
                    }
                    de = new PipeDataElement(itemName, la);
                } else if (typeStr.equalsIgnoreCase("UL")) {
                    long[] ula = new long[vSize];
                    for (i = 0; i < vSize; ++i) {
                        ula[i] = this.get_long((String)tmp.get(i));
                    }
                    de = new PipeDataElement(itemName, ula, true);
                } else if (typeStr.equalsIgnoreCase("LL")) {
                    long[] lla = new long[vSize];
                    for (i = 0; i < vSize; ++i) {
                        lla[i] = this.get_long64((String)tmp.get(i));
                    }
                    de = new PipeDataElement(itemName, lla);
                } else if (typeStr.equalsIgnoreCase("ST")) {
                    sa = new DevState[vSize];
                    for (i = 0; i < vSize; ++i) {
                        sa[i] = (short)this.get_state((String)tmp.get(i));
                    }
                    de = new PipeDataElement(itemName, (DevState[])sa);
                } else if (typeStr.equalsIgnoreCase("STR")) {
                    String[] ss = new String[vSize];
                    for (i = 0; i < vSize; ++i) {
                        ss[i] = (String)tmp.get(i);
                    }
                    de = new PipeDataElement(itemName, ss);
                } else {
                    throw new NumberFormatException("Unknown type specified " + typeStr);
                }
            }
            pb.add((Object)de);
            this.jump_space();
            this.jump_sep("]");
            this.jump_space();
        } while (this.currentChar == ',');
        return pb;
    }

    public boolean parse_boolean() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_boolean(w);
        }
        throw new NumberFormatException("boolean value expected.");
    }

    public boolean[] parse_boolean_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        boolean[] ret = new boolean[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_boolean((String)tmp.get(l));
        }
        return ret;
    }

    public boolean[] parse_boolean_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        boolean[] ret = new boolean[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_boolean((String)tmp.get(l));
        }
        return ret;
    }

    public byte parse_char() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_char(w);
        }
        throw new NumberFormatException("char value expected.");
    }

    public byte[] parse_char_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        byte[] ret = new byte[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_char((String)tmp.get(l));
        }
        return ret;
    }

    public byte[] parse_char_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        byte[] ret = new byte[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_char((String)tmp.get(l));
        }
        return ret;
    }

    public short parse_uchar() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_uchar(w);
        }
        throw new NumberFormatException("unsigned char value expected.");
    }

    public short[] parse_uchar_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        short[] ret = new short[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_uchar((String)tmp.get(l));
        }
        return ret;
    }

    public short[] parse_uchar_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        short[] ret = new short[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_uchar((String)tmp.get(l));
        }
        return ret;
    }

    public short parse_short() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_short(w);
        }
        throw new NumberFormatException("short value expected.");
    }

    public short[] parse_short_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        short[] ret = new short[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_short((String)tmp.get(l));
        }
        return ret;
    }

    public short[] parse_short_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        short[] ret = new short[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_short((String)tmp.get(l));
        }
        return ret;
    }

    public int parse_ushort() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_ushort(w);
        }
        throw new NumberFormatException("unsigned short value expected.");
    }

    public int[] parse_ushort_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        int[] ret = new int[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_ushort((String)tmp.get(l));
        }
        return ret;
    }

    public int[] parse_ushort_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        int[] ret = new int[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_ushort((String)tmp.get(l));
        }
        return ret;
    }

    public int parse_long() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_long(w);
        }
        throw new NumberFormatException("Integer value expected.");
    }

    public int[] parse_long_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        int[] ret = new int[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_long((String)tmp.get(l));
        }
        return ret;
    }

    public int[] parse_long_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        int[] ret = new int[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_long((String)tmp.get(l));
        }
        return ret;
    }

    public long parse_ulong() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_ulong(w);
        }
        throw new NumberFormatException("unsigned long value expected.");
    }

    public long[] parse_ulong_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        long[] ret = new long[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_ulong((String)tmp.get(l));
        }
        return ret;
    }

    public long[] parse_ulong_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        long[] ret = new long[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_ulong((String)tmp.get(l));
        }
        return ret;
    }

    public long parse_long64() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_long64(w);
        }
        throw new NumberFormatException("long64 value expected.");
    }

    public long[] parse_long64_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        long[] ret = new long[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_long64((String)tmp.get(l));
        }
        return ret;
    }

    public long[] parse_long64_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        long[] ret = new long[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_long64((String)tmp.get(l));
        }
        return ret;
    }

    public float parse_float() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return Float.parseFloat(w);
        }
        throw new NumberFormatException("float value expected.");
    }

    public float[] parse_float_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        float[] ret = new float[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = Float.parseFloat((String)tmp.get(l));
        }
        return ret;
    }

    public float[] parse_float_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        float[] ret = new float[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = Float.parseFloat((String)tmp.get(l));
        }
        return ret;
    }

    public double parse_double() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return Double.parseDouble(w);
        }
        throw new NumberFormatException("double value expected.");
    }

    public double[] parse_double_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        double[] ret = new double[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = Double.parseDouble((String)tmp.get(l));
        }
        return ret;
    }

    public double[] parse_double_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        double[] ret = new double[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = Double.parseDouble((String)tmp.get(l));
        }
        return ret;
    }

    private String convertString(String w) {
        Properties prop = new Properties();
        try {
            prop.load(new StringReader("x=" + w + "\n"));
            String decoded = prop.getProperty("x");
            return decoded;
        }
        catch (Exception ex) {
            return w;
        }
    }

    public String parse_string() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.convertString(w);
        }
        throw new NumberFormatException("string expected.");
    }

    public DevState parse_state() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_state(w);
        }
        throw new NumberFormatException("State expected.");
    }

    public DevState[] parse_state_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        DevState[] ret = new DevState[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_state((String)tmp.get(l));
        }
        return ret;
    }

    public DevState[] parse_state_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        DevState[] ret = new DevState[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_state((String)tmp.get(l));
        }
        return ret;
    }

    public String[] parse_string_array() throws NumberFormatException {
        Vector tmp = this.parse_array();
        String[] ret = new String[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.convertString((String)tmp.get(l));
        }
        return ret;
    }

    public String[] parse_string_image() throws NumberFormatException {
        Vector tmp = this.parse_image();
        String[] ret = new String[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = (String)tmp.get(l);
        }
        return ret;
    }

    public int get_image_width() {
        return this.width;
    }

    public int get_image_height() {
        return this.height;
    }

    private void read_char() {
        this.backSlashed = false;
        try {
            int c = this.theStream.read();
            this.currentChar = this.nextChar;
            this.nextChar = this.nextNextChar;
            this.nextNextChar = c < 0 ? (char)'\u0000' : (char)c;
        }
        catch (Exception e) {
            this.nextNextChar = '\u0000';
            this.nextChar = '\u0000';
            this.currentChar = '\u0000';
        }
        if (this.currentChar == '\\' && this.nextChar == '\"') {
            this.read_char();
            this.backSlashed = true;
        }
    }

    private void jump_space() {
        while (this.currentChar <= ' ' && this.currentChar > '\u0000') {
            this.read_char();
        }
    }

    private String get_space() {
        StringBuffer ret_word = new StringBuffer();
        while (this.currentChar <= ' ' && this.currentChar > '\u0000') {
            ret_word.append(this.currentChar);
            this.read_char();
        }
        return ret_word.toString();
    }

    private boolean is_special_char(char c) {
        return c == ',' || c == '[' || c == ']' || c == '(' || c == ')';
    }

    private String read_word() throws NumberFormatException {
        StringBuffer ret_word = new StringBuffer();
        this.jump_space();
        if (this.is_special_char(this.currentChar)) {
            ret_word.append(this.currentChar);
            this.read_char();
            return ret_word.toString();
        }
        if (this.currentChar == '\'' && this.nextNextChar == '\'') {
            ret_word.append(this.currentChar);
            this.read_char();
            ret_word.append(this.currentChar);
            this.read_char();
            ret_word.append(this.currentChar);
            this.read_char();
            return ret_word.toString();
        }
        if (this.currentChar == '\"' && !this.backSlashed) {
            this.read_char();
            while ((this.currentChar != '\"' || this.backSlashed) && this.currentChar != '\u0000' && this.currentChar != '\n') {
                ret_word.append(this.currentChar);
                this.read_char();
            }
            if (this.currentChar == '\u0000' || this.currentChar == '\n') {
                NumberFormatException e = new NumberFormatException("Unterminated string.");
                throw e;
            }
            this.read_char();
            return ret_word.toString();
        }
        while (this.currentChar > ' ' && !this.is_special_char(this.currentChar)) {
            ret_word.append(this.currentChar);
            this.read_char();
        }
        if (ret_word.length() == 0) {
            return null;
        }
        return ret_word.toString();
    }

    private void jump_sep(String sep) throws NumberFormatException {
        String w = this.read_word();
        if (w == null) {
            throw new NumberFormatException("Separator " + sep + " expected.");
        }
        if (!w.equals(sep)) {
            throw new NumberFormatException("Separator " + sep + " expected.");
        }
    }

    private boolean is_array_end() {
        if (this.currentChar == '\u0000') {
            return true;
        }
        return this.currentChar == ']';
    }

    private Vector parse_array() throws NumberFormatException {
        Vector<String> ret = new Vector<String>();
        boolean isClosed = false;
        this.jump_space();
        if (this.currentChar == '[') {
            isClosed = true;
            this.jump_sep("[");
            this.jump_space();
        }
        while (!this.is_array_end()) {
            ret.add(this.read_word());
            this.jump_space();
            if (this.is_array_end()) continue;
            this.jump_sep(",");
            this.jump_space();
        }
        if (isClosed) {
            this.jump_sep("]");
        }
        return ret;
    }

    private Vector parse_image() throws NumberFormatException {
        Vector ret = this.parse_array();
        this.jump_space();
        this.width = ret.size();
        this.height = 1;
        while (this.currentChar == '[') {
            Vector tmp = this.parse_array();
            if (tmp.size() != this.width) {
                throw new NumberFormatException("All lines in an image must have the same size.");
            }
            ret.addAll(tmp);
            ++this.height;
            this.jump_space();
        }
        return ret;
    }

    private boolean get_boolean(String w) throws NumberFormatException {
        if (w.equalsIgnoreCase("true") || w.equalsIgnoreCase("1")) {
            return true;
        }
        if (w.equalsIgnoreCase("false") || w.equalsIgnoreCase("0")) {
            return false;
        }
        throw new NumberFormatException("invalid boolean value " + w + " [true,false or 0,1].");
    }

    private long get_number(String w, String type, long min, long max) throws NumberFormatException {
        long ret;
        int conv_base = 10;
        if (w.startsWith("0x") || w.startsWith("0X")) {
            w = w.substring(2);
            conv_base = 16;
        }
        if ((ret = Long.parseLong(w, conv_base)) < min || ret > max) {
            throw new NumberFormatException(type + " value " + ret + " out of range [" + min + "," + max + "].");
        }
        return ret;
    }

    private byte get_char(String w) throws NumberFormatException {
        if (w.startsWith("'")) {
            if (w.endsWith("'") && w.length() == 3) {
                return (byte)w.charAt(1);
            }
            throw new NumberFormatException("Invalid char value for input string " + w);
        }
        return (byte)this.get_number(w, "char", -128L, 127L);
    }

    private short get_uchar(String w) throws NumberFormatException {
        return (short)this.get_number(w, "unsigned char", 0L, 255L);
    }

    private short get_short(String w) throws NumberFormatException {
        return (short)this.get_number(w, "short", -32768L, 32767L);
    }

    private int get_ushort(String w) throws NumberFormatException {
        return (int)this.get_number(w, "unsigned short", 0L, 65535L);
    }

    private int get_long(String w) throws NumberFormatException {
        return (int)this.get_number(w, "long", Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private long get_ulong(String w) throws NumberFormatException {
        return this.get_number(w, "unsigned long", 0L, 0xFFFFFFFFL);
    }

    private long get_long64(String w) throws NumberFormatException {
        return this.get_number(w, "long64", Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private boolean is_native_number(String s) {
        int length = s.length();
        boolean ret = true;
        for (int i = 0; ret && i < length; ++i) {
            char c = s.charAt(i);
            ret = c >= '0' && c <= '9';
        }
        return ret;
    }

    private boolean is_native_hex_number(String s) {
        int length = s.length();
        boolean ret = true;
        for (int i = 0; ret && i < length; ++i) {
            char c = s.charAt(i);
            ret = c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }
        return ret;
    }

    private boolean is_integer(String s) {
        if (s.contains(".")) {
            return false;
        }
        if (s.startsWith("0x") || s.startsWith("0X")) {
            return this.is_native_hex_number(s.substring(2));
        }
        if (s.startsWith("-")) {
            return this.is_native_number(s.substring(1));
        }
        return this.is_native_number(s);
    }

    private DevState get_state(String s) throws NumberFormatException {
        boolean found = false;
        int i = 0;
        while (!found && i < TangoConst.Tango_DevStateName.length) {
            found = s.equalsIgnoreCase(TangoConst.Tango_DevStateName[i]);
            if (found) continue;
            ++i;
        }
        if (found) {
            return DevState.from_int((int)i);
        }
        throw new NumberFormatException("Invalid state name " + s);
    }

    private boolean is_state_array(Vector v) {
        try {
            for (int i = 0; i < v.size(); ++i) {
                this.get_state((String)v.get(i));
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static void print_array(boolean[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(byte[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(short[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(int[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(float[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(double[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(String[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    public static void main(String[] args) {
        ArgParser a1 = new ArgParser("true");
        ArgParser a2 = new ArgParser("7,8,127.123,1e6,57.8");
        ArgParser a3 = new ArgParser("[1.0,2,3.5] [4,5.7,6] [7,8,127.123] [10.1,11.2,12]");
        ArgParser a4 = new ArgParser("toto,\"ta 'ta\",titi");
        ArgParser a5 = new ArgParser("[34,5] [toto,\"ta ta\",titi]");
        ArgParser a6 = new ArgParser("[7,8,-9,16,5700,0x10]");
        ArgParser a7 = new ArgParser("\"test with \\\" ,quote\"");
        ArgParser a8 = new ArgParser("\\\"quote\\\"");
        ArgParser a9 = new ArgParser("\\u0261toto");
        ArgParser a10 = new ArgParser("'a',' ',0x72,'i'");
        try {
            System.out.println(a1.parse_boolean());
            ArgParser.print_array(a2.parse_float_array());
            ArgParser.print_array(a3.parse_double_image());
            ArgParser.print_array(a4.parse_string_array());
            ArgParser.print_array(a5.parse_long_array());
            ArgParser.print_array(a5.parse_string_array());
            ArgParser.print_array(a6.parse_short_array());
            System.out.println(a7.parse_string());
            System.out.println(a8.parse_string());
            System.out.println(a9.parse_string());
            ArgParser.print_array(a10.parse_char_array());
        }
        catch (NumberFormatException e) {
            System.out.println("Getting error:" + e);
        }
    }
}

