/*
 * Decompiled with CFR 0.152.
 */
package JSSHTerminal;

import JSSHTerminal.MainPanel;
import JSSHTerminal.SSHSession;
import JSSHTerminal.TerminalEmulator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class TerminalEvent
extends JComponent
implements MouseListener,
MouseMotionListener {
    static final Color[] defaultColors = new Color[]{Color.BLACK, new Color(170, 0, 0), new Color(0, 170, 0), new Color(197, 94, 0), new Color(0, 0, 170), new Color(170, 0, 170), new Color(0, 170, 170), new Color(220, 220, 220)};
    static final Color[] defaultBrightColors = new Color[]{new Color(90, 90, 90), new Color(255, 90, 90), new Color(90, 255, 90), new Color(255, 128, 0), new Color(90, 90, 255), new Color(255, 0, 255), new Color(0, 255, 255), Color.WHITE};
    final Color cursorBackground = new Color(0, 170, 0);
    SSHSession session = null;
    TerminalEmulator terminal = null;
    int charWidth;
    int charHeight;
    int termWidth = 0;
    int termHeight = 0;
    int scrollPos = 0;
    Dimension size;
    MainPanel _parent;
    boolean isDragging;
    MouseEvent startSel = null;
    MouseEvent endSel = null;

    public void init(MainPanel parent, int width, int height, int charWidth, int charHeight) {
        this._parent = parent;
        this.setBorder(null);
        this.setOpaque(false);
        this.setDoubleBuffered(false);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.charWidth = charWidth;
        this.charHeight = charHeight;
        this.resizeComponent(width, height);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TerminalEvent.this.resize();
            }
        });
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void resize() {
        Dimension d = this.getSize();
        if (d.width % this.charWidth == 0 && d.height % this.charHeight == 0) {
            this.resizeComponent(d.width / this.charWidth, d.height / this.charHeight);
        } else {
            this.setSize(this.charWidth * (d.width / this.charWidth), this.charHeight * (d.height / this.charHeight));
        }
    }

    public abstract void dispose();

    public abstract void sizeComponent(int var1, int var2);

    synchronized void resizeComponent(int width, int height) {
        if (this.termHeight != height || this.termWidth != width) {
            this.termWidth = width;
            this.termHeight = height;
            this.sizeComponent(width, height);
            this.size = new Dimension(this.termWidth * this.charWidth, this.termHeight * this.charHeight);
            this.notifySizeChange();
        }
    }

    public void notifySizeChange() {
        if (this.terminal != null) {
            this.terminal.resize(this.termWidth, this.termHeight);
        }
        if (this.session != null) {
            this.session.resize(this.termWidth, this.termHeight);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    public void setSession(SSHSession session) {
        this.session = session;
        this.terminal = session.getTerminal();
    }

    public void setScrollPos(int pos) {
        this.scrollPos = this.terminal.getScrollSize() - pos - this.termHeight;
        this.repaint();
    }

    public void moveScroll(int move) {
        this.scrollPos += move;
        if (this.scrollPos < 0) {
            this.scrollPos = 0;
        }
        if (this.scrollPos > this.terminal.getScrollSize() - this.termHeight) {
            this.scrollPos = this.terminal.getScrollSize() - this.termHeight;
        }
        this.repaint();
    }

    public abstract void drawComponent(Graphics var1);

    @Override
    public void paint(Graphics g) {
        this.drawComponent(g);
        if (this.terminal.getTitle().length() > 0) {
            this._parent.setExtraTilte(this.terminal.getTitle());
        }
    }

    private boolean isCtrlKey(int keyCode) {
        return keyCode == 17 || keyCode == 16 || keyCode == 18 || keyCode == 20;
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        char keyChar;
        byte[] fCode;
        int id = e.getID();
        if (e.isConsumed()) {
            return;
        }
        int keyCode = e.getKeyCode();
        if (this.isCtrlKey(keyCode)) {
            e.consume();
            return;
        }
        if (id == 401 && (fCode = this.functionKey(keyCode)) != null) {
            try {
                this.session.write(fCode);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            this.scrollPos = 0;
            e.consume();
            return;
        }
        if (id == 400 && (keyChar = e.getKeyChar()) < '\u007f') {
            try {
                if (keyChar == '\n') {
                    this.session.write(new byte[]{13});
                } else {
                    this.session.write(new byte[]{(byte)keyChar});
                }
                this.scrollPos = 0;
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        e.consume();
    }

    public byte[] functionKey(int keycode) {
        if (this.session == null) {
            return null;
        }
        switch (keycode) {
            case 38: {
                return TerminalEmulator.getCodeUP();
            }
            case 40: {
                return TerminalEmulator.getCodeDOWN();
            }
            case 39: {
                return TerminalEmulator.getCodeRIGHT();
            }
            case 37: {
                return TerminalEmulator.getCodeLEFT();
            }
            case 112: {
                return TerminalEmulator.getCodeF1();
            }
            case 113: {
                return TerminalEmulator.getCodeF2();
            }
            case 114: {
                return TerminalEmulator.getCodeF3();
            }
            case 115: {
                return TerminalEmulator.getCodeF4();
            }
            case 116: {
                return TerminalEmulator.getCodeF5();
            }
            case 117: {
                return TerminalEmulator.getCodeF6();
            }
            case 118: {
                return TerminalEmulator.getCodeF7();
            }
            case 119: {
                return TerminalEmulator.getCodeF8();
            }
            case 120: {
                return TerminalEmulator.getCodeF9();
            }
            case 121: {
                return TerminalEmulator.getCodeF10();
            }
            case 122: {
                return TerminalEmulator.getCodeF11();
            }
            case 123: {
                return TerminalEmulator.getCodeF12();
            }
            case 127: {
                return TerminalEmulator.getCodeDELETE();
            }
            case 33: {
                return TerminalEmulator.getCodeScrollUp();
            }
            case 34: {
                return TerminalEmulator.getCodeScrollDown();
            }
            case 36: {
                return TerminalEmulator.getCodeHome();
            }
            case 35: {
                return TerminalEmulator.getCodeEnd();
            }
        }
        return null;
    }

    private void sendMouseEvent(int x, int y, int b, boolean press) {
        if (b < 1) {
            return;
        }
        char Cx = (char)(x + 33);
        char Cy = (char)(y + 33);
        char Cb = press ? (char)((char)(b + 31)) : (char)'#';
        String seq = "\u001b[M" + Cb + Cx + Cy;
        this.session.write(seq);
    }

    private void copyToClipboard(String s) {
        if (s.length() > 0) {
            StringSelection stringSelection = new StringSelection(s);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    private String getFromClipboard() {
        String ret = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            ret = (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            int sX = e.getX() / this.charWidth;
            int sY = e.getY() / this.charHeight - this.scrollPos;
            this.terminal.autoSelect(sX + sY * this.termWidth);
            this.copyToClipboard(this.terminal.getSelectedText());
            this.repaint();
        }
        if (SwingUtilities.isMiddleMouseButton(e) && e.getClickCount() == 1) {
            String s = this.getFromClipboard();
            this.session.write(s);
            this.scrollPos = 0;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.startSel = e;
            this.endSel = null;
            this.setSelection(this.startSel, this.endSel);
            this.isDragging = false;
            this.repaint();
        }
        if (this.terminal.isMouseEnabled()) {
            int sX = e.getX() / this.charWidth;
            int sY = e.getY() / this.charHeight - this.scrollPos;
            this.sendMouseEvent(sX, sY, e.getButton(), true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.isDragging) {
            this.endSel = e;
            this.setSelection(this.startSel, this.endSel);
            this.copyToClipboard(this.terminal.getSelectedText());
            this.isDragging = false;
            this.repaint();
        }
        if (this.terminal.isMouseEnabled()) {
            int sX = e.getX() / this.charWidth;
            int sY = e.getY() / this.charHeight - this.scrollPos;
            this.sendMouseEvent(sX, sY, e.getButton(), false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.isDragging = true;
            this.endSel = e;
            this.setSelection(this.startSel, this.endSel);
            this.repaint();
        }
    }

    private void setSelection(MouseEvent s, MouseEvent e) {
        int eOff;
        if (s == null || e == null) {
            this.terminal.clearSelection();
            return;
        }
        int sOff = this.getCursorCoordinates(s);
        if (sOff == (eOff = this.getCursorCoordinates(e))) {
            this.terminal.clearSelection();
            return;
        }
        if (sOff > eOff) {
            int swb = sOff;
            sOff = eOff;
            eOff = swb;
        }
        this.terminal.setSelection(sOff, --eOff);
    }

    private int getCursorCoordinates(MouseEvent e) {
        int drift = MainPanel.isWindows ? 2 : 0;
        int sX = (e.getX() + drift + this.charWidth / 2) / this.charWidth;
        int sY = e.getY() / this.charHeight - this.scrollPos;
        int offset = sX + sY * this.termWidth;
        return offset;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

