/*
 * Decompiled with CFR 0.152.
 */
package JSSHTerminal;

import JSSHTerminal.Esc;
import JSSHTerminal.Screen;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TerminalEmulator {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String buf = "";
    private String outBuf = "";
    private Screen scr;
    private Screen backScr = null;
    int[] retScr;
    private String title;
    private String titleBackup;
    private static final EscapeSequence NONE = new EscapeSequence(){

        @Override
        public void handle(TerminalEmulator t, String s, Matcher m) {
        }
    };
    private static final Map<String, EscapeSequence> ESCAPE_SEQUENCES = new HashMap<String, EscapeSequence>();
    private static final Map<Pattern, EscapeSequence> REGEXP_ESCAPE_SEQUENCES = new HashMap<Pattern, EscapeSequence>();
    private static final Map<Character, CsiSequence> CSI_SEQUENCE = new HashMap<Character, CsiSequence>();
    private static OscSequence oscSequence;
    private static byte[] ENTER;
    private static byte[] UP;
    private static byte[] DOWN;
    private static byte[] RIGHT;
    private static byte[] LEFT;
    private static byte[] DELETE;
    private static byte[] SCROLL_UP;
    private static byte[] SCROLL_DOWN;
    private static byte[] HOME;
    private static byte[] END;
    private static byte[] F1;
    private static byte[] F2;
    private static byte[] F3;
    private static byte[] F4;
    private static byte[] F5;
    private static byte[] F6;
    private static byte[] F7;
    private static byte[] F8;
    private static byte[] F9;
    private static byte[] F10;
    private static byte[] F11;
    private static byte[] F12;

    public TerminalEmulator(int width, int height, int scroll) {
        this.scr = new Screen(width, height, scroll);
        this.retScr = new int[width * height];
        this.title = "";
    }

    public boolean isCursor(int x, int y) {
        return this.scr.cx == x && this.scr.cy == y;
    }

    public String getTitle() {
        return this.title;
    }

    public void resize(int nWidth, int nHeight) {
        this.scr.resize(nWidth, nHeight, this.scr.scrollSize);
        if (this.backScr != null) {
            this.backScr.resize(nWidth, nHeight, this.scr.scrollSize);
        }
        this.retScr = new int[nWidth * nHeight];
        this.buf = "";
    }

    public void setSelection(int start, int end) {
        this.scr.setSelection(start, end);
    }

    public void clearSelection() {
        this.scr.clearSelection();
    }

    public int getStartSelection() {
        return this.scr.startSel;
    }

    public int getEndSelection() {
        return this.scr.endSel;
    }

    public void autoSelect(int offset) {
        this.scr.autoSelect(offset);
    }

    public String getSelectedText() {
        return this.scr.getSelectedText();
    }

    public boolean isMouseEnabled() {
        return this.scr.mouseEna;
    }

    public int[] getScreen(int scrollPos) {
        if (scrollPos == 0 || this.scr.scrollScr == null) {
            return this.scr.scr;
        }
        int screenSize = this.scr.width * this.scr.height;
        int scrollLength = scrollPos * this.scr.width;
        int scrollIdx = this.scr.scrollSize * this.scr.width - scrollLength;
        int leftSize = screenSize - scrollLength;
        if (scrollLength > screenSize) {
            scrollLength = screenSize;
        }
        System.arraycopy(this.scr.scrollScr, scrollIdx, this.retScr, 0, scrollLength);
        if (leftSize > 0) {
            System.arraycopy(this.scr.scr, 0, this.retScr, scrollLength, leftSize);
        }
        return this.retScr;
    }

    public int getScrollSize() {
        return this.scr.getScrollSize();
    }

    public int getCharAt(int offset) {
        return this.scr.getCharAt(offset);
    }

    @Esc(value={"\u001bc"})
    public void reset() {
        this.scr.reset();
        this.buf = "";
    }

    @Esc(value={"\n", "\u000b", "\f"})
    public void cursorDown() {
        this.scr.cursorDown();
    }

    public void cursorRight() {
        this.scr.cursorRight();
    }

    public void echo(char c) {
        this.scr.echo(c);
    }

    public void escape() {
        EscapeSequence es = ESCAPE_SEQUENCES.get(this.buf);
        if (es != null) {
            es.handle(this, this.buf, null);
            this.buf = "";
            return;
        }
        for (Map.Entry<Pattern, EscapeSequence> ent : REGEXP_ESCAPE_SEQUENCES.entrySet()) {
            Matcher m = ent.getKey().matcher(this.buf);
            if (!m.matches()) continue;
            ent.getValue().handle(this, this.buf, m);
            this.buf = "";
            return;
        }
    }

    public String read() {
        return "";
    }

    private void printSeq(String buf) {
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c == '\u001b') {
                System.out.print("<ESC>");
                continue;
            }
            if (c < ' ') {
                System.out.print("<" + Integer.toString(c) + ">");
                continue;
            }
            System.out.print(buf.charAt(i));
        }
        System.out.println();
    }

    public void write(char[] s, int length) {
        for (int i = 0; i < length; ++i) {
            char ch = s[i];
            if (this.buf.length() > 0 || ESCAPE_SEQUENCES.containsKey("" + ch)) {
                if (ch == '\u001b') {
                    System.out.print("Warning, unexpected escape sequence :");
                    this.printSeq(this.buf);
                    this.buf = "";
                }
                this.buf = this.buf + ch;
                this.escape();
                continue;
            }
            if (ch == '\u001b') {
                this.buf = this.buf + ch;
                continue;
            }
            this.echo(ch);
        }
    }

    public String dump() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (int y = 0; y < this.scr.height; ++y) {
            for (int x = 0; x < this.scr.width; ++x) {
                buf.append(String.format("%04X ", this.scr.scr[i])).append(" ").append((char)(this.scr.scr[i] & 0xFFFF)).append(" ");
                ++i;
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    @Esc(value={"\u0000", "\u0007", "\u000e", "\u000f", "\u001b#8", "\u001b=", "\u001b>", "\u001b]R", "\u001bD", "\u001bE", "\u001bH", "\u001bN", "\u001bO", "\u001ba", "\u001bn", "\u001bo"})
    public void noOp() {
    }

    @Esc(value={"\b"})
    public void esc_0x08() {
        this.scr.backspace();
    }

    @Esc(value={"\t"})
    public void esc_0x09() {
        this.scr.tab();
    }

    @Esc(value={"\r"})
    public void esc_0x0d() {
        this.scr.carriage_return();
    }

    @Esc(value={"\u001b)A"})
    public void selectCharSetPA() {
        this.scr.selectCharSet(1);
    }

    @Esc(value={"\u001b(A"})
    public void selectCharSetAA() {
        this.scr.selectCharSet(1);
    }

    @Esc(value={"\u001b)B"})
    public void selectCharSetPB() {
        this.scr.selectCharSet(0);
    }

    @Esc(value={"\u001b(B"})
    public void selectCharSetAB() {
        this.scr.selectCharSet(0);
    }

    @Esc(value={"\u001b(0"})
    public void selectCharSetP0() {
        this.scr.selectCharSet(2);
    }

    @Esc(value={"\u001b)0"})
    public void selectCharSetA0() {
        this.scr.selectCharSet(0);
    }

    @Esc(value={"\u001b(1"})
    public void selectCharSetP1() {
        this.scr.selectCharSet(0);
    }

    @Esc(value={"\u001b)1"})
    public void selectCharSetA1() {
        this.scr.selectCharSet(0);
    }

    @Esc(value={"\u001b(2"})
    public void selectCharSetP2() {
        this.scr.selectCharSet(0);
    }

    @Esc(value={"\u001b)2"})
    public void selectCharSetA2() {
        this.scr.selectCharSet(0);
    }

    @Esc(value={"\u001b7"})
    public void saveCursor() {
        this.scr.saveCursor();
    }

    @Esc(value={"\u001b8"})
    public void restoreCursor() {
        this.scr.restoreCursor();
    }

    @Esc(value={"\u001bM"})
    public void escRi() {
        this.scr.escRi();
    }

    public void csi_A(int[] i) {
        this.scr.csi_A(i);
    }

    public void csi_B(int[] i) {
        this.scr.csi_B(i);
    }

    public void csi_C(int[] i) {
        this.scr.csi_C(i);
    }

    public void csi_D(int[] i) {
        this.scr.csi_D(i);
    }

    public void csi_E(int[] i) {
        this.scr.csi_E(i);
    }

    public void csi_F(int[] i) {
        this.scr.csi_F(i);
    }

    public void csi_G(int[] i) {
        this.scr.csi_G(i);
    }

    public void csi_H(int[] i) {
        this.scr.csi_H(i);
    }

    public void csi_J(int[] i) {
        this.scr.csi_J(i);
    }

    public void csi_K(int ... i) {
        this.scr.csi_K(i);
    }

    public void csi_L(int[] args) {
        this.scr.csi_L(args);
    }

    public void csi_M(int[] args) {
        this.scr.csi_M(args);
    }

    public void csi_P(int[] args) {
        this.scr.csi_P(args);
    }

    public void csi_S(int[] args) {
        this.scr.csi_S(args);
    }

    public void csi_T(int[] args) {
        this.scr.csi_T(args);
    }

    public void csi_X(int[] args) {
        this.scr.csi_X(args);
    }

    public void csi_a(int[] args) {
        this.scr.csi_a(args);
    }

    public void csi_c(int[] args) {
        this.scr.csi_c(args);
    }

    public void csi_d(int[] args) {
        this.scr.csi_d(args);
    }

    public void csi_e(int[] args) {
        this.scr.csi_e(args);
    }

    public void csi_f(int[] args) {
        this.scr.csi_f(args);
    }

    public void csi_h(int[] args) {
        switch (args[0]) {
            case 25: {
                this.scr.showCursor = true;
                break;
            }
            case 1049: {
                this.backScr = this.scr;
                this.scr = new Screen(this.backScr.width, this.backScr.height, 0);
                break;
            }
            case 1000: {
                this.scr.mouseEna = true;
            }
        }
    }

    public void csi_l(int[] args) {
        switch (args[0]) {
            case 25: {
                this.scr.showCursor = false;
                break;
            }
            case 1000: {
                this.scr.mouseEna = false;
                break;
            }
            case 1049: {
                this.scr = this.backScr;
            }
        }
    }

    public void csi_m(int[] args) {
        this.scr.csi_m(args);
    }

    public void csi_r(int[] args) {
        this.scr.csi_r(args);
    }

    public void csi_s(int[] args) {
        this.scr.csi_s(args);
    }

    public void csi_u(int[] args) {
        this.scr.csi_u(args);
    }

    public void osc(int function, String param) {
        switch (function) {
            case 0: 
            case 2: {
                this.title = param;
                break;
            }
            default: {
                System.out.println("Warning, unhandled OSC function #" + function);
            }
        }
    }

    public static byte[] getCodeENTER() {
        return ENTER;
    }

    public static byte[] getCodeUP() {
        return UP;
    }

    public static byte[] getCodeDOWN() {
        return DOWN;
    }

    public static byte[] getCodeRIGHT() {
        return RIGHT;
    }

    public static byte[] getCodeDELETE() {
        return DELETE;
    }

    public static byte[] getCodeScrollUp() {
        return SCROLL_UP;
    }

    public static byte[] getCodeScrollDown() {
        return SCROLL_DOWN;
    }

    public static byte[] getCodeHome() {
        return HOME;
    }

    public static byte[] getCodeEnd() {
        return END;
    }

    public static byte[] getCodeLEFT() {
        return LEFT;
    }

    public static byte[] getCodeF1() {
        return F1;
    }

    public static byte[] getCodeF2() {
        return F2;
    }

    public static byte[] getCodeF3() {
        return F3;
    }

    public static byte[] getCodeF4() {
        return F4;
    }

    public static byte[] getCodeF5() {
        return F5;
    }

    public static byte[] getCodeF6() {
        return F6;
    }

    public static byte[] getCodeF7() {
        return F7;
    }

    public static byte[] getCodeF8() {
        return F8;
    }

    public static byte[] getCodeF9() {
        return F9;
    }

    public static byte[] getCodeF10() {
        return F10;
    }

    public static byte[] getCodeF11() {
        return F11;
    }

    public static byte[] getCodeF12() {
        return F12;
    }

    static {
        for (final Method m : TerminalEmulator.class.getMethods()) {
            Esc esc = m.getAnnotation(Esc.class);
            if (esc != null) {
                for (String s : esc.value()) {
                    ESCAPE_SEQUENCES.put(s, new EscapeSequence(){

                        @Override
                        public void handle(TerminalEmulator t, String s, Matcher _) {
                            try {
                                m.invoke((Object)t, new Object[0]);
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalAccessError();
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
            }
            if (m.getName().startsWith("csi_") && m.getName().length() == 5) {
                CSI_SEQUENCE.put(Character.valueOf(m.getName().charAt(4)), new CsiSequence(){

                    @Override
                    void handle(TerminalEmulator t, int[] args) {
                        try {
                            m.invoke((Object)t, new Object[]{args});
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalAccessError();
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            if (!m.getName().equals("osc")) continue;
            oscSequence = new OscSequence(){

                @Override
                void handle(TerminalEmulator t, int func, String s) {
                    try {
                        m.invoke((Object)t, func, s);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalAccessError();
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        REGEXP_ESCAPE_SEQUENCES.put(Pattern.compile("\u001b\\[\\??([0-9;]*)([@ABCDEFGHJKLMPSTXacdefghlmnqrstu`])"), new EscapeSequence(){

            @Override
            public void handle(TerminalEmulator t, String _, Matcher m) {
                String s = m.group(1);
                CsiSequence seq = (CsiSequence)CSI_SEQUENCE.get(Character.valueOf(m.group(2).charAt(0)));
                if (seq != null) {
                    String[] tokens = s.split(";");
                    if (s.length() == 0) {
                        tokens = EMPTY_STRING_ARRAY;
                    }
                    int[] n = new int[tokens.length];
                    for (int i = 0; i < n.length; ++i) {
                        try {
                            n[i] = Integer.parseInt(tokens[i]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            n[i] = 0;
                        }
                    }
                    seq.handle(t, n);
                } else {
                    System.out.println("Warning, unhandled escape sequence " + m.group(2).charAt(0));
                }
            }
        });
        REGEXP_ESCAPE_SEQUENCES.put(Pattern.compile("\u001b\\]([0-9];[\\p{Alpha}\\p{Digit}\\p{Punct} ]*)\u0007"), new EscapeSequence(){

            @Override
            public void handle(TerminalEmulator t, String _, Matcher m) {
                try {
                    String s = m.group(1);
                    String[] tokens = s.split(";");
                    if (tokens.length == 2) {
                        int func = Integer.parseInt(tokens[0]);
                        oscSequence.handle(t, func, tokens[1]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        REGEXP_ESCAPE_SEQUENCES.put(Pattern.compile("\u001c([^\u0007]+)\u0007"), NONE);
        CSI_SEQUENCE.put(Character.valueOf('@'), new CsiSequence(){

            @Override
            void handle(TerminalEmulator t, int[] args) {
                for (int i = 0; i < args[0]; ++i) {
                    t.scr.scrollRight(((TerminalEmulator)t).scr.cy, ((TerminalEmulator)t).scr.cx);
                }
            }
        });
        ENTER = new byte[]{13};
        UP = new byte[]{27, 79, 65};
        DOWN = new byte[]{27, 79, 66};
        RIGHT = new byte[]{27, 79, 67};
        LEFT = new byte[]{27, 79, 68};
        DELETE = new byte[]{27, 91, 51, 126};
        SCROLL_UP = new byte[]{27, 91, 53, 126};
        SCROLL_DOWN = new byte[]{27, 91, 54, 126};
        HOME = new byte[]{27, 91, 49, 126};
        END = new byte[]{27, 91, 52, 126};
        F1 = new byte[]{27, 79, 80};
        F2 = new byte[]{27, 79, 81};
        F3 = new byte[]{27, 79, 82};
        F4 = new byte[]{27, 79, 83};
        F5 = new byte[]{27, 91, 49, 53, 126};
        F6 = new byte[]{27, 91, 49, 55, 126};
        F7 = new byte[]{27, 91, 49, 56, 126};
        F8 = new byte[]{27, 91, 49, 57, 126};
        F9 = new byte[]{27, 91, 50, 48, 126};
        F10 = new byte[]{27, 91, 50, 49, 126};
        F11 = new byte[]{27, 91, 50, 51, 126};
        F12 = new byte[]{27, 91, 50, 52, 126};
    }

    private static abstract class OscSequence {
        protected OscSequence() {
        }

        abstract void handle(TerminalEmulator var1, int var2, String var3);
    }

    private static abstract class CsiSequence {
        protected CsiSequence() {
        }

        abstract void handle(TerminalEmulator var1, int[] var2);
    }

    private static interface EscapeSequence {
        public void handle(TerminalEmulator var1, String var2, Matcher var3);
    }
}

