/*
 * Decompiled with CFR 0.152.
 */
package JSSHTerminal;

import JSSHTerminal.MainPanel;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MultiTerminal
extends JFrame
implements ActionListener {
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private String prefHostList = this.prefs.get("HostList", "");
    private String prefUser = this.prefs.get("User", "");
    private String prefPassword = this.prefs.get("Password", "");
    private String prefTermDim = this.prefs.get("TermDim", "80x40");
    private String prefLastDir = this.prefs.get("LastDir", ".");
    private String prefCommand = this.prefs.get("Command", "");
    private JPanel innerPanel = new JPanel();
    private JTextArea hostList;
    private JScrollPane hostListScroll;
    private JLabel userLabel;
    private JTextField userText;
    private JLabel passwordLabel;
    private JTextField passwordText;
    private JLabel termDimLabel;
    private JTextField termDimText;
    private JLabel commandLabel;
    private JTextField commandText;
    private JButton connectBtn;
    private JButton loadButton;

    public MultiTerminal() {
        this.innerPanel.setLayout(null);
        this.innerPanel.setPreferredSize(new Dimension(350, 175));
        this.setContentPane(this.innerPanel);
        this.hostListScroll = new JScrollPane();
        this.hostList = new JTextArea();
        this.userText = new JTextField();
        this.userLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.passwordText = new JTextField();
        this.connectBtn = new JButton();
        this.loadButton = new JButton();
        this.termDimLabel = new JLabel();
        this.termDimText = new JTextField();
        this.commandLabel = new JLabel();
        this.commandText = new JTextField();
        this.setLayout(null);
        this.hostList.setEditable(true);
        this.hostList.setText(this.prefHostList);
        this.hostListScroll.setViewportView(this.hostList);
        this.innerPanel.add(this.hostListScroll);
        this.hostListScroll.setBounds(10, 10, 130, 160);
        this.userLabel.setText("User");
        this.innerPanel.add(this.userLabel);
        this.userText.setText(this.prefUser);
        this.innerPanel.add(this.userText);
        this.userLabel.setBounds(150, 18, 100, 20);
        this.userText.setBounds(250, 15, 95, 25);
        this.passwordLabel.setText("Password");
        this.innerPanel.add(this.passwordLabel);
        this.passwordText.setText(this.prefPassword);
        this.innerPanel.add(this.passwordText);
        this.passwordLabel.setBounds(150, 48, 100, 20);
        this.passwordText.setBounds(250, 45, 95, 25);
        this.termDimLabel.setText("Terminal (WxH)");
        this.innerPanel.add(this.termDimLabel);
        this.termDimText.setText(this.prefTermDim);
        this.innerPanel.add(this.termDimText);
        this.termDimLabel.setBounds(150, 78, 100, 20);
        this.termDimText.setBounds(250, 75, 95, 25);
        this.commandLabel.setText("Command");
        this.innerPanel.add(this.commandLabel);
        this.commandText.setText(this.prefCommand);
        this.innerPanel.add(this.commandText);
        this.commandLabel.setBounds(150, 108, 100, 20);
        this.commandText.setBounds(250, 105, 95, 25);
        this.connectBtn.setText("Connect");
        this.connectBtn.addActionListener(this);
        this.innerPanel.add(this.connectBtn);
        this.connectBtn.setBounds(255, 145, 88, 25);
        this.loadButton.setText("Load list...");
        this.loadButton.addActionListener(this);
        this.innerPanel.add(this.loadButton);
        this.loadButton.setBounds(145, 145, 105, 25);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MultiTerminal.this.prefs.put("HostList", MultiTerminal.this.hostList.getText());
                MultiTerminal.this.prefs.put("User", MultiTerminal.this.userText.getText());
                MultiTerminal.this.prefs.put("Password", MultiTerminal.this.passwordText.getText());
                MultiTerminal.this.prefs.put("TermDim", MultiTerminal.this.termDimText.getText());
                MultiTerminal.this.prefs.put("LastDir", MultiTerminal.this.prefLastDir);
                MultiTerminal.this.prefs.put("Command", MultiTerminal.this.commandText.getText());
            }
        });
        this.setTitle("MultiTerminal");
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private String[] makeStringArray(String value) {
        while (value.endsWith("\n")) {
            value = value.substring(0, value.length() - 1);
        }
        return value.split("\n");
    }

    private Dimension getTermDim() {
        String[] d = this.termDimText.getText().split("x");
        if (d.length != 2) {
            JOptionPane.showMessageDialog(this, "Error", "Invalid terminal dimension (WxH)", 0);
            return null;
        }
        Dimension ret = new Dimension();
        try {
            ret.width = Integer.parseInt(d[0]);
            ret.height = Integer.parseInt(d[1]);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Error", "Invalid terminal dimension\n" + e.getMessage(), 0);
            return null;
        }
        return ret;
    }

    public static void main(String[] args) {
        new MultiTerminal();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser;
        int returnVal;
        Object src = e.getSource();
        if (src == this.connectBtn) {
            Dimension termD = this.getTermDim();
            if (termD == null) {
                return;
            }
            String[] hList = this.makeStringArray(this.hostList.getText());
            if (hList.length == 0) {
                JOptionPane.showMessageDialog(this, "Error", "Empty host list", 0);
                return;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension scrsize = toolkit.getScreenSize();
            int xPos = 10;
            int yPos = 200;
            String command = this.commandText.getText();
            for (int termCount = 0; termCount < hList.length; ++termCount) {
                MainPanel f = new MainPanel(hList[termCount], this.userText.getText(), this.passwordText.getText(), termD.width, termD.height, 500);
                f.setExitOnClose(true);
                f.setAnswerYes(true);
                if (command.length() > 0) {
                    f.setCommand(command);
                }
                Dimension d = f.getSize();
                f.setLocation(xPos, yPos);
                f.setVisible(true);
                if ((xPos += f.getWidth()) + d.width <= scrsize.width) continue;
                xPos = 10;
                yPos += d.height;
            }
        } else if (src == this.loadButton && (returnVal = (chooser = new JFileChooser(this.prefLastDir)).showOpenDialog(this)) == 0) {
            File f = chooser.getSelectedFile();
            try {
                StringBuffer str = new StringBuffer();
                boolean eof = false;
                FileReader fr = new FileReader(f);
                while (!eof) {
                    int c = fr.read();
                    eof = c < 0;
                    if (eof) continue;
                    str.append((char)c);
                }
                fr.close();
                this.hostList.setText(str.toString());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Error", "Error while loading " + f.getName() + "\n" + ex.getMessage(), 0);
            }
            if (f != null) {
                this.prefLastDir = f.getAbsolutePath();
            }
        }
    }
}

